﻿using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;

using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace DOCConvExample
{
    public partial class WebForm1 : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        [DllImport("kernel32.dll")]
        public static extern IntPtr LoadLibrary(string lpFileName);

        [DllImport("kernel32.dll", CharSet = CharSet.Ansi, ExactSpelling = true)]
        public static extern IntPtr GetProcAddress(IntPtr hModule, string procName);

        [DllImport("kernel32.dll", SetLastError = true)]
        public static extern bool FreeLibrary(IntPtr hModule);

        public delegate int DLLRegisterServerDelegate();

        protected void Button1_Click(object sender, EventArgs e)
        {
            IntPtr hmod = LoadLibrary(fuDLL.Text/*"DOCConverter.dll"*/);

            if ((int)hmod < 32)
            {
                lbStatus.Text = "Can not load DOCConverter.dll";
                return;
            }


            IntPtr RegSvr = GetProcAddress(hmod, "DllRegisterServer");
            DLLRegisterServerDelegate DLLRegisterServer = Marshal.GetDelegateForFunctionPointer(RegSvr, typeof(DLLRegisterServerDelegate)) as DLLRegisterServerDelegate;

            int status=DLLRegisterServer();

            if (status == 0)
            {
                lbStatus.Text = "Registrartion succesful!";
                lbStatus.ForeColor = System.Drawing.Color.White;
            }
            else
            {
                lbStatus.Text = "Registration fail!";
            }


            FreeLibrary(hmod);

        }
    }
}
