﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Reflection;
using System.IO;
using Microsoft.Win32; // for working with registry, enter registration information

namespace DOCConvExample
{
    public partial class _Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        protected void bnConvert_Click(object sender, EventArgs e)
        {
            if (FileUpload1.HasFile)
            {
                string sSource = MapPath(@"temp/") + FileUpload1.FileName;
                Directory.CreateDirectory(MapPath(@"temp/"));
                FileUpload1.SaveAs(sSource);
                Label1.Text = "File Uploaded: " + FileUpload1.FileName;

                Type oType = Type.GetTypeFromProgID("DOCConverter.DOCConverterX");
                if (oType == null)
                {
                    Response.Redirect("RegSvr.aspx");
                    return;
                }


                // We use late bindings to allow build without installed DOCConverterX
                // You should use syntax like:
                //IDOCConverterX Conv = (IDOCConverterX)Activator.CreateInstance(oType);
                // with DOCConverter reference

                object Conv = Activator.CreateInstance(oType);

                string sFormat = rblConvert.SelectedValue;
                string sConverted = Path.ChangeExtension(sSource, "." + sFormat);
                string sCmd = 
                    "-c " + sFormat + 
                    " -po " + cbPageOrientation.SelectedValue + 
                    " -ps " + cbPageSize.SelectedValue + 
                    " " + edAdditional.Text;

                object[] parameters;
                parameters = new object[3];
                parameters[0] = sSource;
                parameters[1] = sConverted;
                parameters[2] = sCmd;

                Conv.GetType().InvokeMember("Convert", BindingFlags.InvokeMethod, null, Conv, parameters);
                /*Conv.Convert(
                    sSource,
                    sConverted,
                    sCmd); */

                Global.cmd = sCmd;
                Global.destination = sConverted;
                Response.Redirect("Converted.aspx");

            }
            else
            {
                Label1.Text = "No File Uploaded.";
            }

        }

        protected void bnRegister_Click(object sender, EventArgs e)
        {
            if (edRegFile.HasFile)
            {
                string sSource = MapPath(@"temp/") + edRegFile.FileName;
                Directory.CreateDirectory(MapPath(@"temp/"));
                edRegFile.SaveAs(sSource);

                string line;
                RegistryKey regkey = null;
                Boolean bOK = false;
                using (StreamReader sr = new StreamReader(sSource))
                
                    while ((line = sr.ReadLine()) != null)
                    {
                        if ((line == "") || (line == "REGEDIT4"))
                            continue;
                        if (line.StartsWith("["))
                        {
                            regkey = Registry.CurrentUser.CreateSubKey(line.Substring(19, line.Length - 20));
                        }
                        else
                        {
                            char[] Separators = { '"', '=' };
                            String[] values = line.Split(Separators, StringSplitOptions.RemoveEmptyEntries);
                            regkey.SetValue(values[0], values[1]);
                            bOK = true;
                        }

                    }
                    if (bOK)
                    {
                        lbRegisterStatus.Text = "Registration succesful!";
                    }
                    else
                    {
                        lbRegisterStatus.Text = "Registration failed!";
                    }
                    lbRegisterStatus.Visible = true;
                
            }
        }
    }
}
