Please take a moment to review this document in order to make the contribution
process easy and effective for everyone involved.


# Using the issue tracker

The issue tracker is the preferred channel for [bug reports](#bugs) and
[features requests](#features), but please respect the following restriction:

* Please **do not** use the issue tracker for personal support requests (use
  a service like [Stack Overflow](http://stackoverflow.com) instead).

<a name="bugs"></a>
## Bug reports

A bug is a _demonstrable problem_ that is caused by the code in the repository.
Good bug reports are extremely helpful - thank you!

Guidelines for bug reports:

1. **Use the GitHub issue search** &mdash; check if the issue has already been
   reported.

2. **Check if the issue has been fixed** &mdash; try to reproduce it using the
   latest `master` branch in the repository.

3. **Isolate the problem** &mdash; provide exact reproduction steps, preferably
   in the form of a failing test case or by providing modification steps in the 
   `MBProgressHUD` Demo application.

A good bug report shouldn't leave others needing to chase you up for more
information. Please try to be as detailed as possible in your report. What is
your environment? What steps will reproduce the issue? What iOS version did 
you use? What would you expect to be the outcome? 


<a name="features"></a>
## Feature requests

Feature requests are welcome. But take a moment to find out whether your idea
fits with the scope and aims of the project. It's up to *you* to make a strong
case to convince the project's developers of the merits of this feature. Please
provide as much detail and context as possible.

<a name="pull-requests"></a>

# Pull requests

Good pull requests - patches, improvements, new features - are a fantastic
help. They should remain focused in scope and avoid containing unrelated
commits.

**Please ask first** before embarking on any significant pull request (e.g.
implementing features, refactoring code, porting to a different language),
otherwise you risk spending a lot of time working on something that the
project's developers might not want to merge into the project.

Please adhere to the coding conventions used throughout a project (indentation,
accurate comments, etc.) and any other requirements (such as test coverage).

**IMPORTANT**: By submitting a patch, you agree to allow the project owner to
license your work under the same license as that used by the project.

This document is based on https://github.com/necolas/issue-guidelines/blob/master/CONTRIBUTING.md. 
