<div class="container mb-4" id="create_station_profile">

<br>
	<?php if($this->session->flashdata('message')) { ?>
		<!-- Display Message -->
		<div class="alert-message error">
		  <p><?php echo $this->session->flashdata('message'); ?></p>
		</div>
	<?php } ?>

	<?php if($this->session->flashdata('notice')) { ?>
		<div id="message" >
			<?php echo $this->session->flashdata('notice'); ?>
		</div>
	<?php } ?>

	<?php $this->load->helper('form'); ?>

	<?php echo validation_errors(); ?>

	<div class="row">
		<div class="col-md">
			<div class="card">
				<div class="card-header"><?php echo lang('station_logbooks_edit_logbook'); ?>: <?php echo $station_logbook_details->logbook_name; ?></div>
				<div class="card-body">
					<form method="post" action="<?php echo site_url('logbooks/edit/'); ?><?php echo $station_logbook_details->logbook_id; ?>" name="create_profile">
						<input type="hidden" name="logbook_id" value="<?php echo $station_logbook_details->logbook_id; ?>">

						<div class="mb-3">
							<label for="stationLogbookNameInput"><?php echo lang('station_logbooks_create_name'); ?></label>
							<input type="text" class="form-control" name="station_logbook_name" id="stationLogbookNameInput" aria-describedby="stationLogbookNameInputHelp" value="<?php if(set_value('station_logbook_name') != "") { echo set_value('station_logbook_name'); } else { echo $station_logbook_details->logbook_name; } ?>" <?php echo isset($is_owner) && !$is_owner ? 'readonly' : 'required'; ?>>
							<small id="stationLogbookNameInputHelp" class="form-text text-muted"><?php echo isset($is_owner) && !$is_owner ? lang('station_logbooks_edit_name_hint').' '.lang('station_logbooks_shared_readonly') : lang('station_logbooks_edit_name_hint'); ?></small>
						</div>

						<input type="hidden" class="form-control" name="station_logbook_id" value="<?php echo $station_logbook_details->logbook_id; ?>" required>	

						<?php if(isset($is_owner) && $is_owner) { ?>
						<button type="submit" class="btn btn-primary"><i class="fas fa-plus-square"></i> <?php echo lang('station_logbooks_edit_name_update'); ?></button>
						<?php } else { ?>
						<p class="text-muted"><i class="fas fa-info-circle"></i> Only the owner can rename this logbook</p>
						<?php } ?>
					</form>
				</div>
			</div>
		</div>

		<?php if(isset($is_owner) && $is_owner) { ?>
		<div class="col-md">
			<div class="card">
				<div class="card-header"><?php echo lang('station_logbooks_public_slug'); ?></div>
				<div class="card-body">
					<p><?php echo lang('station_logbooks_public_slug_hint'); ?></p>
					<p><?php echo lang('station_logbooks_public_slug_format1')?><br>
					<?php echo site_url('visitor'); ?>/<?php echo lang('station_logbooks_public_slug_format2'); ?></p>
					<form hx-post="<?php echo site_url('logbooks/save_publicslug/'); ?>" hx-target="#publicSlugForm" style="display: inline;">
					<div id="publicSlugForm">
					</div>
					<div class="mb-3">
						<input type="hidden" name="logbook_id" value="<?php echo $station_logbook_details->logbook_id; ?>">
						<label for="publicSlugInput"><?php echo lang('station_logbooks_public_slug_input'); ?></label>
						<div hx-target="this" hx-swap="outerHTML">
							<input class="form-control" name="public_slug" id="publicSlugInput" pattern="[a-zA-Z0-9-]+" value="<?php echo $station_logbook_details->public_slug; ?>" hx-post="<?php echo site_url('logbooks/publicslug_validate/'); ?>"  hx-trigger="keyup changed delay:500ms" required>
						</div>
					</div>
					<button type="submit" class="btn btn-primary" style="display:inline-block;"><i class="fas fa-plus-square"></i> <?php echo lang('admin_save'); ?></button>
					</form>
					<form hx-post="<?php echo site_url('logbooks/remove_publicslug/'); ?>" hx-target="#publicSlugForm" style="display: inline; margin-left: 5px;">
						<input type="hidden" name="logbook_id" value="<?php echo $station_logbook_details->logbook_id; ?>">
						<button type="submit" class="btn btn-primary" style="display:inline-block;" onclick="removeSlug()"><i class="fas fa-minus-square"></i> <?php echo lang('admin_remove'); ?></button>
					</form>

					<?php if($station_logbook_details->public_slug != "") { ?>
					<div id="slugLink" class="alert alert-info" role="alert" style="margin-top: 20px;">
						<p><?php echo lang('station_logbooks_public_slug_visit') . " "; ?></p>
						<p><a href="<?php echo site_url('visitor'); ?>/<?php echo $station_logbook_details->public_slug; ?>" target="_blank"><?php echo site_url('visitor'); ?>/<?php echo $station_logbook_details->public_slug; ?></a></p>
					</div>
					<?php } ?>
					<form style="display: inline;">
					<input type="hidden" name="logbook_id" value="<?php echo $station_logbook_details->logbook_id; ?>">
					<p style="margin-top: 15px;"><?php echo lang('station_logbooks_public_search_hint'); ?></p>
					<div class="form-check form-switch">
						<input class="form-check-input" type="checkbox" id="public_search" name="public_search" value="1" 
							<?php if ($station_logbook_details->public_search == 1) { echo " checked"; } ?>
							hx-post="<?php echo site_url('logbooks/save_publicsearch/'); ?>" 
							hx-target="#publicSearchForm" 
							hx-trigger="change"
							hx-vals='{"logbook_id": "<?php echo $station_logbook_details->logbook_id; ?>"}'>
						<label class="form-check-label" for="public_search">
							<?php echo lang('station_logbooks_public_search_enabled'); ?>
						</label>
					</div>
					</form>
					<p>
					<div id="publicSearchForm">
					</div>

					<form style="display: inline;">
					<input type="hidden" name="logbook_id" value="<?php echo $station_logbook_details->logbook_id; ?>">
					<p style="margin-top: 15px;"><?php echo lang('station_logbooks_public_radio_status_hint'); ?></p>
					<div class="form-check form-switch">
						<input class="form-check-input" type="checkbox" id="public_radio_status" name="public_radio_status" value="1" 
							<?php if (isset($station_logbook_details->public_radio_status) && $station_logbook_details->public_radio_status == 1) { echo " checked"; } ?>
							hx-post="<?php echo site_url('logbooks/save_publicradiostatus/'); ?>" 
							hx-target="#publicRadioStatusForm" 
							hx-trigger="change"
							hx-vals='{"logbook_id": "<?php echo $station_logbook_details->logbook_id; ?>"}'>
						<label class="form-check-label" for="public_radio_status">
							<?php echo lang('station_logbooks_public_radio_status_enabled'); ?>
						</label>
					</div>
					</form>
					<p>
					<div id="publicRadioStatusForm">
					</div>
				</div>
			</div>
		</div>
		<?php } ?>
	</div>

	<div class="row">
		<div class="col-md">
			<div class="card">
				<div class="card-header"><?php echo lang('station_location_plural'); ?></div>
				<div class="card-body">
					<form method="post" action="<?php echo site_url('logbooks/edit/'); ?><?php echo $station_logbook_details->logbook_id; ?>" name="create_profile">
					<input type="hidden" name="logbook_id" value="<?php echo $station_logbook_details->logbook_id; ?>">

					<?php
						$linked_stations = array();
						if ($station_locations_linked) {
							foreach ($station_locations_linked->result() as $row) {
								$linked_stations[] = $row->station_id;
							}
						}
					?>

					<div class="mb-3">
						<label for="StationLocationsSelect"><?php echo lang('station_logbooks_select_avail_loc'); ?></label>
						<select name="SelectedStationLocation" class="form-select" id="StationLocationSelect" aria-describedby="StationLocationSelectHelp">
							<?php foreach ($station_locations_list->result() as $row) {
								if (!in_array($row->station_id, $linked_stations)) { ?>
								<option value="<?php echo $row->station_id;?>"><?php echo $row->station_profile_name;?> (<?php echo lang('gen_hamradio_callsign'); ?>: <?php echo $row->station_callsign;?> <?php echo lang('gen_hamradio_dxcc'); ?>: <?php echo $row->station_country; if ($row->dxcc_end != NULL) { echo ' ('.lang('gen_hamradio_deleted_dxcc').')'; } ?>)</option>
								<?php } ?>
							<?php } ?>
						</select>
					</div>

					<input type="hidden" class="form-control" name="station_logbook_id" value="<?php echo $station_logbook_details->logbook_id; ?>" required>	

					<button type="submit" class="btn btn-primary"><i class="fas fa-link"></i> <?php echo lang('station_logbooks_link_loc'); ?></button>
					</form>
				</div>
			</div>
		</div>
	</div>

	<div class="card">
		<div class="card-header">
			<?php echo lang('station_logbooks_linked_loc'); ?>
		</div>

	    <div class="table-responsive m-4">
			<table id="station_logbooks_linked_table" class="table table-hover">
				<thead class="thead-light">
					<tr>
						<th scope="col"><?php echo lang('station_location_name'); ?></th>
						<th scope="col"><?php echo lang('station_location_callsign'); ?></th>
						<th scope="col"><?php echo lang('gen_hamradio_dxcc'); ?></th>
						<th scope="col">Owner</th>
						<th scope="col"><?php echo lang('station_logbooks_unlink_station_location'); ?></th>
					</tr>
				</thead>
				<tbody>
					<?php
						if ($station_locations_linked) {
							foreach ($station_locations_linked->result() as $row) {
					?>
					<tr>
						<td style="text-align: center; vertical-align: middle;"><?php echo $row->station_profile_name;?></td>
						<td style="text-align: center; vertical-align: middle;"><?php echo $row->station_callsign;?></td>
						<td style="text-align: center; vertical-align: middle;"><?php echo $row->station_country; if ($row->end != NULL) { echo ' <span class="badge text-bg-danger">'.lang('gen_hamradio_deleted_dxcc').'</span>'; } ?></td>
						<td style="text-align: center; vertical-align: middle;">
							<?php if ($row->is_shared == 1) { ?>
								<span class="badge bg-info text-dark"><i class="fas fa-share-alt"></i> Shared (<?php echo $row->owner_callsign; ?>)</span>
							<?php } else { ?>
								<span class="badge bg-success"><i class="fas fa-user"></i> Yours</span>
							<?php } ?>
						</td>
						<td style="text-align: center; vertical-align: middle;">
							<?php 
							// Only show unlink button if user is owner of logbook OR owner of this station location
							if (isset($is_owner) && ($is_owner || $row->is_shared == 0)) { 
							?>
								<a href="<?php echo site_url('logbooks/delete_relationship/'); ?><?php echo $station_logbook_details->logbook_id; ?>/<?php echo $row->station_id;?>" class="btn btn-danger"><i class="fas fa-unlink"></i></a>
							<?php } else { ?>
								<span class="text-muted"><i class="fas fa-lock"></i></span>
							<?php } ?>
						</td>
					</tr>
					<?php
							}
						} else {
					?>
					<tr>
						<td style="text-align: center; vertical-align: middle;" colspan="5"><?php echo lang('station_logbooks_no_linked_loc'); ?></td>
					</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>

	</div>

</div>
