<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_fix_brazil_dxcc_data extends CI_Migration {

	public function up()
	{
	  // Fixes Brazilian DXCC data: Typos, ITU zone, 
	  // Callsign assignment plan, time zone
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3 WHERE CountryCode = 108 AND DXCCSort = 1;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 15, PrefixList = 'PP1, PU1[A-I], ZV1[A-I], ZW1[A-I], ZX1[A-I], ZY1[A-I], ZZ1[A-I]', location = 'Espirito Santo <Pri:ES>' WHERE CountryCode = 108 AND DXCCSort = 12;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 13, PrefixList = 'PP2, PU2[F-H], Z[V-Z]2F, Z[V-Z]2G, Z[V-Z]2H', location = 'Goias <Pri:GO>' WHERE CountryCode = 108 AND DXCCSort = 22;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 15, PrefixList = 'PP5, PU5[A-L], ZV5[A-L], ZW5[A-L], ZX5[A-L], ZY5[A-L], ZZ5[A-L]', location = 'Santa Catarina <Pri:SC>' WHERE CountryCode = 108 AND DXCCSort = 52;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 13, PrefixList = 'PP6, PU6[A-I], ZV6[A-I], ZW6[A-I], ZX6[A-I], ZY6[A-I], ZZ6[A-I]', location = 'Sergipe <Pri:SE>' WHERE CountryCode = 108 AND DXCCSort = 62;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 13, PrefixList = 'PP7, PU7[A-D], Z[V-Z]7A, Z[V-Z]7B, Z[V-Z]7C, Z[V-Z]7D', location = 'Alagoas <Pri:AL>' WHERE CountryCode = 108 AND DXCCSort = 72;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 4, ITUZone = 13, PrefixList = 'PP8, PU8[A-C], Z[V-Z]8A, Z[V-Z]8B, Z[V-Z]8C', location = 'Amazonas <Pri:AM>' WHERE CountryCode = 108 AND DXCCSort = 82;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 13, PrefixList = 'PQ2, PU2[I-J], Z[V-Z]2I, Z[V-Z]2J', location = 'Tocantins <Pri:TO>' WHERE CountryCode = 108 AND DXCCSort = 23;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 13, PrefixList = 'PQ8, PU8[G-I], Z[V-Z]8G, Z[V-Z]8H, Z[V-Z]8I', location = 'Amapa <Pri:AP>' WHERE CountryCode = 108 AND DXCCSort = 83;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 13, PrefixList = 'PR7, PU7[E-H], Z[V-Z]7E, Z[V-Z]7F, Z[V-Z]7G, Z[V-Z]7H', location = 'Paraiba <Pri:PB>' WHERE CountryCode = 108 AND DXCCSort = 73;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 13, PrefixList = 'PR8, PU8[M-O], Z[V-Z]8M, Z[V-Z]8N, Z[V-Z]8O', location = 'Maranhao <Pri:MA>' WHERE CountryCode = 108 AND DXCCSort = 84;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 13, PrefixList = 'PS7, PU7[I-L], Z[V-Z]7I, Z[V-Z]7J, Z[V-Z]7K, Z[V-Z]7L', location = 'Rio Grande do Norte <Pri:RN>' WHERE CountryCode = 108 AND DXCCSort = 74;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 13, PrefixList = 'PS8, PU8[P-S], Z[V-Z]8P, Z[V-Z]8Q, Z[V-Z]8R, Z[V-Z]8S', location = 'Piaui <Pri:PI>' WHERE CountryCode = 108 AND DXCCSort = 85;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 13, PrefixList = 'PT2, PU2[A-E], Z[V-Z]2A, Z[V-Z]2B, Z[V-Z]2C, Z[V-Z]2D, Z[V-Z]2E', location = 'Brasilia <Pri:DF>' WHERE CountryCode = 108 AND DXCCSort = 24;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 13, PrefixList = 'PT7, PU7[M-P], Z[V-Z]7M, Z[V-Z]7N, Z[V-Z]7O, Z[V-Z]7P', location = 'Ceara <Pri:CE>' WHERE CountryCode = 108 AND DXCCSort = 75;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 5, ITUZone = 12, PrefixList = 'PT8, PU8[J-L], Z[V-Z]8J, Z[V-Z]8K, Z[V-Z]8L', location = 'Acre <Pri:AC>' WHERE CountryCode = 108 AND DXCCSort = 86;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 4, ITUZone = 13, PrefixList = 'PT9, PU9[A-N], Z[V-Z]9', location = 'Mato Grosso do Sul <Pri:MS>' WHERE CountryCode = 108 AND DXCCSort = 92;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 4, ITUZone = 12, PrefixList = 'PV8, PU8[T-V], Z[V-Z]8T, Z[V-Z]8U, Z[V-Z]8V', location = 'Roraima <Pri:RR>' WHERE CountryCode = 108 AND DXCCSort = 87;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 4, ITUZone = 12, PrefixList = 'PW8, PU8[D-F], Z[V-Z]8D, Z[V-Z]8E, Z[V-Z]8F', location = 'Rondonia <Pri:RO>' WHERE CountryCode = 108 AND DXCCSort = 88;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 15, PrefixList = 'PY1, PU1[J-Y], Z[V-Z]1', location = 'Rio de Janeiro <Pri:RJ>' WHERE CountryCode = 108 AND DXCCSort = 11;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 15, PrefixList = 'PY2, PU2[K-Y], Z[V-Z]2', location = 'Sao Paulo <Pri:SP>' WHERE CountryCode = 108 AND DXCCSort = 21;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 15, PrefixList = 'P[P-Y]3, Z[V-Z]3', location = 'Rio Grande do Sul <Pri:RS>' WHERE CountryCode = 108 AND DXCCSort = 31;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 15, PrefixList = 'P[P-Y]4, Z[V-Z]4', location = 'Minas Gerais <Pri:MG>' WHERE CountryCode = 108 AND DXCCSort = 41;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 15, PrefixList = 'PY5, PU5[M-Y], Z[V-Z]5', location = 'Parana <Pri:PR>' WHERE CountryCode = 108 AND DXCCSort = 51;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 13, PrefixList = 'PY6, PU6[J-Y], Z[V-Z]6', location = 'Bahia <Pri:BA>' WHERE CountryCode = 108 AND DXCCSort = 61;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 13, PrefixList = 'PY7, PU7[R-Y], Z[V-Z]7', location = 'Pernambuco <Pri:PE>' WHERE CountryCode = 108 AND DXCCSort = 71;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 3, ITUZone = 13, PrefixList = 'PY8, PU8[W-Y], Z[V-Z]8', location = 'Para <Pri:PA>' WHERE CountryCode = 108 AND DXCCSort = 81;");
	  $this->db->query("UPDATE `dxcc_master` SET TimeZone = 4, ITUZone = 13, PrefixList = 'PY9, PU9[O-Y], ZV9[O-Z], ZW9[O-Z], ZX9[O-Z], ZY9[O-Z], ZZ9[O-Z]', location = 'Mato Grosso <Pri:MT>' WHERE CountryCode = 108 AND DXCCSort = 91;");
	}

	public function down()
	{
	  // Reverts to the original content
	  // (from 105_create_dxcc_master_tables.php)
	  $this->db->query("DELETE FROM `dxcc_master` WHERE CountryCode = 108;");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',1,108,'P[P-Y], Z[V-Z]','Brazil','Brazil','SA','11',NULL,NULL,4.0,-15.8,-47.9167,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',22,108,'PP2, PU2[F-H], Z[V-Z]2F, Z[V-Z]2G, Z[V-Z]2H','Brazil','Goias <Pri:GO>','SA','11','',NULL,5.0,-15.8,-50.0,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',12,108,'PP1, PU1[A-I], ZV1[A-I], ZW1[A-I], ZX1[A-I], ZY1[A-I], ZZ1[A-I]','Brazil','Esprito Santo <Pri:ES>','SA','11','15',NULL,4.0,-20.0,-40.6,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',75,108,'PT7, PU7[M-P], Z[V-Z]7M, Z[V-Z]7N, Z[V-Z]7O, Z[V-Z]7P','Brazil','Ceara <Pri:CE>','SA','11','15',NULL,4.0,-5.6,-37.0,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',52,108,'PP5, PU5[A-L], ZV5[A-L], ZW5[A-L], ZX5[A-L], ZY5[A-L], ZZ5[A-L]','Brazil','Santa Catarina <Pri:SC>','SA','11','15',NULL,4.0,-27.0,-50.6,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',62,108,'PP6, PU6[A-I], ,ZV6[A-I], ZW6[A-I], ZX6[A-I], ZY6[A-I], ZZ6[A-I]','Brazil','Sergipe <Pri:SE>','SA','11','13',NULL,4.0,-10.7,-37.3,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',72,108,'PP7, PU7[A-D], Z[V-Z]7A, Z[V-Z]7B, Z[V-Z]7C, Z[V-Z]7D','Brazil','Algonas <Pri:AL>','SA','11','13',NULL,4.0,-9.8,-36.6,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',82,108,'PP8, PU8[A-C], Z[V-Z]8A, Z[V-Z]8B, Z[V-Z]8C','Brazil','Amazonas <Pri:AM>','SA','11','',NULL,4.0,-3.9,-65.0,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',86,108,'PT8, PU8[J-L], Z[V-Z]8J, Z[V-Z]8K, Z[V-Z]8L','Brazil','Acre <Pri:AC>','SA','11','12',NULL,4.0,-9.0,-70.3,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',11,108,'P[Q-Y]1, Z[V-Z]1','Brazil','Rio de Janeiro <Pri:RJ>','SA','11','15',NULL,4.0,-22.75,-43.0,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',21,108,'PR2,PS2,P[U-Y]2, Z[V-Z]2','Brazil','Sao Paulo <Pri:SP>','SA','11','15',NULL,4.0,-22.6,-48.3,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',31,108,'P[P-Y]3, Z[V-Z]3','Brazil','Rio Grande do Sul <Pri:RS>','SA','11','15',NULL,4.0,-29.8,-53.5,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',41,108,'P[P-Y]4, Z[V-Z]4','Brazil','Minas Gerias <Pri:MG>','SA','11','',NULL,4.0,-18.8,-45.2,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',51,108,'P[Q-Y]5, Z[V-Z]5','Brazil','Parana <Pri:PR>','SA','11','15',NULL,4.0,-24.8,-52.2,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',61,108,'P[Q-Y]6, Z[V-Z]6','Brazil','Bahia <Pri:BA>','SA','11','',NULL,4.0,-12.2,-42.1,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',71,108,'PQ7, P[U-Y]7,  Z[V-Z]7','Brazil','Pernambuco <Pri:PE>','SA','11','13',NULL,4.0,-8.5,-37.7,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',81,108,'P[X-Y]8, PU8[W-Y], Z[V-Z]8','Brazil','Para <Pri:PA>','SA','11','13',NULL,4.0,-3.3,-52.7,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',91,108,'P[P-S]9, P[U-Y]9, ZV9[O-Z], ZW9[O-Z], ZX9[O-Z], ZY9[O-Z], ZZ9[O-Z]','Brazil','Mato Grosso <Pri:MT>','SA','11','',NULL,4.0,-13.3,-56.0,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',23,108,'PQ2, PU2[I-J], Z[V-Z]2I, Z[V-Z]2J','Brazil','Tocantins <Pri:TO>','SA','11','13',NULL,4.0,-10.4,-48.4,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',84,108,'PR8, PU8[M-O], Z[V-Z]8M, Z[V-Z]8N ,Z[V-Z]8O','Brazil','Maranhao <Pri:MA>','SA','11','15',NULL,4.0,-4.9,-45.2,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',24,108,'PT2, PU2[A-E], Z[V-Z]2A, Z[V-Z]2B, Z[V-Z]2C, Z[V-Z]2D, Z[V-Z]2E','Brazil','Brasilia <Pri:DF>','SA','11','15',NULL,4.0,-15.9,-47.9,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',83,108,'PQ8, PU8[G-I], Z[V-Z]G ,Z[V-Z]8H, Z[V-Z]8I','Brazil','Amapa <Pri:AP>','SA','11','13',NULL,4.0,1.62,-52.1,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',73,108,'PR7, PU7[E-H], Z[V-Z]7E, Z[V-Z]7F, Z[V-Z]7G, Z[V-Z]7H','Brazil','Paraiba <Pri:PB>','SA','11','13',NULL,4.0,-7.1,-36.3,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',85,108,'PS8, PU8[P-S], Z[V-Z]8P, Z[V-Z]8Q, Z[V-Z]8R, Z[V-Z]8S','Brazil','Piaui <Pri:PI>','SA','11','13',NULL,4.0,-7.4,-42.4,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',74,108,'PS7, PU7[I-L], Z[V-Z]7I, Z[V-Z]7J, Z[V-Z]7K, Z[V-Z]7L','Brazil','Rio Grande del Norte <Pri:RN>','SA','11','12',NULL,4.0,-5.8,-36.7,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',87,108,'PV8, PU8[T-V], Z[V-Z]8T, Z[V-Z]8U, Z[V-Z]8]V','Brazil','Roraima <Pri:RR>','SA','11','',NULL,4.0,2.0,-62.0,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',88,108,'PW8, PU8[D-F], Z[V-Z]8D, Z[V-Z]8E, Z[V-Z]8F','Brazil','Rondonia <Pri:RO>','SA','11','12',NULL,4.0,-10.8,-63.0,NULL,NULL);");
	  $this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',92,108,'PT9, PU9[A-N], Z[V-Z]9','Brazil','Mato Grosso do Sul <Pri:MS>','SA','11','15',NULL,4.0,-20.7,-55.0,NULL,NULL);");
	}
}
