<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_create_dxcc_master_tables extends CI_Migration {

	public function up()
	{
	  if (!$this->db->table_exists('dxcc_master')) {
		$this->db->query("CREATE TABLE `dxcc_master` (
			`DXCCPrefix` varchar(6) DEFAULT NULL,
			`DXCCSearch` varchar(6) DEFAULT NULL,
			`DXCCMap` varchar(6) DEFAULT NULL,
			`DXCCSort` int(11) DEFAULT 0,
			`CountryCode` int(11) DEFAULT 0,
			`PrefixList` longtext DEFAULT NULL,
			`DXCCName` varchar(30) DEFAULT NULL,
			`Location` varchar(40) DEFAULT NULL,
			`Continent` varchar(2) DEFAULT NULL,
			`CQZone` varchar(2) DEFAULT NULL,
			`ITUZone` varchar(2) DEFAULT NULL,
			`IOTA` varchar(10) DEFAULT NULL,
			`TimeZone` float DEFAULT NULL,
			`Latitude` double DEFAULT NULL,
			`Longitude` double DEFAULT NULL,
			`StartDate` datetime DEFAULT NULL,
			`EndDate` datetime DEFAULT NULL,
			INDEX (`CountryCode`)) ENGINE=InnoDB DEFAULT CHARSET=utf8;");

		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('3',NULL,NULL,1,93,'~3,~1G9','Geyser Reef','Geyser Reef','AF','39','53',NULL,NULL,NULL,NULL,'1967-05-04 00:00:00.000','1978-02-28 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('4',NULL,NULL,1,2,'~4,~A1','Abu Ail Islands','Abu Ail Islands','AS','21','39',NULL,NULL,NULL,NULL,NULL,'1991-03-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('1M',NULL,NULL,1,178,'~1M','Minerva Reef','Minerva Reef','OC','32','62',NULL,NULL,NULL,NULL,NULL,'1972-07-15 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('4WY',NULL,NULL,1,154,'~4W','Yemen Arab Republic','Yemen Arab Republic','AS','21','39',NULL,NULL,NULL,NULL,NULL,'1990-05-21 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('7J1',NULL,NULL,1,194,'~7J1','Okino Tori-shima','Okino Tori-shima','AS','27','45',NULL,NULL,NULL,NULL,'1976-05-30 00:00:00.000','1980-11-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('8Z4',NULL,NULL,1,226,'~8Z4','Saudi Arabia/Iraq Neutral Zone','Saudi Arabia/Iraq Neutral Zone','AS','21','39',NULL,NULL,NULL,NULL,NULL,'1981-12-25 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('8Z5',NULL,NULL,1,68,'~8Z5,~9K3','Kuwait/Saudi Arabia NZ','Kuwait/Saudi Arabia Neutral Zone','AS','21','39',NULL,NULL,NULL,NULL,NULL,'1969-12-14 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('9S4',NULL,NULL,1,210,'~9S4','Saar','Saar','EU','14','28',NULL,NULL,NULL,NULL,NULL,'1957-03-31 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('9U5',NULL,NULL,1,208,'~9U5','Ruanda-Urundi','Ruanda-Urundi','AF','36','52',NULL,NULL,NULL,NULL,'1960-07-01 00:00:00.000','1962-06-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('AC3',NULL,NULL,1,231,'~AC3','Sikkim','Sikkim','AS','22','41',NULL,NULL,NULL,NULL,NULL,'1975-04-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('AC4',NULL,NULL,1,268,'~AC4','Tibet','Tibet','AS','23','41',NULL,NULL,NULL,NULL,NULL,'1974-05-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('C9M',NULL,NULL,1,164,'~C9M','Manchuria','Manchuria','AS','24','33',NULL,NULL,NULL,NULL,NULL,'1963-09-15 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CN2',NULL,NULL,1,264,'~CN2','Tangier','Tangier','AF','33','37',NULL,NULL,NULL,NULL,NULL,'1960-06-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CR8D',NULL,NULL,1,42,'~CR8D','Damao, Diu','Damao, Diu','AS','22','41',NULL,NULL,NULL,NULL,NULL,'1961-12-31 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CR8G',NULL,NULL,1,101,'~CR8G','Goa','Goa','AS','22','41',NULL,NULL,NULL,NULL,NULL,'1961-12-31 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CR8T',NULL,NULL,1,200,'~CR8T','Portuguese Timor','Portuguese Timor','OC','28','54',NULL,NULL,NULL,NULL,NULL,'1976-09-14 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EA9I',NULL,NULL,1,113,'~EA9I','Ifni','Ifni','AF','33','37',NULL,NULL,NULL,NULL,NULL,'1969-05-13 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FF',NULL,NULL,1,59,'~FF','French West Africa','French West Africa','AF','35','46',NULL,NULL,NULL,NULL,NULL,'1960-08-06 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FH8',NULL,NULL,1,39,'~FH8','Comoro Islands','Comoros (French)','AF','39','53',NULL,NULL,NULL,NULL,NULL,'1975-07-05 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FI8',NULL,NULL,1,58,'~FI8','French Indo-China','French Indo-China','AS','26','49',NULL,NULL,NULL,NULL,NULL,'1950-12-20 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FN8',NULL,NULL,1,67,'~FN8','French India','French India','AS','22','41',NULL,NULL,NULL,NULL,NULL,'1954-10-31 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FQ8',NULL,NULL,1,57,'~FQ8','French Equatorial Africa','French Equatorial Africa','AF','36',NULL,NULL,NULL,NULL,NULL,NULL,'1960-08-16 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HK0B',NULL,NULL,1,19,'~HK0B','Bajo Nuevo','Bajo Nuevo','NA','8','11',NULL,NULL,NULL,NULL,NULL,'1981-09-16 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HK0S',NULL,NULL,1,228,'~HK0S','Serrana Bank & Roncador Cay','Serrana Bank & Roncador Cay','NA','7','11',NULL,NULL,NULL,NULL,NULL,'1981-09-16 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I1',NULL,NULL,1,271,'~I1','Trieste','Trieste','EU','15','28',NULL,NULL,NULL,NULL,NULL,'1957-03-31 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I5',NULL,NULL,1,115,'~I5','Italian Somaliland','Italian Somaliland','AF','37','48',NULL,NULL,NULL,NULL,NULL,'1960-06-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JZ0',NULL,NULL,1,184,'~JZ0','Netherlands New Guinea','Netherlands New Guinea','OC','28','51',NULL,NULL,NULL,NULL,NULL,'1963-04-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KR6',NULL,NULL,1,193,'~KR6','Okinawa','Ryukyu Island','AS','25','45',NULL,NULL,NULL,NULL,NULL,'1972-05-14 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KS4',NULL,NULL,1,261,'~KS4','Swan Island','Swan Island','NA','7','11',NULL,NULL,NULL,NULL,NULL,'1972-08-31 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('P2P',NULL,NULL,1,198,'~P2P','Papua Territory','Papua Territory','OC','28','51',NULL,NULL,NULL,NULL,NULL,'1975-09-15 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('P2G',NULL,NULL,1,267,'~P2G','Territory of New Guinea','Territory of New Guinea','OC','28','51',NULL,NULL,NULL,NULL,NULL,'1975-09-15 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PK1',NULL,NULL,1,119,'~PK1','Java','Java','OC','28','54',NULL,NULL,NULL,NULL,NULL,'1963-04-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PK4',NULL,NULL,1,258,'~PK4','Sumatra','Sumatra','OC','28','54',NULL,NULL,NULL,NULL,NULL,'1963-04-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PK5',NULL,NULL,1,183,'~PK5','Netherlands Borneo','Netherlands Borneo','OC','28','54',NULL,NULL,NULL,NULL,NULL,'1963-04-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PK6',NULL,NULL,1,30,'~PK6','Celebes & Molucca Islands','Celebe and Molucca Islands','OC','28','54',NULL,NULL,NULL,NULL,NULL,'1963-04-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN1',NULL,NULL,1,128,'~UN1','Karelo-Finnish Rep.','Karelo-Finnish Rep.','EU','16','19',NULL,NULL,NULL,NULL,NULL,'1960-06-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VO',NULL,NULL,1,186,'~VO','Newfoundland and Labrador','Newfoundland and Labrador','NA',NULL,'9',NULL,NULL,NULL,NULL,NULL,'1949-03-31 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VQ1',NULL,NULL,1,307,'~VQ1','Zanzibar','Zanzibar','AF','37','53',NULL,NULL,NULL,NULL,NULL,'1974-05-31 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VQ6',NULL,NULL,1,26,'~VQ6','British Somaliland','British Somaliland','AF','37','48',NULL,NULL,NULL,NULL,NULL,'1960-06-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VQ9A',NULL,NULL,1,8,'~VQ9A','Aldabra','Aldabra','AF','39','53',NULL,NULL,NULL,NULL,NULL,'1976-06-28 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VQ9D',NULL,NULL,1,44,'~VQ9D','Desroches','Desroches','AF','39','53',NULL,NULL,NULL,NULL,NULL,'1976-06-28 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VQ9F',NULL,NULL,1,55,'~VQ9F','Farquhar','Farquhar','AF','39','53',NULL,NULL,NULL,NULL,NULL,'1976-06-28 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VS2',NULL,NULL,1,155,'~VS2','Malaya','Malaya','AS','28','54',NULL,NULL,NULL,NULL,NULL,'1963-09-15 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VS4',NULL,NULL,1,220,'~VS4','Sarawak','Sarawak','OC','28','54',NULL,NULL,NULL,NULL,NULL,'1963-09-15 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VS9A',NULL,NULL,1,243,'~VS9A','People''s Dem Rep of Yemen','Peoples Democratic Republic of Yemen','AS','21','39',NULL,NULL,NULL,NULL,NULL,'1990-05-21 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VS9H',NULL,NULL,1,139,'~VS9H','Kuria Muria Island','Kuria Muria Island','AS','21','39',NULL,NULL,NULL,NULL,NULL,'1967-11-29 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VS9K',NULL,NULL,1,127,'~VS9K','Kamaran Islands','Kamaran Island','AS','21','39',NULL,NULL,NULL,NULL,NULL,'1982-03-10 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZC5',NULL,NULL,1,25,'~ZC5','British North Borneo','British North Borneo','OC','28','54',NULL,NULL,NULL,NULL,NULL,'1963-09-15 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZC6',NULL,NULL,1,196,'~ZC6','Palestine (British)','Palestine (British)','AS','20','39',NULL,NULL,NULL,NULL,NULL,'1968-06-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZD4',NULL,NULL,1,102,'~ZD4','Gold Coast/Togoland','Gold Coast & Togoland','AF','35','46',NULL,NULL,NULL,NULL,NULL,'1957-03-05 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('1A','1A','1A',1,246,'1A','Sov. Military Order Of Malta','Sovereign Military Order Of Malta','EU','15','28','',-1.0,41.9051,12.4809,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('1S','1S','1S',1,247,'1S,9M0,9M7,9W0,9W7,BV9S,DU0K,DX0','Spratly Islands','Spratly Island','AS','26','50','AS-051',-8.0,7.372157,113.842992,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('3A','3A','3A',1,260,'3A','Monaco','Monaco','EU','14','27',NULL,-1.0,43.733,7.42,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('3B6','3B6','3B6',2,4,'3b6','Agalega & St Brandon Islands','Agalega Islands','AF','39','53','AF-001',-4.0,-10.3883,56.6165,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('3B8','3B8','3B8',1,165,'3B8,3B','Mauritius Island','Mauritius Island','AF','39','53','AF-049',-4.0,-20.1647,57.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('3B9','3B9','3B9',1,207,'3B9','Rodriguez Island','Rodriguez Island','AF','39','53','AF-017',-4.0,-19.7111,63.4333,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('3C','3C','3C',1,49,'3C','Equatorial Guinea','Equatorial Guinea','AF','36','47',NULL,-1.0,1.6667,10.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('3C0','3C0','3C0',1,195,'3C0','Annobon','Annobon Island','AF','36','52','AF-039',-1.0,-1.4333,5.6333,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('3D2-C','3D2','3D2-F',1,489,'3D2-C, 3D2C','Conway Reef','Conway Reef','OC','32','56','OC-112',-12.0,-21.7799,174.7815,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('3D2-F','3D2','3D2-F',1,176,'3D2,3D[N-Z],3D2-F','Fiji Islands','Fiji Islands','OC','32','56',NULL,-12.0,-17.8,178.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('3D2-R','3D2','3D2-F',1,460,'3D2-R','Rotuma','Rotuma Island','OC','32','56','OC-060',-12.0,-12.5,177.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('3DA','3DA','3DA',1,468,'3D[A-M],3D6','Swaziland','Swaziland','AF','38','57',NULL,-2.0,-26.5,31.3833,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('3V','3V','3V',1,474,'3V,TS','Tunisia','Tunisia','AF','33','37',NULL,-1.0,36.8333,10.167,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('3W','3W','3W',1,293,'3W,XV','Viet Nam','Vietnam','AS','26','49',NULL,-7.0,16.0667,108.1667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('3X','3X','3X',1,107,'3X','Guinea','Republic Of Guinea','AF','35','46',NULL,0.0,9.5375,-13.6792,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('3Y-B','3Y','3Y-B',1,24,'3Y-B,3Y5,3Y','Bouvet Island','Bouvet Island','AF','38','67','AN-002',0.0,-55.4167,3.3667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('3Y-P','3Y','3Y-P',1,199,'3Y-P,3Y0PI,3Y0X','Peter 1 Island','Peter I Island','AN','12','72','AN-004',6.0,-68.8333,-90.58333,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('4J','4J','4J',1,18,'4J,4K','Azerbaijan','Azerbaijan','AS','21','29',NULL,-4.0,40.5,48.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('R1M','UA','UA',1,151,'~R1M','Malyj Vysotski Island','Malyj Vysotski Island <Pri:MV>','EU','16','29','EU-117',-4.0,61.0,29.0,NULL,'2012-02-16 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('R1F','UA','UA',1,61,'RI1F,R1FJ,R1F','Franz Josef Land','Franz Josef Land <Pri:FJL>','EU','40','75','EU-019',-4.0,80.8,47.6667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('4L','4L','4L',3,75,'4L#Q,4L#R,4L#S','Georgia','Adjaria','AS','21','29',NULL,-4.0,42.0,45.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('4L','4L','4L',2,75,'4L#V,4L#W,4L#X','Georgia','Abkhazian','AS','21','29',NULL,-4.0,41.7,44.8,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('4S','4S','4S',1,315,'4[P-S]','Sri Lanka','Sri Lanka','AS','22','41',NULL,-5.5,7.0,80.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('4U1I','4U1I','HB',1,117,'4U#I,4U#W','ITU HQ','ITU (Switzerland)','EU','14','28',NULL,-1.0,46.2208,6.1369,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('4U1U','4U1U','K',1,289,'4U#U','United Nations HQ','United Nations (New York)','NA','5','8',NULL,5.0,40.7489,-73.9681,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('4X','4X','4X',1,336,'4X,4Z','Israel','Israel','AS','20','39',NULL,-2.0,31.7781,35.2352,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FO-A','F','FO-F',1,508,'FO-A','Austral Islands','Austral Islands','OC','32','63',NULL,10.0,-23.3667,-149.5,'1998-04-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('5A','5A','5A',1,436,'5A','Libya','Libya','AF','34','38',NULL,-2.0,32.875,13.175,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('5B','5B','5B',1,215,'5B,H2,P3,C4','Cyprus','Cyprus','AS','20','39','',-2.0,35.0,33.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('5H','5H','5H',1,470,'5H,5I','Tanzania','Tanzania','AF','37','53',NULL,-3.0,-6.1584,35.7225,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('5N','5N','5N',1,450,'5N,5O','Nigeria','Nigeria','AF','35','46',NULL,-1.0,9.0667,7.4792,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('5R','5R','5R',1,438,'5R,5S,6X','Madagascar','Madagascar','AF','39','53','AF-013',-3.0,-19.0,47.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('5T','5T','5T',1,444,'5T','Mauritania','Mauritania','AF','35','46',NULL,0.0,18.0983,-16.0222,'1960-06-20 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('5U','5U','5U',1,187,'5U','Niger','Niger','AF','35','46',NULL,-1.0,13.5117,2.1167,'1960-08-03 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('5V','5V','5V',1,483,'5V','Togo','Togo','AF','35','46',NULL,0.0,6.1667,1.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('5W','5W','5W',1,190,'5W','Samoa','Western Samoa','OC','32','62','OC-097',11.0,-13.85,-171.75,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('5X','5X','5X',1,286,'5X','Uganda','Uganda','AF','37','48',NULL,-3.0,1.3167,32.5833,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('5Z','5Z','5Z',1,430,'5Z,5Y','Kenya','Kenya','AF','37','48',NULL,-3.0,-1.2917,36.8222,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('6W','6W','6W',1,456,'6W,6V','Senegal','Senegal','AF','35','46',NULL,0.0,14.76,-17.3667,'1960-06-20 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('6Y','6Y','6Y',1,82,'6Y','Jamaica','Jamaica','NA','8','11','NA-097',5.0,18.1,-77.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('7O','7O','7O',1,492,'7O','Yemen','Yemen','AS','21','39',NULL,-3.0,13.0,45.0,'1990-05-22 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('7O','7O','7O',2,492,'7O','Yemen','Socotra','AF','37','48','AF-028',-3.0,12.0,52.0,'1990-05-22 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('7P','7P','7P',1,432,'7P','Lesotho','Lesotho','AF','38','57',NULL,-2.0,-30.0,28.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('7Q','7Q','7Q',1,440,'7Q','Malawi','Malawi','AF','37','53',NULL,-2.0,-13.9833,33.7833,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('7X','7X','7X',1,400,'7R,7[T-Y] ','Algeria','Algeria','AF','33','37',NULL,0.0,36.75,3.0417,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('8P','8P','8P',1,62,'8P','Barbados','Barbados','NA','8','11','NA-021',4.0,13.16,-59.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('8Q','8Q','8Q',1,159,'8Q','Maldives','Maldive Islands','AS','22','41','AS-013',-5.0,4.1742,73.5111,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('8R','8R','8R',1,129,'8R','Guyana','Guyana','SA','9','12',NULL,3.0,6.8,-58.1667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('9A','9A','9A',1,497,'9A','Croatia','Croatia','EU','15','28',NULL,-1.0,45.7667,15.975,'1991-06-26 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('9G','9G','9G',1,424,'9G','Ghana','Ghana','AF','35','46',NULL,0.0,8.0,-1.0,'1957-03-05 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('9H','9H','9H',1,257,'9H','Malta','Malta','EU','15','28','EU-023',-1.0,35.88,14.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('9J','9J','9J',1,482,'9J,9I','Zambia','Zambia','AF','36','53',NULL,-2.0,-15.4333,28.2833,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('9K','9K','9K',1,348,'9K','Kuwait','Kuwait','AS','21','39',NULL,-3.0,29.3667,47.9833,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('9L','9L','9L',1,458,'9L','Sierra Leone','Sierra Leone','AF','35','46',NULL,0.0,8.4833,-13.2289,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('9M2','9M2','9M',1,299,'9M2,9M4,9M,9W2,9W4','West Malaysia','West Malaysia','AS','28','54',NULL,-8.0,3.0,102.0,'1963-09-16 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('9M6','9M6','9M',1,46,'9M6,9M8,9W6,9W8','East Malaysia','East Malaysia','OC','28','54',NULL,-8.0,4.0,115.0,'1963-09-16 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('9N','9N','9N',1,369,'9N','Nepal','Nepal','AS','22','42',NULL,-5.75,27.7,85.333,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('9Q','9Q','9Q',1,414,'9[O-T],4U9Q','Dem. Republic of the Congo','Democratic Republic of the Congo','AF','36','52',NULL,-2.0,-4.3333,15.3167,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('9U','9U','9U',1,404,'9U','Burundi','Burundi','AF','36','52',NULL,-2.0,-3.3833,29.35,'1962-07-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('9V','9V','9V',1,381,'9V,S6','Singapore','Singapore','AS','28','54','AS-019',-7.0,1.4,103.8,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('9X','9X','9X',1,454,'9X','Rwanda','Rwanda','AF','36','52',NULL,-2.0,-1.95,30.0833,'1962-07-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('9Y','9Y','9Y',1,90,'9Y,9Z','Trinidad & Tobago','Trinidad & Tobago','SA','9','11',NULL,4.0,10.5,-61.25,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('A2','A2','A2',1,402,'A2,8O','Botswana','Botswana','AF','38','57',NULL,-2.0,-24.65,25.9,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('A3','A3','A3',1,160,'A3','Tonga','Tonga Islands','OC','32','62',NULL,-13.0,-21.16,-175.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('A4','A4','A4',1,370,'A4','Oman','Oman','AS','21','39',NULL,-4.0,23.4,58.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('A5','A5','A5',1,306,'A5','Bhutan','Bhutan','AS','22','41',NULL,-5.5,27.4333,89.6667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('A6','A6','A6',1,391,'A6','United Arab Emirates','United Arab Emirirates','AS','21','39',NULL,-4.0,24.4667,54.3667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('A7','A7','A7',1,376,'A7','Qatar','Qatar','AS','21','39','',-3.0,25.2833,51.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('A9','A9','A9',1,304,'A9','Bahrain','Bahrain','AS','21','39','AS-002',-3.0,26.1667,50.55,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('AP','AP','AP',1,372,'A[P-S],6[P-S]','Pakistan','Pakistan','AS','21','41',NULL,-5.0,30.0,70.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BS7','BY','BS7',1,506,'BS7','Scarborough Reef','Scarborough Reef','AS','27','50','AS-116',-8.0,15.1833,117.7667,'1995-01-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BV','BV','BV',1,386,'B[M-Q;U-X]','Taiwan','Taiwan','AS','24','44',NULL,-8.0,23.75,121.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BV9P','BV','BV9P',1,505,'BV9P, BQ9P','Pratas Island','Pratas Island','AS','24','44',NULL,-8.0,20.7011,116.7292,'1994-01-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',1,318,'B,XS,3[H-U]','China','China','AS','24',NULL,NULL,-8.0,31.0,104.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('C2','C2','C2',1,157,'C2','Nauru','Republic Of Nauru','OC','31','65','OC-031',-12.0,-0.5,166.9333,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('C3','C3','C3',1,203,'C3','Andorra','Andorra','EU','14','27',NULL,-1.0,43.5333,1.5833,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('C5','C5','C5',1,422,'C5','The Gambia','The Gambia','AF','35','46',NULL,0.0,13.4528,-16.5778,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('C6','C6','C6',1,60,'C6','Bahamas','Bahamas','NA','8','11',NULL,5.0,25.05,-77.4,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FO-M','F','FO-F',1,509,'FO-M,FO0CLA,TX4PG','Marquesas Islands','Marquesas Islands','OC','31','63','OC-027',9.5,-9.75,-139.0,'1998-04-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('C9','C9','C9',1,181,'C8,C9','Mozambique','Mozambique','AF','37','53',NULL,-2.0,-19.0,35.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE','CE','CE',2,112,'C[A-E]1,3G1,XR1,XQ1','Chile','Antofagasta, Atacama, Tarapaca, Arica','SA','12','14',NULL,4.0,-23.5,-69.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE','CE','CE',3,112,'C[A-E]2,3G2,XR2,XQ2','Chile','Coquimbo, Valparaiso','SA','12','14',NULL,4.0,-32.0,-71.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE','CE','CE',4,112,'C[A-E]3,3G3,XR3,XQ3','Chile','Santiago City','SA','12','14',NULL,4.0,-34.0,-71.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE','CE','CE',5,112,'C[A-E]4,3G4,XR4,XQ4','Chile','L.G.B.O.H, Maule','SA','12','14',NULL,4.0,-35.0,-71.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE','CE','CE',6,112,'C[A-E]5,3G5,XR5,XQ5','Chile','Bio Bio','SA','12','14',NULL,4.0,-37.0,-72.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE','CE','CE',7,112,'C[A-E]6,3G6,XR6,XQ6','Chile','Arauncinia, Los Gatos, Los Rios','SA','12','',NULL,4.0,-40.0,-73.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE','CE','CE',8,112,'C[A-E]7,3G7,XR7,XQ7','Chile','Aisen del Gen. C. I. del Campo','SA','12','16',NULL,4.0,-47.0,-73.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE','CE','CE',1,112,'CE,XQ,XR,3G,CA,CB,CC,CD','Chile','Chile','SA','12',' ',NULL,4.0,-33.0,-71.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE0Y','CE','CE0E',1,47,'C[A-E]0,XQ0,XR0,3G0','Easter Island','Easter Island','SA','12','63','',7.0,-27.1193,-109.33,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE0X','CE','CE',1,217,'C[A-E]0X,XQ0X,XR0X,3G0X','San Felix Island','San Felix','SA','12','14','SA-013',4.0,-26.2912,-80.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE0Z','CE','CE',1,125,'C[A-E]0Z,3G0Z,XQ0Z,XR0Z','Juan Fernandez Island','Juan Fernandez','SA','12','14','SA-005',6.0,-33.6389,-78.8667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',6,13,'3Y9','Antarctica','Tor & Troll Station (Norway)','AN','39','67',NULL,0.0,-72.0,4.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',21,13,'RI1ANA','Antarctica','Molodezhnaya Station (Russia)','AN','39','69',NULL,0.0,-67.67,45.86,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',22,13,'RI1ANB,RI1ANT','Antarctica','Mirnyy Station (Russia)','AN','29','69','AN-016',0.0,-66.55,93.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',20,13,'RI1ANC,RI1AN','Antarctica','Vostok Station (Russia)','AN','29','70','AN-016',-6.0,-78.47,106.8,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',23,13,'RI1AND,RI1ANN,RI1ANR','Antarctica','Novolazarevskaya Station (Russia)','AN','38','67','AN-016',0.0,-70.77,11.83,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',24,13,'RI1ANG','Antarctica','Leningradskaya Station (Russia)','AN','30','70',NULL,0.0,-69.5,159.38,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',25,13,'RI1ANH','Antarctica','Russkaya Station (Russia)','AN','32','72',NULL,0.0,-74.77,-136.87,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',26,13,'RI1ANJ','Antarctica','Druzhnaya 1 Station (Russia)','AN','12','74',NULL,0.0,-77.42,-40.08,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',27,13,'RI1ANK','Antarctica','Komsomolskaya Station (Russia)','AN','29','69',NULL,0.0,-74.0,97.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',28,13,'RI1ANL','Antarctica','Pioneerskaya Station (Russia)','AN','29','69','AN-016',0.0,-74.0,96.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',30,13,'7S8AAA,7S8BBB','Antarctica','Svea & Wasa (Sweden)','AN','38','67',NULL,0.0,-73.7,-11.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',18,13,'8J1RL','Antarctica','Syowa Bases (Japan)','AN','39','67','AN-015',3.0,-69.0,39.6,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',17,13,'AT0','Antarctica','Maitri Station (India)','AN','38','67',NULL,0.0,-70.75,11.77,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',1,13,'CE9','Antarctica','Gen.B.Higgens Base  (Chile)','AN','13','73',NULL,4.0,-63.32,57.9,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',16,13,'FT#Y,FT-Y','Antarctica','Dumont Durville Base (France)','AN','30','70',NULL,-10.0,-66.67,140.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',15,13,'IA0','Antarctica','Concordia Station (Italy)','AN','13','71',NULL,0.0,-75.1,-123.33,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',14,13,'KC4AAA,KC4AAD,KC4AAE,KC4AAF,KC4US','Antarctica','Asmudsen-Scott South Pole Station (USA)','AN','','74','AN-016',-12.0,-90.0,0.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',13,13,'KC4AAB, KC4AAC','Antarctica','Palmer Station (USA)','AN','13','73','AN-012',4.0,-64.77,-64.05,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',12,13,'KC4USV','Antarctica','McMurdo Station (USA)','AN','30','71','AN-011',-12.0,-77.85,166.67,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',3,13,'AY#Z, AZ#Z, LU#Z, LU#ZB','Antarctica','Belgrano Bases (Argentina)','AN','13','73',NULL,3.0,-77.87,34.62,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',4,13,'AY#ZG, AZ#ZG, LU#ZG','Antarctica','Grahamland Bases (Argentina)','AN','13','73',NULL,0.0,-65.0,60.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',9,13,'VK0-C','Antarctica','Casey Base (Australia)','AN','29','70',NULL,-11.0,-66.28,110.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',10,13,'VK0-D,VK0DX,VK0BP','Antarctica','Davis Base  (Australia)','AN','39','69','AN-016',-5.0,-68.58,77.97,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',8,13,'ZL5?,ZL0AIC','Antarctica','Antarctica (New Zealand)','AN','30','71',NULL,0.0,-90.0,0.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',7,13,'ZS7ANT','Antarctica','Sanae Base (South Africa)','AN','38','67','AN-016',0.0,-71.67,-2.85,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CN','CN','CN',1,446,'CN,5[C-G]','Morocco','Morocco','AF','33','37',NULL,0.0,32.0,-6.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CO','CO','CO',1,70,'CL,CM,CO,T4','Cuba','Cuba','NA','8','11',NULL,5.0,22.4,-80.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CP','CP','CP',1,104,'CP','Bolivia','Bolivia','SA','10',NULL,NULL,4.0,-17.0,-68.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CP','CP','CP',2,104,'CP1','Bolivia','La Paz','SA','10','',NULL,4.0,-15.0,-68.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CP','CP','CP',3,104,'CP2','Bolivia','Chuquisaca','SA','10','14',NULL,4.0,-20.0,-64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CP','CP','CP',4,104,'CP3','Bolivia','Oruro','SA','10','14',NULL,4.0,-19.0,-68.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CP','CP','CP',5,104,'CP4','Bolivia','Potosi','SA','10','14',NULL,4.0,-21.0,-67.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CP','CP','CP',6,104,'CP5','Bolivia','Cochabamba','SA','10','14',NULL,4.0,-17.0,-66.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CP','CP','CP',7,104,'CP6','Bolivia','Santa Cruz','SA','10','',NULL,4.0,-17.0,-63.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CP','CP','CP',8,104,'CP7','Bolivia','Tarija','SA','10','14',NULL,4.0,-21.0,-64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CP','CP','CP',9,104,'CP8','Bolivia','El Beni','SA','10','',NULL,4.0,-14.0,-65.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CP','CP','CP',10,104,'CP9','Bolivia','Pando','SA','10','12',NULL,4.0,-11.0,-67.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CT','CT','CT',1,272,'CT,CQ,CR,CS','Portugal','Portugal','EU','14','37',NULL,0.0,39.0,-9.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CT3','CT','CT3',1,256,'CQ2,CQ3,CR3,CS3,CT3,CQ9,CR9,CS9,CT9','Madeira Islands','Madeira & Porto Santo Islands <Pri:MD>','AF','33','36','',0.0,32.75,-17.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CU','CU','CU',1,149,'CU,CQ1,CR1,CR2,CS4,CQ8,CR8,CS8,CT8','Azores','Azores','EU','14','36',NULL,1.0,38.0,-27.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CU','CU','CU',9,149,'CU1','Azores','Ilha De Santa Maria','EU','14','36','EU-003',1.0,38.0,-25.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CU','CU','CU',8,149,'CU2','Azores','Ilha De S. Miguel','EU','14','36','EU-003',1.0,38.0,-26.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CU','CU','CU',4,149,'CU3','Azores','Ilha Da Terceira','EU','14','36','EU-175',1.0,38.0,-27.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CU','CU','CU',3,149,'CU4','Azores','Ilha Da Graciosa','EU','14','36','EU-175',1.0,38.0,-27.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CU','CU','CU',10,149,'CU5','Azores','Ilha De S. Jorge','EU','14','36','EU-175',1.0,3.75,-25.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CU','CU','CU',6,149,'CU6','Azores','Ilha Do Pico','EU','14','36','EU-175',1.0,38.0,-28.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CU','CU','CU',5,149,'CU7','Azores','Ilha Do Faial','EU','14','36','EU-175',1.0,38.0,-27.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CU','CU','CU',2,149,'CU8','Azores','Ilha Das Flores','EU','14','36','EU-089',1.0,39.0,-31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CU','CU','CU',7,149,'CU9','Azores','Ilha Do Corvo','EU','14','36','EU-089',1.0,39.0,-31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',1,144,'CX,CV,CW','Uruguay','Uruguay','SA','13','14',NULL,3.0,-32.75,-56.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CY0','VE','CY0',1,211,'CY0','Sable Island','Sable Island','NA','5','9','NA-063',4.0,43.9333,-59.9167,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CY9','VE','CY9',1,252,'CY9','Saint Paul Island','St. Paul Island','NA','5','9','NA-094',4.0,47.2,-60.15,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('D2','D2','D2',1,401,'D2,D3','Angola','Angola','AF','36','52',NULL,-1.0,-11.0,18.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('D4','D4','D4',1,409,'D4','Cape Verde','Cape Verde','AF','35','46','',1.0,15.0625,-23.5833,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('D6','D6','D6',1,411,'D6','Comoros','Comoros','AF','39','53','AF-007',-3.0,-11.0,43.333,'1975-07-05 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('DA','DL','DL',1,81,'~DL,~DA','Germany','West Germany','EU','14','28',NULL,-1.0,51.0,10.0,NULL,'1973-09-16 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('DL','DL','DL',1,230,'D[A-R],Y#','Federal Republic of Germany','Germany','EU','14','28',NULL,-1.0,51.0,10.0,'1973-09-17 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('DU','DU','DU',1,375,'D[U-Z],4[D-I]','Philippines','Philippines','OC','27','50',NULL,-8.0,12.0,123.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('H40','H4','H4',1,507,'H40','Temotu Province','Temotu','OC','32','51',NULL,-11.0,-10.7167,166.0,'1998-04-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('4L','4L','4L',1,75,'4L','Georgia','Georgian Republic','AS','21','29',NULL,-4.0,41.7083,44.7917,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('E3','E3','E3',1,51,'E3','Eritrea','Eritrea','AF','37','48',NULL,-3.0,15.33,38.9167,'1991-05-24 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EA','EA','EA',1,281,'A[M-O],E[A-H]','Spain','Spain','EU','14','37',NULL,-1.0,40.0,-4.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EA6','EA','EA',1,21,'E[A-H]6,A[M-O]6','Balearic Islands','Balearic Islands <Pri:IB>','EU','14','37','EU-004',-1.0,39.5,3.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EA8','EA','EA8',1,29,'E[A-H]8,A[M-O]8','Canary Islands','Canary Islands','AF','33','36','AF-004',0.0,27.95,-15.55,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EA9','EA','EA',1,32,'E[A-H]9,A[M-O]9','Ceuta & Melilla','Ceuta & Melilla','AF','33','37',NULL,-1.0,35.28,-2.95,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EI','EI','EI',1,245,'EI,EJ','Ireland','Ireland','EU','14','27','',0.0,53.25,-7.75,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EK','EK','EK',1,14,'EK','Armenia','Armenia','AS','21','29',NULL,-4.0,40.25,45.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EL','EL','EL',1,434,'A8,EL,5L,D5,5M,6Z','Liberia','Liberia','AF','35','46',NULL,0.0,6.5,-9.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EP','EP','EP',1,330,'EP,EQ,9B,9C,9D','Iran','Iran','AS','21','40',NULL,-3.5,35.6667,51.4167,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ER','ER','ER',1,179,'ER','Moldova','Moldova','EU','16','29',NULL,-3.0,47.0334,28.8334,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ES','ES','ES',1,52,'ES','Estonia','Estonia','EU','15','29',NULL,-3.0,59.0,25.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ET','ET','ET',1,53,'ET,9E,9F','Ethiopia','Ethiopia','AF','37','48',NULL,-3.0,9.0,38.75,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EW','EW','EW',1,27,'EU,EV,EW','Belarus','Belarus','EU','16','29',NULL,-3.0,54.0,27.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OM','OM','OM',9,504,'OM0','Slovakia','Presov','EU','15','28',NULL,-1.0,49.2917,21.275,'1993-01-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EW','EW','EW',2,27,'E[U-W]1,E[U-W]2','Belarus','Minskaya <Pri:MI>','EU','16','29',NULL,-3.0,54.0,28.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EW','EW','EW',3,27,'E[U-W]3','Belarus','Brestskaya <Pri:BR>','EU','16','29',NULL,-3.0,54.0,28.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EW','EW','EW',4,27,'E[U-W]4','Belarus','Hrodzenskaya <Pri:HR>','EU','16','29',NULL,-3.0,54.0,28.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EW','EW','EW',5,27,'E[U-W]6','Belarus','Vietebskaya <Pri:VI>','EU','16','29',NULL,-3.0,54.0,28.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EW','EW','EW',6,27,'E[U-W]7','Belarus','Mahilyowskaya <Pri:MA>','EU','16','29',NULL,-3.0,54.0,28.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EW','EW','EW',7,27,'E[U-W]8','Belarus','Homyelskaya <Pri:HO>','EU','16','29',NULL,-3.0,53.9167,27.55,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EX','EX','EX',1,135,'EX','Kyrgyzstan','Kyrgyzstan','AS','17',NULL,NULL,-6.0,42.0,75.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EX','EX','EX',2,135,'EX#M','Kyrgyzstan','Kyrgyzstan','AS','17','',NULL,-6.0,42.0,75.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EX','EX','EX',3,135,'EX#N','Kyrgyzstan','Oshkaya','AS','17','30',NULL,-6.0,42.0,75.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EX','EX','EX',4,135,'EX#P','Kyrgyzstan','Narynsky','AS','17','',NULL,-6.0,42.0,75.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EX','EX','EX',5,135,'EX#Q','Kyrgyzstan','Issyk Kul Przhevalsk','AS','17','31',NULL,-6.0,42.0,75.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EX','EX','EX',6,135,'EX#T','Kyrgyzstan','Talasskaya','AS','17','30',NULL,-6.0,42.0,75.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EY','EY','EY',1,262,'EY','Tajikistan','Tadzhikistan','AS','17','30',NULL,-5.0,38.75,71.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EY','EY','EY',2,262,'EY4','Tajikistan','Gorno Badakhstan','AS','17','30',NULL,-5.0,40.0,67.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EY','EY','EY',3,262,'EY5','Tajikistan','Kulyabskaya','AS','17','30',NULL,-5.0,40.0,67.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EY','EY','EY',4,262,'EY6','Tajikistan','Kurgan Tyubinskaya','AS','17','30',NULL,-5.0,40.0,67.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EY','EY','EY',5,262,'EY7','Tajikistan','Leninabad','AS','17','30',NULL,-5.0,40.0,67.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EY','EY','EY',6,262,'EY8','Tajikistan','Tadzhik','AS','17','30',NULL,-5.0,40.0,67.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EY','EY','EY',7,262,'EY9','Tajikistan','Nurek','AS','17','30',NULL,-5.0,40.0,67.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EZ','EZ','EZ',1,280,'EZ','Turkmenistan','Turkmenistan','AS','17','30',NULL,-5.0,39.0,59.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EZ','EZ','EZ',2,280,'EZ5','Turkmenistan','Maryiskaya','AS','17','30',NULL,-5.0,37.0,62.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EZ','EZ','EZ',3,280,'EZ6','Turkmenistan','Dashkovuzsky Veloyat','AS','17','30',NULL,-5.0,41.0,59.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EZ','EZ','EZ',4,280,'EZ7','Turkmenistan','Lebapsky Veloyat','AS','17','30',NULL,-5.0,38.0,65.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('EZ','EZ','EZ',5,280,'EZ8','Turkmenistan','Ashkhabad City','AS','17','30',NULL,-5.0,37.95,58.3833,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('F','F','F',1,227,'F,TH,TM,TP,TQ,TV,TW,HW,HX,HY','France','France','EU','14','27',NULL,-1.0,47.0,4.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FG','F','FG',1,79,'FG','Guadeloupe','Guadeloupe','NA','8','11','',4.0,16.15,-61.6,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FH','F','FH',1,169,'FH','Mayotte Island','Mayotte','AF','39','53','AF-027',-3.0,-12.75,45.1667,'1975-07-05 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FK','F','FK',1,162,'FK','New Caledonia','New Caledonia','OC','32','56',NULL,-11.0,-21.2666,166.4333,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FM','F','FM',1,84,'FM','Martinique','Martinique','NA','8','11','NA-107',4.0,14.6,-61.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FO0','F','FO-C',1,36,'FO0CI,FO0AAA,FO0','Clipperton Island','Clipperton Island','NA','7','10','NA-011',7.0,10.3,-109.2167,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FO-F','F','FO-F',1,175,'FO','French Polynesia','French Polynesia','OC','32','63',NULL,10.0,-17.6,-149.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FP','F','FP',1,277,'FP','Saint Pierre & Miquelon','Saint Pierre & Miquelon Island','NA','5','9','NA-032',3.0,46.77,-56.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FR-G','F','FR-G',1,99,'FR-G,FT#G','Glorioso Island','Glorioso Island','AF','39','53','AF-011',-4.0,-11.58,47.3,'1960-06-25 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FR-J','F','FR-J',1,124,'FR-J,FT#J','Juan de Nova','Juan de Nova Island','AF','39','53','AF-012',-4.0,-17.0555,42.733,'1960-06-25 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FR','F','FR-R',1,453,'FR','Reunion Island','Reunion Island','AF','39','53','AF-016',-4.0,-21.1,55.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FR-T','F','FR-T',1,276,'FR-T,FT#T','Tromelin Island','Tromelin Island','AF','39','53','AF-031',-4.0,-15.8917,54.5236,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FS','F','FS',1,213,'FS','Saint Martin','Saint Martin, Leeward Islands','NA','8','11',NULL,4.0,18.0695,-63.0833,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FT8W','F','FT8',1,41,'FT#W,FB8W,FT-W','Crozet Island','Crozet Island','AF','39','68','AF-008',-3.0,-46.4167,51.75,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FT8X','F','FT8',1,131,'FT#X,FB8X,FT-X','Kerguelen Island','Kerguelen Island','AF','39','68','AF-048',-5.0,-49.3333,69.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FT8Z','F','FT8',1,10,'FT#Z,FB8Z,FT-Z','Amsterdam & Saint Paul Islands','Amsterdam & SaintPaul Islands','AF','39','68','AF-002',-5.0,-37.1667,77.55,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FW','F','FW',1,298,'FW','Wallis & Futuna Islands','Wallis Island','OC','32','62','',-12.0,-13.28,-176.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FY','F','FY',1,63,'FY','French Guiana','French Guiana','SA','9','12',NULL,3.0,4.8333,-52.333,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('G','G','G',1,223,'G,M,2','England','England','EU','14','27',NULL,0.0,53.0,-1.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('GD','G','GD',1,114,'GD,MD,GT,MT,2D,2T','Isle Of Man','Isle Of Man','EU','14','27','EU-116',0.0,54.25,-4.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('GI','G','GI',1,265,'GI,MI,GN,MN,2I,2N','Northern Ireland','Northern Ireland','EU','14','27','',0.0,54.75,-6.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('GJ','G','GJ',1,122,'GJ,MJ,GH,MH,2J,2H','Jersey','Jersey','EU','14','27',NULL,0.0,49.25,-2.15,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('GM','G','G',1,279,'GM,GS,GA,MM,MS,MA,2M,2S,2A','Scotland','Scotland','EU','14','27',NULL,0.0,56.33,-4.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('GU','GU','GU',1,106,'GU,MU,GP,MP,2U,2P','Guernsey','Guernsey','EU','14','27','EU-114',-1.0,49.4,-2.6,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('GW','G','G',1,294,'GW,MW,GC,MC,2W,2C','Wales','Wales','EU','14','27',NULL,0.0,52.5,-3.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('H4','H4','H4',1,185,'H44, H4','Solomon Islands','Solomon Islands','OC','28','51',NULL,-11.0,-9.5,160.1667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HA','HA','HA',1,239,'HA,HG','Hungary','Hungary','EU','15','28',NULL,-1.0,47.5,19.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HB','HB','HB',1,287,'HB,HE','Switzerland','Switzerland','EU','14','28',NULL,-1.0,47.0,8.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HB0','HB','HB0',1,251,'HB0,HE0','Liechtenstein','Liechtenstein','EU','14','28',NULL,-1.0,47.1667,9.55,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HC','HC','HC',1,120,'HC,HD','Ecuador','Ecuador','SA','10','12',NULL,5.0,-13.0,-78.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HC','HC','HC',2,120,'HC1,HD1','Ecuador','Ecuador 1','SA','10','12',NULL,5.0,0.0,-78.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HC','HC','HC',6,120,'HC2,HD2','Ecuador','Ecuador 2','SA','10','12',NULL,5.0,-2.0,-79.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HC','HC','HC',8,120,'HC3,HD3','Ecuador','Ecuador 3','SA','10','12',NULL,5.0,-4.0,-79.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HC','HC','HC',7,120,'HC4,HD4','Ecuador','Ecuador 4','SA','10','12',NULL,5.0,-1.0,-80.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HC','HC','HC',5,120,'HC5,HD5','Ecuador','Ecuador 5','SA','10','12',NULL,5.0,-3.0,-78.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HC','HC','HC',4,120,'HC6,HD6','Ecuador','Ecuador 6','SA','10','12',NULL,5.0,-3.0,-78.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HC','HC','HC',3,120,'HC7,HD7','Ecuador','Ecuador 7','SA','10','12',NULL,5.0,-2.0,-76.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HC8','HC','HC',9,71,'HC8,HD8','Galapagos Islands','Galapagos Islands','SA','10','12','SA-004',5.0,-0.6,-90.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HH','HH','HH',1,78,'HH,4V','Haiti','Haiti','NA','8','11',NULL,5.0,18.6,-72.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HI','HI','HI',1,72,'HI','Dominican Republic','Dominican Republic','NA','8','11',NULL,4.0,19.0,-70.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HK','HK','HK',1,116,'HK,5J,HJ,5K','Colombia','Colombia','SA','9','12',NULL,5.0,4.5,-74.1667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HK','HK','HK',8,116,'HK1,5J1,HJ1,5K1','Colombia','Colombia  1','SA','9','12',NULL,5.0,8.0,-75.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HK','HK','HK',7,116,'HK2,5J2,HJ2,5K2','Colombia','Colombia 2','SA','9','12',NULL,5.0,9.0,-74.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HK','HK','HK',6,116,'HK3,5J3,HJ3,5K3','Colombia','Colombia 3','SA','9','12',NULL,5.0,5.0,-71.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HK','HK','HK',2,116,'HK4,5J4,HJ4,5K4','Colombia','Colombia 4','SA','9','12',NULL,5.0,5.0,-77.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HK','HK','HK',5,116,'HK5,5J5,HJ5,5K5','Colombia','Colombia 5','SA','9','12',NULL,5.0,2.0,-77.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HK','HK','HK',9,116,'HK6,5J6,HJ6,5K6','Colombia','Colombia 6','SA','9','12',NULL,5.0,2.0,-76.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HK','HK','HK',4,116,'HK7,5J7,HJ7,5K7','Colombia','Colombia 7','SA','9','12',NULL,5.0,7.0,-73.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HK','HK','HK',3,116,'HK8,5J8,HJ8,5K8','Colombia','Colombia 8','SA','9','12',NULL,5.0,1.0,-75.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HK0-M','HK','HK0-M',1,161,'HK0T,HJ0M,HK0M,HK0-M','Malpelo Island','Malpelo Island','SA','9','12','SA-007',5.0,4.1333,-81.61,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HK0-S','HK','HK0-S',1,216,'HK0,5J0,5K0,HJ0,HK0-S','San Andres Island','San Andres & Providencia','NA','7','11',NULL,5.0,12.5833,-81.7167,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HL','HL','HL',1,137,'HL,DS,DT,D7,D8,D9,6K,6L,6M,6N','Republic of Korea','South Korea','AS','25','44',NULL,-9.0,37.0,128.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HP','HP','HP',1,88,'HP,HO,H3,H8,H9,3E,3F','Panama','Panama','NA','7','11',NULL,5.0,9.25,-79.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HR','HR','HR',1,80,'HR,HQ','Honduras','Honduras','NA','7','11',NULL,6.0,14.1,-87.25,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HS','HS','HS',1,387,'HS,E2','Thailand','Thailand','AS','26','49',NULL,-7.0,13.75,100.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HV','HV','HV',1,295,'HV','Vatican','Vatican City','EU','15','28',NULL,-1.0,41.9022,12.4533,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('HZ','HZ','HZ',1,378,'HZ,7Z,8Z','Saudi Arabia','Saudi Arabia','AS','21','39',NULL,-3.0,24.7167,46.75,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',1,248,'I','Italy','Italy','EU','15','28',NULL,-1.0,42.5,13.1667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',21,248,'IT9,IW9','Italy','Sicily <Reg:IT9>','EU','15','28','EU-025',-1.0,37.5,14.1667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('IS0','I','I',1,225,'IS0,IM0,IW0[U-Z]','Sardinia','Sardinia','EU','15','28',NULL,-1.0,40.1667,9.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('J2','J2','J2',1,382,'J2','Djibouti','Djibouti','AF','37','48',NULL,-3.0,11.5833,43.1458,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('J3','J3','J3',1,77,'J3,VP2G','Grenada','Grenada','NA','8','11','',4.0,12.1,-61.7,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('J5','J5','J5',1,109,'J5','Guinea-Bissau','Guinea-Bissau','AF','35','46',NULL,0.0,11.8667,-15.6,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('J6','J6','J6',1,97,'J6,VP2L','Saint Lucia','Saint Lucia','NA','8','11','NA-108',4.0,13.9,-61.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('J7','J7','J7',1,95,'J7,VP2D','Dominica','Dominica','NA','8','11','NA-101',4.0,15.4,-61.33,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('J8','J8','J8',1,98,'J8, VP2S','Saint Vincent','St Vincent','NA','8','11','',4.0,13.25,-61.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JA','JA','JA',1,339,'JA,J[E-S]','Japan','Japan','AS','25','45',NULL,-9.0,36.33,138.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JA','JA','JA',9,339,'JA6,J[E-R]6,7J6','Japan','Kyushu','AS','25','45',NULL,-9.0,33.0,131.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JA','JA','JA',8,339,'JA5,J[E-S]5,7J5','Japan','Shikoku','AS','25','45','AS-076',-9.0,34.0,133.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JA','JA','JA',12,339,'JA8,J[E-S]8,7J8','Japan','Hokkaido','AS','25','45',NULL,-9.0,43.0,143.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JA','JA','JA',10,339,'JR6[R-Z],JS6,7J6C','Japan','Okinawa','AS','25','45','AS-017',-9.0,26.0,128.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JD1-M','JA','JD1-M',1,177,'JD1-M,JD1M,JD1YBJ','Minami Torishima','Minami Torishima Island <Pri:MT>','OC','27','90','OC-073',-10.0,24.23,153.9,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JD1-O','JA','JD1-O',1,192,'JD1-O,JD1,8N1OGA,JD1BLG','Ogasawara','Ogasawara Island <Pri:O>','AS','27','45',NULL,-9.0,27.07,142.22,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JT','JT','JT',1,363,'JT,JU,JV','Mongolia','Mongolia','AS','23',NULL,NULL,-8.0,47.8,107.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JW','JW','JW',1,259,'JW','Svalbard','Svalbard Island','EU','40','18',NULL,-1.0,78.22,15.65,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JX','JX','JX',1,118,'JX','Jan Mayen','Jan Mayen Island','EU','40','18','EU-022',1.0,71.05,-8.4,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JY','JY','JY',1,342,'JY','Jordan','Jordan','AS','20','39',NULL,-2.0,32.0,36.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('K','K','K',12,291,'4U1WB','United States','World Bank (Washington DC)','NA','5','8',NULL,5.0,39.0,-77.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('K','K','K',1,291,'K,W,N','United States','United States','NA',NULL,NULL,NULL,6.0,39.0,-98.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('K','K','K',11,291,'K0,K$0,N0,N$0,W0,W$0,A&0','United States','United States','NA','4','7',NULL,6.0,41.0,-100.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('K','K','K',2,291,'K1,K%1,N1,N%1,W1,W%1,A&1','United States','United States','NA','5','8',NULL,5.0,44.0,-72.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('K','K','K',3,291,'K2,K%2,N2,N%2,W2,W%2,A&2','United States','United States','NA','5','8',NULL,5.0,42.0,-75.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('K','K','K',4,291,'K3,K%3,N3,N%3,W3,W%3,A&3,K3J?','United States','United States','NA','5','8',NULL,5.0,39.0,-77.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('K','K','K',5,291,'K4,K%4,N4,N%4,W4,W%4,A&4','United States','United States','NA',NULL,'',NULL,5.0,33.0,-83.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('K','K','K',6,291,'K5,K%5,N5,N%5,W5,W%5,A&5','United States','United States','NA','4','',NULL,6.0,33.0,-94.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('K','K','K',8,291,'K7,K$7,N7,N$7,W7,W$7,A&7','United States','United States','NA','3',NULL,NULL,7.0,44.0,-115.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('K','K','K',9,291,'K8,K$8,N8,N$8,W8,W$8,A&8','United States','United States','NA',NULL,'',NULL,5.0,40.0,-83.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('K','K','K',10,291,'K9,K$9,N9,N$9,W9,W$9,A&9','United States','United States','NA','4',NULL,NULL,6.0,40.0,-89.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('K','K','K',7,291,'K6,K$6,N6,N$6,W6,W$6,A&6','United States','United States','NA','3','6',NULL,8.0,37.0,-120.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('T8','T8','T8',1,22,'T8','Palau','Western Caroline and Palau Island','OC','27','64','OC-009',-10.0,7.5,134.6166,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KH0','K','KH0',1,166,'KH0,AH0,NH0,WH0','Mariana Islands','Mariana Islands','OC','27','64','OC-086',-10.0,15.1667,145.75,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KH1','K','KH1',1,20,'KH1,AH1,WH1,NH1','Baker & Howland Islands','Baker and Howland Islands','OC','31','61','OC-089',11.0,0.1958,-176.479,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KH2','K','KH2',1,103,'KH2,AH2,WH2,NH2','Guam','Guam','OC','27','64','OC-026',-10.0,13.4667,144.75,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KH3','K','KH3',1,123,'KH3,AH3,NH3,WH3','Johnston Island','Johnston Island','OC','31','61','OC-023',10.0,16.72,179.52,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KH4','K','KH4',1,174,'KH4','Midway Island','Midway Island','OC','31','61','OC-030',11.0,28.2083,-177.3667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KH5-K','K','KH5-K',1,134,'~KH5-K','Kingman Reef','Kingman Reef','OC','31','61','OC-096',10.0,6.3912,-162.3417,NULL,'2016-03-29 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KH5-P','K','KH5-P',1,197,'KH5,WH5,AH5,NH5,KH5-P','Palmyra & Jarvis Islands','Palmyra Island','OC','31','61',NULL,10.0,5.8889,-162.0778,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KH6','K','KH6',1,110,'KH6,WH6,NH6,AH6,KH7[A-J;L-Z],WH7,NH7,AH7','Hawaii','Hawaiian Islands','OC','31','61','',10.0,21.3333,-157.9167,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KH7K','K','KH7',1,138,'KH7K','Kure Island','Kure Island','OC','31','61','OC-020',10.0,28.39,-178.29,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KH8','K','KH8',1,9,'KH8,AH8,NH8,WH8','American Samoa','American Samoa','OC','32','62',NULL,11.0,-14.3,-170.7,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KH9','K','KH9',1,297,'KH9,NH9,AH9,WH9','Wake Island','Wake Island','OC','31','65','OC-053',-12.0,19.28,166.65,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KL7','K','KL7',1,6,'KL#,NL#,WL#,AL#','Alaska','Alaska','NA','1','',NULL,9.0,65.0,-151.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KP1','K','KP1',1,182,'KP1,NP1,WP1','Navassa Island','Navassa Island','NA','8','11','NA-098',5.0,18.4,-75.008,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KP2','K','KP2',1,285,'KP2,NP2,WP2,KV4FZ,KV4AA','US Virgin Islands','U.S. Virgin Islands','NA','8','11','NA-106',4.0,18.35,-64.93,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KP4','K','KP4',1,202,'KP4,WP4,NP4,KP3,NP3,WP3','Puerto Rico','Puerto Rico','NA','8','11','NA-099',4.0,18.25,-66.5,'1979-05-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KP5','K','KP5',1,43,'KP5,NP5,WP5','Desecheo Island','Desecheo Island','NA','8','11','NA-095',4.0,18.38,-67.47,'1979-05-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KZ5','K','HP',1,28,'~KZ5','Canal Zone','Canal Zone','NA','7','11',NULL,5.0,9.0,-81.0,NULL,'1979-09-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LA','LA','LA',1,266,'L[A-N]','Norway','Norway','EU','14','18',NULL,-1.0,59.9139,10.7523,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LX','LX','LX',1,254,'LX','Luxembourg','Luxembourg','EU','14','27',NULL,-1.0,49.6111,6.1292,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LY','LY','LY',1,146,'LY','Lithuania','Lithuania','EU','15','29',NULL,-3.0,54.8834,23.8834,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LZ','LZ','LZ',1,212,'LZ','Bulgaria','Bulgaria','EU','20','28',NULL,-2.0,42.7017,23.3334,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OA','OA','OA',1,136,'O[A-C],4T','Peru','Peru','SA','10','12',NULL,5.0,-12.1,-76.9,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OA','OA','OA',9,136,'O[A-C]1,4T1','Peru','Peru 1','SA','10','12',NULL,5.0,-5.0,-81.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OA','OA','OA',8,136,'O[A-C]2,4T2','Peru','Peru 2','SA','10','12',NULL,5.0,-7.0,-78.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',2,100,'AY#A,AZ#A,L#A,LO#A,LP#A,LQ#A','Argentina','Buenos Aires City <Pri:C>','SA','13','14',NULL,3.0,-34.5,-58.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OA','OA','OA',7,136,'O[A-C]3,4T3','Peru','Peru 3','SA','10','12',NULL,5.0,-9.0,-76.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OA','OA','OA',6,136,'O[A-C]4,4T4','Peru','Peru 4','SA','10','12',NULL,5.0,-13.0,-76.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OA','OA','OA',2,136,'O[A-C]5,4T5','Peru','Peru 5','SA','10','12',NULL,5.0,-15.0,-74.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OA','OA','OA',5,136,'O[A-C]6,4T6','Peru','Peru 6','SA','10','12',NULL,5.0,-18.0,-72.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OA','OA','OA',10,136,'O[A-C]7,4T7','Peru','Peru 7','SA','10','12',NULL,5.0,-15.0,-72.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OA','OA','OA',4,136,'O[A-C]8,4T8','Peru','Peru 8','SA','10','12',NULL,5.0,-5.0,-75.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OA','OA','OA',3,136,'O[A-C]9,4T9','Peru','Peru 9','SA','10','12',NULL,5.0,-7.0,-77.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OD','OD','OD',1,354,'OD','Lebanon','Lebanon','AS','20','39',NULL,-2.0,33.8889,35.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OE','OE','OE',1,206,'OE','Austria','Austria','EU','15','28',NULL,-1.0,48.2083,16.3736,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OH','OH','OH',1,224,'O[F-J]','Finland','Finland','EU','15','18',NULL,-2.0,60.2,24.95,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OH0','OH','OH',1,5,'O[F-I]0','Aland Island','Aland Island','EU','15','18','EU-002',-2.0,60.1528,19.95,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OJ0','OH','OH',1,167,'OJ0','Market Reef','Market Reef','EU','15','18','EU-053',-1.0,60.3011,19.1314,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OK','OK','OK',1,218,'~OK','Czechoslovakia','Czechoslovakia','EU','15','28',NULL,-1.0,50.0,14.0,NULL,'1992-12-31 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OL','OL','OL',1,503,'OK,OL','Czech Republic','Czech Republic','EU','15','28',NULL,-1.0,50.0834,14.45,'1993-01-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OM','OM','OM',1,504,'OM','Slovakia','Slovakia','EU','15','28',NULL,-1.0,48.6667,19.5,'1993-01-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ON','ON','ON',1,209,'O[N-T]','Belgium','Belgium','EU','14','27',NULL,-1.0,50.845,4.3639,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OX','OX','OX',1,237,'OX,XP','Greenland','Greenland','NA','40','',NULL,3.0,64.1917,-51.6778,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OY','OY','OY',1,222,'OY,OW','Faroe Islands','Faroe Islands','EU','14','18','EU-018',0.0,62.0167,-6.7667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OZ','OZ','OZ',1,221,'OZ,OU,OV,5P,5Q','Denmark','Denmark','EU','14','18',NULL,-1.0,55.3,10.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('P2','P2','P2',1,163,'P2','Papua New Guinea','Papua New Guinea','OC','28','51',NULL,-10.0,-9.25,147.2,'1975-09-16 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('P4','P4','P4',1,91,'P4','Aruba','Aruba','SA','9','11','SA-036',4.0,12.5,-70.0,'1986-01-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('P5','P5','P5',1,344,'P5,P6,P7,P8,P9,HM','DPRK (North Korea)','North Korea','AS','25','44',NULL,-9.0,39.0333,125.75,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PA','PA','PA',1,263,'P[A-I]','Netherlands','Netherlands','EU','14','27',NULL,-1.0,52.3667,4.85,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('E4','E4','E4',1,510,'E4','Palestine','Palestine','AS','20','39',NULL,-2.0,31.9,35.2042,'1999-02-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PJ4','PJ2','PJ',1,520,'PJ4','Bonaire','Bonaire','SA','9','11','SA-006',4.0,12.2,-68.25,'2010-10-10 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PJ5','PJ5','PJ',1,519,'PJ5','Saba & Saint Eustatius','St Eustatius Is.','NA','8','11','NA-145',4.0,17.49,-61.97,'2010-10-10 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',1,108,'P[P-Y], Z[V-Z]','Brazil','Brazil','SA','11',NULL,NULL,4.0,-15.8,-47.9167,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',22,108,'PP2, PU2[F-H], Z[V-Z]2F, Z[V-Z]2G, Z[V-Z]2H','Brazil','Goias <Pri:GO>','SA','11','',NULL,5.0,-15.8,-50.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',12,108,'PP1, PU1[A-I], ZV1[A-I], ZW1[A-I], ZX1[A-I], ZY1[A-I], ZZ1[A-I]','Brazil','Esprito Santo <Pri:ES>','SA','11','15',NULL,4.0,-20.0,-40.6,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',75,108,'PT7, PU7[M-P], Z[V-Z]7M, Z[V-Z]7N, Z[V-Z]7O, Z[V-Z]7P','Brazil','Ceara <Pri:CE>','SA','11','15',NULL,4.0,-5.6,-37.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',52,108,'PP5, PU5[A-L], ZV5[A-L], ZW5[A-L], ZX5[A-L], ZY5[A-L], ZZ5[A-L]','Brazil','Santa Catarina <Pri:SC>','SA','11','15',NULL,4.0,-27.0,-50.6,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',62,108,'PP6, PU6[A-I], ,ZV6[A-I], ZW6[A-I], ZX6[A-I], ZY6[A-I], ZZ6[A-I]','Brazil','Sergipe <Pri:SE>','SA','11','13',NULL,4.0,-10.7,-37.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',72,108,'PP7, PU7[A-D], Z[V-Z]7A, Z[V-Z]7B, Z[V-Z]7C, Z[V-Z]7D','Brazil','Algonas <Pri:AL>','SA','11','13',NULL,4.0,-9.8,-36.6,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',82,108,'PP8, PU8[A-C], Z[V-Z]8A, Z[V-Z]8B, Z[V-Z]8C','Brazil','Amazonas <Pri:AM>','SA','11','',NULL,4.0,-3.9,-65.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',86,108,'PT8, PU8[J-L], Z[V-Z]8J, Z[V-Z]8K, Z[V-Z]8L','Brazil','Acre <Pri:AC>','SA','11','12',NULL,4.0,-9.0,-70.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',11,108,'P[Q-Y]1, Z[V-Z]1','Brazil','Rio de Janeiro <Pri:RJ>','SA','11','15',NULL,4.0,-22.75,-43.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',21,108,'PR2,PS2,P[U-Y]2, Z[V-Z]2','Brazil','Sao Paulo <Pri:SP>','SA','11','15',NULL,4.0,-22.6,-48.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',31,108,'P[P-Y]3, Z[V-Z]3','Brazil','Rio Grande do Sul <Pri:RS>','SA','11','15',NULL,4.0,-29.8,-53.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',41,108,'P[P-Y]4, Z[V-Z]4','Brazil','Minas Gerias <Pri:MG>','SA','11','',NULL,4.0,-18.8,-45.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',51,108,'P[Q-Y]5, Z[V-Z]5','Brazil','Parana <Pri:PR>','SA','11','15',NULL,4.0,-24.8,-52.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',61,108,'P[Q-Y]6, Z[V-Z]6','Brazil','Bahia <Pri:BA>','SA','11','',NULL,4.0,-12.2,-42.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',71,108,'PQ7, P[U-Y]7,  Z[V-Z]7','Brazil','Pernambuco <Pri:PE>','SA','11','13',NULL,4.0,-8.5,-37.7,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',81,108,'P[X-Y]8, PU8[W-Y], Z[V-Z]8','Brazil','Para <Pri:PA>','SA','11','13',NULL,4.0,-3.3,-52.7,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',91,108,'P[P-S]9, P[U-Y]9, ZV9[O-Z], ZW9[O-Z], ZX9[O-Z], ZY9[O-Z], ZZ9[O-Z]','Brazil','Mato Grosso <Pri:MT>','SA','11','',NULL,4.0,-13.3,-56.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',23,108,'PQ2, PU2[I-J], Z[V-Z]2I, Z[V-Z]2J','Brazil','Tocantins <Pri:TO>','SA','11','13',NULL,4.0,-10.4,-48.4,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',84,108,'PR8, PU8[M-O], Z[V-Z]8M, Z[V-Z]8N ,Z[V-Z]8O','Brazil','Maranhao <Pri:MA>','SA','11','15',NULL,4.0,-4.9,-45.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',24,108,'PT2, PU2[A-E], Z[V-Z]2A, Z[V-Z]2B, Z[V-Z]2C, Z[V-Z]2D, Z[V-Z]2E','Brazil','Brasilia <Pri:DF>','SA','11','15',NULL,4.0,-15.9,-47.9,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',83,108,'PQ8, PU8[G-I], Z[V-Z]G ,Z[V-Z]8H, Z[V-Z]8I','Brazil','Amapa <Pri:AP>','SA','11','13',NULL,4.0,1.62,-52.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',73,108,'PR7, PU7[E-H], Z[V-Z]7E, Z[V-Z]7F, Z[V-Z]7G, Z[V-Z]7H','Brazil','Paraiba <Pri:PB>','SA','11','13',NULL,4.0,-7.1,-36.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',85,108,'PS8, PU8[P-S], Z[V-Z]8P, Z[V-Z]8Q, Z[V-Z]8R, Z[V-Z]8S','Brazil','Piaui <Pri:PI>','SA','11','13',NULL,4.0,-7.4,-42.4,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',74,108,'PS7, PU7[I-L], Z[V-Z]7I, Z[V-Z]7J, Z[V-Z]7K, Z[V-Z]7L','Brazil','Rio Grande del Norte <Pri:RN>','SA','11','12',NULL,4.0,-5.8,-36.7,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY0-F','PY','PY',1,56,'PY0-F,P[P-Y]0F,P[P-Y]0ZF','Fernando De Noronha','Fernando De Noronha','SA','11','13','SA-003',2.0,-3.8333,-32.4,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY0-F','PY','PY',2,56,'Z[V-Z]0F,Z[V-Z]0ZF','Fernando De Noronha','Fernando De Noronha','SA','11','13','SA-003',2.0,-3.8333,-32.4,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY0-S','PY','PY',1,253,'PY0-S,P[P-Y]0S,P[P-Y]0ZS,Z[V-Z]0S,Z[V-Z]0ZS','Saint Peter & Saint Paul Rocks','Saint Peter and Saint Paul Rocks','SA','11','13','SA-014',2.0,0.9167,-29.3458,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY0-T','PY','PY',1,273,'PY0-T,P[P-Y]0T,P[P-Y]0ZT,Z[V-Z]0T,Z[V-Z]0ZT,ZV0M','Trindade & Martim Vaz Islands','Trindade and Martim Vas Islands','SA','11','15','SA-010',2.0,-20.5083,-29.3333,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PZ','PZ','PZ',1,140,'PZ','Suriname','Suriname','SA','9','12',NULL,3.0,5.8333,-55.1667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('S0','S0','S0',1,302,'S0','Western Sahara','Western Sahara','AF','33','46',NULL,0.0,24.5,-13.75,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('S2','S2','S2',1,305,'S2,S3','Bangladesh','Bangladesh','AS','22','41',NULL,-6.0,23.7,90.4,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('S5','S5','S5',1,499,'S5','Slovenia','Slovenia','EU','15','28',NULL,-1.0,46.05,14.5,'1991-06-26 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('S7','S7','S7',1,379,'S7','Seychelles Islands','Seychelles Islands','AF','39','53',NULL,-4.0,-4.6167,55.45,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('S9','S9','S9',1,219,'S9','Sao Tome & Principe','Sao Tome','AF','36','47','',0.0,0.333,6.725,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('SM','SM','SM',1,284,'S[A-M],7S,8S','Sweden','Sweden','EU','14','18',NULL,-1.0,59.3292,18.0653,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('SP','SP','SP',1,269,'S[N-R],HF,3Z','Poland','Poland','EU','15','28',NULL,-1.0,52.2334,21.0167,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ST','ST','ST',1,466,'ST,6T,6U','Sudan','Sudan','AF','34','',NULL,-2.0,15.55,32.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ST0','ST0','ST0',1,244,'~ST0,~6T0,~6U0','Southern Sudan','Southern Sudan','AF','34','',NULL,-2.0,5.0,32.0,'1972-05-07 00:00:00.000','1998-04-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('SU','SU','SU',1,478,'SU,6A,6B','Egypt','Egypt','AF','34','38',NULL,-2.0,30.05,31.25,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('SV','SV','SV',1,236,'S[V-Z],J4','Greece','Greece','EU','20','28',NULL,-2.0,38.0,23.725,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('SV-A','SV','SV',1,180,'SV-A,SV2ASP,SV2RSG','Mount Athos','Mount Athos','EU','20','28',NULL,-2.0,40.1667,24.3334,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('SV5','SV','SV',1,45,'S[V-Z]5,J45','Dodecanese','Dodecanese','EU','20','28','EU-001',-2.0,36.2,28.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('SV9','SV','SV',1,40,'S[V-Z]9,J49','Crete','Crete','EU','20','28','',-2.0,35.25,25.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('T2','T2','T2',1,282,'T2','Tuvalu','Tuvalu','OC','31','65','OC-015',-12.0,-7.4834,178.683,'1976-01-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('T30','T30','T3',1,301,'T30','Western Kiribati','Western Kiribati','OC','31','65','OC-017',-12.0,1.3517,173.0414,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('T31','T31','T3',1,31,'T31','Central Kiribati','Central Kiribati','OC','31','62','OC-043',-13.0,-2.7695,-171.7178,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('T32','T32','FO-F',1,48,'T32','Eastern Kiribati','Eastern Kiribati','OC','31','','',-14.0,1.9987,-157.3539,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('T33','T33','T3',1,490,'T33','Banaba Island','Banaba Island','OC','31','65','OC-018',-11.0,-0.8583,169.3333,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('T5','T5','T5',1,232,'T5,6O','Somalia','Somalia','AF','37','48',NULL,-3.0,2.05,45.33,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('T7','T7','T7',1,278,'T7','San Marino','San Marino','EU','15','28',NULL,-1.0,43.9333,12.45,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('E7','E7','E7',1,501,'E7','Bosnia-Herzegovina','Bosnia-Herzegovina','EU','15','28',NULL,-1.0,43.8567,18.4131,'1991-10-15 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('TA','TA','TA',2,390,'TA,TB,TC,YM','Turkey','Turkey (Asia)','AS','20','39',NULL,-3.0,39.9167,33.8667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('TF','TF','TF',1,242,'TF','Iceland','Iceland','EU','40','17',NULL,0.0,64.667,-18.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('TG','TG','TG',1,76,'TG,TD','Guatemala','Guatemala','NA','7','11',NULL,6.0,14.64,-90.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('TI','TI','TI',1,308,'TI,TE','Costa Rica','Costa Rica','NA','7','11',NULL,6.0,9.9333,-84.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('TI9','TI','TI9',1,37,'TI9,TE9','Cocos Island','Cocos Island','NA','7','11','NA-012',6.0,5.55,-87.05,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('TJ','TJ','TJ',1,406,'TJ','Cameroon','Cameroon','AF','36','47',NULL,-1.0,3.9167,11.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('TK','F','TK',1,214,'TK','Corsica','Corsica','EU','15','28','',-1.0,42.1,9.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('TL','TL','TL',1,408,'TL','Central African Republic','Central African Republic','AF','36','47',NULL,-1.0,4.3667,18.5,'1960-08-13 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('TN','TN','TN',1,412,'TN','Republic of the Congo','Congo','AF','36','52',NULL,-1.0,-4.25,15.25,'1960-08-15 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('TR','TR','TR',1,420,'TR','Gabon','Gabon','AF','36','52',NULL,-1.0,0.4167,9.5,'1960-08-17 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('TT','TT','TT',1,410,'TT','Chad','Chad','AF','36','47',NULL,-1.0,12.1083,15.1,'1960-08-11 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('TU','TU','TU',1,428,'TU','Cote D''Ivoire','Ivory Coast','AF','35','46',NULL,0.0,6.8167,-5.2833,'1960-08-07 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('TY','TY','TY',1,416,'TY','Benin','Benin','AF','35','46',NULL,-1.0,6.5111,2.6,'1960-08-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('TZ','TZ','TZ',1,442,'TZ','Mali','Mali','AF','35','46',NULL,0.0,12.667,-8.0,'1960-06-20 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',5,54,'R?1A,R?1B,U!1A,U!1B,R?1L,R[A-H;J-Z]1M,U!1L,U!1M','European Russia','St. Petersburg <Pri:SP>','EU','16','',NULL,-4.0,59.6,30.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',7,54,'R?1C,R?1D,U!1C,U!1D,R1C,R1D,U1C,U1D','European Russia','Leningrad <Pri:LO>','EU','16','',NULL,-4.0,59.6,30.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',10,54,'R[A-H;J-Z]1O,R1O,U!1O,U1O','European Russia','Arkhangelsk <Pri:AR>','EU','16','75',NULL,-4.0,64.3,40.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',12,54,'R[A-H;J-Z]1P,U!1P,R1P,U1P','European Russia','Nenetsky Autonomous Okrug <Pri:NO>','EU','16','',NULL,-4.0,67.8,53.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',14,54,'R?1Q,U!1Q,R1Q,U1Q,R?1R,U!1R,R1R,U1R,R?1S,U!1S,R1S,U1S','European Russia','Vologda <Pri:VO>','EU','16','',NULL,-4.0,59.1,39.9,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',15,54,'R?1T,U!1T,R1T,U1T','European Russia','Novgorod <Pri:NV>','EU','16','29',NULL,-4.0,58.3,31.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',16,54,'R?1W,U!1W,R1W,U1W,R?1X,U!1X,R1X,U1X','European Russia','Pskov <Pri:PS>','EU','16','29',NULL,-4.0,57.5,28.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',17,54,'R?1Z,U!1Z,R1Z,U1Z,R!1Y,U!1Y,R1Y,U1Y','European Russia','Murmansk <Pri:MU>','EU','16','19',NULL,-4.0,68.8,33.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',18,54,'R[B-Z]2A,R[B-Z]2B,R[B-Z]2C,R2A,R2B,R2C,U2A,U2B,U2C','European Russia','Moscow <Pri:MA>','EU','16','29',NULL,-4.0,55.5,38.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',22,54,'R?3D,U!3D,R?3F,U!3F,R?3H,U!3H,R3D,R3F,R3H,U3D,U3H','European Russia','Moscow region <Pri:MO>','EU','16','29',NULL,-4.0,55.5,38.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',24,54,'R[B-Z]2E,R2E,U2E,R?3E,U!3E,R3E,U3E,R?5E,U!5E,R5E','European Russia','Orel <Pri:OR>','EU','16','29',NULL,-4.0,52.6,46.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',25,54,'R[B-Z]2G,R2G,U2G,R?3G,U!3G,R3G,U3G,R?5G,U!5G,R5G','European Russia','Lipetsk <Pri:LP>','EU','16','29',NULL,-4.0,52.4,39.6,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',26,54,'R[B-Z]2I,R[B-Z]2J,R2I,R2J,U2I,U2J','European Russia','Tver <Pri:TV>','EU','16','29',NULL,-4.0,56.5,35.9,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',29,54,'R[B-Z]2L,R2L,U2L,R?3L,U!3L,R3L,U3L,R?5L,U!5L,R5L','European Russia','Smolensk <Pri:SM>','EU','16','29',NULL,-4.0,54.5,32.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',30,54,'R[B-Z]2M,R2M,U2M,R?3M,U!3M,R3M,U3M,R?5M,U!5M,R5M','European Russia','Yaroslavl <Pri:YR>','EU','16','29',NULL,-4.0,57.4,39.9,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',31,54,'R[B-Z]2N,R2N,U2N,R?3N,U!3N,R3N,U3N,R?5N,U!5N,R5N','European Russia','Kostroma <Pri:KS>','EU','16','29',NULL,-4.0,57.5,40.9,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',32,54,'R[B-Z]2P,R2P,U2P,R?3P,U!3P,R3P,U3P,R?5P,U!5P,R5P','European Russia','Tula <Pri:TL>','EU','16','29',NULL,-4.0,54.1,39.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',34,54,'R[B-Z]2Q,R2Q,U2Q,R?3Q,U!3Q,R3Q,U3Q,R?5Q,U!5Q,R5Q','European Russia','Voronezh <Pri:VR>','EU','16','29',NULL,-4.0,51.4,39.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',36,54,'R[B-Z]2R,R2R,U2R,R?3R,U!3R,R3R,U3R,R?5R,U!5R,R5R','European Russia','Tambov <Pri:TB>','EU','16','29',NULL,-4.0,52.4,41.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',37,54,'R[B-Z]2S,R2S,U2S,R?3S,U!3S,R3S,U3S,R?5S,U!5S,R5S','European Russia','Ryazan <Pri:RA>','EU','16','29',NULL,-4.0,54.4,39.8,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',38,54,'R[B-Z]2T,R2T,U2T,R?3T,U!3T,R3T,U3T,R?5T,U!5T,R5T','European Russia','Nizhny Novgorod <Pri:NN>','EU','16','29',NULL,-4.0,56.2,44.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',39,54,'R[B-Z]2U,R2U,U2U,R?3U,U!3U,R3U,U3U,R?5U,U!5U,R5U','European Russia','Ivanovo <Pri:IV>','EU','16','29',NULL,-4.0,57.1,41.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',40,54,'R[B-Z]2V,R2V,U2V,R?3V,U!3V,R3V,U3V,R?5V,U!5V,R5V','European Russia','Vladimir <Pri:VL>','EU','16','29',NULL,-4.0,56.1,40.4,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',41,54,'R[B-Z]2W,U[B-I]2W,R2W,U2W,R?3W,U!3W,R3W,U3W,R?5W,U!5W,R5W','European Russia','Kursk <Pri:KU>','EU','16','29',NULL,-4.0,51.4,36.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',42,54,'R[B-Z]2X,R2X,U2X,R?3X,U!3X,R3X,U3X,R?5X,U!5X,R5X','European Russia','Kaluga <Pri:KG>','EU','16','29',NULL,-4.0,54.3,36.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',43,54,'R[B-Z]2Y,R2Y,U2Y,R?3Y,U!3Y,R3Y,U3Y,R?5Y,U!5Y,R5Y','European Russia','Bryansk <Pri:BR>','EU','16','29',NULL,-4.0,53.2,34.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',44,54,'R[B-Z]2Z,R2Z,U2Z,R?3Z,U!3Z,R3Z,U3Z,R?5Z,U!5Z,R5Z','European Russia','Belgorod <Pri:BO>','EU','16','29',NULL,-4.0,50.4,36.7,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',45,54,'R?4A,R?4B,U!4A,U!4B,R4A,U4A','European Russia','Volgograd <Pri:VG>','EU','16','29',NULL,-4.0,48.4,44.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',46,54,'R?4C,R?4D,U!4C,U!4D,R4C,R4D,U4C,U4D','European Russia','Saratov <Pri:SA>','EU','16','',NULL,-4.0,51.3,46.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',47,54,'R?4F,U!4F,R4F,U4F','European Russia','Penza <Pri:PE>','EU','16','29',NULL,-4.0,53.1,45.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',48,54,'R?4H,R?4I,U!4H,U!4I,R4H,R4I,U4H,U4I','European Russia','Samara <Pri:SR>','EU','16','',NULL,-4.0,53.1,50.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',49,54,'R?4L,R?4M,U!4L,U!4M,R4L,R4M,U4L,U4M','European Russia','Uljanovsk <Pri:UL>','EU','16','29',NULL,-4.0,54.2,48.4,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',50,54,'R?4N,R?4O,U!4N,U!4O,R4N,R4O,U4N,U4O','European Russia','Kirov <Pri:KI>','EU','16','30',NULL,-4.0,58.4,49.7,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',51,54,'R?4P,R?4Q,R?4R,U!4P,U!4Q,U!4R,R4P,R4Q,R4R,U4P,U4Q,U4R','European Russia','Republic of Tataria <Pri:TA>','EU','16','',NULL,-4.0,55.5,49.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',52,54,'R?4S,R?4T,U!4S,U!4T,R4S,R4T,U4S,U4T','European Russia','Republic of Marij-El <Pri:MR>','EU','16','29',NULL,-4.0,56.6,47.9,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',53,54,'R?4U,U!4U,R4U,U4U','European Russia','Republic of Mordovia <Pri:MD>','EU','16','29',NULL,-4.0,54.1,45.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',54,54,'R?4W,U!4W,R4W,U4W','European Russia','Republic of Udmurtia <Pri:UD>','EU','16','30',NULL,-4.0,57.1,52.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',55,54,'R?4Y,R?4Z,U!4Y,U!4Z,R4Y,R4Z,U4Y,U4Z','European Russia','Republic of Chuvashia <Pri:CU>','EU','16','29',NULL,-4.0,56.8,47.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',56,54,'R?6A,R?6B,R?6C,R?6D,U!6A,U!6B,U!6C,U!6D,R6A,R6B,R6C,R6D,U6A,U6B,U6C,U6D,R?7A,R?7B,R?7C,R?7D,U!7A,U!7B,U!7C,U!7D,R7A,R7B,R7C,R7D','European Russia','Krasnodar <Pri:KR>','EU','16','29',NULL,-4.0,45.1,39.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',58,54,'R?6E,U!6E,R6E,U6E,R?7E,U!7E,R7E','European Russia','Repub of Karachaevo-Cherkessia <Pri:KC>','EU','16','29',NULL,-4.0,43.8,41.8,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',59,54,'R?6F,R?6G,R?6H,U!6F,U!6G,U!6H,R6F,R6G,R6H','European Russia','Stavropol <Pri:ST>','EU','16','29',NULL,-4.0,45.2,41.9,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',60,54,'R?6I,U!6I,R6I,U6I,R?7I,U!7I,R7I','European Russia','Republic of Kalmykia <Pri:KM>','EU','16','29',NULL,-4.0,46.2,44.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',61,54,'R?6J,U!6J,R6J,U6J,R?7J,U!7J,R7J','European Russia','Republic of Northern Ossetia <Pri:SO>','EU','16','29',NULL,-4.0,43.1,44.7,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',62,54,'R?6L,R?6M,R?6N,U!6L,U!6M,U!6N,R6L,R6M,R6N,U6L,U6M,U6N','European Russia','Rostov <Pri:RO>','EU','16','29',NULL,-4.0,47.1,39.7,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',64,54,'R?6P,U!6P,R6P,U6P,R?7P,U!7P,R7P','European Russia','Republic of Chechnya <Pri:CN>','EU','16','29',NULL,-4.0,43.2,45.8,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',66,54,'R?6U,U!6U,R6U,U6U,R?7U,U!7U,R7U','European Russia','Astrakhan <Pri:AO>','EU','16','29',NULL,-4.0,47.0,48.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',68,54,'R?6W,U!6W,R6W,U6W,R?7W,U!7W,R7W','European Russia','Republic of Daghestan <Pri:DA>','EU','16','29',NULL,-4.0,43.1,47.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',69,54,'R?6X,U!6X,R6X,U6X,R?7X,U!7X,R7X','European Russia','Republic of Kabardino-Balkaria <Pri:KB>','EU','16','29',NULL,-4.0,43.7,43.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',70,54,'R?6Y,U!6Y,R6Y,U6Y,R?7Y,U!7Y,R7Y','European Russia','Republic of Adygeya <Pri:AD>','EU','16','29',NULL,-4.0,44.5,40.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',8,54,'R[A-H;J-Z]1N,U!1N,R1N,U1N','European Russia','Republic of Karelia <Pri:KL>','EU','16','19',NULL,-4.0,61.8,34.4,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',1,54,'R#,U1,U2,U3,U4,U6,U9,U0, R?1,R?2,R?3,R?4,R?5,R?6,R?7,R?8,R?9,R?0,U!1,U!2,U!3,U!4,U!5,U!6,U!7,U!8,U!9,U[B-I]0','European Russia','European Russia','EU','16',NULL,NULL,-4.0,54.0,40.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',25,15,'R?0A,U!0A,R0A,U0A','Asiatic Russia','Krasnoyarsk <Pri:KK>','AS','18','',NULL,-8.0,56.0,93.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',26,15,'R?0B,U!0B,R0B,U0B','Asiatic Russia','Krasnoyarsk <Pri:KK>','AS','18','',NULL,-8.0,73.0,91.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',28,15,'R[A-H;J-Z]0C,U!0C,R0C,U0C','Asiatic Russia','Khabarovsk <Pri:HK>','AS','19','',NULL,-11.0,48.0,135.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',30,15,'R?0D,U!0D,R0D,U0D','Asiatic Russia','Yevreyskaya Autonomous Okrug <Pri:EA>','AS','19','33',NULL,-12.0,48.0,133.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',32,15,'R?0E,R[A-H;J-Z]0F,R?0G,U!0E,U!0F,U!0G,R0E,R0F,R0G,U0E,U0F,U0G','Asiatic Russia','Sakhalin <Pri:SL>','AS','19','34',NULL,-12.0,47.0,143.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',27,15,'R?0H,U!0H,R0H,U0H','Asiatic Russia','Krasnoyarsk <Pri:KK>','AS','18','',NULL,-8.0,64.0,100.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',33,15,'R?0I,U!0I,R0I,U0I','Asiatic Russia','Magadan <Pri:MG>','AS','19','24',NULL,-12.0,60.0,151.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',34,15,'R?0J,U!0J,R0J,U0J','Asiatic Russia','Amurskaya <Pri:AM>','AS','19','33',NULL,-10.0,52.0,127.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',35,15,'R[A-H;J-Z]0K,U!0K,R0K,U0K','Asiatic Russia','Chukotka Autonomous Okrug <Pri:CK>','AS','19','26',NULL,-12.0,65.0,175.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',37,15,'R?0L,R?0M,R[A-H;J-Z]0N,U!0L,U!0M,U!0N,R0L,R0M,R0N,U0L,UOM,U0N','Asiatic Russia','Primorskiy Kray <Pri:PK>','AS','19','34',NULL,-11.0,43.0,132.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',39,15,'R?0O,R?0P,U!0O,U!0P,R0O,R0P,U0O,U0P','Asiatic Russia','Republic of Buryatia <Pri:BU>','AS','18','',NULL,-9.0,52.0,107.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',40,15,'R[A-H;J-Z]0Q,U!0Q,R0Q,U0Q','Asiatic Russia','Republic of Yakutia <Pri:YA>','AS','19','',NULL,-10.0,62.0,130.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',44,15,'R?0S,R?0T,U!0S,U!0T,R0S,R0T,U0S,U0T','Asiatic Russia','Irkutsk <Pri:IR>','AS','18','',NULL,-9.0,52.0,104.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',45,15,'R?0U,U!0U,R0U,U0U','Asiatic Russia','Zabajkal``skiy Kraj <Pri:ZK>','AS','18','',NULL,-10.0,52.0,113.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',47,15,'R?0W,U!0W,R0W,U0W','Asiatic Russia','Republic of Khakassia <Pri:HA>','AS','18','',NULL,-8.0,53.0,93.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',48,15,'R[A-H;J-Z]0X,U!0X,R0X,U0X','Asiatic Russia','Kamchatka <Pri:KT>','AS','19','',NULL,-12.0,57.0,160.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',50,15,'R?0Y,U!0Y,R0Y,U0Y','Asiatic Russia','Republic of Tuva <Pri:TU>','AS','23','',NULL,-8.0,52.0,95.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',51,15,'R[A-H;J-Z]0Z,U!0Z,R0Z,U0Z','Asiatic Russia','Kamchatka <Pri:KT>','AS','19','35',NULL,-12.0,53.0,159.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',43,15,'R?0R,U!0R,R0R,U0R','Asiatic Russia','Irkutsk <Pri:IR>','AS','18','32',NULL,-9.0,56.0,102.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',46,15,'R?0V,U!0V,R0V','Asiatic Russia','Zabajkal``skiy Kraj <Pri:ZK>','AS','18','32',NULL,-10.0,52.0,107.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',3,15,'R?9A,U!9A,R?9B,U!9B,R9A,R9B,U9A,U9B','Asiatic Russia','Chelyabinsk <Pri:CB>','AS','17','30',NULL,-6.0,54.0,61.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',5,15,'R?9C,R?9D,R?9E,U!9C,U!9D,U!9E,R9C,R9D,R9E,U9C,U9D,U9E','Asiatic Russia','Sverdlovsk <Pri: SV>','AS','17','',NULL,-6.0,57.0,61.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',73,54,'R?8F,U!8F,R8F,R?9F,U!9F,R9F,U9F','European Russia','Perm <Pri:PM>','EU','17','',NULL,-6.0,59.0,56.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',74,54,'R?8G,U!8G,R8G,R?9G,U!9G,R9G,U9G','European Russia','Perm <Pri:PM>','EU','17','',NULL,-6.0,59.0,56.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',8,15,'R?9H,R?9I,U!9H,U!9I,R9H,R9I,U9H,U9I','Asiatic Russia','Tomsk <Pri:TO>','AS','18','',NULL,-7.0,57.0,85.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',9,15,'R?8J,U!8J,R8J,R?9J,U!9J,R9J,U9J','Asiatic Russia','Khanty-Mansyisky Auton. Okrug <Pri:HM>','AS','17','',NULL,-6.0,61.0,69.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',10,15,'R?8K,U!8K,R8K,R?9K,U!9K,R9K,U9K','Asiatic Russia','Yamalo-Nenetsky Auton. Okrug <Pri:YN>','AS','17','',NULL,-6.0,65.0,75.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',11,15,'R?8L,U!8L,R8L,R?9L,U!9L,R9L,U9L','Asiatic Russia','Tyumen <Pri:TN>','AS','17','30',NULL,-6.0,57.0,65.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',13,15,'R?9M,R?9N,U!9M,U!9N,R9M,R9N,U9M,U9N','Asiatic Russia','Omsk <Pri:OM>','AS','17','',NULL,-7.0,55.0,74.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',14,15,'R?8O,R?9O,R?9P,U!8O,U!9O,U!9P,R8O,R9O,R9P,U9O,U9P','Asiatic Russia','Novosibirsk <Pri:NS>','AS','18','31',NULL,-7.0,55.0,83.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',16,15,'R?9Q,R?9R,U!9Q,U!9R,R9Q,R9R,U9Q,U9R','Asiatic Russia','Kurgan <Pri:KN>','AS','17','30',NULL,-6.0,55.0,65.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',19,15,'R?8U,R?9U,R?9V,U!8U,U!9U,U!9V,R8U,R9U,R9V,U9U,U9V','Asiatic Russia','Kemerovo <Pri:KE>','AS','18','31',NULL,-8.0,55.0,86.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',20,15,'R?8W,U!8W,R8W,R?9W,U!9W,R9W,U9W','Asiatic Russia','Bashkortostan <Pri:BA>','EU','16','30',NULL,-6.0,54.4,56.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',75,54,'R?8X,U!8X,R8X,R?9X,U!9X,R9X,U9X','European Russia','Komi <Pri:KO>','EU','17','',NULL,-6.0,63.0,54.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',21,15,'R?8Y,U!8Y,R8Y,R?9Y,U!9Y,R9Y,U9Y','Asiatic Russia','Altaysky Kray <Pri:AL>','AS','18','31',NULL,-7.0,53.2,83.8,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',22,15,'R?8Z,U!8Z,R8Z,R?9Z,U!9Z,R9Z,U9Z','Asiatic Russia','Republic of Altay <Pri:GA>','AS','18','31',NULL,-7.0,51.0,87.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA2','UA2','UA',1,126,'R?2F,R?2K,UA2?,U[B-I]2F,U[B-I]2K,R2F,R2K,U2F,U2K','Kaliningrad','Kaliningrad <Pri:KA>','EU','15','29',NULL,-3.0,54.7167,20.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UJ','UJ','UJ',1,292,'UJ,UK,UL,UM,U8','Uzbekistan','Uzbekistanian','AS','17','30',NULL,-5.0,40.0,64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UJ','UJ','UJ',2,292,'UJ#A,UK#A,UL#A,UM#A,U8A','Uzbekistan','Tashkent','AS','17','30',NULL,-5.0,41.0,70.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UJ','UJ','UJ',3,292,'UJ#B,UK#B,UL#B,UM#B,U8B','Uzbekistan','Tashkentskaya','AS','17','30',NULL,-5.0,41.0,70.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UJ','UJ','UJ',4,292,'UJ#C,UK#C,UL#C,UM#C,U8C','Uzbekistan','Kashkadarskaya','AS','17','30',NULL,-5.0,40.0,64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UJ','UJ','UJ',5,292,'UJ#D,UK#D,UL#D,UM#D,U8D','Uzbekistan','Syrdarinskaya','AS','17','30',NULL,-5.0,40.0,64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UJ','UJ','UJ',6,292,'UJ#F,UK#F,UL#F,UM#F,U8F','Uzbekistan','Andijanskaya','AS','17','30',NULL,-5.0,40.0,64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UJ','UJ','UJ',7,292,'UJ#G,UL#G,UM#G,U8G','Uzbekistan','Ferganskaya','AS','17','30',NULL,-5.0,40.0,64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UJ','UJ','UJ',8,292,'UJ#I,UK#I,UL#I,UM#I,U8I','Uzbekistan','Samarkandskaya','AS','17','30',NULL,-5.0,39.0,66.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UJ','UJ','UJ',9,292,'UJ#L,UK#L,UL#L,UM#L,U8L','Uzbekistan','Bukharskaya','AS','17','30',NULL,-5.0,40.0,64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UJ','UJ','UJ',10,292,'UJ#O,UK#O,UL#O,UM#O,U8O','Uzbekistan','Namangan','AS','17','30',NULL,-5.0,40.0,64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UJ','UJ','UJ',11,292,'UJ#Q,UK#Q,UL#Q,UM#Q,U8Q','Uzbekistan','Navoyaskaya','AS','17','30',NULL,-5.0,40.0,64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UJ','UJ','UJ',12,292,'UJ#T,UK#T,UL#T,UM#T,U8T','Uzbekistan','Surkham Darinskaya','AS','17','30',NULL,-5.0,40.0,64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UJ','UJ','UJ',13,292,'UJ#U,UK#U,UL#U,UM#U,U8U','Uzbekistan','Khorezmskaya','AS','17','30',NULL,-5.0,40.0,64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UJ','UJ','UJ',14,292,'UJ#V,UK#V,UL#V,UM#V,U8V','Uzbekistan','Dzhizakskaya','AS','17','30',NULL,-5.0,40.0,64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UJ','UJ','UJ',15,292,'UJ#Z,UK#Z,UL#Z,UM#Z,U8Z','Uzbekistan','Kara-Kalpakia','AS','17','30',NULL,-5.0,40.0,64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',1,130,'UN,UO,UP,UQ','Kazakhstan','Kazakhstanian','AS','17',NULL,NULL,-5.0,53.0,76.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',2,130,'UN#A,UO#A,UP#A,UQ#A,U7A','Kazakhstan','Mangishlakskaya','AS','17','30',NULL,-5.0,53.0,76.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',3,130,'UN#B,UO#B,UP#B,UQ#B,U7B','Kazakhstan','Celinogradskaya','AS','17','30',NULL,-5.0,51.0,71.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',4,130,'UN#C,UO#C,UP#C,UQ#C,U7C','Kazakhstan','North Kazakhstanskaya','AS','17','30',NULL,-5.0,53.0,76.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',5,130,'UN#D,UO#D,UP#D,UQ#D,U7D','Kazakhstan','Semipalatinskaya','AS','17','31',NULL,-5.0,51.0,81.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',6,130,'UN#E,UO#E,UP#E,UQ#E,U7E','Kazakhstan','Kokchetavaskaya','AS','17','30',NULL,-5.0,53.0,76.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',7,130,'UN#F,UO#F,UP#F,UQ#F,U7F','Kazakhstan','Pavoldarskaya','AS','17','',NULL,-5.0,53.0,76.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',8,130,'UN#G,UO#G,UP#G,U7G','Kazakhstan','Alma Ata','AS','17','30',NULL,-5.0,43.0,78.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',9,130,'UN#I,UO#I,UP#I,UQ#I,U7I','Kazakhstan','Aktubinskaya','AS','17','30',NULL,-5.0,53.0,76.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',10,130,'UN#J,UO#J,UP#J,UQ#J,U7J','Kazakhstan','East Kazakhstanskaya','AS','17','30',NULL,-5.0,53.0,76.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',11,130,'UN#K,UO#K,UQ#K,U7K','Kazakhstan','Kizil-Ordinskaya','AS','17','30',NULL,-5.0,53.0,76.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',12,130,'UN#L,UO#L,UP#L,UQ#L,U7L','Kazakhstan','Kustanayskaya','AS','17','30',NULL,-5.0,53.0,73.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',13,130,'UN#M,UO#M,UP#M,UQ#M,U7M','Kazakhstan','Uralskaya','AS','17','',NULL,-5.0,53.0,53.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',14,130,'UO#N,UP#N,UQ#N,U7N','Kazakhstan','Chimkentskaya','AS','17','30',NULL,-5.0,43.0,69.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',15,130,'UN#O,UO#O,UP#O,UQ#O,U7O','Kazakhstan','Guryevskaya','AS','17','',NULL,-5.0,48.0,49.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',16,130,'UN#P,UO#P,UP#P,UQ#P,U7P','Kazakhstan','Karagandinskaya','AS','17','',NULL,-5.0,50.0,74.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',17,130,'UN#Q,UO#Q,UP#Q,UQ#Q,U7Q','Kazakhstan','Alma-Atinskaya','AS','17','',NULL,-5.0,53.0,76.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',18,130,'UN#R,UO#R,UP#R,UQ#R,U7R','Kazakhstan','Dzhezkaganskaya','AS','17','',NULL,-5.0,53.0,76.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',19,130,'UN#T,UO#T,UP#T,UQ#T,U7T','Kazakhstan','Jambulskaya','AS','17','30',NULL,-5.0,53.0,76.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',20,130,'UN#V,UO#V,UP#V,UQ#V,U7V','Kazakhstan','Taldy Kurganskaya','AS','17','31',NULL,-5.0,53.0,76.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UN','UN','UN',21,130,'UN#Y,UO#Y,UP#Y,UQ#Y,U7Y','Kazakhstan','Turgay','AS','17','30',NULL,-5.0,53.0,76.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',1,288,'UR,US,UT,UU,UV,UW,UX,UY,UZ,EM,EN,EO,U5','Ukraine','Ukraine','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',2,288,'UR#A,US#A,UT#A,UV#A,UW#A,UX#A,UY#A','Ukraine','Sumska Oblast <Pri:SU>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',4,288,'UR#B,US#B,UT#B,UV#B,UW#B,UX#B,UY#B','Ukraine','Ternopilska Oblast <Pri:TE>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',6,288,'UR#C,US#C,UT#C,UV#C,UW#C,UX#C,UY#C','Ukraine','Cherkaska Oblast <Pri:CH>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',8,288,'UR#D,US#D,UT#D,UV#D,UW#D,UX#D,UY#D','Ukraine','Zakarpatska Oblast <Pri:ZA>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',10,288,'UR#E,US#E,UT#E,UV#E,UW#E,UX#E,UY#E','Ukraine','Dnipropetrovska Oblast <Pri:DN>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',12,288,'UR#F,US#F,UT#F,UV#F,UW#F,UX#F,UY#F','Ukraine','Odeska Oblast <Pri:OD>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',14,288,'UR#G,US#G,UT#G,UV#G,UW#G,UX#G,UY#G','Ukraine','Khersonska Oblast <Pri:HE>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',16,288,'UR#H,US#H,UT#H,UV#H,UW#H,UX#H,UY#H','Ukraine','Poltavska Oblast <Pri:PO>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',18,288,'UR#I,US#I,UT#I,UV#I,UW#I,UX#I,UY#I','Ukraine','Donetska Oblast <Pri:DO>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',20,288,'UR#J,US#J,UT0J,UT1J,UT2J,UT3J,UT4J,UT6J,UT7J,UT8J,UT9J,UV#J,UW#J,UX#J,UY#J','Ukraine','Crimea','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',22,288,'UR#K,US#K,UT#K,UV#K,UW#K,UX#K,UY#K','Ukraine','Rivnenska Oblast <Pri:RI>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',24,288,'UR#L,US#L,UT#L,UV#L,UW#L,UX#L,UY#L','Ukraine','Kharkivska Oblast <Pri:HA>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',26,288,'UR#M,US#M,UT#M,UV#M,UW#M,UX#M,UY#M','Ukraine','Luhanska Oblast <Pri:LU>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',28,288,'UR#N,US#N,UT#N,UV#N,UW#N,UX#N,UY#N','Ukraine','Vinnytska Oblast <Pri:VI>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',30,288,'UR#P,US#P,UT#P,UV#P,UW#P,UX#P,UY#P','Ukraine','Volyoska Oblast <Pri:VO>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',32,288,'UR#Q,US#Q,UT#Q,UV#Q,UW#Q,UX#Q,UY#Q','Ukraine','Zaporizka Oblast <Pri:ZP>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',34,288,'UR#R,US#R,UT#R,UV#R,UW#R,UX#R,UY#R','Ukraine','Chernihivska Oblast <Pri:CR>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',36,288,'UR#S,US#S,UT#S,UV#S,UW#S,UX#S,UY#S','Ukraine','Ivano-Frankivska Oblast <Pri:IF>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',38,288,'UR#T,US#T,UT#T,UV#T,UW#T,UX#T,UY#T','Ukraine','Khmelnytska Oblast <Pri:HM>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',40,288,'UR#U,US#U,UT#U,UV#U,UW#U,UX#U,UY#U','Ukraine','Kiev','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',42,288,'UR#V,US#V,UT#V,UV#V,UW#V,UX#V,UY#V','Ukraine','Kirovohradska Oblast <Pri:KI>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',44,288,'UR#W,US#W,UT#W,UV#W,UW#W,UX#W,UY#W','Ukraine','Lvivska Oblast <Pri:LV>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',46,288,'UR#X,US#X,UT#X,UV#X,UW#X,UX#X,UY#X','Ukraine','Zhytomyrska Oblast <Pri:ZH>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',48,288,'UR#Y,US#Y,UT#Y,UV#Y,UW#Y,UX#Y,UY#Y','Ukraine','Chernivetska Oblast <Pri:CN>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',50,288,'UR#Z,US#Z,UT#Z,UV#Z,UW#Z,UX#Z,UY#Z','Ukraine','Mykolaivska Oblast <Pri:NI>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',3,288,'UZ#A,EM#A,EN#A,EO#A,U5A','Ukraine','Sumska Oblast <Pri:SU>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',5,288,'UZ#B,EM#B,EN#B,EO#B,U5B','Ukraine','Ternopilska Oblast <Pri:TE>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',7,288,'UZ#C,EM#C,EN#C,EO#C,U5C','Ukraine','Cherkaska Oblast <Pri:CH>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',9,288,'UZ#D,EM#D,EN#D,EO#D,U5D','Ukraine','Zakarpatska Oblast <Pri:ZA>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',11,288,'UZ#E,EM#E,EN#E,EO#E,U5E','Ukraine','Dnipropetrovska Oblast <Pri:DN>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',13,288,'UZ#F,EM#F,EN#F,EO#F,U5F','Ukraine','Odeska Oblast <Pri:OD>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',15,288,'UZ#G,EM#G,EN#G,EO#G,U5G','Ukraine','Khersonska Oblast <Pri:HE>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',17,288,'UZ#H,EM#H,EN#H,EO#H,U5H','Ukraine','Poltavska Oblast <Pri:PO>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',19,288,'UZ#I,EM#I,EN#I,EO#I,U5I','Ukraine','Donetska Oblast <Pri:DO>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',21,288,'UZ#J,EM#J,EN#J,EO#J,U5J','Ukraine','Crimea','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',23,288,'UZ#K,EM#K,EN#K,EO#K,U5K','Ukraine','Rivnenska Oblast <Pri:RI>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',25,288,'UZ#L,EM#L,EN#L,EO#L,U5L','Ukraine','Kharkivska Oblast <Pri:HA>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',27,288,'UZ#M,EM#M,EN#M,EO#M,U5M','Ukraine','Luhanska Oblast <Pri:LU>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',29,288,'UZ#N,EM#N,EN#N,EO#N,U5N','Ukraine','Vinnytska Oblast <Pri:VI>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',31,288,'UZ#P,EM#P,EN#P,EO#P,U5P','Ukraine','Volyoska Oblast <Pri:VO>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',33,288,'UZ#Q,EM#Q,EN#Q,EO#Q,U5Q','Ukraine','Zaporizka Oblast <Pri:ZP>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',35,288,'UZ#R,EM#R,EN#R,EO#R,U5R','Ukraine','Chernihivska Oblast <Pri:CR>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',37,288,'UZ#S,EM#S,EN#S,EO#S,U5S','Ukraine','Ivano-Frankivska Oblast <Pri:IF>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',39,288,'UZ#T,EM#T,EN#T,EO#T,U5T','Ukraine','Khmelnytska Oblast <Pri:HM>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',41,288,'UZ#U,EN#U,EO#U, EM0U, EM2U, EM3U, EM4U, EM5U, EM6U, EM7U, EM8U, EM9U,U5U','Ukraine','Kiev','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',43,288,'UZ#V,EM#V,EN#V,EO#V,U5V','Ukraine','Kirovohradska Oblast <Pri:KI>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',45,288,'UZ#W,EM#W,EN#W,EO#W,U5W','Ukraine','Lvivska Oblast <Pri:LV>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',47,288,'UZ#X,EM#X,EN#X,EO#X,U5X','Ukraine','Zhytomyrska Oblast <Pri:ZH>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',49,288,'UZ#Y,EM#Y,EN#Y,EO#Y,U5Y','Ukraine','Chernivetska Oblast <Pri:CN>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',51,288,'UZ#Z,EM#Z,EN#Z,EO#Z,U5Z','Ukraine','Mykolaivska Oblast <Pri:NI>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('V2','V2','V2',1,94,'V2,VP2A','Antigua & Barbuda','Antigua and Barbuda','NA','8','11','NA-100',4.0,17.1,-61.8,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('V3','V3','V3',1,66,'V3,VP1','Belize','Belize','NA','7','11',NULL,6.0,17.25,-88.75,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('V4','V4','V4',1,249,'V4,VP2K','Saint Kitts & Nevis','St Kitts and Nevis Islands','NA','8','11','NA-104',4.0,17.3,-62.74,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('V5','V5','V5',1,464,'V5','Namibia','Namibia','AF','38','57',NULL,-2.0,-22.5667,17.0833,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('V6','V6','V6',1,173,'V6','Micronesia','Eastern Caroline and Yap Islands','OC','27','65',NULL,-10.0,6.9167,158.1667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('V7','V7','V7',1,168,'V7','Marshall Islands','Marshall Islands','OC','31','65',NULL,-12.0,8.7208,167.7333,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('V8','V8','V8',1,345,'V8','Brunei ','Brunei Darussalam','OC','28','54',NULL,-8.0,4.9,114.95,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VE','VE','VE',1,1,'V[A-G],VO,VY,VX,C[F-K],CY,CZ,X[J-O]','Canada','Canada','NA','',NULL,NULL,6.0,54.0,-106.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VE','VE','VE',9,1,'V[A-C]1,VE1,VG1,CG1,CK1,VX1,XM1,CF1,CJ1,XL1','Canada','Nova Scotia <Pri:NS>','NA','5','9',NULL,4.0,46.0,-66.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VE','VE','VE',10,1,'V[A-C]2,VE2,VG2,CG2,CK2,VX2,XM2,CF2,CJ2,XL2','Canada','Quebec <Pri:QC>','NA','',NULL,NULL,5.0,53.0,-72.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VE','VE','VE',11,1,'V[A-G]3,CG3,CK3,VX3,XM3,CF3,CJ3,XL3','Canada','Ontario <Pri:ON>','NA','4',NULL,NULL,5.0,50.0,-84.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VE','VE','VE',12,1,'V[A-G]4,CG4,CK4,VX4,XM4,CF4,CJ4,XL4','Canada','Manitoba <Pri:MB>','NA','4','3',NULL,6.0,54.0,-98.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VE','VE','VE',13,1,'V[A-G]5,CG5,CK5,VX5,XM5,CF5,CJ5,XL5','Canada','Saskatchewan <Pri:SK>','NA','4','3',NULL,6.0,54.0,-106.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VE','VE','VE',14,1,'V[A-G]6,CG6,CK6,VX6,XM6,CF6,CJ6,XL6','Canada','Alberta <Pri:AB>','NA','4','2',NULL,7.0,55.0,-114.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VE','VE','VE',15,1,'V[A-G]7,CG7,CK7,VX7,XM7,CF7,CJ7,XL7','Canada','British Columbia <Pri:BC>','NA','3','2',NULL,8.0,54.0,-125.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VE','VE','VE',16,1,'V[A-G]8,CG8,CK8,VX8,XM8,CF8,CJ8,XL8','Canada','Northwest Territory <Pri:NT>','NA','1',NULL,NULL,7.0,65.0,-114.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VE','VE','VE',3,1,'V[A-G]9,CG9,CK9,VX9,XM9,CF9,CJ9,XL9','Canada','New Brunswick <Pri:NB>','NA','5','9',NULL,4.0,46.0,-67.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VE','VE','VE',4,1,'VO1,CH1,CY1,XJ1,XN1,VD1','Canada','Newfoundland <Pri:NL>','NA','5','9',NULL,3.5,49.0,-56.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VE','VE','VE',5,1,'VO2,CH2,CY2,XJ2,XN2,VD2','Canada','Labrador <Pri:NL>','NA','2','9',NULL,4.0,54.0,-61.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VE','VE','VE',7,1,'VY1,CI1,CZ1,XK1,XO1,VF1','Canada','Yukon Territory <Pri:YT>','NA','1','2',NULL,8.0,65.0,-135.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VE','VE','VE',8,1,'VY2,CI2,CZ2,XK2,XO2,VF2','Canada','Prince Edward Island <Pri:PE>','NA','5','',NULL,4.0,46.0,-63.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK','VK','VK',1,150,'V[H-N],VZ,AX','Australia','Australia','OC',NULL,NULL,NULL,-10.0,-28.0,147.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK','VK','VK',2,150,'V[H-N]1,VZ1,AX1','Australia','Australian Capital Territory <Pri:ACT>','OC','30','59',NULL,-10.0,-35.0,149.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK','VK','VK',3,150,'V[H-N]2,VZ2,AX2','Australia','New South Wales <Pri:NSW>','OC','30','59',NULL,-10.0,-34.0,151.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK','VK','VK',4,150,'V[H-N]3,VZ3,AX3','Australia','Victoria <Pri:VIC>','OC','30','59',NULL,-10.0,-38.0,145.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK','VK','VK',5,150,'V[H-N]4,VZ4,AX4','Australia','Queensland <Pri:QLD>','OC','30','55',NULL,-10.0,-28.0,153.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK','VK','VK',6,150,'V[H-N]5,VZ5,AX5','Australia','South Australia <Pri:SA>','OC','30','59',NULL,-9.5,-30.0,134.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK','VK','VK',7,150,'V[H-N]6,VZ6,AX6','Australia','Western Australia <Pri:WA>','OC','29','58',NULL,-8.0,-27.0,122.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK','VK','VK',8,150,'V[H-N]7,VZ7,AX7','Australia','Tasmania <Pri:TAS>','OC','30','59',NULL,-10.0,-42.0,147.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK','VK','VK',9,150,'V[H-N]8,VZ8,AX8','Australia','Northern Territory <Pri:NT>','OC','29','55',NULL,-9.5,-20.0,134.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK0-H','VK','VK0-H',1,111,'VK0HI,VK0XH,VK0KH,VK0NH,VK0ZH,VK0IR,VK0CW,VK0JS,VK0-H','Heard Island','Heard Island','AF','39','68','AN-003',-5.0,-53.1,73.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK0-M','VK','VK0-M',1,153,'V[H-N]0,VZ0,AX0,VK0-M','Macquarie Island','Macquarie Island <Pri:MA>','OC','30','60','AN-005',-11.0,-54.6167,158.8667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK9-C','VK','VK9-C',1,38,'V[H-N]9C,VZ9C,AX9C,VK9?C,VK9-C','Cocos (Keeling) Islands','Cocos-Keeling Island','OC','29','54','OC-003',-6.5,-12.1917,96.8333,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK9-C','VK','VK9-C',2,38,'V[H-N]9Y,VK9?Y,VZ9Y,AX9Y','Cocos (Keeling) Islands','Cocos-Keeling Island','OC','29','54','OC-003',-6.5,-12.1917,96.8333,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK9-L','VK','VK9-L',1,147,'V[H-N]9L,VK9?L,VZ9L,AX9L,VK9-L','Lord Howe Island','Lord Howe Island <Pri:LH>','OC','30','60','OC-004',-10.5,-31.5417,159.0778,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK9-M','VK','VK9-M',1,171,'V[H-N]9M,VK9?M,VZ9M,AX9M,VK9-M','Mellish Reef','Mellish Reef','OC','30','56','OC-072',-11.0,-17.4028,155.8553,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK9-N','VK','VK9-N',1,189,'V[H-N]9,VZ9,AX9,VK9N,VK9-N','Norfolk Island','Norfolk and Philip Islands','OC','32','60','OC-005',-11.5,-29.05,167.97,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK9-W','VK','VK9-W',2,303,'VK9GS,VK9TR,VK9ZG','Willis Island','Willis Island','OC','30','55','OC-007',-10.0,-16.288,149.965,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK9-W','VK','VK9-W',1,303,'V[H-N]9W,VK9?W,VZ9W,AX9W,VK9-W','Willis Island','Willis Island','OC','30','55','OC-007',-10.0,-16.288,149.965,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VK9-X','VK','VK9-X',1,35,'V[H-N]9X,VK9?X,VZ9X,AX9X,VK9GA,VK9VKL,VK9-X','Christmas Island','Christmas Island','OC','29','54','OC-002',-7.0,-10.45,105.667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VP2-E','VP2E','VP2-E',1,12,'VP2E,VP25,VP2-E,VP29E','Anguilla','Anguilla','NA','8','11','NA-022',4.0,18.217,-63.05,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VP2-M','VP2M','VP2-M',1,96,'VP2M,VP2-M','Montserrat','Montserrat','NA','8','11','NA-103',4.0,16.75,-62.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VP2-V','VP2V','VP2-V',1,65,'VP2V,VP2-V','British Virgin Islands','British Virgin Islands','NA','8','11','NA-023',4.0,18.43,-64.62,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VP5','VP5','VP5',1,89,'VP5, VQ5','Turks & Caicos Islands','Turks and Caicos Islands','NA','8','11',NULL,4.0,21.8,-71.9,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VP8-F','VP8F','VP8-F',1,141,'VP8,VP8-F','Falkland Islands','Falkland Islands','SA','13','16','SA-002',4.0,-51.7,-57.85,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VP8-G','VP8G','VP8-GS',2,235,'VP8CID,VP8CIZ,VP8CKB,VP8CLR,VP8SGB,VP8SGP','South Georgia Island','South Georgia Islands','SA','13','73','AN-007',2.0,-54.25,-36.45,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VP8-G','VP8G','VP8-GS',1,235,'VP8G,VP8BUB,VP8CBA,VP8CDJ,VP8CGE,VP8CGK,VP8-G','South Georgia Island','South Georgia Islands','SA','13','73','AN-007',2.0,-54.25,-36.75,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VP8-H','VP8H','VP8-H',1,241,'VP8HG,VP8-H,RI1ANF,HF0POL,D88S,LZ0A,DT8A, LU#ZC, LU#ZI, LU#ZO, LU#ZT ','South Shetland Islands','South Shetland Islands','SA','13','73','AN-010',4.0,-62.0333,-58.21,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VP8-O','VP8O','VP8-O',1,238,'VP8BXK, VP8-O, ED0BUD, VP8LU, LU#ZA, LU#ZM','South Orkney Islands','South Orkney Islands','SA','13','73','AN-008',3.0,-60.7167,-45.6,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VP8-S','VP8S','VP8-GS',1,240,'VP8S,VP8-S,4K1ZI, VP8THU','South Sandwich Islands','South Sandwich Islands','SA','13','73','AN-009',4.0,-59.4267,-27.0833,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VP9','VP9','VP9',1,64,'VP9','Bermuda','Bermuda','NA','5','11','NA-005',4.0,32.2958,-64.7833,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VQ9','VQ9','VQ9',1,33,'VQ9','Chagos','Chagos','AF','39','41','',-5.0,-7.3083,72.411,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VP6','VP6','VP6',1,172,'VP6,VP6DB','Pitcairn Island','Pitcairn Island','OC','32','63','',8.0,-25.0667,-130.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VR','VR','VR',1,321,'VS6,VR','Hong Kong','Hong Kong','AS','24','44','',-8.0,22.4,114.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VU','VU','VU',1,324,'V[T-W],8[T-Y],A[T-W]','India','India','AS','22','41',NULL,-5.5,24.0,80.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VU4','VU','VU',1,11,'V[T-W]4,8[T-X]4,A[T-W]4','Andaman & Nicobar Islands','Andaman and Nicobar Islands','AS','26','49',NULL,-5.5,11.667,92.667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VU7','VU','VU',1,142,'V[T-W]7,8[T-Y]7,A[T-W]7','Lakshadweep Islands','Laccadive Islands','AS','22','41','AS-011',-5.5,10.56,72.641,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('XE','XE','XE',1,50,'X[A-I],4[A-C],6[D-J]','Mexico','Mexico','NA','6','10',NULL,6.0,19.4,-99.133,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('XF4','XE','XE',1,204,'X[A-I]4,XF0C,4[A-C]4,6[D-J]4','Revillagigedo','Revillagigedo  Archipelago','NA','6','10',NULL,7.0,18.8,-110.983,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('XT','XT','XT',1,480,'XT','Burkina Faso','Burkina Faso','AF','35','46',NULL,0.0,12.333,-1.55,'1960-08-05 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('XU','XU','XU',1,312,'XU','Cambodia','Cambodia','AS','26','49',NULL,-7.0,11.566,104.9167,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('XW','XW','XW',1,143,'XW','Laos','Laos','AS','26','49',NULL,-7.0,17.9667,102.5833,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('XX9','XX9','XX9',1,152,'XX9','Macao','Macao','AS','24','44','',-8.0,22.2,113.55,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('XZ','XZ','XZ',1,309,'XY,XZ,1Z','Myanmar','Myanmar','AS','26','49',NULL,-6.5,19.75,96.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('Y','DL','DL',1,229,'~Y,~DM','German Democratic Republic','German Democratic Republic','EU','14','28',NULL,-1.0,51.0,6.0,'1973-09-17 00:00:00.000','1990-10-02 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YA','YA','YA',1,3,'YA,T6','Afghanistan','Afghanistan','AS','21','40',NULL,-3.5,34.53,69.1667,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',1,327,'Y[B-H],7[A-I],8[A-I],JZ,P[K-O]','Indonesia','Indonesia','OC','28',NULL,NULL,-7.0,-6.2,106.8333,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YI','YI','YI',1,333,'YI,HN','Iraq','Iraq','AS','21','39',NULL,-3.0,33.33,44.4,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YJ','YJ','YJ',1,158,'YJ','Vanuatu','Vanuatu','OC','32','56','',-11.0,-17.7,168.317,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YK','YK','YK',1,384,'YK,6C','Syria','Syria','AS','20','39',NULL,-2.0,33.5,36.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YL','YL','YL',1,145,'YL','Latvia','Latvia','EU','15','29',NULL,-3.0,56.95,24.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YN','YN','YN',1,86,'YN,HT,H6,H7','Nicaragua','Nicaragua','NA','7','11',NULL,6.0,12.133,-86.25,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YO','YO','YO',1,275,'YO,YP,YQ,YR','Romania','Romania','EU','20','28',NULL,-2.0,44.45,26.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YS','YS','YS',1,74,'YS,HU','El Salvador','El Salvador','NA','7','11',NULL,6.0,14.0,-89.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YU','YU','YU',1,296,'YU,YT','Serbia','Serbia','EU','15','28',NULL,-1.0,44.833,20.45,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('4O','4O','4O',1,514,'4O','Montenegro','Montenegro','EU','15','28',NULL,-1.0,42.4458,19.2722,'2006-06-28 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YU','YU','YU',2,296,'YU7,YT7','Serbia','Vojvodina','EU','15','28',NULL,-1.0,45.5,20.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YV','YV','YV',1,148,'Y[V-Y],4M','Venezuela','Venezuela','SA','9','12',NULL,4.5,10.5,-66.9167,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YV','YV','YV',8,148,'Y[V-Y]1,4M1','Venezuela','Venezuela 1','SA','9','12',NULL,4.5,10.0,-72.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YV','YV','YV',7,148,'Y[V-Y]2,4M2','Venezuela','Venezuela 2','SA','9','12',NULL,4.5,8.0,-71.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YV','YV','YV',6,148,'Y[V-Y]3,4M3','Venezuela','Venezuela 3','SA','9','12',NULL,4.5,10.0,-70.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YV','YV','YV',9,148,'Y[V-Y]4,4M4','Venezuela','Venezuela 4','SA','9','12',NULL,4.5,10.0,-68.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YV','YV','YV',4,148,'Y[V-Y]5,4M5','Venezuela','Venezuela 5','SA','9','12',NULL,4.5,9.0,-66.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YV','YV','YV',5,148,'Y[V-Y]6,4M6','Venezuela','Venezuela 6','SA','9','12',NULL,4.5,7.0,-64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YV','YV','YV',10,148,'Y[V-Y]7,4M7','Venezuela','Venezuela 7','SA','9','12',NULL,4.5,11.0,-64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YV','YV','YV',3,148,'Y[V-Y]8,4M8','Venezuela','Venezuela 8','SA','9','12',NULL,4.5,9.0,-62.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YV','YV','YV',2,148,'Y[V-Y]9,4M9','Venezuela','Venezuela 9','SA','9','12',NULL,4.5,4.0,-66.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YV0','YV','YV0',1,17,'Y[V-Y]0,4M0','Aves Island','Aves Island','NA','8','11','NA-020',4.5,15.6717,-63.6164,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('Z2','Z2','Z2',1,452,'ZE,Z2','Zimbabwe','Zimbabwe','AF','38','53',NULL,-2.0,-17.8,31.05,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('Z3','Z3','Z3',1,502,'Z3','Macedonia','Macedonia','EU','15','28',NULL,-1.0,41.9906,21.4264,'1991-09-08 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZA','ZA','ZA',1,7,'ZA','Albania','Albania','EU','15','28',NULL,-1.0,41.3278,19.8186,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZB2','ZB2','ZB2',1,233,'ZB,ZG','Gibraltar','Gibraltar','EU','14','37',NULL,-1.0,36.15,-5.33,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZC4','ZC4','5B',1,283,'ZC4,ZB4','U K Bases on Cyprus','Cyprus (UK Military Bases)','AS','20','39','AS-004',-2.0,34.6,32.983,'1960-08-16 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZD7','ZD7','ZD7',1,250,'ZD7','Saint Helena','Saint Helena Island','AF','36','66','AF-022',0.0,-15.967,-5.67,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZD8','ZD8','ZD8',1,205,'ZD8','Ascension Island','Ascension Island','AF','36','66','AF-003',0.0,-7.933,-14.367,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZD9','ZD9','ZD9',1,274,'ZD9','Tristan Da Cunha & Gough Is.','Tristan De Cunha and Gough Islands','AF','38','66',NULL,0.0,-37.1,-12.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZF','ZF','ZF',1,69,'ZF','Cayman Islands','Cayman Islands','NA','8','11','NA-016',5.0,19.3,-81.25,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('E5-N','E5','E5',1,191,'E5-N,E51WL,E50W','North Cook Islands','North Cook Islands','OC','32','62',NULL,10.0,-10.425,-161.0333,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('E5-S','E5','E5',1,234,'E5,E5-S','South Cook Islands','South Cook Islands','OC','32','62',NULL,10.0,-21.233,-159.7833,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('E6','E6','ZK2',1,188,'E6,ZK2','Niue','Niue','OC','32','62','OC-040',11.0,-19.05,-169.8583,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZK3','ZL','ZK3',1,270,'ZK3','Tokelau Islands','Tokelau Islands','OC','31','62','OC-048',11.0,-9.13,-171.79,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZL','ZL','ZL',1,170,'ZL,ZK,ZM','New Zealand','New Zealand','OC','32','60',NULL,-12.0,-41.25,174.75,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZL7','ZL','ZL7',1,34,'ZL7','Chatham Island','Chatham Island','OC','32','60','OC-038',-12.75,-44.0,-176.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZL8','ZL','ZL8',1,133,'ZL8','Kermadec Island','Kermadec Island','OC','32','60','OC-039',-12.0,-29.267,-177.817,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZL9','ZL','ZL9',1,16,'ZL9','New Zealand Subantarctic Is.','Auckland, Campbell, Antipodes & Bounty','OC','32','60','',-12.0,-50.67,166.1,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZP','ZP','ZP',1,132,'ZP','Paraguay','Paraguay','SA','11','14',NULL,4.0,-25.25,-57.65,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZP','ZP','ZP',9,132,'ZP1','Paraguay','Paraguay 1','SA','11','14',NULL,4.0,-22.0,-60.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZP','ZP','ZP',8,132,'ZP2','Paraguay','Paraguay 2','SA','11','14',NULL,4.0,-24.0,-59.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZP','ZP','ZP',7,132,'ZP3','Paraguay','Paraguay 3','SA','11','14',NULL,4.0,-23.0,-57.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZP','ZP','ZP',6,132,'ZP4','Paraguay','Paraguay 4','SA','11','14',NULL,4.0,-25.0,-57.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZP','ZP','ZP',5,132,'ZP5','Paraguay','Asuncion','SA','11','14',NULL,4.0,-26.0,-56.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZP','ZP','ZP',2,132,'ZP6','Paraguay','Paraguay 6','SA','11','14',NULL,4.0,-27.0,-56.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZP','ZP','ZP',4,132,'ZP7','Paraguay','Paraguay 7','SA','11','14',NULL,4.0,-26.0,-55.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZP','ZP','ZP',10,132,'ZP8','Paraguay','Paraguay 8','SA','11','14',NULL,4.0,-27.0,-56.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZP','ZP','ZP',3,132,'ZP9','Paraguay','Paraguay 9','SA','11','14',NULL,4.0,-27.0,-56.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZS','ZS','ZS',1,462,'Z[R-U],S8','Republic of South Africa','South Africa','AF','38','57',NULL,-2.0,-25.45,28.167,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZS8','ZS','ZS',1,201,'Z[R-U]8','Prince Edward & Marion Islands','Prince Edward and Marion Islands','AF','38','57','AF-021',0.0,-46.883,37.75,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',1,100,'AY,AZ,L[O-W],L#','Argentina','Argentina','SA','13',NULL,NULL,3.0,-34.6167,-64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZS9','ZS','ZS',1,488,'~ZS9','Walvis Bay','Walvis Bay','AF','38','57',NULL,0.0,-27.0,15.0,'1977-09-01 00:00:00.000','1994-02-28 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('ZS0','ZS','ZS',1,493,'~ZS0','Penguin Islands','Penguin Island','AF','38','57',NULL,0.0,-27.0,15.0,NULL,'1994-02-28 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('4W','4W','4W',1,511,'4W,4U1ET','Timor - Leste','East Timor','OC','28','54',NULL,-8.0,-9.0,126.0,'2000-03-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FK-C','TX0','TX0',1,512,'FK-C','Chesterfield Islands','Chesterfield Islands','OC','30','56','OC-176',-10.0,-19.975,158.475,'2000-03-21 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',18,15,'R?9S,R?9T,U!9S,U!9T,R9S,R9T,U9S,U9T','Asiatic Russia','Orenburg <Pri:OB>','EU','16','30',NULL,-6.0,52.0,55.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('2',NULL,NULL,1,23,'~2,~1B9','Blenheim Reef','Blenheim Reef','AF','39','41',NULL,NULL,NULL,NULL,'1967-05-04 00:00:00.000','1975-06-30 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VP6D','VP6','VP6',1,513,'VP6D','Ducie Island','Ducie Island','OC','32','63','OC-182',8.0,-24.39,-124.48,'2001-11-16 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',11,318,'B[A-L;R-T;Y-Z]3G,B[A-L;R-T;Y-Z]3H, B[A-L;R-T;Y-Z]3I','China','NeiMenggu <Pri: 15>','AS','23',NULL,NULL,-8.0,38.0,100.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('3B6','3B6','3B6',3,4,'3B7','Agalega & St Brandon Islands','St. Brandon Islands','AF','39','53','AF-015',-4.0,-16.5725,59.7028,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',31,13,'EM1HO, EM1U','Antarctica','Vernadsky Station, Galindez Is.','AN','13','73','AN-006',0.0,-65.23,-64.25,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KG4','K','CO',1,105,'KG4','Guantanamo Bay','Guantanamo Bay','NA','8','11','NA-015',5.0,19.95,-75.16,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',32,13,'DP1POL,DP0GVN','Antarctica','Neumayer Research Base','AN','38','67','AN-016',0.0,-70.65,-8.25,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VE','VE','VE',6,1,'VY0,CI0,CZ0,XK0,XO0,VF0','Canada','Nunavut <Pri:NU>','NA',NULL,NULL,NULL,5.0,67.0,-70.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',4,54,'R1A,R1B,R1F[A-I;K-Z],R1G,R1H,R1I,R1J,R1L,R1M ','European Russia','St. Petersburg <Pri:SP>','EU','16','',NULL,-4.0,59.6,30.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',3,54,'U1A,U1B,U1F,U1G,U1H,U1I,U1J,U1L,U1M','European Russia','St. Petersburg <Pri:SP>','EU','16','',NULL,-4.0,59.6,30.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',19,54,'R?3A,R?3B,R?3C,U!3A,U!3B,U!3C,R3A,R3B,R3C,U3A,U3B,U3C','European Russia','Moscow <Pri:MA>','EU','16','29',NULL,-4.0,55.5,38.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('4J','4J','4J',2,18,'4J2,4K2','Azerbaijan','Nakhichevan','AS','21','29',NULL,-4.0,45.5,39.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('4J','4J','4J',3,18,'4J4,4J5,4J6,4J7,4J8,4J9,4K4,4K5,4K6,4K7,4K8,4K9','Azerbaijan','Baku','AS','21','29',NULL,-4.0,40.5,50.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JA','JA','JA',2,339,'7J','Japan','Japan (reciprocal)','AS','25','45',NULL,-9.0,36.33,138.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JA','JA','JA',4,339,'JA1,J[E-S]1,7J1,7K,7L,7M,7N','Japan','Kanto','AS','25','45',NULL,-9.0,36.0,140.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JA','JA','JA',5,339,'JA2,J[E-S]2,7J2','Japan','Tokai','AS','25','45',NULL,-9.0,35.0,137.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JA','JA','JA',6,339,'JA3,J[E-S]3,7J3','Japan','Kansai','AS','25','45',NULL,-9.0,35.0,135.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JA','JA','JA',7,339,'JA4,J[E-S]4,7J4','Japan','Chugoku','AS','25','45',NULL,-9.0,35.0,133.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JA','JA','JA',11,339,'JA7,J[E-S]7,7J7','Japan','Tohoku','AS','25','45',NULL,-9.0,39.0,141.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JA','JA','JA',13,339,'JA9,J[E-S]9,7J9','Japan','Hokuriku','AS','25','45',NULL,-9.0,37.0,137.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JA','JA','JA',14,339,'JA0,J[E-S]0,7J0','Japan','Shinetsu','AS','25','45',NULL,-9.0,38.0,139.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JA','JA','JA',3,339,'8[J-N]','Japan','Japan (special events)','AS','25','45',NULL,-9.0,36.33,138.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',16,248,'ID9','Italy','Lipari Islands','EU','15','28','EU-017',-1.0,38.0,15.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',17,248,'IE9','Italy','Ustica Islands','EU','15','28','EU-051',-1.0,38.0,13.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',18,248,'IF9','Italy','Egadi Islands','EU','15','28','EU-054',-1.0,38.0,12.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',19,248,'IG9','Italy','Pelagie Islands <Reg:IG9/IH9>','AF','33','37','AF-019',-1.0,35.5166,12.5833,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',60,318,'B[A-L;R-T;Y-Z]0G,B[A-L;R-T;Y-Z]0H,B[A-L;R-T;Y-Z]0I','China','Xizanh (Tibet) <Pri: 54>','AS','23','',NULL,-6.0,32.0,90.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',20,248,'IH9','Italy','Pantelleria Island <Reg:IG9/IH9>','AF','33','37','AF-018',-1.0,36.7833,12.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',2,248,'I1,IK1,IW1,IX1,IZ1','Italy','Liguria, Piemonte, Valle dAosta','EU','15','28',NULL,-1.0,45.0,8.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',3,248,'I2,IK2,IW2,IZ2','Italy','Lombardia','EU','15','28',NULL,-1.0,46.0,10.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',4,248,'I3,IK3,IZ3,IW3[E-P]','Italy','Veneto','EU','15','28',NULL,-1.0,46.0,12.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',7,248,'I4,IK4,IW4,IZ4','Italy','Emilia-Romagna','EU','15','28',NULL,-1.0,44.0,11.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',8,248,'I5,IK5,IW5,IZ5','Italy','Tuscany','EU','15','28',NULL,-1.0,43.0,11.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',10,248,'I6,IK6,IW6,IZ6','Italy','Marche, Abruzzo','EU','15','28',NULL,-1.0,43.0,13.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',11,248,'I7,IK7,IW7,IZ7','Italy','Puglia, Matera ','EU','15','28',NULL,-1.0,41.0,16.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',14,248,'I8,ID8,IK8,IW8,IZ8','Italy','Campania, Calabria, Molise, Potenza','EU','15','28',NULL,-1.0,40.0,16.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',22,248,'I0,IK0,IW0[A-T],IZ0','Italy','Lazio, Umbria','EU','15','28',NULL,-1.0,42.0,13.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',9,248,'IA5','Italy','Tuscan Islands Group','EU','15','28','EU-028',-1.0,43.0,10.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',13,248,'IL7','Italy','Foggia Island Group (Tremiti)','EU','15','28','EU-050',-1.0,42.0,15.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',12,248,'IJ7','Italy','Puglia (Taranto) Group','EU','15','28','EU-073',-1.0,40.0,17.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',15,248,'IC8','Italy','Campania Region Group','EU','15','28','EU-031',-1.0,41.0,14.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',23,248,'IB0','Italy','Lazio Region Group','EU','15','28','EU-045',-1.0,42.0,12.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE','CE','CE',9,112,'C[A-E]8,3G8,XR8,XQ8','Chile','Magallanes y de la Antarctica','SA','12','16',NULL,4.0,-50.0,-73.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',4,100,'AY#B,AZ#B,L#B,LO#B,LP#B,LQ#B','Argentina','Buenos Aires City <Pri:C>','SA','13','14',NULL,3.0,-34.5,-58.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',6,100,'AY#C,AZ#C,L#C,LO#C,LP#C,LQ#C,','Argentina','Buenos Aires City <Pri:C>','SA','13','14',NULL,3.0,-34.5,-58.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',7,100,'LR#C,LS#C,LT#C,LU#C,LV#C,LW#C','Argentina','Buenos Aires City <Pri:C>','SA','13','14',NULL,3.0,-34.5,-58.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',8,100,'AY#D,AZ#D,L#D,LO#D,LP#D,LQ#D,','Argentina','Buenos Aires <Pri:B>','SA','13','14',NULL,3.0,-36.0,-60.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',9,100,'LR#D,LS#D,LT#D,LU#D,LV#D,LW#D','Argentina','Buenos Aires <Pri:B>','SA','13','14',NULL,3.0,-36.0,-60.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',10,100,'AY#E,AZ#E,L#E,LO#E,LP#E,LQ#E,','Argentina','Buenos Aires <Pri:B>','SA','13','14',NULL,3.0,-36.0,-60.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',11,100,'LR#E,LS#E,LT#E,LU#E,LV#E,LW#E','Argentina','Buenos Aires <Pri:B>','SA','13','14',NULL,3.0,-36.0,-60.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',12,100,'AY#F,AZ#F,L#F,LO#F,LP#F,LQ#F,','Argentina','Santa Fe <Pri:S>','SA','13','14',NULL,3.0,-30.0,-61.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',13,100,'LR#F,LS#F,LT#F,LU#F,LV#F,LW#F','Argentina','Santa Fe <Pri:S>','SA','13','14',NULL,3.0,-30.0,-61.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',14,100,'AY#G,AZ#G,L#G,LO#G,LP#G,LQ#G,','Argentina','Chaco, Formosa','SA','13','14',NULL,3.0,-26.0,-60.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',15,100,'LR#G,LS#G,LT#G,LU#G,LV#G,LW#G','Argentina','Chaco, Formosa','SA','13','14',NULL,3.0,-26.0,-60.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',16,100,'AY#H,AZ#H,L#H,LO#H,LP#H,LQ#H,','Argentina','Cordoba <Pri:X>','SA','13','14',NULL,3.0,-32.0,-64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',17,100,'LR#H,LS#H,LT#H,LU#H,LV#H,LW#H','Argentina','Cordoba <Pri:X>','SA','13','14',NULL,3.0,-32.0,-64.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',18,100,'AY#I,AZ#I,L#I,LO#I,LP#I,LQ#I,','Argentina','Misiones <Pri:N>','SA','13','14',NULL,3.0,-27.0,-55.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',19,100,'LR#I,LS#I,LT#I,LU#I,LV#I,LW#I','Argentina','Misiones <Pri:N>','SA','13','14',NULL,3.0,-27.0,-55.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',20,100,'AY#J,AZ#J,L#J,LO#J,LP#J,LQ#J,','Argentina','Entre Rios <Pri:E>','SA','13','14',NULL,3.0,-32.0,-59.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',21,100,'LR#J,LS#J,LT#J,LU#J,LV#J,LW#J','Argentina','Entre Rios <Pri:E>','SA','13','14',NULL,3.0,-32.0,-59.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',22,100,'AY#K,AZ#K,L#K,LO#K,LP#K,LQ#K,','Argentina','Tucuman <Pri:T>','SA','13','14',NULL,3.0,-27.0,-65.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',23,100,'LR#K,LS#K,LT#K,LU#K,LV#K,LW#K','Argentina','Tucuman <Pri:T>','SA','13','14',NULL,3.0,-27.0,-65.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',24,100,'AY#L,AZ#L,L#L,LO#L,LP#L,LQ#L,','Argentina','Corrientes <Pri:W>','SA','13','14',NULL,3.0,-29.0,-58.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',25,100,'LR#L,LS#L,LT#L,LU#L,LV#L,LW#L','Argentina','Corrientes <Pri:W>','SA','13','14',NULL,3.0,-29.0,-58.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',26,100,'AY#M,AZ#M,L#M,LO#M,LP#M,LQ#M,','Argentina','Mendoza <Pri:M>','SA','13','14',NULL,3.0,-34.0,-68.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',27,100,'LR#M,LS#M,LT#M,LU#M,LV#M,LW#M','Argentina','Mendoza <Pri:M>','SA','13','14',NULL,3.0,-34.0,-68.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',28,100,'AY#N,AZ#N,L#N,LO#N,LP#N,LQ#N,','Argentina','Santiago del Estero <Pri:G>','SA','13','14',NULL,3.0,-28.0,-63.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',29,100,'LR#N,LS#N,LT#N,LU#N,LV#N,LW#N','Argentina','Santiago del Estero <Pri:G>','SA','13','14',NULL,3.0,-28.0,-63.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',30,100,'AY#O,AZ#O,L#O,LO#O,LP#O,LQ#O,','Argentina','Salta <Pri:A>','SA','13','14',NULL,3.0,-25.0,-65.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',31,100,'LR#O,LS#O,LT#O,LU#O,LV#O,LW#O','Argentina','Salta <Pri:A>','SA','13','14',NULL,3.0,-25.0,-65.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',32,100,'AY#P,AZ#P,L#P,LO#P,LP#P,LQ#P,','Argentina','San Juan <Pri:J>','SA','13','14',NULL,3.0,-31.0,-69.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',33,100,'LR#P,LS#P,LT#P,LU#P,LV#P,LW#P','Argentina','San Juan <Pri:J>','SA','13','14',NULL,3.0,-31.0,-69.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',34,100,'AY#Q,AZ#Q,L#Q,LO#Q,LP#Q,LQ#Q,','Argentina','San Luis <Pri:D>','SA','13','14',NULL,3.0,-34.0,-66.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',35,100,'LR#Q,LS#Q,LT#Q,LU#Q,LV#Q,LW#Q','Argentina','San Luis <Pri:D>','SA','13','14',NULL,3.0,-34.0,-66.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',36,100,'AY#R,AZ#R,L#R,LO#R,LP#R,LQ#R,','Argentina','Catamarca <Pri:K>','SA','13','14',NULL,3.0,-27.0,-67.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',37,100,'LR#R,LS#R,LT#R,LU#R,LV#R,LW#R','Argentina','Catamarca <Pri:K>','SA','13','14',NULL,3.0,-27.0,-67.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',38,100,'AY#S,AZ#S,L#S,LO#S,LP#S,LQ#S,','Argentina','La Rioja <Pri:F>','SA','13','14',NULL,3.0,-30.0,-67.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',39,100,'LR#S,LS#S,LT#S,LU#S,LV#S,LW#S','Argentina','La Rioja <Pri:F>','SA','13','14',NULL,3.0,-30.0,-67.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',40,100,'AY#T,AZ#T,L#T,LO#T,LP#T,LQ#T,','Argentina','Jujuy <Pri:Y>','SA','13','',NULL,3.0,-24.0,-65.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',41,100,'LR#T,LS#T,LT#T,LU#T,LV#T,LW#T','Argentina','Jujuy <Pri:Y>','SA','13','',NULL,3.0,-24.0,-65.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',42,100,'AY#U,AZ#U,L#U,LO#U,LP#U,LQ#U,','Argentina','La Pampa <Pri:L>','SA','13','14',NULL,3.0,-37.0,-65.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',43,100,'LR#U,LS#U,LT#U,LU#U,LV#U,LW#U','Argentina','La Pampa <Pri:L>','SA','13','14',NULL,3.0,-37.0,-65.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',44,100,'AY#V,AZ#V,L#V,LO#V,LP#V,LQ#V,','Argentina','Rio Negro <Pri:R>','SA','13',NULL,NULL,3.0,-41.0,-68.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',45,100,'LR#V,LS#V,LT#V,LU#V,LV#V,LW#V','Argentina','Rio Negro <Pri:R>','SA','13',NULL,NULL,3.0,-41.0,-68.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',46,100,'AY#W,AZ#W,L#W,LO#W,LP#W,LQ#W,','Argentina','Chubut <Pri:U>','SA','13','16',NULL,3.0,-44.0,-69.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',47,100,'LR#W,LS#W,LT#W,LU#W,LV#W,LW#W','Argentina','Chubut <Pri:U>','SA','13','16',NULL,3.0,-44.0,-69.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',48,100,'AY#X,AZ#X,L#X,LO#X,LP#X,LQ#X,','Argentina','Santa Cruz, Tierra del Fuego','SA','13','16',NULL,3.0,-49.0,-69.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',49,100,'LR#X,LS#X,LT#X,LU#X,LV#X,LW#X','Argentina','Santa Cruz, Tierra del Fuego','SA','13','16',NULL,3.0,-49.0,-69.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',50,100,'AY#Y,AZ#Y,L#Y,LO#Y,LP#Y,LQ#Y,','Argentina','Neuquen <Pri:Q>','SA','13','14',NULL,3.0,-39.0,-70.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',51,100,'LR#Y,LS#Y,LT#Y,LU#Y,LV#Y,LW#Y','Argentina','Neuquen <Pri:Q>','SA','13','14',NULL,3.0,-39.0,-70.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PJ7','PJ7','PJ',1,518,'PJ7','Sint Maarten','St Maarten','NA','8','11','',4.0,18.03,-63.05,'2010-10-10 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('KH8-S','K','KH8',1,515,'KH8-S','Swains Island','Swains Island','OC','32','62','OC-200',11.0,-11.056,-171.0875,'2006-07-22 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',5,248,'IN3,IW3[A-D]','Italy','Trentino Alto Adige','EU','15','28',NULL,-1.0,46.0,12.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('I','I','I',6,248,'IV3,IW3[Q-Z]','Italy','Friuli Venezia Giulia','EU','15','28',NULL,-1.0,46.0,12.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PJ2','PJ2','PJ',1,517,'PJ2','Curacao','Curacao','SA','9','11','SA-099',4.0,12.1,-68.9,'2010-10-10 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','VP8','CE9',33,13,'VP8ROT, VP8ADE','Antarctica','Rothera Station - Adelaide Island','AN','13','73','AN-001',4.0,-67.57,68.13,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FJ','FJ','FJ',1,516,'FJ','Saint Barthelemy','Saint Barthelemy','NA','8','11','NA-146',4.0,17.9,-62.83,'2007-12-14 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',9,318,'B[A-L;R-T;Y-Z]3A,B[A-L;R-T;Y-Z]3B,B[A-L;R-T;Y-Z]3C','China','TianJin <Pri: 12>','AS','24',NULL,NULL,-8.0,39.5,117.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',2,318,'B[A-L;R-T;Y-Z]1','China','Beijing <Pri:11>','AS','24',NULL,NULL,-8.0,40.0,116.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',13,318,'B[A-L;R-T;Y-Z]3M,B[A-L;R-T;Y-Z]3N,B[A-L;R-T;Y-Z]3O','China','HeBei <Pri: 13>','AS','24',NULL,NULL,-8.0,40.0,116.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',15,318,'B[A-L;R-T;Y-Z]3S,B[A-L;R-T;Y-Z]3T,B[A-L;R-T;Y-Z]3U,B[A-L;R-T;Y-Z]3V','China','ShanXi <Pri: 14>','AS','24',NULL,NULL,-8.0,38.0,113.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',58,318,'B[A-L;R-T;Y-Z]0A,B[A-L;R-T;Y-Z]0B,B[A-L;R-T;Y-Z]0C','China','XinJiang <Pri: 65>','AS','23',NULL,NULL,-8.0,37.0,85.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',3,100,'LR#A,LS#A,LT#A,LU#A,LV#A,LW#A','Argentina','Buenos Aires City <Pri:C>','SA','13','14',NULL,3.0,-34.5,-58.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('LU','LU','LU',5,100,'LR#B,LS#B,LT#B,LU#B,LV#B,LW#B','Argentina','Buenos Aires City <Pri:C>','SA','13','14',NULL,3.0,-34.5,-58.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('TA','TA','TA',1,390,'TA1,TB1,TC1,YM1','Turkey','Istanbul <Reg:TA1>','EU','20','39',NULL,-3.0,41.25,28.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OE','OE','OE',2,206,'4U1V,C7A,4Y1A','Austria','UN Vienna <Reg:4U1V>','EU','15','28',NULL,-1.0,48.2342,16.4169,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('GM','G','G',2,279,'2Z,GZ,MZ','Scotland','Shetland Islands <Reg:GM/S>','EU','14','27','EU-012',0.0,60.4,-1.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('GM','G','G',3,279,'2M0ZET,2M1ANT,2M1ASQ,2M1ODL,G0FBJ,GB2ELH,GB2ZET,GB3LER,GB4SI,GM0CXQ,MM6SJK,MS0ZCG,MS0ZET,GM0CYJ,GM0DJI,
	GM0EKM,GM0GFL,GM0ILB,GM0JDB,GM0MZD,GM0OMV,GM0VFA,GM1BYL,GM1CBQ,GM1KKI,GM1MXN,GM1ZNR,GM3KLA,GM3KZH,
	GM3RFR,GM3SJA,GM3STU,GM3UPU,GM3WCH,GM3WHT,GM3XPQ,GM3ZET,GM3ZNM,GM3ZXH,GM4AGX,MM6BDU,GM4CAQ,GM4DQD,
	GM4ENK,GM4FNA,GM4FNE,GM4GPN,GM4GPP,GM4GQD,GM4GQM,GM4IPK,GM4JPI,GM4KJQ,GM4LBE,GM4LER,GM4PXG,GM4SLV,
	GM4SRU,GM4SSA,GM4SWU,GM4WXQ,GM4YEL,GM4ZHL,GM6RTO,GM6VZB,GM6WVI,GM6YQA,GM7AFE,GM7GWW,GM7RKD,GM8LNH,
	GM8MMA,GM8YEC,GS3ZET,MA1FJM,MM0LSM,MM0XAU,MM0ZAL,MM0ZCG,MM1FJM,MM3ZET,MM5PSL,MM6ACW','Scotland','Shetland Islands <Reg:GM/S>','EU','14','27','EU-012',0.0,60.4,-1.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OL','OL','OL',2,503,'OK1','Czech Republic','Bohemia','EU','15','28',NULL,-1.0,50.0834,14.45,'1993-01-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OL','OL','OL',3,503,'OK2','Czech Republic','Moravia','EU','15','28',NULL,-1.0,49.5939,17.25,'1993-01-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OM','OM','OM',2,504,'OM1','Slovakia','Bratslava','EU','15','28',NULL,-1.0,48.1667,17.1,'1993-01-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OM','OM','OM',3,504,'OM2','Slovakia','Trnva','EU','15','28',NULL,-1.0,48.3828,17.5875,'1993-01-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OM','OM','OM',4,504,'OM4','Slovakia','Trencin, Prievidza','EU','15','28',NULL,-1.0,48.8944,18.035,'1993-01-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OM','OM','OM',5,504,'OM5','Slovakia','Nitra, Nove Zamky','EU','15','28',NULL,-1.0,48.31,18.0833,'1993-01-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OM','OM','OM',6,504,'OM6','Slovakia','Zilina, Cadca, Martin','EU','15','28',NULL,-1.0,49.2167,18.73,'1993-01-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OM','OM','OM',7,504,'OM7','Slovakia','Banska Bystrica','EU','15','28',NULL,-1.0,48.7375,19.15,'1993-01-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('OM','OM','OM',8,504,'OM8','Slovakia','Kosice, Poprad','EU','15','28',NULL,-1.0,48.7214,21.25,'1993-01-01 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('SV','SV','SV',2,236,'S[V-Z]1,J41','Greece','Sterea Ellada','EU','20','28',NULL,-2.0,38.5,23.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('SV','SV','SV',3,236,'S[V-Z]2,J42','Greece','Central & West Macedonia','EU','20','28',NULL,-2.0,40.5,23.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('SV','SV','SV',4,236,'S[V-Z]3,J43','Greece','Peloponnese','EU','20','28',NULL,-2.0,37.5,22.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('SV','SV','SV',5,236,'S[V-Z]4,J44','Greece','Thessaly','EU','20','28',NULL,-2.0,39.5,22.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('SV','SV','SV',6,236,'S[V-Z]6,J46','Greece','Epirus','EU','20','28',NULL,-2.0,39.6,20.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('SV','SV','SV',7,236,'S[V-Z]7,J47','Greece','Thrace & East Macedonia','EU','20','28',NULL,-2.0,41.1,25.7,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('SV','SV','SV',8,236,'S[V-Z]8,J48','Greece','Aegean & Ionian Islands','EU','20','28',NULL,-2.0,37.0,25.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',3,318,'B[A-L;R-T;Y-Z]2A,B[A-L;R-T;Y-Z]2B,B[A-L;R-T;Y-Z]2C,B[A-L;R-T;Y-Z]2D','China','Hei Long Jiang <Pri: 23>','AS','24','',NULL,-7.0,47.0,128.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',5,318,'B[A-L;R-T;Y-Z]2I,B[A-L;R-T;Y-Z]J,B[A-L;R-T;Y-Z]2K,B[A-L;R-T;Y-Z]2L','China','Ji Lin <Pri: 22>','AS','24','',NULL,-7.0,42.0,127.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',7,318,'B[A-L;R-T;Y-Z]2Q,B[A-L;R-T;Y-Z]2R,B[A-L;R-T;Y-Z]2S,B[A-L;R-T;Y-Z]2T','China','Lio Ning <Pri: 21>','AS','24','44',NULL,-7.0,41.0,123.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',17,318,'B[A-L;R-T;Y-Z]4A,B[A-L;R-T;Y-Z]4B,B[A-L;R-T;Y-Z]4C,B[A-L;R-T;Y-Z]4D','China','Shang Hai <Pri: 31>','AS','24','44',NULL,-7.0,31.0,121.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',19,318,'B[A-L;R-T;Y-Z]4I,B[A-L;R-T;Y-Z]4J,B[A-L;R-T;Y-Z]4K,B[A-L;R-T;Y-Z]4L','China','Shandong <Pri: 37>','AS','24','44',NULL,-7.0,36.0,118.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',21,318,'B[A-L;R-T;Y-Z]4Q,B[A-L;R-T;Y-Z]4R,B[A-L;R-T;Y-Z]4S,B[A-L;R-T;Y-Z]4T,B[A-L;R-T;Y-Z]4U','China','Jiangsu <RegL32>','AS','24','44',NULL,-7.0,33.5,119.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',23,318,'B[A-L;R-T;Y-Z]5A,B[A-L;R-T;Y-Z]5B,B[A-L;R-T;Y-Z]5C,B[A-L;R-T;Y-Z]5D','China','Zhejiang <Pri: 33>','AS','24','44',NULL,-7.0,29.0,120.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',25,318,'B[A-L;R-T;Y-Z]5I,B[A-L;R-T;Y-Z]5J,B[A-L;R-T;Y-Z]5K,B[A-L;R-T;Y-Z]5L','China','Jiangxi <Pri: 36>','AS','24','44',NULL,-7.0,NULL,NULL,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',27,318,'B[A-L;R-T;Y-Z]5Q,B[A-L;R-T;Y-Z]5R,B[A-L;R-T;Y-Z]5S,B[A-L;R-T;Y-Z]5T,B[A-L;R-T;Y-Z]5U','China','Fujian <Pri: 35>','AS','24','44',NULL,-7.0,26.0,118.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',29,318,'B[A-L;R-T;Y-Z]6A,B[A-L;R-T;Y-Z]6B,B[A-L;R-T;Y-Z]6C,B[A-L;R-T;Y-Z]6D','China','Anhui <Pri: 34>','AS','24','44',NULL,-7.0,32.0,117.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',31,318,'B[A-L;R-T;Y-Z]6I,B[A-L;R-T;Y-Z]6J,B[A-L;R-T;Y-Z]6K,B[A-L;R-T;Y-Z]6L','China','Henan <Pri: 41>','AS','24','44',NULL,-7.0,34.0,114.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',37,318,'B[A-L;Y-Z]7I,B[A-L;Y-Z]7J,B[A-L;Y-Z]7K,B[A-L;Y-Z]7L,BR7[I-P]','China','Guangdong <Pri: 44>','AS','24','44',NULL,-7.0,24.0,114.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',33,318,'B[A-L;R-T;Y-Z]6Q,B[A-L;R-T;Y-Z]6R,B[A-L;R-T;Y-Z]6S,B[A-L;R-T;Y-Z]6T','China','Hubei <Pri:42>','AS','24','',NULL,-7.0,31.0,112.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',35,318,'B[A-L;Y-Z]7A,B[A-L;Y-Z]7B,B[A-L;Y-Z]7C,B[A-L;Y-Z]7D,BR7[A-H]','China','Hunan <Pri: 43>','AS','22','',NULL,-7.0,27.0,111.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',39,318,'B[A-L;Y-Z]7Q,B[A-L;Y-Z]7R,B[A-L;Y-Z]7S,B[A-L;Y-Z]7T,BR7[Q-X]','China','Guangxi <Pri: 45>','AS','24','',NULL,-7.0,24.0,109.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',42,318,'B[A-L;R-T;Y-Z]8A,B[A-L;R-T;Y-Z]8B,B[A-L;R-T;Y-Z]8C','China','Sichuan <Pri: 51>','AS','24','43',NULL,-7.0,30.0,103.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',44,318,'B[A-L;R-T;Y-Z]8G,B[A-L;R-T;Y-Z]8H,B[A-L;R-T;Y-Z]8I','China','Chongquing <Pri: 50>','AS','24','43',NULL,-7.0,29.5,106.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',46,318,'B[A-L;R-T;Y-Z]8M,B[A-L;R-T;Y-Z]8N,B[A-L;R-T;Y-Z]8O','China','Guizhou <Pri: 52>','AS','24','43',NULL,-7.0,27.0,107.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',48,318,'B[A-L;R-T;Y-Z]8S,B[A-L;R-T;Y-Z]8T,B[A-L;R-T;Y-Z]8U','China','Yunnan <Pri: 53>','AS','24','42',NULL,-7.0,25.0,102.7,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',50,318,'B[A-L;R-T;Y-Z]9A,B[A-L;R-T;Y-Z]9B,B[A-L;R-T;Y-Z]9C','China','Shanxi <Pri: 14>','AS','24','',NULL,-7.0,37.0,112.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',52,318,'B[A-L;R-T;Y-Z]9G,B[A-L;R-T;Y-Z]9H,B[A-L;R-T;Y-Z]9I','China','Gansu <Pri: 62>','AS','23','43',NULL,-7.0,36.0,104.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',54,318,'B[A-L;R-T;Y-Z]9M,B[A-L;R-T;Y-Z]9N,B[A-L;R-T;Y-Z]9O','China','Ningxia <Pri: 64>','AS','23','43',NULL,-7.0,37.0,107.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',56,318,'B[A-L;R-T;Y-Z]9S,B[A-L;R-T;Y-Z]9T,B[A-L;R-T;Y-Z]9U','China','Quinghai <Pri: 63>','AS','23','43',NULL,-7.0,36.0,96.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',2,144,'CX#A,CX#B,CX#C,CV#A,CV#B,CV#C,CW#A,CW#B,CW#C','Uruguay','Montevideo <Pri:MO>','SA','13','14',NULL,3.0,-34.9,-56.25,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',3,144,'CX#D,CV#D,CW#D','Uruguay','Canelones <Pri:CA>','SA','13','14',NULL,3.0,-34.5,-56.25,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',4,144,'CX#E,CV#E,CW#E','Uruguay','San Jose <Pri:SJ>','SA','13','14',NULL,3.0,-34.25,-56.75,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',5,144,'CX#F,CV#F,CW#F','Uruguay','Colonia <Pri:CO>','SA','13','14',NULL,3.0,-34.25,-57.75,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',6,144,'CX#G,CV#G,CW#G','Uruguay','Soriano <Pri:SO>','SA','13','14',NULL,3.0,-33.5,-57.75,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',7,144,'CX#H,CV#H,CW#H','Uruguay','Rio Negro <Pri:RN>','SA','13','14',NULL,3.0,-32.75,-57.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',8,144,'CX#I,CV#I,CW#I','Uruguay','Paysandu <Pri:PA>','SA','13','14',NULL,3.0,-33.3,-50.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',9,144,'CX#J,CV#J,CW#J','Uruguay','Salto <Pri:SA>','SA','13','14',NULL,3.0,-31.4,-57.9,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',10,144,'CX#K,CV#K,CW#K','Uruguay','Artigas <Pri:AR>','SA','13','14',NULL,3.0,-30.5,-57.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',11,144,'CX#L,CV#L,CW#L','Uruguay','Florida <Pri:FD>','SA','13','14',NULL,3.0,-33.75,-55.9,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',12,144,'CX#M,CV#M,CW#M','Uruguay','Flores <Pri:FS>','SA','13','14',NULL,3.0,-33.5,-56.9,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',13,144,'CX#N,CV#N,CW#N','Uruguay','Durazno <Pri:DU>','SA','13','14',NULL,3.0,-33.0,-56.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',14,144,'CX#O,CV#O,CW#O','Uruguay','Tacuarembo <Pri:TA>','SA','13','14',NULL,3.0,-31.7,-56.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',15,144,'CX#P,CV#P,CW#P','Uruguay','Rivera <Pri:RV>','SA','13','14',NULL,3.0,-31.5,-55.25,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',16,144,'CX#R,CV#R,CW#R','Uruguay','Maldonado <Pri:MA>','SA','13','14',NULL,3.0,-34.9,-55.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',17,144,'CX#S,CV#S,CW#S','Uruguay','Lavalleja <Pri:LA>','SA','13','14',NULL,3.0,-34.35,-55.25,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',18,144,'CX#T,CV#T,CW#T','Uruguay','Rocha <Pri:RO>','SA','13','14',NULL,3.0,-34.5,-55.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',19,144,'CX#U,CV#U,CW#U','Uruguay','Treinta y Tres <Pri:TT>','SA','13','14',NULL,3.0,-33.25,-54.4,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CX','CX','CX',20,144,'CX#V,CV#V,CW#V','Uruguay','Cerro Largo <Pri:CL>','SA','13','14',NULL,3.0,-32.3,-54.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',87,108,'PV8, PU8[T-V], Z[V-Z]8T, Z[V-Z]8U, Z[V-Z]8]V','Brazil','Roraima <Pri:RR>','SA','11','',NULL,4.0,2.0,-62.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',88,108,'PW8, PU8[D-F], Z[V-Z]8D, Z[V-Z]8E, Z[V-Z]8F','Brazil','Rondonia <Pri:RO>','SA','11','12',NULL,4.0,-10.8,-63.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PY','PY','PY',92,108,'PT9, PU9[A-N], Z[V-Z]9','Brazil','Mato Grosso do Sul <Pri:MS>','SA','11','15',NULL,4.0,-20.7,-55.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',4,318,'B[A-L;R-T;Y-Z]2E,B[A-L;R-T;Y-Z]2F,B[A-L;R-T;Y-Z]2G,B[A-L;R-T;Y-Z]2H','China','Hei Long Jiang <Pri: 23>','AS','24','',NULL,-7.0,47.0,128.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',6,318,'B[A-L;R-T;Y-Z]2M,B[A-L;R-T;Y-Z]N,B[A-L;R-T;Y-Z]2O,B[A-L;R-T;Y-Z]2P','China','Ji Lin <Pri: 22>','AS','24','',NULL,-7.0,42.0,127.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',8,318,'B[A-L;R-T;Y-Z]2U,B[A-L;R-T;Y-Z]2V,B[A-L;R-T;Y-Z]2W,B[A-L;R-T;Y-Z]2X','China','Lio Ning <Pri: 21>','AS','24','44',NULL,-7.0,41.0,123.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',10,318,'B[A-L;R-T;Y-Z]3D,B[A-L;R-T;Y-Z]3E,B[A-L;R-T;Y-Z]3F','China','TianJin <Pri: 12>','AS','24',NULL,NULL,-8.0,39.5,117.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',12,318,'B[A-L;R-T;Y-Z]3J, B[A-L;R-T;Y-Z]3K,B[A-L;R-T;Y-Z]3L','China','NeiMenggu <Pri: 15>','AS','23',NULL,NULL,-8.0,38.0,100.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',14,318,'B[A-L;R-T;Y-Z]3P,B[A-L;R-T;Y-Z]3Q,B[A-L;R-T;Y-Z]3R','China','HeBei <Pri: 13>','AS','24',NULL,NULL,-8.0,40.0,116.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',16,318,'B[A-L;R-T;Y-Z]3W,B[A-L;R-T;Y-Z]3X,B[A-L;R-T;Y-Z]3Y,B[A-L;R-T;Y-Z]3Z','China','ShanXi <Pri: 14>','AS','24',NULL,NULL,-8.0,38.0,113.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',18,318,'B[A-L;R-T;Y-Z]4E,B[A-L;R-T;Y-Z]4F,B[A-L;R-T;Y-Z]4G,B[A-L;R-T;Y-Z]4H','China','Shang Hai <Pri: 31>','AS','24','44',NULL,-7.0,31.0,121.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',20,318,'B[A-L;R-T;Y-Z]4M,B[A-L;R-T;Y-Z]4N,B[A-L;R-T;Y-Z]4O,B[A-L;R-T;Y-Z]4P','China','Shandong <Pri: 37>','AS','24','44',NULL,-7.0,36.0,118.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',22,318,'B[A-L;R-T;Y-Z]4V,B[A-L;R-T;Y-Z]4W,B[A-L;R-T;Y-Z]4X,B[A-L;R-T;Y-Z]4Y,B[A-L;R-T;Y-Z]4Z','China','Jiangsu <Pri: 32>','AS','24','44',NULL,-7.0,33.5,119.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',24,318,'B[A-L;R-T;Y-Z]5E,B[A-L;R-T;Y-Z]5F,B[A-L;R-T;Y-Z]5G,B[A-L;R-T;Y-Z]5H','China','Zhejiang <Pri: 33>','AS','24','44',NULL,-7.0,29.0,120.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',26,318,'B[A-L;R-T;Y-Z]5M,B[A-L;R-T;Y-Z]5N,B[A-L;R-T;Y-Z]5O,B[A-L;R-T;Y-Z]5P','China','Jiangxi <Pri: 36>','AS','24','44',NULL,-7.0,NULL,NULL,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',28,318,'B[A-L;R-T;Y-Z]5V,B[A-L;R-T;Y-Z]5W,B[A-L;R-T;Y-Z]5X,B[A-L;R-T;Y-Z]5Y,B[A-L;R-T;Y-Z]5Z','China','Fujian <Pri: 35>','AS','24','44',NULL,-7.0,26.0,118.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',30,318,'B[A-L;R-T;Y-Z]6E,B[A-L;R-T;Y-Z]6F,B[A-L;R-T;Y-Z]6G,B[A-L;R-T;Y-Z]6H','China','Anhui <Pri: 34>','AS','24','44',NULL,-7.0,32.0,117.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',32,318,'B[A-L;R-T;Y-Z]6M,B[A-L;R-T;Y-Z]6N,B[A-L;R-T;Y-Z]6O,B[A-L;R-T;Y-Z]6P','China','Henan <Pri: 41>','AS','24','44',NULL,-7.0,34.0,114.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',34,318,'B[A-L;R-T;Y-Z]6U,B[A-L;R-T;Y-Z]6V,B[A-L;R-T;Y-Z]6W,B[A-L;R-T;Y-Z]6X','China','Hubei <Pri: 42>','AS','24','',NULL,-7.0,31.0,112.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',36,318,'B[A-L;Y-Z]7E,B[A-L;Y-Z]7F,B[A-L;Y-Z]7G,B[A-L;Y-Z]7H,BT7[A-H]','China','Hunan <Pri: 43>','AS','22','',NULL,-7.0,27.0,111.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',38,318,'B[A-L;Y-Z]7M,B[A-L;Y-Z]7N,B[A-L;Y-Z]7O,B[A-L;Y-Z]7P,BT7[I-P]','China','Guangdong <Pri: 44>','AS','24','44',NULL,-7.0,24.0,114.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',40,318,'B[A-L;Y-Z]7U,B[A-L;Y-Z]7V,B[A-L;Y-Z]7W,B[A-L;Y-Z]7X,BT7[Q-X]','China','Guangxi <Pri:45>','AS','24','',NULL,-7.0,24.0,109.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',41,318,'B[A-L;Y-Z]7Y,BR7Y,BT7Y','China','Hainan Island <Pri:46>','AS','24','44','AS-129',-7.0,19.0,110.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',43,318,'B[A-L;R-T;Y-Z]8D,B[A-L;R-T;Y-Z]8E,B[A-L;R-T;Y-Z]8F','China','Sichuan <Pri: 51>','AS','24','43',NULL,-7.0,30.0,103.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',45,318,'B[A-L;R-T;Y-Z]8J,B[A-L;R-T;Y-Z]8K,B[A-L;R-T;Y-Z]8L','China','Chongquing <Pri: 50>','AS','24','43',NULL,-7.0,29.5,106.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',47,318,'B[A-L;R-T;Y-Z]8P,B[A-L;R-T;Y-Z]8Q,B[A-L;R-T;Y-Z]8R','China','Guizhou <Pri:52>','AS','24','43',NULL,-7.0,27.0,107.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',49,318,'B[A-L;R-T;Y-Z]8V,B[A-L;R-T;Y-Z]8W,B[A-L;R-T;Y-Z]8X','China','Yunnan <Pri: 53:','AS','24','42',NULL,-7.0,25.0,102.7,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',51,318,'B[A-L;R-T;Y-Z]9D,B[A-L;R-T;Y-Z]9E,B[A-L;R-T;Y-Z]9F','China','Shanxi <Pri: 14>','AS','24','',NULL,-7.0,37.0,112.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',53,318,'B[A-L;R-T;Y-Z]9J,B[A-L;R-T;Y-Z]9K,B[A-L;R-T;Y-Z]9L','China','Gansu <Pri: 62>','AS','23','43',NULL,-7.0,36.0,104.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',55,318,'B[A-L;R-T;Y-Z]9P,B[A-L;R-T;Y-Z]9Q,B[A-L;R-T;Y-Z]9R','China','Ningxia <Pri: 64>','AS','23','43',NULL,-7.0,37.0,107.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',57,318,'B[A-L;R-T;Y-Z]9V,B[A-L;R-T;Y-Z]9W,B[A-L;R-T;Y-Z]9X','China','Quinghai <Pri: 63>','AS','23','43',NULL,-7.0,36.0,96.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',59,318,'B[A-L;R-T;Y-Z]0D,B[A-L;R-T;Y-Z]0E,B[A-L;R-T;Y-Z]0F','China','XinJiang <Pri: 65>','AS','23',NULL,NULL,-8.0,37.0,85.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('BY','BY','BY',61,318,'B[A-L;R-T;Y-Z]0J,B[A-L;R-T;Y-Z]0K,B[A-L;R-T;Y-Z]0L','China','Xizanh (Tibet) <Pri: 54>','AS','23','42',NULL,-6.0,32.0,90.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FR-J','F','FR-J',2,124,'FR-E,FT#E','Juan de Nova','Europa Island','AF','39','53','AF-009',-4.0,-22.3667,40.35,'1960-06-25 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',52,288,'UU0,UU1,UU2,UU3,UU4,UU5,UU6,UU8','Ukraine','Respublika Krym <Pri:KR>','EU','16','29',NULL,-3.0,51.0,31.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UT','UT','UT',53,288,'UU9,UT5J','Ukraine','Sevastopol <Pri:SL>','EU','16','29',NULL,-3.0,50.45,30.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',5,13,'AY#ZS, AZ#ZS, LU#ZS','Antarctica','Marambio Station (Argentina)','AN','30','73','AN-013',3.0,-64.23,56.62,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',2,13,'CE9AP','Antarctica','Capt. Arturo Pratt Base (Chile)','AN','13','73',NULL,4.0,-62.5,59.68,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',11,13,'VK0-W','Antarctica','Mawson Base (Austtralia)','AN','39','69',NULL,-5.0,-67.6,62.87,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',6,54,'R[A-H;J-Z]1F,R?1G,R?1H,R?1I,R?1J,U!1[F-J]','European Russia','St. Petersburg <Pri:SP>','EU','16','',NULL,-4.0,59.6,30.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',20,54,'R?5A,R?5B,R?5C,U!5A,U!5B,U!5C,R5A,R5B,R5C','European Russia','Moscow <Pri:MA>','EU','16','29',NULL,-4.0,55.5,38.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',21,54,'R[B-Z]2D,R[B-Z]2H,R2D,R2H,U2D,U2H','European Russia','Moscow region <Pri:MO>','EU','16','29',NULL,-4.0,55.5,38.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',23,54,'R?5D,U!5D,R?5F,U!5F,R?5H,U!5H,R5D,R5F,R5H','European Russia','Moscow region <Pri:MO>','EU','16','29',NULL,-4.0,55.5,38.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',27,54,'R?3I,R?3J,U!3I,U!3J,R3I,R3J,U3I,U3J','European Russia','Tver <Pri:TV>','EU','16','29',NULL,-4.0,56.5,35.9,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',28,54,'R?5I,R?5J,U!5I,U!5J,R5I,R5J','European Russia','Tver <Pri:TV>','EU','16','29',NULL,-4.0,55.0,35.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',33,54,'R[B-Z]2O,R2O,U2O,R?3O,U!3O,R3O,U3O,R?5O,U!5O,R5O','European Russia','Voronezh <Pri:VR>','EU','16','29',NULL,-4.0,51.4,39.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',35,54,'R?3K,U!3K,R3K,U3K,R?5K,U!5K,R5K','European Russia','Voronezh <Pri:VR>','EU','16','29',NULL,-4.0,51.4,39.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',65,54,'R?6Q,U!6Q,R6Q,U6Q,R?7Q,U!7Q,R7Q','European Russia','Republic of Ingushetia <Pri:IN>','EU','16','29',NULL,-4.0,43.2,44.8,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',63,54,'R?7L,R?7M,R?7N,U!7L,U!7M,U!7N,R7L,R7M,R7N','European Russia','Rostov <Pri:RO>','EU','16','29',NULL,-4.0,47.1,39.7,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',67,54,'R?6V,U[A-E;G-I]6V,R6V,U6V,R?7V,U!7V,R7V','European Russia','Astrakhan <Pri:AO>','EU','16','29',NULL,-4.0,47.0,48.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',2,15,'R?8A,U!8A,R?8B,U!8B,R8A,R8B','Asiatic Russia','Chelyabinsk <Pri:CB>','AS','17','30',NULL,-6.0,54.0,61.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',4,15,'R?8C,R?8D,U!8C,U!8D,R8C,R8D','Asiatic Russia','Sverdlovsk <Pri: SV>','AS','17','',NULL,-6.0,57.0,61.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',7,15,'R?8H,R?8I,U!8H,U!8I,R8H,R8I','Asiatic Russia','Tomsk <Pri:TO>','AS','18','',NULL,-7.0,57.0,85.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',12,15,'R?8M,R?8N,U!8M,U!8N,R8M,R8N','Asiatic Russia','Omsk <Pri:OM>','AS','17','',NULL,-7.0,55.0,74.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',15,15,'R?8Q,R?8R,U!8Q,U!8R,R8Q,R8R','Asiatic Russia','Kurgan <Pri:KN>','AS','17','30',NULL,-6.0,55.0,65.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',17,15,'R?8S,R?8T,U!8S,U!8T,R8S,R8T','Asiatic Russia','Orenburg <Pri:OB>','EU','16','30',NULL,-6.0,52.0,55.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',11,54,'RI1O','European Russia','Novaya Zemlya <Pri:AR>','EU','16','75','EU-035',-4.0,73.0,55.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',13,54,'RI1P','European Russia','Kolguev Is. <Pri:NO>','EU','16','20','EU-085',-4.0,69.0,49.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',32,15,'RI0F','Asiatic Russia','Kuril Islands <Pri:SL>','AS','19','34','AS-025',-12.0,47.0,150.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',36,15,'RI0K','Asiatic Russia','Wrangel Ia. <Pri:CK>','AS','19','26','AS-027',-12.0,71.3,-179.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',41,15,'RI0Q[A-L],RI0QA?','Asiatic Russia','Bear Is. <Pri:YA>','AS','19','23','AS-022',-10.0,70.6,161.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',42,15,'RI0Q[M-Z],RI0QC?','Asiatic Russia','Siberian Islands. <Pri:YA>','AS','19','23','AS-070',-10.0,70.5,157.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',49,15,'RI0X','Asiatic Russia','Karaginskij Island <Pri:KT>','AS','19','25','AS-064',-12.0,59.5,164.6,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',52,15,'RI0Z','Asiatic Russia','Commander Islands <Pri:KT>','AS','19','35','AS-039',-12.0,55.0,166.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',29,15,'RI0C','Asiatic Russia','Iony Is. <Pri:HK>','AS','19','34','AS-069',-12.0,56.3,143.4,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',9,54,'RI1N','European Russia','Islands of European Russia','EU','16',NULL,NULL,-4.0,NULL,NULL,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',38,15,'RI0N','Asiatic Russia','Islands of Asiatic Russia','AS','19',NULL,NULL,-11.0,NULL,NULL,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PJ5','PJ5','PJ',2,519,'PJ6','Saba & Saint Eustatius','Saba','NA','8','11','NA-145',4.0,17.63,-63.23,'2010-10-10 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PJ9','PJ2','PJ',1,85,'~PJ9','Bonaire, Curacao ','Bonaire, Curacao (Neth Antilles)','SA','9','11','SA-006',4.0,12.15,-68.9,NULL,'2010-10-09 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('PJ8','PJ5','PJ',1,255,'~PJ7,~PJ8','St Maarten, Saba, St Eustatius','Sint Maarten, Saba, Saint Eustatius','NA','8','11',NULL,4.0,17.5,-62.0,NULL,'2010-10-09 00:00:00.000');");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('Z8','Z8','Z8',1,521,'Z8','Republic of South Sudan','South Sudan','AF','34',NULL,NULL,-2.0,4.95,31.5,'2011-07-14 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('FW','F','FW',2,298,'TW0F','Wallis & Futuna Islands','Futuna & Horne Islands','OC','32','62','OC-118',-12.0,-14.28,-178.13,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VP8-H','VP8H','VP8-H',2,241,'AY#ZC, AY#ZI, AY#ZO, AY#ZT,  AZ#ZC, AZ#ZI, AZ#ZO, AZ#ZT ','South Shetland Islands','South Shetland Islands','AN','13','73','AN-010',4.0,-62.0333,-58.21,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VP8-S','VP8S','VP8-GS',2,240,'AY#ZY, AZ#ZY, LU#ZY','South Sandwich Islands','South Sandwich Islands',NULL,'13','73','AN-009',4.0,-59.4267,-27.0833,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('VP8-O','VP8O','VP8-O',2,238,' AY#ZA, AY#ZM, AZ#ZA,  AZ#ZM','South Orkney Islands','South Orkney Islands','AN','13','73','AN-008',3.0,-60.7167,-45.6,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',19,13,'8J1RF','Antarctica','Dome Fuji Base (Japan)','AN','39','67','AN-016',-3.0,-77.2,38.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('Z6','Z6','YU',3,522,'Z6','Republic of Kosovo','Kosovo ','EU','15','28',NULL,-1.0,42.7,21.167,'2018-01-21 00:00:00.000',NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',67,54,'UF6V','European Russia','Russian-occupied Georgia','AD','21','29',NULL,-4.0,41.8333,42.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('5B','1B','5B',1,215,'1B','Cyprus','TRNC (Not valid for DXCC)','AS','20','39',NULL,-2.0,35.25,33.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('JW','JW','JW',2,259,'JW*/B','Svalbard','Bear Island <Reg:JW/B>','EU','40','18','EU-027',-1.0,74.45,19.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',2,327,'Y[B-H]0','Indonesia','Jakarta','OC','28',NULL,NULL,-7.0,-6.25,106.83,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',6,327,'Y[B-H]4','Indonesia','Jambi, S. Sumatra, Bengkulu, & Lampung','OC','28','54',NULL,-7.0,-2.99,104.75,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',9,327,'YB7[A-G],YB7Z[A-G],YC7[A-G],YC7Z[A-G],YD7[A-G],YD7Z[R-G],YE7[A-G],YE7Z[A-G],YF7[A-G],YF7Z[A-G], YG7[A-G],YG7Z[A-G],YH7[A-G],YH7Z[A-G]','Indonesia','West Borneo','OC','28','54',NULL,-7.0,0.0,109.3,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',10,327,'YB7[O-T],YB2Z[O-T],Yc7[O-T],YC2Z[O-T],YD7[O-T],YD2Z[O-T],YE7[O-T],YE2Z[O-T],YF7[O-T],YF2Z[O-T],YG7[O-T],YG2Z[O-T],YH7[O-T],YH2Z[O-T],','Indonesia','Central Borneo','OC','28','54',NULL,-7.0,-2.5,113.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',11,327,'YB7[H-N],YB7Z[H-N],YC7[H-N],YC7Z[H-N],YD7[H-N],YD7Z[H-N],YE7[H-N],YE7Z[H-N],YF7[H-N],YF7Z[H-N],YG7[H-N],YG7Z[H-N],YH7[H-N],YH7Z[H-N]','Indonesia','South Borneo','OC','28','54',NULL,-8.0,-3.5,115.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',12,327,'YB7[U-Y],YB7Z[U-Z],YC7[U-Y],YC7Z[U-Z],YD7[U-Y],YD7Z[U-Z],YE7[U-Y],YE7Z[U-Z],YF7[U-Y],YF7Z[U-Z],YG7[U-Y],YG7Z[U-Z],YH7[U-Y],YH7Z[U-Z]','Indonesia','East Borneo','OC','28','54',NULL,-8.0,-0.5,117.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',13,327,'YB8[A-U],YB8Z[A-U],YC8[A-U],YC8Z[A-U],YD8[A-U],YD8Z[A-U],YE8[A-U],YE8Z[A-U],YF8[A-U],YF8Z[A-U],YG8[A-U],YG8Z[A-U],YH8[A-U],YH8Z[A-U]','Indonesia','Sulawesi','OC','28','54',NULL,-8.0,-2.0,120.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',14,327,'YB8[V-Y],YB8Z[V-Z],YC8[V-Y],YC8Z[V-Z],YD8[V-Y],YD8Z[V-Z],YE8[V-Y],YE8Z[V-Z],YF8[V-Y],YF8Z[V-Z],YG8[V-Y],YG8Z[V-Z],YH8[V-Y],YH8Z[V-Z]','Indonesia','Maluku Islands','OC','28','54',NULL,-9.0,-3.7,128.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',15,327,'YB9[A-F],YB9Z[A-F],YC9[A-F],YC9Z[A-F],YD9[A-F],YD9Z[A-F],YE9[A-F],YE9Z[A-F],YF9[A-F],YF9Z[A-F],YG9[A-F],YG9Z[A-F],YH9[A-F],YH9Z[A-F]','Indonesia','Bali','OC','28','54',NULL,-8.0,-8.65,115.22,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',18,327,'YB9[Q-Y],YB9Z[Q-Z],YC9[Q-Y],YC9Z[Q-Z],YD9[Q-Y],YD9Z[Q-Z],YE9[Q-Y],YE9Z[Q-Z],YBF[Q-Y],YF9Z[Q-Z],YG9[Q-Y],YG9Z[Q-Z],YH9[Q-Y],YH9Z[Q-Z]','Indonesia','Papua','OC','28','51',NULL,-9.0,-3.75,137.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',71,54,'R?6R,U!6R,R6R,U6R,R?7R,U!7R,R7R','European Russia','Russian-occupied Sevastapol<Pri:SE>','EU','16','29',NULL,-3.0,44.6,33.52,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA','UA','UA',72,54,'R?6K,U!6K,R6K,R?97K,U!7K,R7K','European Russia','Russian-occupied Crimea <PRI:KR>','EU','16','29',NULL,-3.0,45.5,34.25,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','HL','CE9',34,13,'D8A','Antarctica','Jang Bogo Station (Korea)','AN','30','71','AN-016',-12.0,-74.62,164.2,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',3,327,'Y[B-H]1','Indonesia','Banten & West Java','OC','28',NULL,NULL,-7.0,-6.91,107.6,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',4,327,'Y[B-H]2','Indonesia','Central Java & Yogyakarta','OC','28',NULL,NULL,-7.0,-6.98,110.43,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',5,327,'Y[B-H]3','Indonesia','East Java','OC','28',NULL,NULL,-7.0,-7.98,112.62,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',7,327,'Y[B-H]5','Indonesia','West Sumatra & Riau','OC','28','54',NULL,-7.0,-0.95,100.4,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',8,327,'Y[B-H]6','Indonesia','North Sumatra & Aceh','OC','28','54',NULL,-7.0,3.28,98.0,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',16,327,'YB9[G-K],YB9Z[G-K],YC9[G-K],YC9Z[G-K],YD9[G-K],YD9Z[G-K],YE9[G-K],YE9Z[G-K],YF9[G-K],YF9Z[G-K],YG9[G-K],YG9Z[G-K],YH9[G-K],YH9Z[G-K]','Indonesia','West Nusatenggara','OC','28','54',NULL,-8.0,-8.67,117.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('YB','YB','YB',17,327,'YB9[L-P],YB9Z[L-P],YC9[L-P],YC9Z[L-P],YD9[L-P],YD9Z[L-P],YE9[L-P],YE9Z[L-P],YF9[L-P],YF9Z[L-P],YG9[L-P],YG9Z[L-P],YH9[L-P],YH9Z[L-P]','Indonesia','East Nusatenggara','OC','28','54',NULL,-8.0,-8.67,121.5,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('CE9','CE9','CE9',29,13,'RI1ANZ','Antarctica','Progress Station (Russia)','AN','39','69','AN-016',-6.0,-69.397,76.373,NULL,NULL);");
		$this->db->query("INSERT INTO `dxcc_master` (DXCCPrefix,DXCCSearch,DXCCMap,DXCCSort,CountryCode,PrefixList,DXCCName,Location,Continent,CQZone,ITUZone,IOTA,TimeZone,Latitude,Longitude,StartDate,EndDate) VALUES ('UA0','UA0','UA',1,15,'UA0','Asiatic Russia','Asiatic Russia','AS',NULL,NULL,NULL,NULL,64.0,130.0,NULL,NULL);");
	  }
	}

	public function down(){
         $this->db->query("");
	}
}
