<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_create_iota_tables extends CI_Migration {

	public function up()
	{
		// create iota table
		$this->db->query("CREATE TABLE `iota` (`Tag` VARCHAR(8) NOT NULL, `Name` LONGTEXT, `Prefix` VARCHAR(16), `DXCCID` INTEGER DEFAULT 0, `Lat1` FLOAT NULL DEFAULT 0, `Lat2` FLOAT NULL DEFAULT 0, `Lon1` FLOAT NULL DEFAULT 0, `Lon2` FLOAT NULL DEFAULT 0, `Status` VARCHAR(1), `Notes` VARCHAR(50), INDEX (`DXCCID`)) ENGINE=myisam DEFAULT CHARSET=utf8;");

		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-001', 'Agalega Islands', '3B6', 4, 10, 10.75, 56.25, 57, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-002', 'Amsterdam & St Paul Islands', 'FT*Z', 10, 37.75, 39, 77.25, 77.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-003', 'Ascension Island', 'ZD8', 205, 7.75, 8, -14.25, -14.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-004', 'Canary Islands', 'EA8', 29, -27.5, -29.5, -13.25, -18.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-005', 'Cape Verde - Leeward Islands', 'D4', 409, -14.5, -15.75, -22, -26, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-006', 'Diego Garcia Island', 'VQ9', 33, 7, 7.75, 72.25, 72.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-007', 'Comoro Islands', 'D6', 411, 11.25, 12.5, 43, 44.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-008', 'Crozet Islands', 'FT*W', 41, 45.75, 46.75, 50, 52.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-009', 'Europa Island', 'FT*E', 124, 22.25, 22.5, 40.25, 40.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-010', 'Bioco (Fernando Poo) Island', '3C', 49, -3, -4, 8.25, 9, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-011', 'Glorioso Islands', 'FT*G', 99, 11.25, 11.75, 47, 47.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-012', 'Juan De Nova Island', 'FT*J', 124, 16.83333, 17.16667, 42.5, 43, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-013', 'Madagascar (main island only)', '5R', 438, 11.75, 26, 43, 51, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-014', 'Madeira Archipelago', 'CT3', 256, -32.58333, -33.25, -16, -17.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-015', 'Saint Brandon Islands', '3B7', 4, 16, 17, 59, 60, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-016', 'Reunion Island', 'FR', 453, 20.75, 21.5, 55, 56, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-017', 'Rodrigues Island', '3B9', 207, 19.5, 20, 63.25, 63.58333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-018', 'Pantelleria Island', 'IH9', 248, -36.71667, -36.85, 11.9, 12.08333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-019', 'Pelagie Islands', 'IG9', 248, -35.41667, -35.91667, 12.25, 12.91667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-020', 'Bijagos Archipelago', 'J5', 109, -10.83333, -11.66667, -15.5, -16.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-021', 'Prince Edward & Marion Islands', 'ZS8', 201, 46.5, 47, 37.5, 38.08333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-022', 'St Helena Island', 'ZD7', 250, 15.83333, 16.08333, -5.583333, -5.833333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-023', 'Sao Tome Island', 'S9', 219, -.5, .5, 6.4, 6.85, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-024', 'Seychelles - Inner Islands', 'S7', 379, 3.5, 7.5, 55, 57, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-025', 'Aldabra Islands', 'S7', 379, 9.25, 10, 46, 47, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-026', 'Cosmoledo Islands', 'S7', 379, 9.5, 10.25, 47, 48, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-027', 'Mayotte Island', 'FH', 169, 12.5, 13.25, 44.75, 45.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-028', 'Socotra group', '7O', 492, -12, -13, 52, 54.58333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-029', 'Tristan Da Cunha Islands', 'ZD9', 274, 37, 37.58333, -12, -13, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-030', 'Gough Island', 'ZD9', 274, 40, 41, -9.75, -10.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-031', 'Tromelin Island', 'FR/T', 276, 15.66667, 16, 54.25, 54.58333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-032', 'Zanzibar Island', '5H', 470, 5.583333, 7.083333, 39.08333, 40, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-033', 'Amirante Islands', 'S7', 379, 4.5, 7.5, 52, 55, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-034', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'D', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-035', 'Farquhar Islands', 'S7', 379, 8.5, 10.5, 50.5, 52, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-036', 'Chafarinas Islands', 'EA9', 32, -35.13334, -35.21667, -2.333333, -2.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-037', 'Northern / Western Province group', '9L', 458, -8.083333, -9.05, -13, -13.41667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-038', 'Dahlak Archipelago', 'E3', 51, -15.28333, -16.91667, 39.25, 41, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-039', 'Annobon (Pagalu) Island', '3C0', 195, 1.366667, 1.45, 5.566667, 5.65, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-040', 'Coast Province North group', '5Z', 430, 1.716667, 3.066667, 40.13334, 41.58333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-041', 'Egmont group', 'VQ9', 33, 6, 6.75, 71.16666, 71.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-042', 'Alboran Island', 'EA9', 32, -35.91667, -35.96667, -3.016667, -3.116667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-043', 'Estuaire Province group', 'TR', 420, -1, .75, 9.16, 9.76, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-044', 'Principe Island', 'S9', 219, -1.416667, -1.833333, 7.25, 7.583333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-045', 'Senegal North group', '6W', 456, -13.58333, -16.05, -16.5, -17.58333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-046', 'Desertas Islands', 'CT3', 256, -32.33333, -32.58333, -16.33333, -16.58333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-047', 'Selvagens Islands', 'CT3', 256, -30, -30.25, -15.75, -16.16667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-048', 'Kerguelen Islands', 'FT*X', 131, 48.25, 50.25, 68.25, 71, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-049', 'Mauritius Island', '3B8', 165, 19.75, 20.58333, 57.25, 58, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-050', 'Dakhlet Nouadhibou / Inchiri Region group', '5T', 444, -19.06667, -21.13333, -16.21667, -17.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-051', 'Guinee-Maritime Province South group', '3X', 107, -9.05, -9.866667, -13.33333, -14, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-052', 'Indian Ocean Coast South group', 'T5', 232, .75, 1.7, 41.6, 43.6, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-053', 'Gulf Of Tadjoura group', 'J2', 382, -11.45, -12, 42.7, 43.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-054', 'Mafia Island', '5H', 470, 7.5, 8.166667, 39.58333, 40, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-055', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'D', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-056', 'Southern Province group', '9L', 458, -6.916667, -8.25, -11.5, -13.13333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-057', 'Madagascar\'s Coastal Islands West', '5R', 438, 11.75, 26, 43, 49.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-058', 'Salomon group', 'VQ9', 33, 5, 6, 71.58334, 72.58334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-059', 'Strait of Mandab group', 'J2', 382, -12, -12.71667, 43.13334, 43.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-060', 'The Gambia group', 'C5', 422, -13.06667, -13.58333, -16.53333, -17, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-061', 'Cabo Delgado District group', 'C9', 181, 10.5, 13.53333, 40.33333, 40.91667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-062', 'Suakin Archipelago', 'ST', 466, -18.25, -19.41667, 37.35, 39, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-063', 'Pemba Island', '5H', 470, 4.75, 5.583333, 39.58333, 40, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-064', 'Western Cape Province South West group', 'ZS', 462, 33, 34.91667, 17.86667, 20, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-065', 'Safi / Essaouira / Agadir Region group', 'CN', 446, -29.96667, -32.83333, -9, -10, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-066', 'Gaza / Maputo District group', 'C9', 181, 24.83333, 26.83333, 32.58333, 34.58333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-067', 'Coast Province South group', '5Z', 430, 3.066667, 4.733333, 39.2, 40.18333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-068', 'Western Sahara South group', 'CN,S0', 302, -20.88333, -25, -14.83333, -17.25, 'H', 'Herne & Virginia Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-069', 'Alhucemas Island', 'EA9', 32, -35.2, -35.23333, -3.883333, -3.916667, 'H', 'Perejil Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-070', 'Karas Region group', 'V5', 464, 24.93333, 28.66667, 14.71667, 16.41667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-071', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'D', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-072', 'Inhambane District group', 'C9', 181, 21, 24.83333, 34.58333, 35.66667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-073', 'Sfax Region group', '3V', 474, -34.08333, -35.03333, 10, 11.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-074', 'Lindi / Mtwara Region group', '5H', 470, 8.333333, 10.5, 39.25, 40.58333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-075', 'Dar Es Salaam / Pwani Region group', '5H', 470, 6, 8.333333, 38.78333, 39.58333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-076', 'Bayelsa / Rivers / Akwa Ibom etc States group', '5N', 450, -4.25, -5.133333, 5.45, 8.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-077', 'Western Cape Province South group', 'ZS', 462, 34, 34.91667, 20, 23.58333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-078', 'Senegal South group', '6W', 456, -12.33333, -13.06667, -16.66667, -16.86667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-079', 'Eastern Cape Province group', 'ZS', 462, 31.11667, 34.33333, 23.58333, 30.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-080', 'Red Sea Coast North group', 'E3', 51, -14.88333, -18, 38.58333, 40.66667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-081', 'Red Sea Coast South group', 'E3', 51, -12.71667, -14.88333, 40.66667, 43.13334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-082', 'Rio Muni Province group', '3C', 49, -.8666667, -2.333333, 9.166667, 9.833333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-083', 'Gabes / Medenine Region group', '3V', 474, -33.18333, -34.08333, 10, 11.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-084', 'Ghana group', '9G', 424, -4.666667, -6.083333, -3.083333, 1.2, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-085', 'Western Cape Province North West group', 'ZS', 462, 31.16667, 33, 17.78333, 18.33333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-086', 'Cape Verde - Windward Islands', 'D4', 409, -15.75, -17.5, -22, -26, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-087', 'Tanga Region group', '5H', 470, 4.683333, 6, 38.78333, 39.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-088', 'Nampula District group', 'C9', 181, 13.53333, 16.83333, 39.11666, 40.91667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-089', 'Ogooue-Maritime Province group', 'TR', 420, .25, 2.833333, 8.583333, 10.03333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-090', 'Madagascar\'s Coastal Islands East', '5R', 438, 11.75, 26, 45.16667, 51, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-091', 'Jendouba / Bizerte / Tunis / Nabeul Reg group', '3V', 474, -36.33333, -37.66667, 8.666667, 11.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-092', 'Sousse / Monastir / Mahdia Region group', '3V', 474, -35.03333, -36.33333, 10.5, 11.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-093', 'Guinea-Bissau Coastal Region group', 'J5', 109, -10.83333, -12.33333, -15, -16.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-094', 'Mediterranean Sea Coast West Group', '7X', 400, -35, -36.58333, -2.216667, 1.6, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-095', 'Cameroon Group', 'TJ', 406, -2.35, -4.75, 8.5, 10, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-096', 'Guinee-Maritime Province North Group', '3X', 107, -9.866667, -10.83333, -13.75, -15.08333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-001', 'Graham Land West (Adelaide Island) group', 'Various', 13, 66.58334, 68.5, -66, -70, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-002', 'Bouvet Island', '3Y', 24, 54.33333, 54.5, 3.283333, 3.466667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-003', 'Heard Island', 'VK0', 111, 52.75, 53.5, 73.16666, 73.91666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-004', 'Peter 1 Island', '3Y', 199, 68.75, 69.08334, -90.5, -91, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-005', 'Macquarie Island', 'VK0', 153, 54, 55.25, 158.5, 159.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-006', 'Graham Land West (Biscoe Islands) group', 'Various', 13, 65, 66.58334, -63.5, -67.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-007', 'South Georgia Island', 'VP8', 235, 53.83333, 55.25, -34.25, -39, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-008', 'South Orkney Islands', 'Various', 238, 60.25, 61, -44, -47.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-009', 'South Sandwich Islands', 'VP8', 240, 56, 60, -26, -28, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-010', 'South Shetland Islands', 'Various', 13, 60.75, 63.5, -53.75, -63, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-011', 'Ross Island group', 'Various', 13, 76, 78, 165, 170, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-012', 'Graham Land West (Palmer Archipelago) group', 'Various', 13, 63.5, 65, -59, -65, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-013', 'Trinity Peninsula group', 'Various', 13, 62.5, 64.5, -53.75, -59, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-014', 'Berkner Island', 'Various', 13, 77.5, 81.5, -43, -55, 'D', 'DELETED');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-015', 'Queen Maud Land (Prince Harald etc) group', 'Various', 13, 67.5, 70, 35, 45, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-016', 'Antarctica (main island only)', 'Various', 13, 70, 90, 180, -180, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-017', 'Adelie Land group', 'Various', 13, 66, 67, 136, 142, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-018', 'Palmer Land West (Alexander Island) group', 'Various', 13, 68.5, 73, -67.75, -77, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-001', 'Andaman Islands', 'VU', 11, -10.33333, -13.83333, 92, 94.33334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-002', 'Bahrain Island', 'A9', 304, -25.53333, -26.33333, 50.33333, 50.85, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-003', 'Sri Lanka Island (main island only)', '4S', 315, -5.833333, -10, 79.5, 82, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-004', 'Cyprus Island (main island only)', '5B,ZC', NULL, -34.5, -35.75, 32.23333, 34.66667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-005', 'Kara Sea Coast West group', 'R0B', 15, -71.68333, -74.75, 78.5, 82, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-006', 'Hong Kong group', 'VR2', 321, -22.11667, -22.56667, 113.8167, 114.4167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-007', 'Honshu Island (main island only)', 'JA1', 339, -33.4, -41.58333, 130.8333, 142.1333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-008', 'North Izu Islands', 'JA1', 339, -33.5, -34.86666, 139, 139.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-009', 'Red Sea Coast group', '7O', 492, -12.71667, -16.41667, 41.75, 43.41667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-010', 'Zufar Region group', 'A4', 370, -16.65, -17.93333, 53.1, 56.33333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-011', 'Laccadive Islands', 'VU', 142, -9.916667, -13.91667, 71.58334, 74, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-012', 'Kyushu\'s Coastal Islands', 'JA6', 339, -30.9, -34, 129.2167, 132.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-013', 'Maldive Islands', '8Q', 159, -7.25, .7, 72.5, 74, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-014', 'Ash Sharqiyah / Al Wusta Region group', 'A4', 370, -17.93333, -23, 56.33333, 59.91667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-015', 'Pinang State group', '9M2', 299, -5.116667, -5.583333, 100.1167, 100.4167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-016', 'Gulf Of Aden West group', '7O', 492, -12.58333, -13.55, 43.33333, 47, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-017', 'Okinawa Islands', 'JA6', 339, -26, -28, 126.5833, 128.3667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-018', 'Sakhalin Island (main island only)', 'R0F', 15, -45.83333, -54.58333, 141.5, 144.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-019', 'Singapore Island', '9V', 381, -1.133333, -1.483333, 103.6167, 104.0833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-020', 'Taiwan Island (main island only)', 'BV', 386, -21.83333, -25.35, 120, 122, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-021', 'Trucial Coast group', 'A6', 391, -23.96667, -26.08333, 51.5, 56.08333, 'H', 'Abu Dhabi Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-022', 'Medvezh\'I (Bear) Islands', 'R0Q', 15, -70.55, -71, 160.25, 162.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-023', 'Amami Islands', 'JA6', 339, -26.96667, -28.58333, 128.3667, 130.1, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-024', 'Yaeyama Islands', 'JA6', 339, -24, -24.66667, 122.8333, 124.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-025', 'Kuril\'skiye (Kuril) Islands South', 'R0F', 15, -43.58333, -46.7833, 145.3333, 151.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-026', 'Cheju-do Province (Cheju Island) group', 'HL4', 137, -33, -33.75, 126, 127, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-027', 'Vrangelya (Wrangel) Island', 'R0K', 15, -70.66666, -71.75, 178.25, -175.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-028', 'Anzhu Islands', 'R0Q', 15, -74.41666, -76.41666, 135.1667, 151.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-029', 'Lyakhovskiye Islands', 'R0Q', 15, -73.08334, -74.41666, 135.1667, 143.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-030', 'Kazan (Volcano) Islands', 'JD', 192, -24.13333, -25.58333, 141.1667, 141.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-031', 'Chichi/ Haha/ Muko (Bonin) Islands', 'JD', 192, -26.41667, -27.83333, 140.8333, 142.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-032', 'Osumi Islands', 'JA6', 339, -30.16667, -30.9, 129.8333, 131.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-033', 'Nicobar Islands', 'VU', 11, -6.583333, -9.333333, 92.5, 94, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-034', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'D', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-035', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'D', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-036', 'Iki / Tsushima Islands', 'JA6', 339, -33.66667, -34.75, 129.0833, 130.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-037', 'Koshikijima Islands', 'JA6', 339, -31.53333, -31.96667, 129.5833, 130.0333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-038', 'East Siberian Sea Coast group', 'R0K', 15, -68.76667, -70.16666, 162.5, 172.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-039', 'Komandorskiye (Commander) Islands', 'R0Z', 15, -54.25, -55.58333, 165.3333, 168.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-040', 'Goto Islands', 'JA6', 339, -32.5, -33.38334, 128.5, 129.2167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-041', 'Oki Islands', 'JA4', 339, -35.95, -36.38334, 132.8333, 133.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-042', 'Severnaya Zemlya (North Land)', 'R0B', 15, -77.83334, -81.5, 89.83334, 108, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-043', 'South Izu Islands', 'JA1', 339, -29.66667, -33.25, 139.5833, 140.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-044', 'Sea of Okhotsk Coast Centre group', 'R0C', 15, -53.55, -56, 135.2, 139, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-045', 'Kyongsang-bukto Prov (Ullung Island)', 'HL5', 137, -37.08333, -37.58333, 130.75, 131.95, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-046', 'Pahang / Johor State East group', '9M2', 299, -1.333333, -4.166667, 103.3333, 104.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-047', 'Daito Islands', 'JA6', 339, -24.41667, -26, 131.1167, 131.3667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-048', 'De Longa Islands', 'R0Q', 15, -75.66666, -77.08334, 148.1667, 158.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-049', 'Tokara Islands', 'JA6', 339, -28.71667, -30.03333, 128.8333, 130, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-050', 'Sergeya Kirova Islands', 'R0B', 15, -76.83334, -77.75, 88.25, 92.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-051', 'Spratly Islands', 'various', 247, -6, -12, 111, 117, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-052', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'D', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-053', 'Malay Peninsula West group', 'HS', 387, -7, -9.966666, 97.5, 99.66666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-054', 'Laptev Sea Coast West group', 'R0B', 15, -76.45, -77.83334, 100, 109, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-055', 'Vize Island', 'R0B', 15, -79.33334, -79.75, 75.5, 78, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-056', 'Danjo Islands', 'JA6', 339, -31.93333, -32.13334, 128.2667, 128.5333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-057', 'Uyedineniya Island', 'R0B', 15, -77.41666, -77.58334, 82, 83, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-058', 'Perlis / Kedah State group', '9M2', 299, -5.583333, -6.5, 99.16666, 100.35, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-059', 'Sea of Okhotsk Coast group', 'R0I', 15, -58.93333, -59.8, 146.9333, 154, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-060', 'Cholla-namdo Province group', 'HL4', 137, -33.91667, -35.43333, 125.4167, 128, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-061', 'Ratmanova (Big Diomede) Island', 'R0K', 15, -65.71667, -65.85, -169, -169.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-062', 'Habomai Islands', 'R0F', 15, -43.33333, -43.91667, 145.85, 147, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-063', 'Laptev Sea Coast East group', 'R0B', 15, -72.73333, -76.91666, 105.3333, 114, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-064', 'Bering Sea Coast Centre group', 'R0X', 15, -57.33333, -60.5833, 162, 170.3, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-065', 'Chukchi Sea Coast East group', 'R0K', 15, -66.08334, -68.13333, -169.5833, -177, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-066', 'Sea of Japan Coast group', 'R0L', 15, -42.25, -47.33333, 130.6667, 139, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-067', 'Uji & Kusagaki Islands', 'JA6', 339, -30.75, -31.33333, 129.3333, 129.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-068', 'Kara Sea Coast Centre group', 'R0B', 15, -73.61667, -75.83334, 82, 91, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-069', 'Iony Island', 'R0C', 15, -56.36666, -56.48333, 143.3167, 143.4667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-070', 'East Siberian Sea Coast East group', 'R0Q', 15, -69.33334, -71.16666, 152.5, 162.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-071', 'Bering Sea Coast North group', 'R0K', 15, -64.16666, -66.08334, -169.5833, -177, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-072', 'Perak State group', '9M2', 299, -3.833333, -5.116667, 100.3333, 100.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-073', 'Kelantan / Terengganu State group', '9M2', 299, -4.166667, -6.233333, 102.0833, 103.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-074', 'Selangor / Negeri Sembilan State group', '9M2', 299, -2.383333, -3.833333, 100.75, 101.9667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-075', 'Macau group', 'XX', 152, -22.06667, -22.26667, 113.5333, 113.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-076', 'Shikoku Island', 'JA5', 339, -32.66667, -34.58333, 132, 134.8667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-077', 'Kyushu Island (main island only)', 'JA6', 339, -30.95, -33.98333, 129.55, 132.1167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-078', 'Hokkaido Island (main island only)', 'JA8', 339, -41.33333, -45.58333, 139.75, 145.85, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-079', 'Miyako Islands', 'JA6', 339, -24.5, -25, 124.5, 125.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-080', 'Ch\'ungch\'ong-namdo Province group', 'HL3', 137, -35.98333, -37.08333, 125.5, 126.7833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-081', 'Kyongsang-bukto / Kyongsang-namdo Prov group', 'HL5', 137, -34.5, -37.15, 127.75, 129.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-082', 'Laptev Sea Coast Centre group', 'R0Q', 15, -70.71667, -74, 121.5, 132.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-083', 'Kara Sea Coast East group', 'R9K', 15, -70.91666, -73.66666, 69.5, 78.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-084', 'Cheju-do Province (Ch\'uja Islands) group', 'HL4', 137, -33.88334, -34.05, 126.25, 126.4167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-085', 'Cholla-namdo Province (Soan Islands) group', 'HL4', 137, -34.05, -34.25, 126.3667, 126.95, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-086', 'Izvestiy TS.I.K. Islands', 'R0B', 15, -75.66666, -76.08334, 81.25, 83.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-087', 'Arkticheskogo Instituta Islands', 'R0B', 15, -75, -75.66666, 81.25, 82.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-088', 'Qatar group', 'A7', 376, -24.63333, -26.2, 50.7, 52.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-089', 'Kara Sea Coast West group', 'R9K', 15, -68.2, -73, 65.1, 69.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-090', 'Kyonggi-do Province (Tokchok Islands)', 'HL2', 137, -36.9, -37.3, 125.75, 126.3667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-091', 'Sea of Okhotsk Coast group', 'R0X', 15, -55.81667, -62.68333, 155.5, 165.0833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-092', 'Bering Sea Coast South group', 'R0K', 15, -61.81667, -66.33334, 174.5, -177, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-093', 'Cholla-namdo Province (Huksan Islands) group', 'HL4', 137, -34, -34.83333, 125, 125.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-094', 'Hainan Province (Hainan Island) group', 'BY7', 318, -18, -20.2, 108.5, 111.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-095', 'Bering Sea Coast South group', 'R0Z', 15, -50.85, -57.33333, 156.6667, 163.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-096', 'Karnataka State group', 'VU', 324, -12.7, -14.91667, 74.01667, 74.88333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-097', 'Melaka / Johor State West group', '9M2', 299, -1.25, -2.383333, 101.9667, 103.6167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-098', 'Aydin / Mugla Province group', 'TA', 390, -36.28333, -37.88334, 27, 29.3, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-099', 'Canakkale / Balikesir / Izmir Province group', 'TA', 390, -37.88334, -40.01667, 25.91667, 27.25, 'H', 'Alibey, Gokceada Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-100', 'Israel group', '4X', 336, -31.58333, -33.08333, 34.48333, 35.11666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-101', 'Malay Peninsula East group', 'HS', 387, -9, -12, 99.13333, 100.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-102', 'Kinmen (Quemoy) Island', 'BV', 386, -24.35, -24.51667, 118.2, 118.6, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-103', 'P\'enghu (Pescadores) Islands', 'BV', 386, -23.13333, -23.8, 119.25, 119.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-104', 'Kara Sea Coast East group', 'R0B', 15, -75.63333, -76.5, 91, 100, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-105', 'Kyonggi-do Province group', 'HL2', 137, -37, -37.83333, 125.5833, 126.8, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-106', 'Minicoy Island', 'VU', 142, -8.183333, -8.366667, 72.95, 73.11667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-107', 'Gulf of Thailand North group', 'HS', 387, -12, -13.5, 99.95, 102, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-108', 'Lebanon group', 'OD', 354, -33.08333, -34.63334, 35.11666, 35.98333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-109', 'Obskaya Gulf group', 'R9K', 15, -66.23333, -70.91666, 69.13333, 78.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-110', 'Tungsha (Pratas) Island', 'BQ9', 505, -20.58333, -20.83333, 116.5833, 116.9167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-111', 'The Gulf group', 'HZ', 378, -24.23333, -28.56667, 48.36666, 51.58333, 'H', 'Tarut Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-112', 'Al Batinah / Masqat Region group', 'A4', 370, -23, -24.96667, 56.36666, 59.08333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-113', 'Matsu Islands', 'BV', 386, -25.93333, -26.41667, 119.9167, 120.6333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-114', 'Sea of Okhotsk Coast South group', 'R0C', 15, -47.33333, -54.75, 139, 141.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-115', 'Antalya Province group', 'TA', 390, -36.05, -36.85, 29.3, 32.58333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-116', 'Huang Yan Island (Scarborough Reef)', 'BS7', 506, -15.06667, -15.16667, 117.75, 117.9167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-117', 'JA3,4,9 Honshu\'s Coastal Islands West', 'JA3,4,9', 339, -33.4, -37.9, 130, 137.58, 'H', 'Omishima, Mukai, Hiko Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-118', 'Kuwait Group', '9K', 348, -28.56667, -30.01667, 47.8, 48.83333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-119', 'Musandam Region group', 'A4', 370, -25.61667, -26.53333, 56.08333, 56.66667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-120', 'Cyprus\'s Coastal Islands', '5B', 215, -34.5, -35.75, 32.23333, 34.66667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-121', 'Nordenshel\'da Archipelago', 'R0B', 15, -76.33334, -77.33334, 93.75, 98.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-122', 'Kyonggi-do Province West group', 'HL2', 137, -37.71667, -38, 124.5667, 124.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-123', 'Icel / Adana / Hatay Province group', 'TA', 390, -35.91667, -36.9, 32.58333, 36.21667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-124', 'Gulf of Oman group', 'A61', 391, -24.96667, -25.61667, 56.26667, 56.41667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-125', 'Gulf of Thailand North East group', 'HS', 387, -11.5, -12.5, 102, 102.9167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-126', 'Malay Peninsula South West group', 'HS', 387, -6.433333, -7, 99.08334, 100.1, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-127', 'Chittagong Region group', 'S2', 305, -20.51667, -22.66667, 91, 92.41666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-128', 'Gulf of Thailand group', '3W', 293, -8.25, -10.46667, 103.3333, 105.5333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-129', 'Guangdong Province East group', 'BY7', 318, -21.7, -23.7, 113.85, 117.1833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-130', 'South China Sea Coast South group', '3W', 293, -8.416667, -10.55, 105.5333, 107.6333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-131', 'Guangdong Province West group', 'BY7', 318, -20.2, -22.75, 109.5833, 113.85, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-132', 'Gulf of Tongking North group', '3W', 293, -19.96667, -21.5, 106, 108, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-133', 'Cambodia group', 'XU', 312, -9.866667, -11.58333, 102.8333, 104.45, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-134', 'Hebei / Tianjin Province group', 'BY3', 318, -38.26667, -39.98333, 117.55, 119.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-135', 'Jiangsu Province group', 'BY4', 318, -31.66667, -35.06667, 119.1833, 121.9333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-136', 'Shanghai Province group', 'BY4', 318, -30.71667, -31.86667, 121.3167, 121.9333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-137', 'Zhejiang Province North group', 'BY5', 318, -29, -30.91667, 120.3333, 123, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-138', 'Fujian Province group', 'BY5', 318, -23.5, -27.13333, 117.1833, 120.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-139', 'Guangxi Autonomous Region group', 'BY7', 318, -20.2, -21.66667, 108, 109.7667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-140', 'Khulna / Barisal Region group', 'S2', 305, -21.58333, -22.83333, 89.11667, 91, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-141', 'Zhejiang Province South group', 'BY5', 318, -27.13333, -29, 120.45, 122.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-142', 'Sea of Okhotsk Coast group', 'R0Z', 15, -50.85, -55.81667, 155.4167, 156.7667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-143', 'Hainan Province (Xisha Islands) group', 'BY7', 318, -15, -17.5, 111, 113, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-144', 'Tenasserim Region South group', 'XZ', 309, -9.5, -13.25, 97.33334, 98.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-145', 'Malay Peninsula South East group', 'HS', 387, -6.233333, -9, 99.95, 102.0833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-146', 'Shandong Province North East group', 'BY4', 318, -37, -38.45, 120, 122.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-147', 'Hokkaido\'s Coastal Islands', 'JA8', 339, -41.3, -45.58333, 139.3333, 145.85, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-148', 'Cholla-bukto Province group', 'HL4', 137, -35.43333, -36.16667, 125.9167, 126.6833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-149', 'Sakhalin\'s Coastal Islands', 'R0F', 15, -45.66667, -54.66667, 141, 145, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-150', 'Shandong Province South group', 'BY4', 318, -35.06667, -37, 119.3, 122.6, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-151', 'Liaoning Province West group', 'BY2', 318, -38.66667, -40.91667, 119.8333, 122.2667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-152', 'Laptev Sea Coast West group', 'R0Q', 15, -72.93333, -75, 111, 121.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-153', 'West Bengal State group', 'VU', 324, -21.5, -22.08333, 87.5, 89.11667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-154', 'Black Sea Coast East group', 'TA', 390, -40.91667, -42.13334, 35, 41.53333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-155', 'Taiwan\'s Coastal Islands', 'BV', 386, -21.58333, -25.91667, 119.9167, 122.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-156', 'Ushakova Island', 'R0B', 15, -80.75, -81.08334, 78.5, 81, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-157', 'South China Sea Coast Centre group', '3W', 293, -9.916667, -12.81667, 107.6333, 109.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-158', 'Liaoning Province East group', 'BY2', 318, -38.66667, -39.83333, 121.1667, 124.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-159', 'Black Sea Coast West group', 'TA', 390, -41.08333, -42.13334, 29.11667, 35, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-160', 'Shandong Province North West group', 'BY4', 318, -37.15, -38.3, 117.8333, 120, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-161', 'Kerala State group', 'VU', 324, -8.3, -12.7, 74.88333, 77.11667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-162', 'South China Sea Coast North group', '3W', 293, -12.81667, -16.18333, 108.1667, 109.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-163', 'Laptev Sea Coast East group', 'R0Q', 15, -71.21667, -72.91666, 132.5, 142.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-164', 'East Siberian Sea Coast West group', 'R0Q', 15, -70.83334, -72.75, 142.5, 152.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-165', 'Arakan Region group', 'XZ', 309, -17.46667, -20.63333, 92.41666, 94.53333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-166', 'Hormozgan Province group', 'EP', 330, -25.43333, -27.31667, 52.73333, 59.2, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-167', 'Irrawaddy / Yangon / Pegu Region group', 'XZ', 309, -15.61667, -17.46667, 94.08334, 96.9, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-168', 'Kangwon-do Province Group', 'HL2', 137, -37.15, -38.6, 128.3667, 129.3667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-169', 'Maharashtra State Group', 'VU', 324, -15.76667, -20.11667, 72.58334, 73.66666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-170', 'Shelikhova Bay Group', 'R0I', 15, -59.03333, -61.93333, 154, 162.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-001', 'Dodecanese (Dodekanisos)', 'SV5', 45, -35.28333, -37.5, 26.1, 29.6, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-002', 'Aland Islands', 'OH0', 5, -59.75, -60.53333, 19.41667, 21.33333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-003', 'Eastern group', 'CU1,2', 149, -36.83333, -38, -24.5, -26.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-004', 'Balearic Islands', 'EA6', 21, -38.5, -40.16667, 1, 4.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-005', 'Great Britain (main island only)', 'Various', NULL, -49.83333, -58.66667, -6.25, 1.9, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-006', 'Aran Islands', 'EI', 245, -53.03333, -53.18333, -9.466666, -9.916667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-007', 'Blasket Islands', 'EI', 245, -52.01667, -52.15, -10.46667, -10.68333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-008', 'Inner Hebrides', 'GM,MM', 279, -55.55, -57.78333, -5.416667, -7, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-009', 'Orkney', 'GM,MM', 279, -58.66, -59.48, -2.25, -4.6, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-010', 'Outer Hebrides', 'GM,MM', 279, -56.75, -59.16667, -5.733333, -7.733333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-011', 'Isles of Scilly', 'G,M', 223, -49.83333, -50.06667, -6.083333, -6.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-012', 'Shetland & Fair Isle', 'GM,MM', 279, -59.46667, -61, -.5, -2.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-013', 'Jersey', 'GJ,MJ', 122, -49.13334, -49.33333, -1.833333, -2.333333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-014', 'Corsica (Corse) Island (main island only)', 'TK', 214, -41.31667, -43.05, 8.416667, 9.666667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-015', 'Crete (Kriti) Island (main island only)', 'SV9', 40, -34.88334, -35.71667, 23.46667, 26.36667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-016', 'Dalmatia South group', '9A', 497, -42.38334, -43.58333, 15.41667, 18.55, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-017', 'Eolie (Lipari) Islands', 'I*9', 248, -38.33333, -38.86666, 14.25, 15.33333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-018', 'Faroe Islands', 'OY', 222, -61.33333, -62.5, -6, -8, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-019', 'Franz Josef Land', 'R1F', 61, -79.66666, -81.91666, 36.5, 65.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-020', 'Gotland County (Gotland Island) group', 'SM1', 284, -56.83333, -58.5, 17.83333, 19.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-021', 'Iceland (main island only)', 'TF', 242, -63.25, -66.66666, -13.33333, -24.66667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-022', 'Jan Mayen Island', 'JX', 118, -70.75, -71.25, -7.75, -9.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-023', 'Malta group', '9H', 257, -35.75, -36.16667, 14.16667, 14.66667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-024', 'Sardinia (Sardegna) (main island only)', 'I*0', 225, -38.83333, -41.26667, 8.083333, 9.883333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-025', 'Sicily (Sicilia) (main island only)', 'I*9', 248, -36.61666, -38.33333, 12.41667, 15.65, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-026', 'Spitsbergen Island (main island only)', 'JW', 259, -76.5, -80.08334, 10.5, 21.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-027', 'Bear Island (Bjornoya)', 'JW', 259, -74.25, -74.58334, 18.75, 19.41667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-028', 'Toscana (Tuscany) Region group', 'I*5', 248, -42.2, -44.01667, 9.75, 11.45, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-029', 'Sjaelland Archipelago', 'OZ', 221, -54.55, -56.25, 10.86667, 12.83333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-030', 'Bornholm Island', 'OZ', 221, -54.91667, -55.36666, 14.58333, 15.33333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-031', 'Campania Region group', 'I*8', 248, -39.98333, -41.21667, 13.76667, 15.65, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-032', 'Poitou-Charentes Region group', 'F', 227, -45.61666, -46.26667, -1.083333, -1.666667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-033', 'Vesteralen Islands', 'LA', 266, -68.25, -69.41666, 14.16667, 16.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-034', 'Hiiumaa / Saaremaa / Laanemaa County group', 'ES0,3', 52, -57.86666, -59.33333, 21.66667, 23.61667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-035', 'Novaya Zemlya', 'R1O', 54, -70.46667, -77.16666, 51.25, 69.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-036', 'Sor-Trondelag / More Og Romsdal Cty Nth group', 'LA', 266, -62.91667, -64.43333, 6.833333, 10.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-037', 'Kalmar County group', 'SM7', 284, -56.16667, -58, 16.06667, 17.21667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-038', 'Noord Holland / Friesland / Groningen Prov group', 'PA', 263, -52.33333, -53.56667, 4.5, 7, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-039', 'Chausey Islands', 'F', 227, -48.85, -48.91667, -1.7, -1.883333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-040', 'Estremadura Province group', 'CT', 272, -38.38334, -39.86666, -8.916667, -9.583333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-041', 'Maddalena Archipelago', 'I*0', 248, -41.15, -41.31667, 9.3, 9.533334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-042', 'Schleswig-Holstein State North West group', 'DL', 230, -54.33333, -55.06667, 8.25, 9, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-043', 'Goteborg Och Bohus / Halland County group', 'SM6', 284, -56.45, -59.08333, 10.91667, 12.93333, 'H', 'Skafto/Brato/Salto/Smogen/Tryggo/Valon  Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-044', 'Finnmark County West group', 'LA', 266, -69.98333, -71.25, 21, 26.66667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-045', 'Lazio Region group', 'I*0', 248, -40.75, -42.36666, 11.45, 13.76667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-046', 'Troms County group', 'LA', 266, -68.66666, -70.38333, 16.75, 21.88333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-047', 'Niedersachsen State group', 'DL', 230, -53.33333, -53.9, 6.633333, 9, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-048', 'Bretagne (Morbihan) Region group', 'F', 227, -47.25, -47.75, -2.483333, -3.533333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-049', 'North Aegean Islands', 'SV', 236, -37.5, -40.06667, 24.91667, 27.13333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-050', 'Puglia (Foggia) Region group', 'I*7', 248, -41.36666, -42.25, 15.13333, 16.21667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-051', 'Ustica Island', 'I*9', 248, -38.66667, -38.75, 13.11667, 13.26667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-052', 'Ipeiros / Dytiki Ellas Region group', 'SV', 236, -37.2, -39.95, 19.33333, 21.75, 'H', 'Lefkada, Petalas Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-053', 'Market Reef', 'OJ0,SM', NULL, -60.28333, -60.31667, 19.11667, 19.15, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-054', 'Egadi Islands', 'I*9', 248, -37.9, -38.06667, 12, 12.43333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-055', 'Sogn og Fjordane etc County group', 'LA', 266, -58.26667, -62.23333, 4.416667, 6.383333, 'H', 'Karmoy/Eigeroya/Osteroy/Radoy/Tysnesoy Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-056', 'More Og Romsdal County Centre group', 'LA', 266, -62.38334, -62.91667, 5.833333, 7.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-057', 'Mecklenburg-Vorpommern State group', 'DL', 230, -53.93333, -54.71667, 10.91667, 13.95, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-058', 'Provence-Cote D\'Azur (Alpes-Marit) Reg group', 'F', 227, -43.48333, -43.78333, 6.933333, 7.533333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-059', 'St Kilda', 'GM,MM', 279, -57.76667, -57.9, -8.45, -8.683333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-060', 'Sterea Ellas Region group', 'SV', 236, -37.91667, -39.06667, 22.7, 24.68333, 'H', 'Evvoia Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-061', 'Vest Agder To Ostfold County group', 'LA', 266, -57.93333, -59.41667, 6.383333, 11.2, 'H', 'Hisoy, Notteroy, Skjernoyto Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-062', 'Nordland / Nord-Trondelag County group', 'LA', 266, -64.43333, -68.36667, 10.41667, 16.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-063', 'Spitsbergen\'s Coastal Islands', 'JW', 259, -76, -81, 10, 34, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-064', 'Pays De La Loire Region group', 'F', 227, -46.26667, -47.45, -1.083333, -2.666667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-065', 'Bretagne (Finistere North West) Region group', 'F', 227, -48.1, -48.5, -4.283333, -5.166667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-066', 'Solovetskiye Islands', 'R1O', 54, -64.93333, -65.21667, 35.43333, 36.33333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-067', 'Kyklades (Cyclades)', 'SV', 236, -36.16667, -38.01667, 24.08333, 26.1, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-068', 'Bretagne (Finistere South West) Region group', 'F', 227, -47.8, -48.1, -4.366667, -4.916667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-069', 'Columbretes Islands', 'EA5', 281, -39.78333, -39.95, .5, .75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-070', 'Provence-Cote D\'Azur (Var) Region group', 'F', 227, -42.96667, -43.48333, 5.666667, 6.933333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-071', 'Vestmannaeyjar (Westman Islands)', 'TF7', 242, -63.25, -63.53333, -20.1, -20.7, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-072', 'Thessalia Region group', 'SV', 236, -39, -39.98333, 22.65, 24.35, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-073', 'Puglia (Taranto) Region group', 'I*7', 248, -40.28333, -40.51667, 16.85, 17.78333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-074', 'Bretagne (Cotes-D\'Armor Centre) Region group', 'F', 227, -48.53333, -49.16667, -2.5, -3.166667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-075', 'Peloponnisos (Argolis) / Attiki Region group', 'SV', 236, -37.06667, -38.33333, 22.71667, 24.08333, 'H', 'Poros Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-076', 'Lofoten Islands', 'LA', 266, -67.36667, -68.48333, 11.75, 15.18333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-077', 'La Coruna / Lugo Province group', 'EA1', 281, -42.41667, -43.83333, -7.05, -9.416667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-078', 'Gerona Province group', 'EA3', 281, -41.66667, -42.43333, 2.783333, 3.416667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-079', 'More Og Romsdal County South group', 'LA', 266, -62.15, -62.43333, 5.25, 6.166667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-080', 'Pontevedra Province group', 'EA1', 281, -41.86666, -42.58333, -8.8, -8.966666, 'H', 'La Toja/Lobeira/San Simon/Tambo/Toralla Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-081', 'Basse-Normandie (Manche East) Region group', 'F', 227, -49.36666, -49.83333, -1.1, -1.966667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-082', 'Barents Sea Coast West group', 'R1Z', 54, -68.88333, -69.96667, 30.81667, 37, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-083', 'Liguria Region group', 'I*1', 248, -43.75, -44.41667, 7.533333, 10.01667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-084', 'Uppsala / Stockholm County group', 'SM5,0', 284, -58.66667, -60.66667, 17.36667, 19.5, 'H', 'See WWW.RSGBIOTA.COM for ineligible islands');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-085', 'Kolguev Island', 'R1P', 54, -68.58334, -69.58334, 48, 50.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-086', 'Pechorskoye Sea Coast East group', 'R1P', 54, -68.33334, -70.46667, 58, 65.1, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-087', 'Vasternorrland County group', 'SM3', 284, -62.13334, -63.46667, 17.5, 19.28333, 'H', 'See WWW.RSGBIOTA.COM for ineligible islands');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-088', 'Kattegat group', 'OZ', 221, -56.58333, -57.41667, 10.75, 11.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-089', 'Western group', 'CU8,9', 149, -39.25, -39.83333, -31, -31.33333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-090', 'Palagruza Island', '9A', 497, -42.33333, -42.41667, 16.21667, 16.36667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-091', 'Puglia (Lecce / Brindisi / Bari) Region group', 'I*7', 248, -39.75, -41.36666, 16.21667, 18.58333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-092', 'Summer Isles', 'GM,MM', 279, -57.93333, -58.05, -5.333333, -5.55, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-093', 'Alicante / Murcia Province group', 'EA5', 281, -37.38334, -38.88334, -1.633333, .33, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-094', 'Bretagne (Finistere South) Region group', 'F', 227, -47.68333, -47.86666, -3.533333, -4.383333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-095', 'Provence-Cote D\'Azur (Bouches-Du-Rhone) group', 'F', 227, -43.15, -43.46667, 4.233333, 5.666667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-096', 'Lansi-Suomi (Turku) Province group', 'OH1', 224, -59.58333, -61.06667, 21, 22.8, 'H', 'Kimito Kemio, Rymattyla Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-097', 'Etela-Suomi (Uusimaa) Province group', 'OH2', 224, -59.58333, -60.41667, 22.8, 26.58333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-098', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'D', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-099', 'Les Minquiers Islands', 'GJ,MJ', 122, -48.93333, -49.03333, -2.033333, -2.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-100', 'Cerbicales Islands', 'TK', 214, -41.53333, -41.58333, 9.35, 9.4, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-101', 'Lansi-Suomi (Vaasa) Province group', 'OH6', 224, -61.95, -64.16666, 20.58333, 23.71667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-102', 'Pechorskoye Sea Coast Centre group', 'R1P', 54, -68.2, -69, 52, 58, 'H', 'Pesyakov Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-103', 'Saltee Islands', 'EI', 245, -52.08333, -52.15, -6.566667, -6.65, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-104', 'Sanguinaires Islands', 'TK', 214, -41.86666, -41.9, 8.566667, 8.616667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-105', 'Bretagne (Finistere North) Region group', 'F', 227, -48.5, -48.75, -3.65, -4.833333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-106', 'St Tudwal\'s Islands', 'GW,MW', 294, -52.78333, -52.83333, -4.45, -4.483333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-107', 'Bretagne (Cotes-D\'Armor West) Region group', 'F', 227, -48.66667, -48.91667, -3.166667, -3.65, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-108', 'Treshnish Isles', 'GM,MM', 279, -56.43333, -56.51667, -6.366667, -6.516667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-109', 'Farne Islands', 'G,M', 223, -55.6, -55.66667, -1.55, -1.683333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-110', 'Istra group', '9A', 497, -44.75, -45.51667, 13.48333, 14.33333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-111', 'Monach Islands', 'GM,MM', 279, -57.5, -57.55, -7.566667, -7.733333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-112', 'Shiant Islands', 'GM,MM', 279, -57.86666, -57.91667, -6.3, -6.45, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-113', 'Peloponnisos (Lakonia) / Kythira Region group', 'SV', 236, -35.8, -37.06667, 22.33333, 23.91667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-114', 'Guernsey group', 'GU,MU', 106, -49.33333, -49.83333, -2.083333, -2.833333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-115', 'Ireland', 'EI,GI,MI', NULL, -51.33333, -55.5, -5.4, -10.68333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-116', 'Isle of Man', 'GD,MD', 114, -54, -54.5, -4.166667, -4.916667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-117', 'Malyy Vysotskiy Island', 'R1M,OH', NULL, -60.61666, -60.65, 28.55, 28.58333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-118', 'Flannan Isles', 'GM,MM', 279, -58.25, -58.31667, -7.55, -7.7, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-119', 'White Sea Coast East group', 'R1O', 54, -65.95, -66.83334, 40.66667, 44.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-120', 'English Coastal Islands', 'G,M', 223, -49.83333, -55.8, -5.833333, 1.9, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-121', 'Irish Coastal Islands', 'EI', 245, -51.33333, -55.5, -5.966667, -10.68333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-122', 'Northern Irish Coastal Islands', 'GI,MI', 265, -54.01667, -55.33333, -5.4, -6.933333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-123', 'Scottish Coastal Islands', 'GM,MM', 279, -54.61666, -58.7, -1.666667, -6.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-124', 'Welsh Coastal Islands', 'GW,MW', 294, -51.36666, -53.46667, -2.666667, -5.8, 'H', 'Isle of Anglesey Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-125', 'Jylland West group', 'OZ', 221, -54.91667, -56.71667, 8, 8.666667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-126', 'Lappi Province group', 'OH9', 224, -65.58334, -65.83334, 24.13333, 25.08333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-127', 'Schleswig-Holstein State South West group', 'DL', 230, -53.9, -54.33333, 7.833333, 9, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-128', 'Schleswig-Holstein State East group', 'DL', 230, -53.98333, -54.88334, 9.583333, 11.35, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-129', 'Usedom (Uznam) Island', 'DL,SP1', NULL, -53.83333, -54.2, 13.75, 14.33333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-130', 'Friuli-Venezia Giulia Region group', 'I*3', 248, -45.6, -45.78333, 13.1, 13.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-131', 'Veneto Region group', 'I*3', 248, -44.78333, -45.65, 12.11667, 13.1, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-132', 'Szczecin / Koszalin Province group', 'SP1', 269, -53.8, -54.5, 14.26667, 16.48333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-133', 'Gulf of Finland group', 'R1A-C', 54, -59.46667, -60.61666, 26.61667, 30.23333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-134', 'Bilbao / San Sebastian (Basque) Prov group', 'EA2', 281, -43.3, -43.5, -1.8, -3.15, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-135', 'Vasterbotten County group', 'SM2', 284, -63.4, -65.06667, 19.25, 21.66667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-136', 'Kvarner group', '9A', 497, -44.4, -45.35, 14.16667, 15.43333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-137', 'Skane County group', 'SM7', 284, -55.28333, -56.5, 12.41667, 14.55, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-138', 'Blekinge County group', 'SM7', 284, -55.91667, -56.33333, 14.55, 16.08333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-139', 'Norrbotten County group', 'SM2', 284, -65.06667, -65.83334, 21.53333, 24.16667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-140', 'Etela-Suomi (Kymi) Province group', 'OH5', 224, -60.25, -60.53333, 26.58333, 27.83333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-141', 'Finnmark County East group', 'LA', 266, -69.75, -71.25, 26.66667, 31.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-142', 'Oviedo / Santander Province group', 'EA1', 281, -43.4, -43.66667, -3.15, -7.05, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-143', 'Cadiz / Huelva Province group', 'EA7', 281, -36, -37.2, -5.25, -7.4, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-144', 'Calabria / Basilicata Region group', 'I*8', 248, -37.9, -40.38334, 15.63333, 17.21667, 'H', 'Dino Isl ineligble after 1/1/15');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-145', 'Algarve Province group', 'CT', 272, -36.93333, -37.45, -7.4, -9.033334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-146', 'Zuid Holland / Zeeland Province group', 'PA', 263, -51.36666, -52.33333, 3.366667, 4.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-147', 'White Sea Coast group', 'R1N', 54, -63.95, -66.58334, 33.08333, 36.83333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-148', 'Languedoc-Roussillon Region group', 'F', 227, -42.43333, -43.55, 3.033333, 4.233333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-149', 'Tallinn & Harjumaa / Virumaa County group', 'ES1,2,4', 52, -59.23333, -59.83333, 23.71667, 28.05, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-150', 'Minho / Douro Lit / Beira Litoral Province group', 'CT', 272, -39.86666, -41.86666, -8.666667, -9, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-151', 'Castellon / Valencia Province group', 'EA5', 281, -38.88334, -40.53333, -.3333333, .5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-152', 'Almeria / Granada / Malaga Province group', 'EA7', 281, -36.33333, -37.38334, -1.633333, -5.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-153', 'White Sea Coast West group', 'R1O', 54, -63.78333, -65.95, 36.38334, 40.66667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-154', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'D', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-155', 'Emilia Romagna Region group', 'I*4', 248, -43.96667, -44.83333, 12.25, 12.75, 'D', 'DELETED');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-156', 'Basse-Normandie (Manche West) Reg group', 'F', 227, -48.61666, -49.83333, -1.466667, -1.966667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-157', 'Bretagne (Cotes-D\'Armor East etc) Reg group', 'F', 227, -48.61666, -48.73333, -1.566667, -2.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-158', 'Peloponnisos (Messinia) Region group', 'SV', 236, -36.63334, -37.38334, 21.5, 22.33333, 'H', 'Skaktiria, Chelonaki Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-159', 'Aquitaine Region group', 'F', 227, -43.36666, -45.61666, -1.083333, -1.8, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-160', 'Barents Sea Coast group', 'R1P', 54, -66.43333, -68.7, 43.16667, 48, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-161', 'Barents Sea Coast East group', 'R1Z', 54, -66.38333, -68.88333, 37, 41.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-162', 'White Sea Coast group', 'R1Z', 54, -66.03333, -67.16666, 32.25, 40.3, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-163', 'Montenegro group', '4O,YU', 296, -41.83333, -42.38334, 18.55, 19.38333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-164', 'Corsica\'s Coastal Islands', 'TK', 214, -41.31667, -43.05, 8.416667, 9.666667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-165', 'Sardinia\'s Coastal Islands', 'I*0', 225, -38.83333, -41.26667, 8.083333, 9.883333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-166', 'Sicily\'s Coastal Islands', 'I*9', 248, -36.61666, -38.33333, 12.41667, 15.65, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-167', 'Baixo Alentejo Province group', 'CT', 272, -37.45, -38.5, -8.783334, -8.916667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-168', 'Iceland\'s Coastal Islands', 'TF', 242, -63.25, -66.66666, -13.33333, -24.66667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-169', 'Albania group', 'ZA', 7, -39.68333, -41.85, 19.21667, 20.01667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-170', 'Dalmatia North group', '9A', 497, -43.58333, -44.73333, 14.55, 15.93333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-171', 'Jylland North group', 'OZ', 221, -56.71667, -57.83333, 8.166667, 10.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-172', 'Jylland East and Fyn group', 'OZ', 221, -54.66667, -56.71667, 9.5, 11, 'H', 'Als, Alro Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-173', 'Lansi-suomi (Pori) Province group', 'OH1', 224, -61.06667, -61.95, 21, 21.66667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-174', 'Makedonia / Thraki Region group', 'SV', 236, -39.88334, -41, 22.55, 26.03333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-175', 'Central group', 'CU3-7', 149, -38, -39.25, -26.5, -29, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-176', 'Gavleborg County group', 'SM3', 284, -60.65, -62.13334, 17.16667, 17.58333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-177', 'Sodermanland / Ostergotland County group', 'SM5', 284, -58, -58.91667, 16.75, 17.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-178', 'Parnumaa County / Saaremaa County South group', 'ES0,8', 52, -57.7, -58.53333, 23.08333, 24.58333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-179', 'Mykolayiv / Kherson Obl Black Sea Coast group', 'UR', 288, -46, -46.63334, 31.18333, 33.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-180', 'Respublika Krym Black Sea Coast group', 'UR', 288, -44.38334, -46.06667, 32.45, 36.6, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-181', 'Bulgaria group', 'LZ', 212, -41.98333, -43.73333, 27.45, 28.63333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-182', 'Odes\'ka Obl Black Sea Coast group', 'UR', 288, -45.21667, -46.63334, 29.63333, 31.18333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-183', 'Romania group', 'YO', 275, -43.73333, -45.21667, 28.56667, 29.7, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-184', 'Oulu Province group', 'OH8', 224, -64.16666, -65.58334, 23.58333, 25.43333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-185', 'Krasnodarskiy Kray Black Sea Coast group', 'R6A-D', 54, -43.38334, -45.36666, 36.6, 40, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-186', 'Turkey group', 'TA', 390, -40.03333, -40.71667, 25.61667, 26.83333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-187', 'Crete\'s Coastal Islands', 'SV9', 40, -34.75, -35.71667, 23.41667, 26.41667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-188', 'Pechorskoye Sea Coast West group', 'R1P', 54, -67.6, -68.55, 48, 52, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-001', 'Great Bahama Bank group', 'C6', 60, -21.58333, -25.7, -74.25, -78.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-002', 'Caicos Islands', 'VP5', 89, -21.08333, -22.08333, -71.33334, -72.58334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-003', 'Turks Islands', 'VP5', 89, -21.08333, -21.66667, -71, -71.33334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-004', 'North Slope County Centre group', 'KL', 6, -70.21667, -71, -147.6667, -154, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-005', 'Bermuda Islands', 'VP9', 64, -32.16667, -32.5, -64.5, -65, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-006', 'Nunavut (Victoria Island) group', 'VE8,VY0', 1, -68.33334, -74, -100.75, -119.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-007', 'Nunavut (Southampton Island) group', 'VY0', 1, -62, -66.55, -80, -88.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-008', 'Nunavut (Ellesmere Island) group', 'VY0', 1, -76.16666, -83.33334, -60.5, -92.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-009', 'Nunavut (Devon Island) group, Canada', 'VY0', 1, -74.4, -77.85, -79, -106.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-010', 'NS Province (Cape Breton Island) group', 'VE1', 1, -45.41667, -47.13334, -59.63334, -61.63334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-011', 'Clipperton Island', 'FO', 36, -10.21667, -10.38333, -109.1333, -109.3, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-012', 'Coco\'s Island', 'TI9', 37, -5.466667, -5.633333, -86.96667, -87.13333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-013', 'Caribbean Sea Coast Centre group', 'YN', 86, -12, -13.5, -82.75, -83.66666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-014', 'NB Province South group', 'VE9', 1, -44.45, -45.8, -64.5, -67.06667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-015', 'Cuba (main island only)', 'CO,KG4', NULL, -19.8, -23.25, -74.11667, -85, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-016', 'Cayman Islands', 'ZF', 69, -19, -20, -79.58334, -81.58334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-017', 'Baja California State South West group', 'XE2', 50, -28, -30, -114.1, -116, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-018', 'Greenland (main island only)', 'OX', 237, -59.75, -84, -11.5, -74, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-019', 'Kodiak group', 'KL', 6, -56.66667, -58.75, -151.5, -155, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-020', 'Aves Island', 'YV0', 17, -15.63333, -15.8, -63.56667, -63.71667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-021', 'Barbados', '8P', 62, -12.83333, -13.41667, -59.33333, -59.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-022', 'Anguilla', 'VP2E', 12, -18.15, -18.66667, -62.88334, -63.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-023', 'British Virgin Islands', 'VP2V', 65, -18.25, -18.83333, -64.16666, -64.91666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-024', 'Grenada', 'J3', 77, -11.95, -12.26667, -61.5, -61.91667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-025', 'The Grenadines', 'J8', 98, -12.53333, -13.06667, -61.06667, -61.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-026', 'NY State group', 'W2', 291, -40.48333, -41.3, -71.83334, -74.26667, 'H', 'Staten, Manhattan Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-027', 'Newfoundland Island (main island only)', 'VO1', 1, -46.58333, -51.66667, -52.58333, -59.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-028', 'Pribilof Islands', 'KL', 6, -56.41667, -57.41667, -169.3333, -170.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-029', 'Prince Edward Island', 'VY2', 1, -45.91667, -47.16667, -61.95, -64.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-030', 'Revillagigedo Islands', 'XE4', 204, -18.58333, -19.5, -110.6667, -112.4167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-031', 'RI State group', 'W1', 291, -41.13334, -41.68333, -71.11667, -71.9, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-032', 'St Pierre & Miquelon', 'FP', 277, -46.66667, -47.25, -56.1, -56.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-033', 'San Andres Island', 'HK0', 216, -12, -12.66667, -81.25, -82, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-034', 'FL State Centre West group', 'W4', 291, -26.95, -28.46667, -82.5, -82.91666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-035', 'Santanilla (Swan) Islands', 'HR', 80, -17.33333, -17.5, -83.75, -84, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-036', 'BC Province (Vancouver Island) group', 'VE7', 1, -48.25, -51, -123.2, -129.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-037', 'Near Islands (Semichi Islands) group', 'KL', 6, -52.58333, -52.83333, 173.8167, 174.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-038', 'QC Province (La Madeleine Islands) group', 'VE2', 1, -47, -48, -61.08333, -62.33333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-039', 'Andreanof Islands', 'KL', 6, -51.55, -52.5, -172.1667, -178.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-040', 'St Lawrence Island', 'KL', 6, -62.83333, -63.83333, -168.5, -172, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-041', 'Alexander Archipelago', 'KL', 6, -54.66667, -58.58333, -131, -136.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-042', 'Valdez Cordova County West group', 'KL', 6, -59.33333, -61, -145.6333, -148.55, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-043', 'Nunavut (Sverdrup Islands) group', 'VY0', 1, -77.5, -81.58334, -85, -106.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-044', 'NFLD Province (Labrador) South group', 'VO2', 1, -51.36666, -54.4, -55.16667, -58.21667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-045', 'Quintana Roo State North group', 'XE3', 50, -20.83333, -21.83333, -86.5, -87.53333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-046', 'MA State South group', 'W1', 291, -41.21667, -41.73333, -69.9, -71.11667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-047', 'Nunavut (Baffin Island) group (Main Island)', 'VY0', 1, -61.75, -73.91666, -61, -90.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-048', 'Bimini Islands', 'C6', 60, -24.66667, -26.16667, -78.75, -79.41666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-049', 'Providencia Island', 'HK0', 216, -13.25, -13.45, -81.25, -81.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-050', 'North Slope County East group', 'KL', 6, -69.65, -70.5, -141, -147.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-051', 'BC Province (Queen Charlotte Islands) group', 'VE7', 1, -51.83333, -54.33333, -130.9167, -133.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-052', 'FL State South West (Collier / Monroe) group', 'W4', 291, -25.1, -26.31667, -80.85, -81.85, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-053', 'Trinity Islands', 'KL', 6, -56.33333, -56.66667, -153.75, -155, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-054', 'Berry Islands', 'C6', 60, -25.33333, -25.91667, -77.58334, -78, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-055', 'ME State East group', 'W1', 291, -43.75, -45.05, -66.93333, -69.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-056', 'La Juventud Island group', 'CO4', 70, -21.25, -22.25, -81.3, -83.3, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-057', 'Bahia Islands', 'HR', 80, -16.03333, -16.53333, -85.75, -87.08334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-058', 'GA State group', 'W4', 291, -30.7, -32.08333, -80.83334, -81.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-059', 'Fox Islands', 'KL', 6, -52.66667, -55.08333, -163, -169.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-060', 'Valle / Choluteca Department group', 'HR', 80, -13, -13.41667, -87.3, -87.81667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-061', 'BC Province North group', 'VE7', 1, -51, -55.05, -127.1833, -130.9167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-062', 'FL State (Florida Keys) group', 'W4', 291, -24.41667, -25.61667, -80, -82.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-063', 'Sable Island', 'CY0', 211, -43.88334, -44.05, -59.66667, -60.21667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-064', 'Near Islands (Agattu & Attu) group', 'KL', 6, -52.25, -53.16667, 172.3333, 173.8167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-065', 'WA State North group', 'W7', 291, -47.31667, -49, -122.2167, -123.5, 'H', 'Camano/Fidalgo/Fox/McNeil/Mercer Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-066', 'CA State South (Orange / San Diego) group', 'W6', 291, -32.53333, -33.75, -117.1167, -119.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-067', 'NC State East group', 'W4', 291, -34.53333, -36.53333, -75.33334, -76.66666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-068', 'NB Province North group', 'VE9', 1, -46, -48.08333, -63.71667, -66.36667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-069', 'FL State South West (Charlotte / Lee) group', 'W4', 291, -26.31667, -26.95, -81.85, -82.41666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-070', 'Rat Islands', 'KL', 6, -51.25, -52.5, 175.75, 179.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-071', 'Chiriqui / Veraguas South Province group', 'HP', 88, -7.166667, -8.333333, -80.65, -82.9, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-072', 'Panama / Darien Province group', 'HP', 88, -7.2, -9.016666, -77.9, -80.03333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-073', 'Corozal / Belize District group', 'V3', 66, -17.11667, -18.48333, -87.75, -88.35, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-074', 'Nunivak Island', 'KL', 6, -59.66667, -60.5, -165.4167, -167.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-075', 'BC Province (Gulf Islands) group', 'VE7', 1, -48.5, -49.25, -123, -124, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-076', 'FL State North West (Jefferson etc) group', 'W4', 291, -28.46667, -30.1, -82.65, -84.08334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-077', 'QC Province (Anticosti Island) group', 'VE2', 1, -49, -50, -61.58333, -64.58334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-078', 'Baja California Sur State South West group', 'XE2', 50, -22.75, -25.55, -110, -112.4167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-079', 'FL State (Dry Tortugas Islands) group', 'W4', 291, -24.5, -24.83333, -82.75, -83.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-080', 'Little Bahama Bank group', 'C6', 60, -25.7, -27.5, -76.83334, -79.16666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-081', 'NS Province East group', 'VE1', 1, -44, -45, -61.88334, -64.63333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-082', 'MS State group', 'W5', 291, -30.16667, -30.4, -88.38333, -89.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-083', 'VA State group', 'W4', 291, -36.53333, -38.03333, -75, -76.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-084', 'QC Province (St Lawrence Gulf) East group', 'VE2', 1, -50.13334, -51.5, -57.1, -61, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-085', 'FL State North West (Bay to Wakulla) group', 'W4', 291, -29.55, -30.28333, -84.08334, -86, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-086', 'Ciego De Avila / Camaguey Province Nth group', 'CO7', 70, -21.5, -22.66667, -77, -78.93333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-087', 'Shumagin Islands', 'KL', 6, -54.66667, -55.66667, -159, -161, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-088', 'Bocas Del Toro Province group', 'HP', 88, -8.8, -9.566667, -81.23333, -82.56667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-089', 'LA State East group', 'W5', 291, -29.41667, -30.2, -88.78333, -89.85, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-090', 'Quintana Roo State Centre group', 'XE3', 50, -19.83333, -20.83333, -86.5, -87.46667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-091', 'BC Province South group', 'VE7', 1, -49, -51, -122.75, -127.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-092', 'TX State West group', 'W5', 291, -25.95, -28.38333, -96.36667, -97.55, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-093', 'Pinar Del Rio / La Habana Province group', 'CO1-3', 70, -21.66667, -23.33333, -81.66666, -85.08334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-094', 'St Paul Island', 'CY9', 252, -47.13334, -47.25, -60.11666, -60.23333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-095', 'Desecheo Island', 'KP5', 43, -18.33333, -18.43333, -67.41666, -67.53333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-096', 'Hispaniola (main island only)', 'HH,HI', NULL, -17.6, -20, -68.2, -74.53333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-097', 'Jamaica', '6Y', 82, -16.75, -18.75, -75.5, -78.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-098', 'Navassa Island', 'KP1', 182, -18.3, -18.5, -74.91666, -75.16666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-099', 'Puerto Rico', 'KP3,4', 202, -17.8, -18.66667, -65.15, -68, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-100', 'Antigua & Barbuda', 'V2', 94, -16.86667, -17.75, -61.63334, -62.38334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-101', 'Dominica', 'J7', 95, -15.16667, -15.66667, -61.2, -61.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-102', 'Guadeloupe', 'FG', 79, -15.8, -16.55, -60.91667, -61.91667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-103', 'Montserrat', 'VP2M', 96, -16.63333, -16.86667, -62.08333, -62.33333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-104', 'St Kitts & Nevis', 'V4', 249, -17.08333, -17.45, -62.5, -62.91667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-105', 'St Martin (main island only)', 'FS,PJ7', NULL, -18, -18.15, -63, -63.16667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-106', 'Virgin Islands', 'KP2', 285, -17.66667, -18.43333, -64.53333, -65.15, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-107', 'Martinique', 'FM', 84, -14.33333, -14.91667, -60.66667, -61.33333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-108', 'St Lucia', 'J6', 97, -13.66667, -14.16667, -60.8, -61.13334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-109', 'St Vincent', 'J8', 98, -13.06667, -13.41667, -61.06667, -61.31667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-110', 'SC State group', 'W4', 291, -32.08333, -33.85, -78.55, -80.93333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-111', 'NJ State group', 'W2', 291, -38.91667, -40.48333, -73.95, -75.5, 'H', 'Peck\'s Beach, Absecon Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-112', 'NC State West group', 'W4', 291, -33.85, -34.7, -76.66666, -78.55, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-113', 'South Bahamas group', 'C6', 60, -20.83333, -23.25, -72.58334, -74.58334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-114', 'Les Saintes Islands', 'FG', 79, -15.8, -15.91667, -61.5, -61.71667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-115', 'Clarion Island', 'XE4', 204, -18.25, -18.5, -114.5833, -114.9167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-116', 'Puntarenas Province West group', 'TI8', 308, -9.333333, -10.16667, -84, -85.23333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-117', 'Puntarenas Province East group', 'TI8', 308, -8.033334, -9.333333, -82.91666, -84, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-118', 'BC Province (Dundas Islands) group', 'VE7', 1, -54.33333, -54.66667, -130.6667, -131.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-119', 'LA State Centre group', 'W5', 291, -29, -29.46667, -90.41666, -91.35, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-120', 'LA State West group', 'W5', 291, -29.38333, -29.8, -91.21667, -93.83334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-121', 'Dillingham / Bristol Bay County group', 'KL', 6, -58.33333, -59.05, -157, -161.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-122', 'Dominican Republic\'s Coastal Islands', 'HI', 72, -17.5, -20, -68, -71.86667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-123', 'Turneffe Islands', 'V3', 66, -17.11667, -17.66667, -87.41666, -88, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-124', 'Baja California Sur State South East group', 'XE2', 50, -22.75, -25.55, -109.25, -111.1, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-125', 'QC Province (St Lawrence Gulf) West group', 'VE2', 1, -49.26667, -50.3, -65, -68, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-126', 'NS Province South group', 'VE1', 1, -43.25, -44, -64.63333, -66.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-127', 'NS Province West group', 'VE1', 1, -44, -45.71667, -64.5, -66.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-128', 'QC Province (St Lawrence Waterway) group', 'VE2', 1, -46.83333, -49.28333, -68, -71.16666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-129', 'NWT (Banks Island) group', 'VY8', 1, -70.83334, -74.66666, -115, -126.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-130', 'Nunavut (Baffin\'s Coastal Islands) East group', 'VY0', 1, -61.25, -73.91666, -61, -86, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-131', 'Nunavut (Kitikmeot Region) East Centre group', 'VY0', 1, -67.25, -71, -93.5, -106.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-132', 'Bajo Nuevo & Serranilla Bank Cays', 'HK0', 216, -15.66667, -16, -78.5, -80.08334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-133', 'Serrana Bank & Roncador Cays', 'HK0', 216, -13.45, -14.5, -79.91666, -81.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-134', 'Greenland\'s Coastal Islands North West', 'OX', 237, -66.5, -84, -44.75, -74, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-135', 'Campeche State group', 'XE3', 50, -18.45, -22.5, -90.41666, -92.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-136', 'CT State group', 'W1', 291, -40.96667, -41.33333, -71.9, -73.65, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-137', 'ME State West group', 'W1', 291, -43.06667, -43.98333, -69.25, -70.7, 'H', 'See WWW.RSGBIOTA.COM for ineligible islands');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-138', 'FL State North East group', 'W4', 291, -27.86667, -30.7, -80.5, -81.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-139', 'MD State East group', 'W3', 291, -38.03333, -38.45, -75.03333, -75.36667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-140', 'MD State West group', 'W3', 291, -37.9, -39.08333, -75.75, -76.58334, 'H', 'See WWW.RSGBIOTA.COM for ineligible islands');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-141', 'FL State South East group', 'W4', 291, -25.61667, -27.86667, -80, -80.41666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-142', 'FL State North West (Escambia etc) group', 'W4', 291, -30.2, -30.41667, -86, -87.56667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-143', 'TX State East group', 'W5', 291, -28.38333, -29.68333, -93.83334, -96.36667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-144', 'CA State South (Santa Barbara to LA) group', 'W6', 291, -33.7, -34.95, -118.1167, -120.7, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-145', 'Saba & Sint Eustatius', 'PJ5,6,8', 519, -17.45, -17.75, -62.91667, -63.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-146', 'St-Barthelemy Island', 'FJ', 516, -17.83333, -18, -62.76667, -62.95, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-147', 'The Grenadines', 'J3', 77, -12.26667, -12.53333, -61.33333, -61.66667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-148', 'MA State North group', 'W1', 291, -41.73333, -42.86666, -69.9, -71.03333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-149', 'Haiti\'s Coastal Islands', 'HH', 78, -17.95, -20.16667, -71.68333, -74.53333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-150', 'Little Diomede Island', 'KL', 6, -65.71667, -65.8, -168.8333, -169, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-151', 'Greenland\'s Coastal Islands South East', 'OX', 237, -59.75, -66.5, -34.5, -44.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-152', 'Nome County North group', 'KL', 6, -64.75, -66.56667, -164.5, -168.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-153', 'Yucatan State group', 'XE3', 50, -20.8, -22.75, -87.53333, -90.41666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-154', 'NS Province North group', 'VE1', 1, -45, -46, -60.91667, -64.05, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-155', 'Limon Province group', 'TI6', 308, -9.566667, -10.95, -82.56667, -83.65, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-156', 'Nunavut (Hudson Bay - QC Coast) NW group', 'VY0', 1, -61.25, -65, -66, -80.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-157', 'Valdez Cordova County East group', 'KL', 6, -59.66667, -60.45, -141, -145.6333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-158', 'Kenai - Cook Inlet group', 'KL', 6, -58.58333, -61.25, -149.6667, -154.2333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-159', 'Nunavut (King George Islands) group', 'VY0', 1, -56.93333, -58.58333, -78, -81, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-160', 'Cortes / Atlantida / Colon Department group', 'HR', 80, -15.66667, -16.03333, -85, -88.23333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-161', 'Skagway County group', 'KL', 6, -58.2, -58.8, -135, -138, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-162', 'Baja California State North West group', 'XE2', 50, -30, -32.53333, -115.8333, -117.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-163', 'Baja California State East group', 'XE2', 50, -28, -31.8, -112.7333, -114.8833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-164', 'Baja California Sur State North West group', 'XE2', 50, -25.55, -28, -112.05, -115.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-165', 'Baja California Sur State North East group', 'XE2', 50, -25.55, -28, -110.6667, -112.7833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-166', 'Sonora State South group', 'XE2', 50, -26.15, -28.5, -109.3, -111.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-167', 'Sonora State North group', 'XE2', 50, -28.5, -31.76667, -111.75, -114.6833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-168', 'LA State South East group', 'W5', 291, -28.83333, -29.61667, -89, -90.41666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-169', 'WA State West group', 'W7', 291, -46.23333, -48.45, -123.5, -124.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-170', 'San Blas Province group', 'HP', 88, -8.666667, -9.666667, -77.36667, -79.08334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-171', 'Sinaloa State group', 'XE2', 50, -22.53333, -26.15, -105.75, -109.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-172', 'North Slope County North group', 'KL', 6, -70.45, -71.5, -154, -160.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-173', 'Nunavut (Hudson Bay - QC Coast) South group', 'VY0', 1, -51.38334, -56, -76.73333, -80.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-174', 'Nunavut (Foxe Basin) group', 'VY0', 1, -65, -70.33334, -72.33334, -85, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-175', 'Nunavut (Kitikmeot Region) West Centre group', 'VY0', 1, -67.08334, -68.33334, -106.5, -115.5333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-176', 'QC Province (St Lawrence Gulf) Centre group', 'VE2', 1, -50.05, -50.31667, -61, -65, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-177', 'QC Province (Gaspe Peninsula) group', 'VE2', 1, -48, -49.33333, -64, -68, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-178', 'CA State Centre (Sonoma to Santa Cruz) group', 'W6', 291, -36.91667, -38.75, -121.8, -123.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-179', 'Guadalupe Island', 'XE2', 50, -28.75, -29.33333, -118.0833, -118.4167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-180', 'Stann Creek / Toledo District group', 'V3', 66, -15.9, -17.11667, -87.5, -88.93333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-181', 'BC Province (Estevan Group)', 'VE7', 1, -52.91667, -53.2, -129.4667, -129.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-182', 'NWT (Inuvik Region) East group', 'VE8', 1, -69.33334, -70.66666, -121.6833, -129.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-183', 'Guerrero State group', 'XE3', 50, -16.33333, -17.98333, -98.56667, -102.1333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-184', 'CA State North group', 'W6', 291, -38.75, -42, -123.5, -124.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-185', 'Nunavut (Keewatin Region) group', 'VY0', 1, -60, -64, -88.5, -94.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-186', 'Nunavut (Hudson Bay - Manitoba Coast) group', 'VY0', 1, -56.83333, -60, -89, -94.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-187', 'CA State Centre (Monterey etc) group', 'W6', 291, -34.95, -36.91667, -120.6167, -122, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-188', 'Oaxaca State group', 'XE3', 50, -15.61667, -16.33333, -94, -98.56667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-189', 'Nayarit / Jalisco State group', 'XE1', 50, -19.18333, -22.53333, -104.7, -105.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-116', 'Gulf of Aden West Group', 'T5', 232, -10.4, -11.5, 43.25, 46, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-117', 'Gulf of Aden East Group', 'T5', 232, -10.7, -12, 46, 51.33, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-019', 'Balleny Islands', 'Various', 13, 66.25, 68, 162.25, 165.1, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-020', 'Scott Island', 'Various', 13, 67.25, 67.66, -179.9, 179.9, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AN-021', 'Shag Rocks, South Georgia Island', 'VP8', 235, 53, 54, -41, -42.5, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-175', 'Gujarat State West Group', 'VU', 324, -20.75, -23.66, 68.15, 70.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-176', 'Gujarat State East Group', 'VU', 324, -20.47, -22.25, 70.5, 72.95, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-177', 'Goa State group', 'VU', 324, -14.9, -15.76, 73.66, 74.05, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-178', 'Andhra Pradesh State North Group', 'VU', 324, -16.25, -19.15, 81.27, 84.9, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-179', 'Orissa State Group', 'VU', 324, -19.15, -23.6, 84.9, 87.5, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-180', 'Balochistan Province Group', 'AP', 372, -24.88, -25.4, 61.6, 66.75, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-181', 'Sindh Province Group', 'AP', 372, -23.66, -24.88, 66.62, 68.15, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-182', 'Mon Region Group', 'XZ', 309, -14.9, -17.3, 96.9, 97.8, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-183', 'Tenasserim Region North Group', 'XZ', 309, -13.25, -14.9, 97.66, 98.28, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-184', 'Preparis Channel Group', 'XZ', 309, -13.85, -15, 93.1, 93.88, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-185', 'Gulf of Tongking South Group', '3W', 293, -16.19, -19.98, 105.62, 108.33, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-186', 'Syria Group', 'YK', 384, -34.62, -35.9, 35.66, 35.99, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-187', 'Gulf of Aden East Group', '7O', 492, -13.55, -16.6, 47, 53.1, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-188', 'Khuzestan Province Group', 'EP', 330, -29.9, -30.25, 48.6, 50.05, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-189', 'Bushehr Province Group', 'EP', 330, -27.3, -30.2, 50.05, 52.74, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-190', 'Red Sea Coast North (Tabuk Prov.) Grp.', 'HZ', 378, -24.5, -29.35, 34.42, 37.44, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-191', 'Red Sea Coast Centre Group', 'HZ', 378, -18.1, -24.5, 37.42, 41.55, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-192', 'Red Sea Coast South (Jizan Province) Group', 'HZ', 378, -16.42, -18.1, 40.85, 42.72, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-193', 'Farasan Islands', 'HZ', 378, -16.5, -17.13, 41.25, 42.28, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-194', 'Senkaku Islands', 'JA6', 339, -25.66, -26, 123.32, 124.66, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-195', 'P\'yongan-Bukto / P\'yongan-Namdo Prov. Grp.', 'P5', 433, -38.74, -39.9, 124.15, 125.38, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-196', 'Nam\'p\'o-si / Hwanghae-Namdo Prov. Grp.', 'P5', 433, -37.62, -38.7, 124.6, 126.15, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-197', 'Hamgyona-Bukto/Hamgyong-Namdo Prov. Grp.', 'P5', 433, -39.29, -42.33, 127.49, 130.66, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-198', 'Kangwon-do Province Group', 'P5', 433, -38.6, -39.29, 127.34, 128.34, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-229', 'Nunavut (Hudson Bay - QC Coast) NE Grp.', 'VY0', 1, -58.33, -61.25, -64.5, -71, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-230', 'Nunavut (Ottawa Islands) group', 'VY0', 1, -58.9, -60.1, -79.66, -81, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-231', 'Nunavut (Hudson Bay - Ontario Coast) N. Grp.', 'VY0', 1, -55, -57, -82.18, -89, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-232', 'St. Matthew Island', 'KL', 6, -60.1, -60.75, -172.1, -173.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-233', 'Delarof Islands', 'KL', 6, -51.15, -51.9, -178.25, -179.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-234', 'Islands of Four Mountains', 'KL', 6, -52.33, -53.18, -169.5, -171.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-235', 'Semidi Islands', 'KL', 6, -55.6, -56.33, -155.5, -157, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-236', 'Sanak Islands', 'KL', 6, -54.25, -54.53, -162.25, -163, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-237', 'Southern Alaska Peninsula East Group', 'KL', 6, -56.33, -58.6, -153.9, -157.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-238', 'Southern Alaska Peninsula Centre Group', 'KL', 6, -55.66, -56.66, -157.5, -160, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-239', 'Northern Alaska Peninsula East Group', 'KL', 6, -56.6, -58.6, -157.33, -159.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-240', 'Bethel County Group', 'KL', 6, -58.55, -60.9, -161.33, -165.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-241', 'Wade-Hampton County Group', 'KL', 6, -60.91, -63.29, -162.7, -166.33, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-242', 'North Slope County West Group', 'KL', 6, -67.9, -70.47, -160.5, -166.92, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-243', 'Greenland\'s Coastal Islands North East', 'OX', 237, -66.5, -84, -11.5, -44.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-244', 'Marias Islands', 'XE1', 50, -21.18, -21.91, -106.18, -106.75, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-245', 'Rocas Alijos Islands', 'XE2', 50, -24.8, -25, -115.6, -115.85, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-271', 'Babar Islands', 'YB8', 327, 7.45, 8.33, 129.4, 130.15, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-272', 'Barat Daya Islands', 'YB8', 327, 5.48, 8.05, 125.66, 130.4, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-273', 'Gorong and Watubela Islands', 'YB8', 327, 3.9, 4.85, 130.98, 131.92, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-274', 'Lucipara and Penyu Islands', 'YB8', 327, 5.25, 5.75, 127.33, 127.92, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-275', 'Irian Jaya\'s Coastal Islands South', 'YB9', 327, 3.77, 9.15, 134, 141, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-276', 'Mapia Islands', 'YB9', 327, -.75, -1, 134.15, 134.41, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-277', 'Sorol Atoll', 'V6', 173, -8, -8.25, 140.15, 140.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-278', 'Ujelang Atoll', 'V7', 168, -9.89, -10, 160.6, 161.08, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-279', 'Malden Island', 'T32', 48, 3.92, 4.08, -154.95, -155.05, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-280', 'Starbuck Island', 'T32', 48, 5.55, 5.66, -155.9, -155.97, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-281', 'Caroline (Millennium) Island', 'T32', 48, 9.96, 10.07, -150.17, -150.33, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-282', 'Vostok and Flint Islands', 'T32', 48, 10.05, 11.48, -151.74, -152.46, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-283', 'Tauu (Takuu) Islands', 'P2', 163, 4.66, 4.91, 156.91, 157.15, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-284', 'Nukumanu Islands', 'P2', 163, 4.33, 4.75, 159.25, 159.6, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-285', 'Stewart Islands (aka Sikaiana Atoll)', 'H4', 185, 8.26, 8.48, 162.6, 162.85, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-286', 'Antipodes Islands', 'ZL9', 16, 49.6, 49.75, 178.66, 178.92, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-287', 'Bounty Islands', 'ZL9', 16, 47.6, 47.75, 179, 179.25, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-288', 'Nihoa Islands', 'KH6,7', 110, -23, -23.1, -161.88, -162, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-289', 'Necker Island', 'KH6,7', 110, -23.53, -23.63, -164.63, -164.76, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-290', 'Gardner Pinnacles', 'KH6,7', 110, -24.91, -25.09, -167.93, -168.1, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-291', 'Laysan Island', 'KH6,7', 110, -25.72, -25.82, -171.7, -171.8, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-292', 'Lisianski Island', 'KH6,7', 110, -26, -26.13, -173.9, -173.04, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-293', 'Pearl and Hermes Atoll', 'KH6,7', 110, -27.66, -28, -175.58, -176.15, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-294', 'Sandy Island', 'VK', 150, 13.85, 14.25, 121.66, 122.1, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-095', 'O\'Higgins / Maule Region Group', 'CE4', 112, 33.85, 36.05, -71.87, -72.85, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-096', 'Chubut Province North Group', 'LU', 100, 42, 44, -63.42, -65.26, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-097', 'Diego Ramirez Islands', 'CE9', 112, 56.33, 56.67, -68.58, -68.92, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-098', 'Arequipa / Moquegua / Tacna Dept. Grp', 'OA6', 136, 15.42, 18.38, -70.43, -75.07, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-190', 'El Salvador group', 'YS', 74, -13.11667, -13.75, -87.66666, -90.11667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-191', 'Guanacaste Province group', 'TI7', 308, -9.75, -11.08333, -85.15, -86, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-192', 'NWT (Inuvik Region) West group', 'VE8', 1, -68.83334, -70.33334, -129.25, -136.45, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-193', 'Yukon Territory group', 'VY1', 1, -68.86667, -69.75, -136.45, -141, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-194', 'NFLD Province (Labrador) North group', 'VO2', 1, -57.61666, -61.3, -61.41667, -64.58334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-195', 'Nunavut (Hudson Bay - QC Coast) Centre group', 'VY0', 1, -56, -61.25, -76.53333, -79.16666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-196', 'Nunavut (Belcher Islands) group', 'VY0', 1, -55.5, -56.93333, -77.83334, -80.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-197', 'Kenai Peninsula County group', 'KL', 6, -59, -60, -148.55, -152.0833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-198', 'Newfoundland\'s Coastal Islands', 'VO1', 1, -46.55, -51.7, -52.5, -59.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-189', 'Isle of Rockall', 'GM,MM', 279, -57.6, -57.6, -13.7, -13.7, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-099', 'Matrah Region Group', 'SU', 478, -30.9, -31.75, 25.18, 29.68, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-098', 'Sofala District Group', 'C9', 181, 18.85, 21, 34.74, 36.29, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-100', 'Bas-Congo Province Group', '9Q', 414, 5.75, 6.05, 12.18, 12.6, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-174', 'Chukchi Sea Coast West Group', 'R0K', 15, -68.13, -69.45, 178, -177, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-227', 'Nunavut (Kitikmeot Region) West Group', 'VY0', 1, -68.33, -69.95, -113.4, -121.7, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-269', 'Karimata Islands', 'YB7', 327, 1.4, 1.8, 108.6, 109.15, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-199', 'St Martin\'s Coastal Islands', 'FS', 213, -18.06667, -18.15, -62.95, -63.16667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-200', 'Quintana Roo State South group', 'XE3', 50, -18.16667, -19.83333, -87.13333, -88.28333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-201', 'Ciego De Avila / Camaguey Province South group', 'CO7', 70, -20.33333, -21.58333, -77.83334, -79.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-202', 'Colon / Veraguas North Province group', 'HP', 88, -8.8, -9.75, -79.08334, -81.23333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-203', 'Los Santos / Herrera / Cocle Province group', 'HP', 88, -7.166667, -8.4, -79.96667, -80.65, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-204', 'Matanzas to Sancti Spiritus Province group', 'CO5,6', 70, -21.5, -23.33333, -78.93333, -82.21667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-205', 'NFLD Province (Labrador) Centre group', 'VO2', 1, -54.4, -57.61666, -56.83333, -62.33333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-206', 'Barren Islands', 'KL', 6, -58.75, -59, -151.8333, -152.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-207', 'Nunavut (Hudson Bay - ONT Coast) South group', 'VY0', 1, -51.16667, -55, -79.5, -82.41666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-208', 'Nunavut (Kitikmeot Region) East group', 'VY0', 1, -67.16666, -72, -85, -94.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-209', 'Caribbean Sea Coast South group', 'YN', 86, -10.95, -12, -83.25, -83.86667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-210', 'Nome County Centre group', 'KL', 6, -64, -64.75, -160.7833, -166.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-211', 'Oregon State group', 'W7', 291, -42, -46.23333, -123.9167, -124.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-212', 'Pacific Ocean Coast group', 'YN', 86, -11.08333, -13.11667, -85.7, -87.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-213', 'Alabama State group', 'W4', 291, -30.16667, -30.7, -87.56667, -88.38333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-214', 'Nome County South group', 'KL', 6, -63.21667, -64, -160.7833, -162.7167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-215', 'Northwest Arctic County group', 'KL', 6, -66.03333, -67.91666, -161.0833, -165, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-216', 'Northern Alaska Peninsula West group', 'KL', 6, -54.86666, -56.58333, -159.75, -163.4, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-217', 'New Hampshire State group', 'W1', 291, -42.86666, -43.06667, -70.58334, -70.81667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-218', 'Las Tunas to Santiago de Cuba Province group', 'CO8', 70, -19.75, -21.5, -74.05, -77.96667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-219', 'Cay Sal Bank Cays', 'C6', 60, -23.45, -24.16667, -79.41666, -80.58334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-220', 'Greenland\'s Coastal Islands South West', 'OX', 237, -59.75, -66.5, -44.75, -54, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-221', 'Veracruz State North group', 'XE1', 50, -20, -22.25, -96.55, -97.78333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-222', 'Southern Alaska Peninsula West group', 'KL', 6, -54.58333, -55.66667, -161, -163.3667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-223', 'Gracias a Dios Department group', 'HR', 80, -15, -16.16667, -82, -85, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-224', 'Veracruz State South group', 'XE1', 50, -18.15, -20, -94.13333, -96.55, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-225', 'Nunavut (Prince of Wales & Somerset Is) grp.', 'VY0', 1, -71, -74.4, -89.5, -102.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-226', 'Colima / Michoacan State Group', 'XE1', 50, -17.88333, -19.18333, -102.1333, -104.7, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-001', 'Australia (main island only)', 'VK', 150, 10.66667, 39.16667, 113.1667, 153.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-002', 'Christmas Island', 'VK9', 35, 10.33333, 10.6, 105.5, 105.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-003', 'Cocos (Keeling) Islands', 'VK9', 38, 11.75, 12.25, 96.75, 97, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-004', 'Lord Howe Island', 'VK9', 147, 31.46667, 31.8, 159, 159.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-005', 'Norfolk Island', 'VK9', 189, 28.96667, 29.16667, 167.8833, 168, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-006', 'Tasmania (main island only)', 'VK7', 150, 41.66667, 43.66667, 144.25, 148.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-007', 'Willis Islands', 'VK9', 303, 16.05, 16.38333, 149.9167, 150.1333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-008', 'Bismarck Archipelago', 'P2', 163, 2.25, 6.5, 146.75, 153.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-009', 'Palau Islands', 'T8', 22, -6.833333, -8.25, 134.0833, 134.9167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-010', 'Pohnpei Islands', 'V6', 173, -5.75, -7.25, 157, 158.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-011', 'Chuuk Islands', 'V6', 173, -6.666667, -7.833333, 151.3333, 152.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-012', 'Yap Islands', 'V6', 173, -9.333333, -9.75, 138, 138.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-013', 'Rarotonga Island', 'E5', 234, 21, 21.33333, -159.5833, -160, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-014', 'Manihiki Atoll', 'E5', 191, 9.916667, 10.58333, -160.8333, -161.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-015', 'Tuvalu Islands', 'T2', 282, 5.5, 10.66667, 176, 180, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-016', 'Viti Levu & Vanua Levu Group', '3D2', 176, 15.66667, 19.25, 177.1667, -179.65, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-017', 'Gilbert Islands', 'T30', 301, -3.416667, 2.8, 172.66, 177, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-018', 'Banaba (Ocean) Island', 'T33', 490, .8166667, .9166667, 169.5333, 169.6333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-019', 'Hawaiian Islands', 'KH6,7', 110, -18.83333, -22.41667, -154.75, -160.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-020', 'Kure Atoll', 'KH7K', 138, -28.36667, -28.46667, -178.2833, -178.3833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-021', 'Java (Jawa) Island (main island only)', 'YB0-3', 327, 5.833333, 8.833333, 105.1667, 114.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-022', 'Bali Island', 'YB9', 327, 8, 8.916667, 114.3833, 115.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-023', 'Johnston Atoll', 'KH3', 123, -16.68333, -16.8, -169.4667, -169.6, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-024', 'Kiritimati (Christmas) Island', 'T32', 48, -1.583333, -2.116667, -157, -157.6167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-025', 'Admiralty Islands', 'P2', 163, 1.833333, 3, 145.75, 148.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-026', 'Guam Island', 'KH2', 103, -13.2, -13.68333, 144.5833, 145, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-027', 'Marquesas Islands', 'FO', 509, 7.666667, 10.66667, -138.3333, -141, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-028', 'Ralik Chain', 'V7', 168, -4.5, -11.83333, 165, 169.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-029', 'Ratak Chain', 'V7', 168, -5.75, -12.5, 168.9667, 172.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-030', 'Midway Islands', 'KH4', 174, -28.15, -28.28333, -177.2833, -177.45, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-031', 'Nauru', 'C2', 157, .3333333, .5833333, 166.8667, 166.9833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-032', 'New Caledonia Island', 'FK', 162, 19.95, 23, 163.6667, 167.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-033', 'Loyalty Islands', 'FK', 162, 19.58333, 22.75, 165.5, 169, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-034', 'New Guinea (main island only)', 'P2,YB9', NULL, .25, 10.75, 130.9167, 150.9167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-035', 'New Hebrides', 'YJ', 158, 14.58333, 20.33333, 166.4167, 170.3, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-036', 'North Island (main island only)', 'ZL', 170, 34.35, 41.66667, 172.6, 178.6, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-037', 'Campbell Island', 'ZL9', 16, 52.41667, 52.66667, 168.9167, 169.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-038', 'Chatham Islands', 'ZL7', 34, 43.5, 44.5, -175.75, -177, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-039', 'Kermadec Islands', 'ZL8', 133, 29.08333, 31.5, -177.75, -179, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-040', 'Niue Island', 'ZK2', 188, 18.83333, 19.25, -169.6667, -170, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-041', 'Ninigo Group', 'P2', 163, .5833333, 1.916667, 142.6667, 145.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-042', 'Luzon Island (main island only)', 'DU1-4', 375, -12.48333, -18.75, 119.6667, 124.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-043', 'Phoenix Islands', 'T31', 31, 2.5, 5, -170.42, -173, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-044', 'Pitcairn Island', 'VP6', 172, 23.83333, 25.13333, -130, -130.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-045', 'Tutuila Island', 'KH8', 9, 14, 14.5, -170.3333, -171, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-046', 'Windward Islands', 'FO', 175, 16.91667, 18, -147.8333, -150.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-047', 'Solomon Islands', 'H4', 185, 6.5, 11.16667, 156.25, 162.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-048', 'Tokelau Islands', 'ZK3', 270, 8.25, 9.75, -171, -172.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-049', 'Tongatapu Group', 'A3', 160, 20.91667, 22.5, -174.75, -176.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-050', 'Rurutu & Rimatara Islands', 'FO', 508, 22.33333, 22.75, -151.25, -152.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-051', 'Rapa & Marotiri Islands', 'FO', 508, 27.5, 28, -143.3333, -144.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-052', 'Duke of Gloucester Islands', 'FO', 175, 19.75, 20.75, -142.9167, -145.0833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-053', 'Wake Island', 'KH9', 297, -19.25, -19.33333, 166.5667, 166.7, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-054', 'Wallis Islands', 'FW', 298, 13.16667, 13.46667, -176.05, -176.2833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-055', 'French Frigate Shoals', 'KH6,7', 110, -23.58333, -24, -166, -166.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-056', 'Henderson Island', 'VP6', 172, 24.3, 24.41667, -128.2667, -128.3833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-057', 'Maupihaa group', 'FO', 175, 15.66667, 16.91667, -153.8333, -154.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-058', 'D\'Entrecasteaux Reefs', 'FK', 162, 17.75, 18.75, 162.6667, 163.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-059', 'Kosrae (Kusaie) Island', 'V6', 173, -5.233333, -5.4, 162.8833, 163.05, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-060', 'Rotuma Island', '3D2', 460, 12.41667, 12.58333, 176.9167, 177.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-061', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'D', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-062', 'Pukapuka Atoll', 'FO', 175, 14.75, 14.91667, -138.75, -138.9167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-063', 'Gambier Islands', 'FO', 175, 22.91667, 23.41667, -134.3333, -135.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-064', 'Vava\'u Group', 'A3', 160, 17.96667, 19.06667, -173.8333, -174.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-065', 'Reef (Swallow) Islands', 'H40', 507, 10, 10.5, 165.5833, 166.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-066', 'Tuamotu Archipelago', 'FO', 175, 14.75, 22.5, -138.25, -148.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-067', 'Leeward Islands', 'FO', 175, 16.16667, 16.91667, -150.75, -152.4167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-068', 'Snares Islands', 'ZL', 170, 48, 48.08333, 166.3333, 166.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-069', 'Lihir Group', 'P2', 163, 2.75, 3.333333, 152.5, 152.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-070', 'Seram group', 'YB8', 327, 2.583333, 3.883333, 125.9167, 130.9667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-071', 'WA State (N Coast) West group', 'VK6', 150, 15.41667, 17.41667, 122.95, 124, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-072', 'Mellish Reef', 'VK9', 171, 17.4, 17.48333, 155.8, 155.9167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-073', 'Minami Torishima (Marcus Island)', 'JD', 177, -24.2, -24.36667, 153.8833, 154.05, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-074', 'Auckland Islands', 'ZL9', 16, 50.41667, 50.96667, 165.8333, 166.4167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-075', 'Riau Islands', 'YB5', 327, -.45, -1.233333, 103.25, 105.0833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-076', 'Sula Islands', 'YB8', 327, 1.416667, 2.583333, 124.1, 126.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-077', 'Manua Islands', 'KH8', 9, 14, 14.5, -169.25, -169.9167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-078', 'Ulithi Atoll', 'V6', 173, -9.666667, -10.16667, 139.4167, 140.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-079', 'Belep Islands', 'FK', 162, 19, 19.95, 163.25, 163.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-080', 'Suwarrow Atoll (Suvorov)', 'E5', 191, 13.08333, 13.53333, -162.8333, -163.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-081', 'Jarvis Island', 'KH5', 197, .3333333, .4333333, -159.9667, -160.0833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-082', 'Penrhyn Atoll (Tongareva)', 'E5', 191, 8.75, 9.25, -157.75, -158.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-083', 'Aitutaki group', 'E5', 234, 18.75, 20.33333, -157.25, -160, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-084', 'Tabuaeran & Teraina Islands', 'T32', 48, -3.75, -4.833333, -159.25, -160.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-085', 'Palmyra Atoll', 'KH5', 197, -5.833333, -5.916667, -162, -162.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-086', 'Northern Mariana Islands', 'KH0', 166, -14, -20.66667, 144.8333, 146.1333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-087', 'Enewetak (Eniwetok) Atoll', 'V7', 168, -11.16667, -11.83333, 161.9167, 162.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-088', 'Borneo', '9M6,9M8,V85,YB7', NULL, -7.083333, 4.2, 108.75, 119.33, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-089', 'Baker & Howland Islands', 'KH1', 20, -.1333333, -.8666667, -176.3833, -176.7167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-090', 'Calamian Group', 'DU1', 375, -11.6, -12.5, 119.75, 120.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-091', 'Polillo Islands', 'DU1', 375, -14.5, -15.16667, 121.75, 122.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-092', 'Babuyan Islands', 'DU2', 375, -18.75, -19.66667, 121.0833, 122.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-093', 'Batan Islands', 'DU2', 375, -19.83333, -21.25, 121.6667, 122.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-094', 'Disappointment Islands', 'FO', 175, 13.91667, 14.2, -141.0833, -141.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-095', 'Lau Group', '3D2', 176, 16.71667, 21.06667, -178, -179.65, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-096', 'Kingman Reef', 'KH5K', 134, -6.366667, -6.466667, -162.3333, -162.4333, 'D', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-097', 'Samoa Islands', '5W', 190, 13.25, 14.08333, -171.25, -172.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-098', 'Pukapuka Atoll (Danger Islands)', 'E5', 191, 10.71667, 11.71667, -165.25, -166, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-099', 'Tabar Islands', 'P2', 163, 2.583333, 3.083333, 151.8333, 152.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-100', 'Nendo Island', 'H40', 507, 10.5, 11, 165.6667, 166.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-101', 'Feni Islands', 'P2', 163, 3.933333, 4.166667, 153.5, 153.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-102', 'Tanga Islands', 'P2', 163, 3.333333, 3.75, 153.0833, 153.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-103', 'St Matthias Group', 'P2', 163, 1.25, 1.75, 149.4167, 150.0833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-104', 'Banks Islands', 'YJ', 158, 13.16667, 14.58333, 167.1667, 168.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-105', 'Cagayan De Sulu group', 'DU8', 375, -6.833333, -8, 118.25, 118.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-106', 'Natuna Besar Islands', 'YB5', 327, -3.416667, -4.916667, 107.3333, 108.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-107', 'Lingga Islands', 'YB5', 327, -.45, .98, 104, 105.1, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-108', 'Anambas Islands', 'YB5', 327, -2.25, -3.5, 105.25, 106.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-109', 'Natuna Selatan Islands', 'YB5', 327, -2.166667, -3.416667, 107.5, 109.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-110', 'Torres Islands', 'YJ', 158, 13, 13.58333, 166.4167, 166.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-111', 'Shepherd Islands', 'YJ', 158, 16.78333, 17.2, 168.25, 168.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-112', 'Conway Reef (Ceva-I-Ra)', '3D2', 489, 21.68333, 21.78333, 174.5833, 174.6833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-113', 'Actaeon Group', 'FO', 175, 21.16667, 22.08333, -135.3333, -136.833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-114', 'Raivavae Island', 'FO', 508, 23.78333, 23.95, -147.5, -147.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-115', 'Trobriand Islands', 'P2', 163, 8.166667, 9, 150, 151.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-116', 'D\'Entrecasteaux Islands', 'P2', 163, 9, 10.23333, 150, 151.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-117', 'Louisiade Archipelago', 'P2', 163, 10.08333, 11.83333, 151.5, 154.4167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-118', 'Hoorn Islands', 'FW', 298, 14.2, 14.4, -177.9167, -178.3, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-119', 'Jolo Group', 'DU8', 375, -5.333333, -6.116667, 120.55, 122, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-120', 'Cuyo Islands', 'DU1', 375, -10.58333, -11.58333, 120.5833, 121.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-121', 'Mamanuca (Mamanutha) Group', '3D2', 176, 17.41667, 17.88333, 177, 177.3667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-122', 'Tambelan Islands', 'YB5', 327, -3.333334E-02, -1.416667, 106.8333, 107.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-123', 'Niuafo\'ou Island', 'A3', 160, 15.53333, 15.63333, -175.5833, -175.6833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-124', 'Palmerston Atoll', 'E5', 234, 17.91667, 18.25, -162.9167, -163.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-125', 'Semirara Islands', 'DU6', 375, -11.75, -12.16667, 121.25, 121.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-126', 'Lubang Islands', 'DU1', 375, -13.55, -14, 119.9667, 120.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-127', 'Rennell Island', 'H4', 185, 11.16667, 11.91667, 159.6667, 160.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-128', 'Palawan Island', 'DU1', 375, -7.666667, -11.6, 116.8333, 120.4167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-129', 'Visayan Islands', 'DU5-7', 375, -9, -12.75, 121.6667, 126, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-130', 'Mindanao Island (main island only)', 'DU8,9', 375, -5.533333, -9.833333, 121.8333, 126.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-131', 'King George Islands', 'FO', 175, 14.25, 15, -144.45, -146.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-132', 'Yap Centre group', 'V6', 173, -6.583333, -9.333333, 142.9167, 145.66, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-133', 'Sabah\'s Coastal Islands', '9M6', 46, -4.133333, -7.5, 115.1333, 119.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-134', 'South Island (main island only)', 'ZL', 170, 40.46667, 46.71667, 166.3833, 174.4167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-135', 'Solomon Islands', 'P2', 163, 4.95, 6.95, 154.4167, 156, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-136', 'VIC State Centre group', 'VK3', 150, 38.25, 39.2, 144, 147, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-137', 'QLD State (S Coast) South group', 'VK4', 150, 26, 28.13333, 153.0333, 153.6667, 'H', 'Bribie Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-138', 'QLD State (Torres Strait) group', 'VK4', 150, 9.2, 10.83333, 141.5, 144.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-139', 'SA State East Centre group', 'VK5', 150, 33, 36.16667, 135.5, 138.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-140', 'WA State (NW Coast) West group', 'VK6', 150, 20.25, 24.25, 113.3333, 116, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-141', 'NT (Gulf of Carpentaria) North group', 'VK8', 150, 13, 15, 135.5, 137.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-142', 'QLD State (S Coast) Centre group', 'VK4', 150, 23, 26, 150.7833, 153.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-143', 'Sumatra Island', 'YB4-6', 327, -5.67, 6, 95.12, 106.12, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-144', 'Bangka & Belitung Islands', 'YB4', 327, .8333333, 3.833333, 105, 108.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-145', 'Halmahera group', 'YB8', 327, -2.833333, 1.18, 126, 129.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-146', 'Celebes Island', 'YB8', 327, -1.8, 5.75, 118.7, 125.3, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-147', 'Irian Jaya\'s Coastal Islands North', 'YB9', 327, .25, 3.35, 134, 141, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-148', 'Timor Island (main island only)', 'YB9,4W', NULL, 8.3, 10.41667, 123.4167, 127.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-149', 'New Georgia Islands', 'H4', 185, 7.466667, 8.916667, 156.25, 158.4167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-150', 'Tenggara Barat Islands', 'YB9', 327, 8, 9.166667, 115.75, 119.3667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-151', 'Tenggara Timur Islands', 'YB9', 327, 7.666667, 10.91667, 118.8333, 125.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-152', 'Tubuai Island', 'FO', 508, 23.25, 23.46667, -149.3667, -149.5333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-153', 'PNG\'s Coastal Islands South', 'P2', 163, 7.5, 9.333333, 141, 146.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-154', 'WA State (N Coast) East group', 'VK6', 150, 13.5, 15.33333, 125.8833, 129, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-155', 'West Chuuk group', 'V6', 173, -6.583333, -9.083333, 149, 150.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-156', 'Yasawa Group', '3D2', 176, 16.58333, 17.41667, 176.8333, 177.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-157', 'Banda Islands', 'YB8', 327, 4.333333, 4.666667, 129.5833, 130.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-158', 'Florida Islands', 'H4', 185, 8.833333, 9.25, 159.9667, 160.4667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-159', 'Mangaia Island', 'E5', 234, 21.75, 22.08333, -157.75, -158.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-160', 'QLD State (S Coast) North group', 'VK4', 150, 19.95, 23, 148.1667, 152.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-161', 'Nias & Batu Islands', 'YB6', 327, -1.75, .9, 97, 98.9, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-162', 'Shortland Islands', 'H4', 185, 6.633333, 7.466667, 155.5, 156.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-163', 'Vanikolo & Utupua Islands', 'H40', 507, 11, 11.83333, 166.3333, 167.0333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-164', 'WA State (SW Coast) South group', 'VK6', 150, 31.25, 34.25, 114.8333, 115.7, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-165', 'Sarawak\'s Coastal Islands', '9M8', 46, -1.5, -5.083333, 109.65, 115.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-166', 'Kalimantan\'s Coastal Islands East', 'YB7', 327, -4.133333, 4.25, 114.4, 119.1, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-167', 'Kapingamarangi Atoll', 'V6', 173, -1, -1.116667, 154.7333, 154.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-168', 'Russell Islands', 'H4', 185, 8.916667, 9.216666, 158.6667, 159.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-169', 'Ha\'apai Group', 'A3', 160, 19.5, 20.66667, -174.1667, -175.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-170', 'WA State (S Coast) East Centre group', 'VK6', 150, 32.9, 34.66667, 121.25, 124.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-171', 'QLD State (N Coast) South group', 'VK4', 150, 17.5, 19.95, 146, 148.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-172', 'QLD State (N Coast) Centre group', 'VK4', 150, 15, 17.5, 145.2333, 147, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-173', 'NT (Arafura Sea Coast) West group', 'VK8', 150, 11, 15.16667, 129, 131.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-174', 'Tawi Tawi Group', 'DU8', 375, -4.383333, -5.483333, 119.25, 120.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-175', 'Sarangani Islands', 'DU9', 375, -5.333333, -5.533333, 125.25, 125.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-176', 'Chesterfield Islands', 'FK', 512, 18.83333, 21.5, 158.1667, 159.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-177', 'Seribu Islands', 'YB0', 327, 5.25, 5.75, 106.3333, 106.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-178', 'Tikopia & Anuta Islands', 'H40', 507, 11.5, 12.5, 168.75, 170.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-179', 'Duff Islands', 'H40', 507, 9.75, 10.08333, 167, 167.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-180', 'Ngulu Atoll', 'V6', 173, -8.25, -8.75, 137.25, 137.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-181', 'Witu Islands', 'P2', 163, 4.5, 5, 149, 149.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-182', 'Ducie Island', 'VP6', 513, 24.6, 24.73333, -124.7333, -124.8667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-183', 'WA State (SW Coast) Centre group', 'VK6', 150, 27.25, 31.25, 113.9833, 115.4167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-184', 'Brunei\'s Coastal Islands', 'V8', 345, -4.6, -5.166667, 114.1, 115.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-185', 'NT (Arafura Sea Coast) East group', 'VK8', 150, 11, 13, 134.5, 137.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-186', 'Karimunjawa Islands', 'YB2', 327, 5.666667, 6, 110, 110.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-187', 'QLD State (N Coast) North group', 'VK4', 150, 10.83333, 15, 142.6167, 146, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-188', 'Pangutaran Group', 'DU8', 375, -5.483333, -6.583333, 119.5833, 121.0833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-189', 'Ringgold Isles', '3D2', 176, 15.91667, 16.71667, -179.0833, -179.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-190', 'Rose Atoll', 'KH8', 9, 14.41667, 14.58333, -168.1333, -168.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-191', 'Niuatoputapu Island', 'A3', 160, 15.8, 16, -173.6667, -173.8, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-192', 'Ontong Java Atoll', 'H4', 185, 5, 5.666667, 159, 159.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-193', 'WA State (S Coast) West Centre group', 'VK6', 150, 33.8, 34.96667, 118.25, 121.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-194', 'NSW State North group', 'VK2', 150, 28.16667, 31.5, 152.8333, 153.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-195', 'Furneaux Group', 'VK7', 150, 39.2, 40.66667, 146.5, 148.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-196', 'VIC State East group', 'VK3', 150, 37.5, 38.53333, 147, 149.9167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-197', 'Bawean Island', 'YB3', 327, 5.666667, 6, 112.5, 112.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-198', 'NT (Gulf of Carpentaria) South group', 'VK8', 150, 15, 16.5, 135.6333, 138, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-199', 'WA State (NW Coast) Centre group', 'VK6', 150, 19.5, 21, 116, 120, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-200', 'Swains Island', 'KH8', 515, 11, 11.1, -171, -171.2, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-201', 'North Island\'s Coastal Islands', 'ZL', 170, 34.08333, 41.66667, 172, 178.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-202', 'Calagua Islands', 'DU4', 375, -14.31667, -14.55, 122.75, 123.0833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-203', 'South Island\'s Coastal Islands', 'ZL', 170, 40.46667, 47.5, 166.3833, 174.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-204', 'Enggano Island', 'YB4', 327, 5.166667, 5.666667, 102, 102.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-205', 'Woodlark group', 'P2', 163, 8.666667, 9.666667, 151.5, 153.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-206', 'WA State (SW Coast) North group', 'VK6', 150, 24.25, 27.25, 112.9167, 114.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-207', 'Cagayan Islands', 'DU1', 375, -8.666667, -9.75, 119.75, 121.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-208', 'Banggai Islands', 'YB8', 327, 1.083333, 2.333333, 122.75, 124.1, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-209', 'Talaud Islands', 'YB8', 327, -3.666667, -4.916667, 126.5, 127.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-210', 'Sangihe Islands', 'YB8', 327, -2, -4.833333, 125.0833, 125.9167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-211', 'Houtman Abrolhos', 'VK6', 150, 28.25, 29, 113.55, 114.15, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-212', 'NSW State Centre group', 'VK2', 150, 31.5, 34.5, 150.8667, 152.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-213', 'Togian Islands', 'YB8', 327, 6.666667E-02, .6166667, 121.5, 122.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-214', 'WA State (NW Coast) East group', 'VK6', 150, 16.33333, 19.95, 120, 122.95, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-215', 'Mentawai Islands', 'YB5', 327, .8333333, 4, 98.5, 101.0833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-216', 'Ashmore & Cartier Islands', 'VK9', 150, 12.13333, 12.63333, 123, 123.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-217', 'Kangean Islands', 'YB3', 327, 6.333333, 7.333333, 115.0833, 116.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-218', 'Matthew & Hunter Islands', 'FK', 162, 22.28333, 22.45, 171.25, 172.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-219', 'Tukangbesi Islands', 'YB8', 327, 5.166667, 6.25, 123.3333, 124.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-220', 'SA State West group', 'VK5', 150, 31.46667, 32.66667, 129, 133.9167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-221', 'Kai Islands', 'YB8', 327, 5, 6.166667, 131.8333, 133.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-222', 'Obi Islands', 'YB8', 327, 1.033333, 1.916667, 127.1667, 129, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-223', 'NSW State South group', 'VK2', 150, 34.5, 37.5, 149.9167, 150.8667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-224', 'Tanimbar Islands', 'YB8', 327, 6.583333, 8.416667, 130.5833, 132.0333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-225', 'Turtle Islands', 'DU8', 375, -6, -6.583333, 118, 118.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-226', 'Mwokil (Mokil) & Pingelap Atolls', 'V6', 173, -6.16, -6.7, 159.75, 160.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-227', 'QLD State (Gulf of Carpentaria) South group', 'VK4', 150, 16.25, 17.71667, 138, 141, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-228', 'SA State East group', 'VK5', 150, 35.51667, 38.08333, 138.5, 140.9667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-229', 'NT (Arafura Sea Coast) Centre group', 'VK8', 150, 11, 12.3, 131.6667, 134.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-230', 'Rowley Shoals, WA Outliers', 'VK', 150, 16.9, 17.8, 118.75, 119.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-231', 'Green Islands', 'P2', 163, 4.25, 4.666667, 154, 154.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-232', 'East Timor\'s Coastal Islands', '4W', 511, 8.083333, 9.5, 124.0833, 127.4167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-233', 'Tasmania\'s Coastal Islands', 'VK7', 150, 39.5, 43.75, 144.5, 148.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-234', 'Browse Island, WA Outliers', 'VK', 150, 14, 14.13333, 123.45, 123.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-235', 'Mindanao\'s Coastal Islands', 'DU8-9', 375, -5.533333, -10.5, 121.3333, 126.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-236', 'Celebes\'s Coastal Islands', 'YB8', 327, -2, 6.75, 116.5, 125.45, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-237', 'Java\'s Coastal Islands', 'YB0-3', 327, 5.75, 8.916667, 105.0833, 114.8333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-238', 'Pukarua & Reao Atolls', 'FO', 175, 18.16667, 18.75, -136.3167, -137.0833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-239', 'Irian Jaya\'s Coastal Islands West', 'YB9', 327, -1.166667, 4.4, 129.25, 134, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-240', 'PNG\'s Coastal Islands East', 'P2', 163, 5.75, 11, 146.75, 151.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-241', 'Timor Barat\'s Coastal Islands', 'YB9', 327, 8.916667, 11.16667, 122.5833, 125.1667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-242', 'Bonerate & Taka\' Bonerate Islands', 'YB8', 327, 6.333333, 7.583333, 120.5, 122.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-243', 'WA State (South Coast) West group', 'VK6', 150, 34.25, 35.25, 115, 118.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-244', 'Luzon\'s Coastal Islands', 'DU1-4', 375, -11.66667, -18.75, 119.6667, 124.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-245', 'Sumatra\'s Coastal Islands North', 'YB5-6', 327, 0, -6.1, 94.92, 103.92, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-246', 'Leti & Sermata Islands', 'YB8', 327, 8, 8.42, 127.42, 129.17, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-247', 'Sabalana & Tengah Islands', 'YB8', 327, 6.416667, 7.666667, 117.0833, 119.3333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-248', 'Sonsorol Islands group', 'T8', 22, -2.666667, -5.416667, 131, 132.4167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-249', 'Aru Islands', 'YB8', 327, 5.25, 7.166667, 134, 135, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-250', 'Masalembu Islands', 'YB3', 327, 5.333333, 5.666667, 114.3333, 114.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-251', 'VIC State West group', 'VK3', 150, 38.08333, 38.91667, 140.9667, 144, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-252', 'Kalimantan\'s Coastal Islands West', 'YB7', 327, -2.166667, 3.6, 108, 114.4, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-253', 'Hall Islands', 'V6', 173, -8.333333, -8.833333, 151.25, 152.4167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-254', 'Mortlock Islands', 'V6', 173, -5.1, -6.033333, 153, 154, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-255', 'QLD State (Gulf of Carpentaria) North group', 'VK4', 150, 10.83333, 14, 141, 142.3833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-256', 'Kilinailau (Tulun) Islands', 'P2', 163, 4.583333, 4.916667, 155.1667, 155.5833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-257', 'Nuguria Islands', 'P2', 163, 3.333333, 3.666667, 154.75, 154.9167, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-258', 'PNG\'s Coastal Islands North', 'P2', 163, 2.583333, 5.75, 141, 146.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-259', 'Nukuoro Atoll', 'V6', 173, -3.783333, -3.916667, 154.9167, 155.0333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-260', 'Oroluk Atoll', 'V6', 173, -7.466667, -7.6, 155.2333, 155.3667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-261', 'SA State West Centre group', 'VK5', 150, 32.45, 35, 133.9167, 135.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-262', 'Sumatra\'s Coastal Islands South', 'YB4-5', 327, 0, 6.166667, 99.66666, 106.1333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-263', 'Taongi Atoll (aka Bokaak Atoll)', 'V7', 168, -14.41667, -14.75, 168.8, 169.1333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-264', 'Maria Island', 'FO', 508, 21.71667, 21.88333, -154.6, -154.7667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-265', 'Coral Sea Islands Territory South', 'VK9', 150, 20.5, 23.5, 153.25, 156, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-266', 'Western Australia State (N Coast) Centre Grp', 'VK6', 150, 13.75, 16.43333, 124, 125.8833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-001', 'Easter Island', 'CE0', 47, 27, 27.25, -109.0833, -109.6667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-002', 'Falkland Islands', 'VP8', 141, 50.83333, 53.16667, -57, -62, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-003', 'Fernando De Noronha Archipelago', 'PY0F', 56, 3.783333, 3.883333, -32.33333, -32.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-004', 'Galapagos Islands', 'HC8', 71, -1.833333, 1.66, -89, -92.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-005', ' Juan Fernandez Archipelago (Robinson Crusoe Island)', 'CE0', 125, 33.5, 33.83, -78.66666, -79.08, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-006', 'Bonaire Island', 'PJ4', 520, -11.98333, -12.53333, -68.08334, -68.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-007', 'Malpelo Island', 'HK0', 161, -3.95, -4.033333, -81.5, -81.66666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-008', 'Tierra Del Fuego', 'LU,CE8', NULL, 52.41667, 55.05, -65, -72.16666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-009', 'Tobago Island', '9Y', 90, -11.08333, -11.41667, -60.41667, -60.91667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-010', 'Trindade & Martin Vaz Islands', 'PY0T', 273, 20.45, 20.56667, -28.75, -29.41667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-011', 'Trinidad Island', '9Y', 90, -10, -10.91667, -60.83333, -62, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-012', 'Nueva Esparta State group', 'YV7', 148, -10.71667, -11.18333, -63.76667, -64.41666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-013', 'San Felix & San Ambrosio Islands', 'CE0', 217, 26.16667, 26.41667, -79.83334, -80.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-014', 'St Peter & St Paul Rocks', 'PY0S', 253, -.9166667, -.95, -29.35, -29.38333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-015', 'Los Monjes Archipelago', 'YV5', 148, -12.25, -12.66667, -70.66666, -71, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-016', 'Maranhao State Centre group', 'PR8', 108, 2.2, 2.833333, -43, -44.41667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-017', 'Cauca / Valle Division group', 'HK5', 116, -2.666667, -4.066667, -77.11667, -78, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-018', 'Los Lagos Region South group', 'CE7', 112, 40.91667, 43.68333, -72.5, -75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-019', 'Abrolhos Archipelago', 'PY6', 108, 17.88333, 18.06667, -38.6, -38.73333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-020', 'French Guiana group', 'FY', 63, -4.133333, -5.8, -51.61666, -54, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-021', 'Buenos Aires (Bahia Blanca) Province group', 'LU', 100, 38.78333, 39.5, -61, -62.4, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-022', 'Buenos Aires (Bahia Anegada) Province group', 'LU', 100, 39.5, 41.03333, -62, -62.8, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-023', 'Bahia State North group', 'PY6', 108, 11.46667, 13.25, -37.28333, -38.86666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-024', 'Sao Paulo State West group', 'PY2', 108, 24.41667, 25.28333, -47, -48.03333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-025', 'Piaui State group', 'PS8', 108, 2.716667, 2.933333, -41.3, -41.9, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-026', 'Santa Catarina State Centre group', 'PP5', 108, 27.33333, 28, -48.28333, -48.65, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-027', 'Santa Catarina State North group', 'PP5', 108, 26, 27.33333, -48.28333, -48.7, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-028', 'Sao Paulo State East group', 'PY2', 108, 23.35, 24, -44.71667, -45.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-029', 'Rio De Janeiro State West group', 'PY1', 108, 22.91667, 23.41667, -43.56667, -44.71667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-030', 'San Jose / Montevideo / Canelones Dept group', 'CX', 144, 34.46667, 35, -55.4, -57.13334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-031', 'Wollaston & Hermite Islands', 'CE9', 112, 55.35, 56, -66.66666, -67.91666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-032', 'Ultima Esperanza Province North group', 'CE8', 112, 48.6, 51.63334, -73.66666, -75.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-033', 'Manabi Province group', 'HC4', 120, -.35, 1.6, -80.01, -81.1, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-034', 'Guayas / El Oro Province group', 'HC2,3', 120, 1.666667, 3.4, -79.7, -81.03333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-035', 'Los Roques Islands', 'YV5', 148, -11.66667, -12, -66.5, -67, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-036', 'Aruba Island', 'P4', 91, -12.33333, -12.75, -69.83334, -70.1, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-037', 'Blanquilla group', 'YV5', 148, -11.66667, -12, -64.25, -64.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-038', 'Atol Das Rocas', 'PY0R', 56, 3.783333, 3.883333, -33.75, -33.91667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-039', 'Maldonado / Rocha Department group', 'CX', 144, 33.75, 35.1, -53.36666, -55.4, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-040', 'Bolivar / Atlantico Division group', 'HK1', 116, -10.11667, -11.13333, -74.83334, -75.83334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-041', 'Maranhao State West group', 'PR8', 108, 1, 3.05, -44.41667, -46.05, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-042', 'Para State West group', 'PY8', 108, -.6666667, .6, -49.25, -52, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-043', 'Aisen Region North group', 'CE7', 112, 43.68333, 45, -72.66666, -75.33334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-044', 'La Tortuga Island', 'YV5', 148, -10.85, -11.08333, -65.08334, -65.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-045', 'Amapa State group', 'PQ8', 108, 4.45, .5, -49.9, -51.6, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-046', 'Pernambuco State group', 'PY7', 108, 7.5, 8.866667, -34.63334, -35.06667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-047', 'Parana State group', 'PY5', 108, 25.28333, 26, -48.03333, -48.66667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-048', 'Sucre State East group', 'YV7', 148, -10.2, -10.76667, -61.83333, -63.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-049', 'Tierra Del Fuego\'s Coastal Islands', 'LU', 100, 52.66667, 55.05, -63.58333, -68.58334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-050', 'Antartica Chilena Province group', 'CE9', 112, 54.08333, 55.91667, -66.33334, -72.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-051', 'Las Aves Islands', 'YV5', 148, -11.83333, -12.16667, -67.33334, -67.83334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-052', 'Lima Department group', 'OA4', 136, 10.63333, 13.3, -76.2, -77.91666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-053', 'Aisen Region South group', 'CE7', 112, 46.66667, 48.83333, -74, -75.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-054', 'Orchila Island', 'YV5', 148, -11.66667, -12, -66, -66.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-055', 'Buenos Aires (Delta Del Parana) Prov group', 'LU', 100, 33.91667, 34.5, -58.23333, -58.53333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-056', 'Esmeraldas Province group', 'HC4', 120, -.35, -1.416667, -78.83334, -80.11667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-057', 'Colonia Department group', 'CX', 144, 33.91667, 34.5, -57.13334, -58.41667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-058', 'Carabobo / Aragua / DF / Miranda State group', 'YV4,5', 148, -10.16667, -10.85, -65.41666, -68.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-059', 'Los Testigos group', 'YV5', 148, -11.18333, -11.5, -62.96667, -63.76667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-060', 'Para State East group', 'PY8', 108, .05, 1.583333, -46.05, -49.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-061', 'La Araucania Reg / Los Lagos Reg North group', 'CE6', 112, 38.4, 40.91667, -73.33334, -74, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-062', 'Bahia State South group', 'PY6', 108, 16, 18.33333, -38.85, -39.63334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-063', 'Monagas / Delta Amacuro State group', 'YV8', 148, -8.383333, -10.2, -59.83333, -62.58333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-064', 'Aisen Region Centre group', 'CE7', 112, 45, 46.66667, -73.33334, -75.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-065', 'Chubut Province South group', 'LU', 100, 44, 46, -65.08334, -67.55, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-066', 'Zulia State group', 'YV1', 148, -10.8, -11.83333, -71.25, -71.93333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-067', 'Espirito Santo State group', 'PP1', 108, 18.33333, 21.3, -39.63334, -40.95, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-068', 'Guyana group', '8R', 129, -5.816667, -8.45, -57.16667, -59.83333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-069', 'Antofagasta Region group', 'CE1', 112, 21.48333, 26.06667, -70.03333, -70.86667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-070', 'Bio-Bio Region group', 'CE5', 112, 36.05, 38.4, -72.83334, -73.83334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-071', 'Sao Paulo State Centre group', 'PY2', 108, 23.78333, 24.5, -45.5, -47, 'H', 'Santo Amaro Is. Ineligible');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-072', 'Maranhao State East group', 'PR8', 108, 2.45, 2.833333, -41.9, -43, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-073', 'Ica Department group', 'OA5', 136, 13.3, 15.41667, -75.06667, -76.2, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-074', 'Ancash Department group', 'OA3', 136, 8.966666, 10.63333, -77.91666, -78.76667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-075', 'La Libertad Department group', 'OA2', 136, 7.166667, 8.966666, -78.66666, -79.75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-076', 'Tumbes / Piura / Lambayeque Department group', 'OA1', 136, 3.4, 7.166667, -79.75, -81.4, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-077', 'Rio De Janeiro State East group', 'PY1', 108, 21.3, 23.03333, -40.95, -42.16667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-078', 'Cordoba / Sucre Division group', 'HK1', 116, -8.883333, -10.11667, -75.56667, -76.43333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-079', 'Rio De Janeiro State Centre group', 'PY1', 108, 22.91667, 23.16667, -42.16667, -43.56667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-080', 'Bahia State Centre group', 'PY6', 108, 13.25, 16, -38.76667, -39.01667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-081', 'Narino Division group', 'HK8', 116, -1.416667, -2.716667, -78, -79.11667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-082', 'Magdalena / Guajira Division group', 'HK2', 116, -10.93333, -12.5, -71, -74.83334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-083', 'Salas y Gomez Island', 'CE0', 47, 26.45, 26.46667, -105.4167, -105.4833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-084', 'Choco Division South group', 'HK4', 116, -4.066667, -7.2, -77.23333, -77.9, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-085', 'Atacama Region group', 'CE1', 112, 26.06667, 29.13333, -70.66666, -71.68333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-086', 'Coquimbo / Valparaiso Region group', 'CE2', 112, 29.13333, 33.83333, -71.33334, -71.86667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-087', 'Santa Cruz Province North group', 'LU', 100, 46, 49, -65.58334, -67.58334, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-088', 'Santa Catarina State South group', 'PP5', 108, 28, 29.3, -48.58333, -49.7, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-089', 'Falcon State group', 'YV1', 148, -10.56667, -12.25, -68.13333, -71.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-090', 'Anzoategui State / Sucre State West group', 'YV5-7', 148, -10.05, -10.71667, -63.75, -65.41666, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-091', 'Magallanes Province group', 'CE8', 112, 52.61666, 54.5, -70.16666, -75, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-092', 'Suriname group', 'PZ', 140, -5.633333, -6.016667, -53.98333, -57.16667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-093', 'Choco Division North / Antioquia Division group', 'HK4', 116, -7.933333, -8.883333, -76.43333, -77.36667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-094', 'Ultima Esperanza Province South group', 'CE8', 112, 51.6, 52.8, -73.6, -75.35, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-268', 'Laut Kecil Islands', 'YB7', 327, 4.25, 5.25, 114.5, 116.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-097', 'Mediterranean Sea Coast Centre Group', '7X', 400, -36.5, -37, 1.6, 5.4, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-171', 'Sri Lanka\'s Coastal Islands', '4S', 315, -5.85, -10, 79.5, 82, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-172', 'Sea of Okhotsk Coast North Group', 'R0C', 15, -56, -59.5, 137.5, 137.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-173', 'Tamil Nadu State Group', 'VU', 324, -8, -13.5, 77.1, 80.4, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-267', 'Coral Sea Islands Territory North', 'VK9', 150, 16.4, 19.5, 148.1, 152.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-228', 'Caribbean Sea Coast North Group', 'YN', 86, -13.5, -15, -82.5, -83.55, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-101', 'Red Sea Coast North group', 'SU', 478, -26, -29.98, 32.3, 35, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-270', 'Simeulue and Banyak Islands', 'YB6', 327, 1.75, 3, 95.55, 97.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-102', 'Erongo / Hardap Region Group', 'V5', 464, 21.13, 24.95, 13.6, 14.85, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-103', 'Zambezia District Group', 'C9', 181, 16.85, 18.85, 36.3, 39.15, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-104', 'Mediterranean Sea Coast East Group', '7X', 400, -36.5, -37.25, 5.4, 8.7, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-105', 'Nyanga Province Group', 'TR', 420, 2.9, 3.95, 10.05, 11.13, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-106', 'Cote d\'Ivoire Group', 'TU', 428, -4.33, -5.2, -3.1, -7.6, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-107', 'Cuanza Sul / Benguela Province Group', 'D2', 401, 10.25, 13.35, 12.5, 13.5, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-108', 'Namibe Province Group', 'D2', 401, 13.6, 17.25, 11.5, 12.5, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-109', 'Nile Delta and Sinai Region Group', 'SU', 478, -31, -31.75, 29.7, 34.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-110', 'Red Sea Coast South Group', 'SU', 478, -23.15, -26, 34.3, 35.85, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-111', 'Liberia Group', 'EL', 434, -4.33, -6.9, -7.6, -11.5, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-112', 'Mediterranean Sea Coast Centre Group', '5A', 436, -30.3, -32.85, 16.1, 21.45, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-113', 'Mediterranean Sea Coast East Group', '5A', 436, -31.6, -33, 21.4, 25.15, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-114', 'Halaib Triangle Group', 'ST', 466, -22, -23.13, 35.66, 36.9, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-115', 'Red Sea State Group', 'ST', 466, -18, -22, 36.9, 38.6, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-246', 'Tamaulipas State Group', 'XE2', 50, -22.25, -25.95, -97, -97.85, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-295', 'Sebatik Island', '9M6,YB7', 0, -4, -4.28, 117.62, 117.95, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-099', 'Curacao', 'PJ2', 517, -11.98333, -12.53333, -68.736, -69.25, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-199', 'Andhra Pradesh State South group', 'VU', 324, 13.5, 16.25, 80.07, 81.28, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-118', 'Mediterranean Seacoast Group, Morocco', 'CN', 446, -34.98333, -35.93333, -2.216667, -6.25, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AF-119', 'Coetivy Island, Seychelles', 'S7', 379, 6.966667, 7.3, 56.13333, 56.41667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-200', 'Shikoku\'s Coastal Islands, Japan', 'JA5', 339, -32.66667, -34.58333, 132, 134.8667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-201', 'Sea of Marmara Islands, Turkey', 'TA', 390, -40.3, -41.06667, 26.16667, 29.51667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-202', 'Hawar Islands, Bahrain', 'A9', 304, -25.53333, -25.78333, 50.68333, 50.85, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-203', 'Shelikhova Bay group, Asiatic Russia', 'R0X', 15, -59, -62.68333, 159.6667, 165.0833, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-190', 'Viktoriya Island, Franz Josef Land', 'RI1FJ', 61, -80.08334, -80.2, 36.5, 37.16667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-191', 'Fericirii Island, Romania/Ukraine', 'YO, UR', NULL, -45.15, -45.21667, 29.75, 29.78333, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-247', 'Sint Maarten’s Coastal Islands', 'PJ7', 518, -18, -18.06667, -62.95, -63.16667, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-248', 'NWT (Melville Island) group, Canada', 'VE8, VY0', 1, -74.33334, -78.83334, -105, -123.5, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-296', 'Tobi and Helen Islands, Palau', 'T8', 22, -2.666667, -3.166667, 131, 132, NULL, NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-100', 'Arica and Parinacota/Tarapaca Region group, Chile', 'CE1', 112, 18.38333, 21.48333, -70.03333, -70.43333, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-204', 'Kuril\'skiye (Kuril) Islands North', 'R0F', 15, -46.66667, -51, 151.5, 156.333, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-205', 'Bering Sea Coast North', 'R0X', 15, -59.9, -61.81667, 170.3, 174.5, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('EU-192', 'Kataja', 'SM,OH', NULL, -65.68333, -65.71667, 24.1167, 24.183, 'P', 'Split Sovereignty SWE/FIN');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-249', 'Puerto Rico\'s Coastal Islands', 'KP3', 4, -17.8, -18.66667, -65.15, -68, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('NA-250', 'Yakutat County Group', 'KL', 6, -58.8, -60, -137.933, -141, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-297', 'Morane Atoll, Tuamotu Islands', 'FO', 175, 23.91667, 23.25, -137.083, -137.183, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-206', 'JA0,1,2,7 Honshu’s Coastal Islands East', 'JA0,1,2,7', 339, -33.7, -41.6, 136, 142.3, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('AS-207', ' Chukchi Sea Coast Centre group', 'R0K', 15, -68.13, -69.45, 178, 177, 'P', 'Kosa Dvukh Pilotov');");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-298', 'Tatakoto Atoll, Tuamotu Islands', 'FO', 175, 17.25, 17.41, -138.18, -138.58, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-299', ' Yap East group', 'V6', 173, -7.25, -8.25, 145.66, 147.75, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('OC-300', 'McKean and Nikumaroro Atolls', 'T31', 31, 2.5, 5, -173, -174.08, 'P', NULL);");
		$this->db->query("INSERT INTO `iota` (`Tag`, `Name`, `Prefix`, `DXCCID`, `Lat1`, `Lat2`, `Lon1`, `Lon2`, `Status`, `Notes`) VALUES ('SA-101', 'Alejandro Selkirk Island', 'CE0', 125, 33.58, 33.91, -80.58, -81, 'P', NULL);");




	}

	public function down(){
         $this->db->query("");

	}
}
