<?php

class DxccFlag
{

    // create an array
    private $dxccCodetoISOArray = array(
        '1' => "CA",
        '3' => "AF",
        '4' => "MP",
        '5' => "AX",
        '6' => "US",
        '7' => "AL",
        '9' => "AS",
        '10' => "FR",
        '11' => "IN",
        '12' => "AI",
        '13' => "AQ",
        '14' => "AM",
        '15' => "RU",
        '16' => "NZ",
        '17' => "VE",
        '18' => "AZ",
        '20' => "US",
        '21' => "ES",
        '22' => "PW",
        '24' => "BV",
        '27' => "BY",
        '29' => "ES",
        '31' => "KI",
        '32' => "ES",
        '33' => "GB",
        '34' => "NZ",
        '35' => "CX",
        '36' => "FR",
        '37' => "CR",
        '38' => "CC",
        '40' => "GR",
        '41' => "FR",
        '43' => "PR",
        '45' => "GR",
        '46' => "MY",
        '47' => "CL",
        '48' => "KI",
        '49' => "GQ",
        '50' => "MX",
        '51' => "ER",
        '52' => "EE",
        '53' => "ET",
        '54' => "RU",
        '56' => "BR",
        '60' => "BS",
        '61' => "RU",
        '62' => "BB",
        '63' => "GF",
        '64' => "BM",
        '65' => "VG",
        '66' => "BZ",
        '69' => "KY",
        '70' => "CU",
        '71' => "EC",
        '72' => "DO",
        '74' => "SV",
        '75' => "GE",
        '76' => "GT",
        '77' => "GD",
        '78' => "HT",
        '79' => "GP",
        '80' => "HN",
        '82' => "JM",
        '84' => "MQ",
        '85' => "AN",
        '86' => "NI",
        '88' => "PA",
        '89' => "TC",
        '90' => "TT",
        '91' => "AW",
        '94' => "AG",
        '95' => "DM",
        '96' => "MS",
        '97' => "LC",
        '98' => "VC",
        '99' => "FR",
        '100' => "AR",
        '103' => "GU",
        '104' => "BO",
        '105' => "US",
        '106' => "GG",
        '107' => "GN",
        '108' => "BR",
        '109' => "GW",
        '110' => "US",
        '111' => "HM",
        '112' => "CL",
        '114' => "IM",
        '116' => "CO",
        '117' => "CH",
        '118' => "SJ",
        '120' => "EC",
        '122' => "JE",
        '123' => "US",
        '124' => "FR",
        '125' => "CL",
        '126' => "RU",
        '129' => "GY",
        '130' => "KZ",
        '131' => "FR",
        '132' => "PY",
        '133' => "NZ",
        '134' => "US",
        '135' => "KG",
        '136' => "PE",
        '137' => "KR",
        '138' => "US",
        '140' => "SR",
        '141' => "FK",
        '142' => "IN",
        '143' => "LA",
        '144' => "UY",
        '145' => "LV",
        '146' => "LT",
        '147' => "AU",
        '148' => "VE",
        '149' => "PT",
        '150' => "AU",
        '151' => "RU",
        '152' => "MO",
        '153' => "AU",
        '157' => "NR",
        '158' => "VU",
        '159' => "MV",
        '160' => "TO",
        '161' => "CO",
        '162' => "NC",
        '163' => "PG",
        '165' => "MU",
        '166' => "US",
        '167' => "SE",
        '168' => "MH",
        '169' => "YT",
        '170' => "NZ",
        '171' => "AU",
        '172' => "PN",
        '173' => "FM",
        '174' => "US",
        '175' => "PF",
        '176' => "FJ",
        '177' => "JP",
        '179' => "MD",
        '180' => "GR",
        '181' => "MZ",
        '182' => "US",
        '185' => "SB",
        '187' => "NE",
        '188' => "NU",
        '189' => "NF",
        '190' => "WS",
        '191' => "NZ",
        '192' => "JP",
        '195' => "GQ",
        '197' => "US",
        '199' => "NO",
        '201' => "ZA",
        '202' => "PR",
        '203' => "AD",
        '204' => "MX",
        '205' => "SH-AC",
        '206' => "AT",
        '207' => "MU",
        '209' => "BE",
        '211' => "CA",
        '212' => "BG",
        '213' => "FR",
        '214' => "FR",
        '215' => "CY",
        '216' => "NI",
        '217' => "CL",
        '219' => "ST",
        '221' => "DK",
        '222' => "FO",
        '223' => "GB-ENG",
        '224' => "FI",
        '225' => "IT",
        '227' => "FR",
        '230' => "DE",
        '232' => "SO",
        '233' => "GI",
        '234' => "GS",
        '235' => "GS",
        '236' => "GR",
        '237' => "GL",
        '238' => "GB",
        '239' => "HU",
        '240' => "GS",
        '241' => "GB",
        '242' => "IS",
        '245' => "IE",
        '246' => "MT",
        '247' => "PH",
        '248' => "IT",
        '249' => "KN",
        '250' => "SH-HL",
        '251' => "LI",
        '252' => "CA",
        '253' => "BR",
        '254' => "LU",
        '256' => "PT",
        '257' => "MT",
        '259' => "SJ",
        '260' => "MC",
        '262' => "TJ",
        '263' => "NL",
        '265' => "GB-NIR",
        '266' => "NO",
        '269' => "PL",
        '270' => "TK",
        '272' => "PT",
        '273' => "BR",
        '274' => "SH-TA",
        '275' => "RO",
        '276' => "FR",
        '277' => "CA",
        '278' => "SM",
        '279' => "GB-SCT",
        '280' => "TM",
        '281' => "ES",
        '282' => "TV",
        '283' => "CY",
        '284' => "SE",
        '285' => "VI",
        '286' => "UG",
        '287' => "CH",
        '288' => "UA",
        '289' => "UN",
        '291' => "US",
        '292' => "UZ",
        '293' => "VN",
        '294' => "GB-WLS",
        '295' => "VA",
        '296' => "RS",
        '297' => "US",
        '298' => "WF",
        '299' => "MY",
        '301' => "KI",
        '302' => "EH",
        '303' => "AU",
        '304' => "BH",
        '305' => "BD",
        '306' => "BT",
        '308' => "CR",
        '309' => "MM",
        '312' => "KH",
        '315' => "LK",
        '318' => "CN",
        '321' => "HK",
        '324' => "IN",
        '327' => "ID",
        '330' => "IR",
        '333' => "IQ",
        '336' => "IL",
        '339' => "JP",
        '342' => "JO",
        '344' => "KP",
        '345' => "BN",
        '348' => "KW",
        '354' => "LB",
        '363' => "MN",
        '369' => "NP",
        '370' => "OM",
        '372' => "PK",
        '375' => "PH",
        '376' => "QA",
        '378' => "SA",
        '379' => "SC",
        '381' => "SG",
        '382' => "DJ",
        '384' => "SY",
        '386' => "TW",
        '387' => "TH",
        '390' => "TR",
        '391' => "AE",
        '400' => "DZ",
        '401' => "AO",
        '402' => "BW",
        '404' => "BI",
        '406' => "CM",
        '408' => "CF",
        '409' => "CV",
        '410' => "TD",
        '411' => "KM",
        '412' => "CG",
        '414' => "CD",
        '416' => "BJ",
        '420' => "GA",
        '422' => "GM",
        '424' => "GH",
        '428' => "CI",
        '430' => "KE",
        '432' => "LS",
        '434' => "LR",
        '436' => "LY",
        '438' => "MG",
        '440' => "MW",
        '442' => "ML",
        '444' => "MR",
        '446' => "MA",
        '450' => "NG",
        '452' => "ZW",
        '453' => "RE",
        '454' => "RW",
        '456' => "SN",
        '458' => "SL",
        '460' => "FJ",
        '462' => "ZA",
        '464' => "NA",
        '466' => "SD",
        '468' => "SZ",
        '470' => "TZ",
        '474' => "TN",
        '478' => "EG",
        '480' => "BF",
        '482' => "ZM",
        '483' => "TG",
        '489' => "FJ",
        '490' => "KI",
        '492' => "YE",
        '497' => "HR",
        '499' => "SI",
        '501' => "BA",
        '502' => "MK",
        '503' => "CZ",
        '504' => "SK",
        '505' => "TW",
        '507' => "SB",
        '508' => "PF",
        '509' => "FR",
        '510' => "PS",
        '511' => "TL",
        '512' => "GB",
        '513' => "PN",
        '514' => "ME",
        '515' => "US",
        '517' => "AN",
        '519' => "AN",
        '521' => "SS",
        '1378' => "SA"
    );

    private $dxccFlags = array(
      '0' => "", // DXCC NONE
      '1' => "\u{1F1E8}\u{1F1E6}", // CANADA
      '2' => "", // ABU AIL IS
      '3' => "\u{1F1E6}\u{1F1EB}", // AFGHANISTAN
      '4' => "", // AGALEGA & ST BRANDON ISLANDS
      '5' => "\u{1F1E6}\u{1F1FD}", // ALAND ISLANDS
      '6' => "", // ALASKA
      '7' => "\u{1F1E6}\u{1F1F1}", // ALBANIA
      '8' => "", // ALDABRA
      '9' => "\u{1F1E6}\u{1F1F8}", // AMERICAN SAMOA
      '10' => "\u{1F1F9}\u{1F1EB}", // AMSTERDAM & ST PAUL ISLANDS
      '11' => "", // ANDAMAN & NICOBAR ISLANDS
      '12' => "\u{1F1E6}\u{1F1EE}", // ANGUILLA
      '13' => "\u{1F1E6}\u{1F1F6}", // ANTARCTICA
      '14' => "\u{1F1E6}\u{1F1F2}", // ARMENIA
      '15' => "\u{1F1F7}\u{1F1FA}", // ASIATIC RUSSIA
      '16' => "", // NEW ZEALAND SUBANTARCTIC ISLANDS
      '17' => "", // AVES ISLAND
      '18' => "\u{1F1E6}\u{1F1FF}", // AZERBAIJAN
      '19' => "", // BAJO NUEVO
      '20' => "", // BAKER HOWLAND ISLANDS
      '21' => "", // BALEARIC ISLANDS
      '22' => "\u{1F1F5}\u{1F1FC}", // PALAU
      '23' => "", // BLENHEIM REEF
      '24' => "\u{1F1E7}\u{1F1FB}", // BOUVET ISLAND
      '25' => "", // BRITISH NORTH BORNEO
      '26' => "", // BRITISH SOMALILAND
      '27' => "\u{1F1E7}\u{1F1FE}", // BELARUS
      '28' => "\u{1F1E8}\u{1F1FB}", // CANAL ZONE
      '29' => "", // CANARY ISLANDS
      '30' => "", // CELEBE & MOLUCCA ISLANDS
      '31' => "\u{1F1F0}\u{1F1EE}", // CENTRAL KIRIBATI
      '32' => "", // CEUTA & MELILLA
      '33' => "", // CHAGOS ISLANDS
      '34' => "", // CHATHAM ISLAND
      '35' => "\u{1F1E8}\u{1F1FD}", // CHRISTMAS ISLAND
      '36' => "", // CLIPPERTON ISLAND
      '37' => "", // COCOS ISLAND
      '38' => "\u{1F1E8}\u{1F1E8}", // COCOS (KEELING) ISLAND
      '39' => "", // COMORO ISLANDS
      '40' => "", // CRETE
      '41' => "\u{1F1F9}\u{1F1EB}", // CROZET ISLAND
      '42' => "", //"DAMAO, DIU"
      '43' => "", // DESECHEO ISLAND
      '44' => "", // DESROCHES
      '45' => "", // DODECANESE
      '46' => "", // EAST MALAYSIA
      '47' => "", // EASTER ISLAND
      '48' => "\u{1F1F0}\u{1F1EE}", // EASTERN KIRIBATI
      '49' => "\u{1F1EC}\u{1F1F6}", // EQUATORIAL GUINEA
      '50' => "\u{1F1F2}\u{1F1FD}", // MEXICO
      '51' => "\u{1F1EA}\u{1F1F7}", // ERITREA
      '52' => "\u{1F1EA}\u{1F1EA}", // ESTONIA
      '53' => "\u{1F1EA}\u{1F1F9}", // ETHIOPIA
      '54' => "\u{1F1F7}\u{1F1FA}", // EUROPEAN RUSSIA
      '55' => "", // FARQUHAR
      '56' => "", // FERNANDO DE NORONHA
      '57' => "", // FRENCH EQUATORIAL AFRICA
      '58' => "", // FRENCH INDO-CHINA
      '59' => "", // FRENCH WEST AFRICA
      '60' => "\u{1F1E7}\u{1F1F8}", // BAHAMAS
      '61' => "", // FRANZ JOSEF LAND
      '62' => "\u{1F1E7}\u{1F1E7}", // BARBADOS
      '63' => "\u{1F1EC}\u{1F1EB}", // FRENCH GUIANA
      '64' => "\u{1F1E7}\u{1F1F2}", // BERMUDA
      '65' => "\u{1F1FB}\u{1F1EC}", // BRITISH VIRGIN ISLANDS
      '66' => "\u{1F1E7}\u{1F1FF}", // BELIZE
      '67' => "", // FRENCH INDIA
      '68' => "", // KUWAIT/SAUDI ARABIA NEUT. ZONE
      '69' => "\u{1F1F0}\u{1F1FE}", // CAYMAN ISLANDS
      '70' => "\u{1F1E8}\u{1F1FA}", // CUBA
      '71' => "", // GALAPAGOS ISLANDS
      '72' => "\u{1F1E9}\u{1F1F4}", // DOMINICAN REPUBLIC
      '74' => "\u{1F1F8}\u{1F1FB}", // EL SALVADOR
      '75' => "\u{1F1EC}\u{1F1EA}", // GEORGIA
      '76' => "\u{1F1EC}\u{1F1F9}", // GUATEMALA
      '77' => "\u{1F1EC}\u{1F1E9}", // GRENADA
      '78' => "\u{1F1ED}\u{1F1F9}", // HAITI
      '79' => "\u{1F1EC}\u{1F1F5}", // GUADELOUPE
      '80' => "\u{1F1ED}\u{1F1F3}", // HONDURAS
      '81' => "", // GERMANY
      '82' => "\u{1F1EF}\u{1F1F2}", // JAMAICA
      '84' => "\u{1F1F2}\u{1F1F6}", // MARTINIQUE
      '85' => "", //"BONAIRE, CURACAO (NETH ANTILLES)"
      '86' => "\u{1F1F3}\u{1F1EE}", // NICARAGUA
      '88' => "\u{1F1F5}\u{1F1E6}", // PANAMA
      '89' => "\u{1F1F9}\u{1F1E8}", // TURKS & CAICOS ISLANDS
      '90' => "\u{1F1F9}\u{1F1F9}", // TRINIDAD & TOBAGO
      '91' => "\u{1F1E6}\u{1F1FC}", // ARUBA
      '93' => "", // GEYSER REEF
      '94' => "\u{1F1E6}\u{1F1EC}", // ANTIGUA & BARBUDA
      '95' => "\u{1F1E9}\u{1F1F2}", // DOMINICA
      '96' => "\u{1F1F2}\u{1F1F8}", // MONTSERRAT
      '97' => "\u{1F1F1}\u{1F1E8}", // SAINT LUCIA
      '98' => "\u{1F1FB}\u{1F1E8}", // SAINT VINCENT
      '99' => "", // GLORIOSO ISLAND
      '100' => "\u{1F1E6}\u{1F1F7}", // ARGENTINA
      '101' => "", // GOA
      '102' => "", // GOLD COAST TOGOLAND
      '103' => "\u{1F1EC}\u{1F1FA}", // GUAM
      '104' => "\u{1F1E7}\u{1F1F4}", // BOLIVIA
      '105' => "", // GUANTANAMO BAY
      '106' => "\u{1F1EC}\u{1F1EC}", // GUERNSEY
      '107' => "\u{1F1EC}\u{1F1F3}", // GUINEA
      '108' => "\u{1F1E7}\u{1F1F7}", // BRAZIL
      '109' => "\u{1F1EC}\u{1F1FC}", // GUINEA-BISSAU
      '110' => "", // HAWAII
      '111' => "\u{1F1ED}\u{1F1F2}", // HEARD ISLAND
      '112' => "\u{1F1E8}\u{1F1F1}", // CHILE
      '113' => "", // IFNI
      '114' => "\u{1F1EE}\u{1F1F2}", // ISLE OF MAN
      '115' => "", // ITALIAN SOMALI
      '116' => "\u{1F1E8}\u{1F1F4}", // COLOMBIA
      '117' => "", // ITU HQ
      '118' => "", // JAN MAYEN
      '119' => "", // JAVA
      '120' => "\u{1F1EA}\u{1F1E8}", // ECUADOR
      '122' => "\u{1F1EF}\u{1F1EA}", // JERSEY
      '123' => "", // JOHNSTON ISLAND
      '124' => "", //"JUAN DE NOVA, EUROPA"
      '125' => "", // JUAN FERNANDEZ ISLANDS
      '126' => "", // KALININGRAD
      '127' => "", // KAMARAN ISLANDS
      '128' => "", // KARELO-FINN REP
      '129' => "\u{1F1EC}\u{1F1FE}", // GUYANA
      '130' => "\u{1F1F0}\u{1F1FF}", // KAZAKHSTAN
      '131' => "\u{1F1F9}\u{1F1EB}", // KERGUELEN ISLAND
      '132' => "\u{1F1F5}\u{1F1FE}", // PARAGUAY
      '133' => "", // KERMADEC ISLAND
      '134' => "", // KINGMAN REEF
      '135' => "\u{1F1F0}\u{1F1EC}", // KYRGYZSTAN
      '136' => "\u{1F1F5}\u{1F1EA}", // PERU
      '137' => "\u{1F1F0}\u{1F1F7}", // REPUBLIC OF KOREA
      '138' => "", // KURE ISLAND
      '139' => "", // KURIA MURIA ISLAND
      '140' => "", // SURINAME
      '141' => "\u{1F1EB}\u{1F1F0}", // FALKLAND ISLANDS
      '142' => "", // LAKSHADWEEP ISLANDS
      '143' => "\u{1F1F1}\u{1F1E6}", // LAOS
      '144' => "\u{1F1FA}\u{1F1FE}", // URUGUAY
      '145' => "\u{1F1F1}\u{1F1FB}", // LATVIA
      '146' => "\u{1F1F1}\u{1F1F9}", // LITHUANIA
      '147' => "", // LORD HOWE ISLAND
      '148' => "\u{1F1FB}\u{1F1EA}", // VENEZUELA
      '149' => "", // AZORES
      '150' => "\u{1F1E6}\u{1F1FA}", // AUSTRALIA
      '151' => "", // MALYJ VYSOTSKIJ ISLAND
      '152' => "\u{1F1F2}\u{1F1F4}", // MACAO
      '153' => "", // MACQUARIE ISLAND
      '154' => "", // YEMEN ARAB REPUBLIC
      '155' => "\u{1F1F2}\u{1F1FE}", // MALAYA
      '157' => "\u{1F1F3}\u{1F1F7}", // NAURU
      '158' => "\u{1F1FB}\u{1F1FA}", // VANUATU
      '159' => "\u{1F1F2}\u{1F1FB}", // MALDIVES
      '160' => "\u{1F1F9}\u{1F1F4}", // TONGA
      '161' => "", // MALPELO ISLAND
      '162' => "\u{1F1F3}\u{1F1E8}", // NEW CALEDONIA
      '163' => "\u{1F1F5}\u{1F1EC}", // PAPUA NEW GUINEA
      '164' => "", // MANCHURIA
      '165' => "\u{1F1F2}\u{1F1FA}", // MAURITIUS ISLAND
      '166' => "", // MARIANA ISLANDS
      '167' => "", // MARKET REEF
      '168' => "\u{1F1F2}\u{1F1ED}", // MARSHALL ISLANDS
      '169' => "\u{1F1FE}\u{1F1F9}", // MAYOTTE
      '170' => "\u{1F1F3}\u{1F1FF}", // NEW ZEALAND
      '171' => "", // MELLISH REEF
      '172' => "\u{1F1F5}\u{1F1F3}", // PITCAIRN ISLAND
      '173' => "\u{1F1EB}\u{1F1F2}", // MICRONESIA
      '174' => "", // MIDWAY ISLAND
      '175' => "\u{1F1F5}\u{1F1EB}", // FRENCH POLYNESIA
      '176' => "\u{1F1EB}\u{1F1EF}", // FIJI ISLANDS
      '177' => "", // MINAMI TORISHIMA
      '178' => "", // MINERVA REEF
      '179' => "\u{1F1F2}\u{1F1E9}", // MOLDOVA
      '180' => "", // MOUNT ATHOS
      '181' => "\u{1F1F2}\u{1F1FF}", // MOZAMBIQUE
      '182' => "", // NAVASSA ISLAND
      '183' => "", // NETHERLANDS BORNEO
      '184' => "", // NETHERLANDS NEW GUINEA
      '185' => "\u{1F1F8}\u{1F1E7}", // SOLOMON ISLANDS
      '186' => "", // NEWFOUNDLAND LABRADOR
      '187' => "\u{1F1F3}\u{1F1EA}", // NIGER
      '188' => "\u{1F1F3}\u{1F1FA}", // NIUE
      '189' => "\u{1F1F3}\u{1F1EB}", // NORFOLK ISLAND
      '190' => "\u{1F1FC}\u{1F1F8}", // SAMOA
      '191' => "\u{1F1E8}\u{1F1F0}", // NORTH COOK ISLANDS
      '192' => "", // OGASAWARA
      '193' => "", // OKINAWA
      '194' => "", // OKINO TORI-SHIMA
      '195' => "", // ANNOBON
      '196' => "", // PALESTINE (DELETED)
      '197' => "", // PALMYRA & JARVIS ISLANDS
      '198' => "", // PAPUA TERR
      '199' => "", // PETER 1 ISLAND
      '200' => "", // PORTUGUESE TIMOR
      '201' => "", // PRINCE EDWARD & MARION ISLANDS
      '202' => "\u{1F1F5}\u{1F1F7}", // PUERTO RICO
      '203' => "\u{1F1E6}\u{1F1E9}", // ANDORRA
      '204' => "", // REVILLAGIGEDO
      '205' => "", // ASCENSION ISLAND
      '206' => "\u{1F1E6}\u{1F1F9}", // AUSTRIA
      '207' => "", // RODRIGUEZ ISLAND
      '208' => "", // RUANDA-URUNDI
      '209' => "\u{1F1E7}\u{1F1EA}", // BELGIUM
      '210' => "", // SAAR
      '211' => "", // SABLE ISLAND
      '212' => "\u{1F1E7}\u{1F1EC}", // BULGARIA
      '213' => "\u{1F1F2}\u{1F1EB}", // SAINT MARTIN
      '214' => "", // CORSICA
      '215' => "\u{1F1E8}\u{1F1FE}", // CYPRUS
      '216' => "", // SAN ANDRES ISLAND
      '217' => "", // SAN FELIX ISLANDS
      '218' => "", // CZECHOSLOVAKIA
      '219' => "\u{1F1F8}\u{1F1F9}", // SAO TOME & PRINCIPE
      '220' => "", // SARAWAK
      '221' => "\u{1F1E9}\u{1F1F0}", // DENMARK
      '222' => "\u{1F1EB}\u{1F1F4}", // FAROE ISLANDS
      '223' => "\u{1F3F4}\u{E0067}\u{E0062}\u{E0065}\u{E006E}\u{E0067}\u{E007F}", // ENGLAND
      '224' => "\u{1F1EB}\u{1F1EE}", // FINLAND
      '225' => "", // SARDINIA
      '226' => "", // SAUDI ARABIA/IRAQ NEUT ZONE
      '227' => "\u{1F1EB}\u{1F1F7}", // FRANCE
      '228' => "", // SERRANA BANK & RONCADOR CAY
      '229' => "\u{1F1E9}\u{1F1EA}", // GERMAN DEMOCRATIC REPUBLIC
      '230' => "\u{1F1E9}\u{1F1EA}", // FEDERAL REPUBLIC OF GERMANY
      '231' => "", // SIKKIM
      '232' => "\u{1F1F8}\u{1F1F4}", // SOMALIA
      '233' => "\u{1F1EC}\u{1F1EE}", // GIBRALTAR
      '234' => "\u{1F1E8}\u{1F1F0}", // SOUTH COOK ISLANDS
      '235' => "\u{1F1EC}\u{1F1F8}", // SOUTH GEORGIA ISLAND
      '236' => "\u{1F1EC}\u{1F1F7}", // GREECE
      '237' => "\u{1F1EC}\u{1F1F1}", // GREENLAND
      '238' => "", // SOUTH ORKNEY ISLANDS
      '239' => "\u{1F1ED}\u{1F1FA}", // HUNGARY
      '240' => "", // SOUTH SANDWICH ISLANDS
      '241' => "", // SOUTH SHETLAND ISLANDS
      '242' => "\u{1F1EE}\u{1F1F8}", // ICELAND
      '243' => "", // PEOPLE'S DEM REP OF YEMEN
      '244' => "\u{1F1F8}\u{1F1F8}", // SOUTHERN SUDAN
      '245' => "\u{1F1EE}\u{1F1EA}", // IRELAND
      '246' => "", // SOV MILITARY ORDER OF MALTA
      '247' => "", // SPRATLY ISLANDS
      '248' => "\u{1F1EE}\u{1F1F9}", // ITALY
      '249' => "\u{1F1F0}\u{1F1F3}", // SAINT KITTS & NEVIS
      '250' => "\u{1F1F8}\u{1F1ED}", // SAINT HELENA
      '251' => "\u{1F1F1}\u{1F1EE}", // LIECHTENSTEIN
      '252' => "", // SAINT PAUL ISLAND
      '253' => "\u{1F1F5}\u{1F1F2}", // SAINT PETER AND PAUL ROCKS
      '254' => "\u{1F1F1}\u{1F1FA}", // LUXEMBOURG
      '255' => "", //"SINT MAARTEN, SABA, ST EUSTATIUS"
      '256' => "", // MADEIRA ISLANDS
      '257' => "\u{1F1F2}\u{1F1F9}", // MALTA
      '258' => "\u{1F1F8}\u{1F1F7}", // SUMATRA
      '259' => "\u{1F1F8}\u{1F1EF}", // SVALBARD
      '260' => "\u{1F1F2}\u{1F1E8}", // MONACO
      '261' => "", // SWAN ISLAND
      '262' => "\u{1F1F9}\u{1F1EF}", // TAJIKISTAN
      '263' => "\u{1F1F3}\u{1F1F1}", // NETHERLANDS
      '264' => "", // TANGIER
      '265' => "", // NORTHERN IRELAND
      '266' => "\u{1F1F3}\u{1F1F4}", // NORWAY
      '267' => "", // TERR NEW GUINEA
      '268' => "", // TIBET
      '269' => "\u{1F1F5}\u{1F1F1}", // POLAND
      '270' => "\u{1F1F9}\u{1F1F0}", // TOKELAU ISLANDS
      '271' => "", // TRIESTE
      '272' => "\u{1F1F5}\u{1F1F9}", // PORTUGAL
      '273' => "", // TRINDADE & MARTIM VAZ ISLANDS
      '274' => "", // TRISTAN DA CUNHA & GOUGH ISLANDS
      '275' => "\u{1F1F7}\u{1F1F4}", // ROMANIA
      '276' => "", // TROMELIN ISLAND
      '277' => "", // SAINT PIERRE & MIQUELON
      '278' => "\u{1F1F8}\u{1F1F2}", // SAN MARINO
      '279' => "\u{1F3F4}\u{E0067}\u{E0062}\u{E0073}\u{E0063}\u{E0074}\u{E007F}", // SCOTLAND
      '280' => "\u{1F1F9}\u{1F1F2}", // TURKMENISTAN
      '281' => "\u{1F1EA}\u{1F1F8}", // SPAIN
      '282' => "\u{1F1F9}\u{1F1FB}", // TUVALU
      '283' => "", // UK BASES ON CYPRUS
      '284' => "\u{1F1F8}\u{1F1EA}", // SWEDEN
      '285' => "\u{1F1FB}\u{1F1EE}", // US VIRGIN ISLANDS
      '286' => "\u{1F1FA}\u{1F1EC}", // UGANDA
      '287' => "\u{1F1E8}\u{1F1ED}", // SWITZERLAND
      '288' => "\u{1F1FA}\u{1F1E6}", // UKRAINE
      '289' => "", // UNITED NATIONS HQ
      '291' => "\u{1F1FA}\u{1F1F8}", // UNITED STATES OF AMERICA
      '292' => "\u{1F1FA}\u{1F1FF}", // UZBEKISTAN
      '293' => "\u{1F1FB}\u{1F1F3}", // VIET NAM
      '294' => "\u{1F3F4}\u{E0067}\u{E0062}\u{E0077}\u{E006C}\u{E0073}\u{E007F}", // WALES
      '295' => "\u{1F1FB}\u{1F1E6}", // VATICAN CITY
      '296' => "\u{1F1F7}\u{1F1F8}", // SERBIA
      '297' => "", // WAKE ISLAND
      '298' => "\u{1F1FC}\u{1F1EB}", // WALLIS & FUTUNA ISLANDS
      '299' => "", // WEST MALAYSIA
      '301' => "\u{1F1F0}\u{1F1EE}", // WESTERN KIRIBATI
      '302' => "\u{1F1EA}\u{1F1ED}", // WESTERN SAHARA
      '303' => "", // WILLIS ISLAND
      '304' => "\u{1F1E7}\u{1F1ED}", // BAHRAIN
      '305' => "\u{1F1E7}\u{1F1E9}", // BANGLADESH
      '306' => "\u{1F1E7}\u{1F1F9}", // BHUTAN
      '307' => "", // ZANZIBAR
      '308' => "\u{1F1E8}\u{1F1F7}", // COSTA RICA
      '309' => "\u{1F1F2}\u{1F1F2}", // MYANMAR
      '312' => "\u{1F1F0}\u{1F1ED}", // CAMBODIA
      '315' => "\u{1F1F1}\u{1F1F0}", // SRI LANKA
      '318' => "\u{1F1E8}\u{1F1F3}", // CHINA
      '321' => "\u{1F1ED}\u{1F1F0}", // HONG KONG
      '324' => "\u{1F1EE}\u{1F1F3}", // INDIA
      '327' => "\u{1F1EE}\u{1F1E9}", // INDONESIA
      '330' => "\u{1F1EE}\u{1F1F7}", // IRAN
      '333' => "\u{1F1EE}\u{1F1F6}", // IRAQ
      '336' => "\u{1F1EE}\u{1F1F1}", // ISRAEL
      '339' => "\u{1F1EF}\u{1F1F5}", // JAPAN
      '342' => "\u{1F1EF}\u{1F1F4}", // JORDAN
      '344' => "\u{1F1F0}\u{1F1F5}", // DPRK (NORTH KOREA)
      '345' => "\u{1F1E7}\u{1F1F3}", // BRUNEI
      '348' => "\u{1F1F0}\u{1F1FC}", // KUWAIT
      '354' => "\u{1F1F1}\u{1F1E7}", // LEBANON
      '363' => "\u{1F1F2}\u{1F1F3}", // MONGOLIA
      '369' => "\u{1F1F3}\u{1F1F5}", // NEPAL
      '370' => "\u{1F1F4}\u{1F1F2}", // OMAN
      '372' => "\u{1F1F5}\u{1F1F0}", // PAKISTAN
      '375' => "\u{1F1F5}\u{1F1ED}", // PHILIPPINES
      '376' => "\u{1F1F6}\u{1F1E6}", // QATAR
      '378' => "\u{1F1F8}\u{1F1E6}", // SAUDI ARABIA
      '379' => "\u{1F1F8}\u{1F1E8}", // SEYCHELLES ISLANDS
      '381' => "\u{1F1F8}\u{1F1EC}", // SINGAPORE
      '382' => "\u{1F1E9}\u{1F1EF}", // DJIBOUTI
      '384' => "\u{1F1F8}\u{1F1FE}", // SYRIA
      '386' => "\u{1F1F9}\u{1F1FC}", // TAIWAN
      '387' => "\u{1F1F9}\u{1F1ED}", // THAILAND
      '390' => "\u{1F1F9}\u{1F1F7}", // TURKEY
      '391' => "\u{1F1E6}\u{1F1EA}", // UNITED ARAB EMIRATES
      '400' => "\u{1F1E9}\u{1F1FF}", // ALGERIA
      '401' => "\u{1F1E6}\u{1F1F4}", // ANGOLA
      '402' => "\u{1F1E7}\u{1F1FC}", // BOTSWANA
      '404' => "\u{1F1E7}\u{1F1EE}", // BURUNDI
      '406' => "\u{1F1E8}\u{1F1F2}", // CAMEROON
      '408' => "\u{1F1E8}\u{1F1EB}", // CENTRAL AFRICAN REPUBLIC
      '409' => "", // CAPE VERDE
      '410' => "\u{1F1F9}\u{1F1E9}", // CHAD
      '411' => "\u{1F1F0}\u{1F1F2}", // COMOROS
      '412' => "\u{1F1E8}\u{1F1EC}", // REPUBLIC OF THE CONGO
      '414' => "\u{1F1E8}\u{1F1E9}", // DEM. REP. OF THE CONGO
      '416' => "\u{1F1E7}\u{1F1EF}", // BENIN
      '420' => "\u{1F1EC}\u{1F1E6}", // GABON
      '422' => "\u{1F1EC}\u{1F1F2}", // THE GAMBIA
      '424' => "\u{1F1EC}\u{1F1ED}", // GHANA
      '428' => "\u{1F1E8}\u{1F1EE}", // COTE D'IVOIRE
      '430' => "\u{1F1F0}\u{1F1EA}", // KENYA
      '432' => "\u{1F1F1}\u{1F1F8}", // LESOTHO
      '434' => "\u{1F1F1}\u{1F1F7}", // LIBERIA
      '436' => "\u{1F1F1}\u{1F1FE}", // LIBYA
      '438' => "\u{1F1F2}\u{1F1EC}", // MADAGASCAR
      '440' => "\u{1F1F2}\u{1F1FC}", // MALAWI
      '442' => "\u{1F1F2}\u{1F1F1}", // MALI
      '444' => "\u{1F1F2}\u{1F1F7}", // MAURITANIA
      '446' => "\u{1F1F2}\u{1F1E6}", // MOROCCO
      '450' => "\u{1F1F3}\u{1F1EC}", // NIGERIA
      '452' => "\u{1F1FF}\u{1F1FC}", // ZIMBABWE
      '453' => "\u{1F1F7}\u{1F1EA}", // REUNION ISLAND
      '454' => "\u{1F1F7}\u{1F1FC}", // RWANDA
      '456' => "\u{1F1F8}\u{1F1F3}", // SENEGAL
      '458' => "\u{1F1F8}\u{1F1F1}", // SIERRA LEONE
      '460' => "", // ROTUMA
      '462' => "\u{1F1FF}\u{1F1E6}", // REPUBLIC OF SOUTH AFRICA
      '464' => "\u{1F1F3}\u{1F1E6}", // NAMIBIA
      '466' => "\u{1F1F8}\u{1F1E9}", // SUDAN
      '468' => "\u{1F1F8}\u{1F1FF}", // KINGDOM OF ESWATINI
      '470' => "\u{1F1F9}\u{1F1FF}", // TANZANIA
      '474' => "\u{1F1F9}\u{1F1F3}", // TUNISIA
      '478' => "\u{1F1EA}\u{1F1EC}", // EGYPT
      '480' => "\u{1F1E7}\u{1F1EB}", // BURKINA FASO
      '482' => "\u{1F1FF}\u{1F1F2}", // ZAMBIA
      '483' => "\u{1F1F9}\u{1F1EC}", // TOGO
      '488' => "", // WALVIS BAY
      '489' => "", // CONWAY REEF
      '490' => "", // BANABA ISLAND
      '492' => "\u{1F1FE}\u{1F1EA}", // YEMEN
      '493' => "", // PENGUIN ISLANDS
      '497' => "\u{1F1ED}\u{1F1F7}", // CROATIA
      '499' => "\u{1F1F8}\u{1F1EE}", // SLOVENIA
      '501' => "\u{1F1E7}\u{1F1E6}", // BOSNIA-HERZEGOVINA
      '502' => "\u{1F1F2}\u{1F1F0}", // NORTH MACEDONIA
      '503' => "\u{1F1E8}\u{1F1FF}", // CZECH REPUBLIC
      '504' => "\u{1F1F8}\u{1F1F0}", // SLOVAK REPUBLIC
      '505' => "", // PRATAS ISLAND
      '506' => "", // SCARBOROUGH REEF
      '507' => "", // TEMOTU PROVINCE
      '508' => "", // AUSTRAL ISLANDS
      '509' => "", // MARQUESAS ISLANDS
      '510' => "\u{1F1F5}\u{1F1F8}", // PALESTINE
      '511' => "\u{1F1F9}\u{1F1F1}", // TIMOR-LESTE
      '512' => "", // CHESTERFIELD ISLANDS
      '513' => "", // DUCIE ISLAND
      '514' => "\u{1F1F2}\u{1F1EA}", // MONTENEGRO
      '515' => "", // SWAINS ISLAND
      '516' => "\u{1F1E7}\u{1F1F1}", // SAINT BARTHELEMY
      '517' => "\u{1F1E8}\u{1F1FC}", // CURACAO
      '518' => "\u{1F1F8}\u{1F1FD}", // SINT MAARTEN
      '519' => "", // SABA & ST EUSTATIUS
      '520' => "", // BONAIRE
      '521' => "", // REPUBLIC OF SOUTH SUDAN
      '522' => "\u{1F1FD}\u{1F1F0}" //REPUBLIC OF KOSOVO
    );

    public function get($dxcc)
    {
        if (!isset($this->dxccFlags[$dxcc])) {
            return null;
        } else {
            return $this->dxccFlags[$dxcc];
        }
    }

    public function getISO($dxccCode) {
        // Check if DXCC Code is in dxccCodetoISOArray
        if (!isset($this->dxccCodetoISOArray[$dxccCode])) {
            return "00";
        } else {
            return $this->dxccCodetoISOArray[$dxccCode];
        }
    }
}