# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html
#
import os
import sys
import importlib
from recommonmark.transform import AutoStructify

#################################################################################
package = 'xmlcli'
package_name = package

# use absolute path for relative directory
current_directory = os.path.abspath(os.path.dirname(__file__))
# make sure this version of package "wins" so that we get version correct
sys.path.insert(0, f"{current_directory}{os.sep}..")
sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.dirname(current_directory))))
# get version from our package, assumes we have _version file
mod = importlib.import_module(package)

# The version info for the project you're documenting
# The short X.Y version.
version = mod.__version__
# The full version, including alpha/beta/rc tags.
release = mod.__version__

#################################################################################

# -- Project information -----------------------------------------------------
project = 'XmlCli'
copyright = '2022, Intel'
author = 'Gahan Saraiya, Amol Shinde'

# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings.
# could be extensions with Sphinx (i.e. 'sphinx.ext.*') or custom ones.
extensions = [
  'sphinx.ext.autodoc',
  'sphinx.ext.viewcode',
  'sphinx.ext.napoleon',
  'sphinx.ext.coverage',
  'sphinx.ext.mathjax',
  'sphinx.ext.autosectionlabel',
  "recommonmark",
  "sphinx_markdown_tables"
]

# Prefix document path to section labels, otherwise autogenerated labels would look like 'heading'
# rather than 'path/to/file:heading'
autosectionlabel_prefix_document = True

# Napolean settings
napoleon_google_docstring              = True
napoleon_numpy_docstring               = True
napoleon_include_private_with_doc      = False
napoleon_include_special_with_doc      = True
napoleon_use_admonition_for_examples   = False
napoleon_use_admonition_for_notes      = False
napoleon_use_admonition_for_references = False
napoleon_use_ivar                      = False
napoleon_use_param                     = True
napoleon_use_rtype                     = True

# Add any relative paths that contain templates
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# List of directories, that should not be searched for source files.
exclude_trees = ['_build']

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
add_module_names = True

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# The encoding of source files.
source_encoding = 'utf-8'

# The master toctree document.
master_doc = 'index'


# HTML
html_theme = 'alabaster'
html_static_path = ['_static']
htmlhelp_basename = package_name

source_suffix = {
  '.rst': 'restructuredtext',
  '.md': 'markdown',
}

# LaTex
latex_paper_size = 'letter'
latex_font_size = '10pt'
latex_documents = [
  (master_doc, f'{package}.tex',
   f'{project} Documentation',
   'Saraiya, Gahan', 'manual'),
]

# man page
man_pages = [
  (master_doc, package_name,
   f'{project} Documentation',
   [author], 1)
]

# PDF
pdf_documents = [
  ('index', project, f'{project} Documentation', author),
]

# A comma-separated list of custom stylesheets. Example:
pdf_stylesheets = ['sphinx', 'kerning', 'a4']

# A list of folders to search for stylesheets. Example:
pdf_style_path = ['.', '_styles']

# How many levels deep should the table of contents be?
pdf_toc_depth = 9999

# Add section number to section references
pdf_use_numbered_links = False

# Background images fitting mode
pdf_fit_background_mode = 'scale'


def setup(app):
  app.add_config_value('recommonmark_config', {
    # 'url_resolver': lambda url: github_doc_root + url,
    'enable_auto_toc_tree': True,
    'auto_toc_tree_section': 'Contents',
    'enable_math': False,
    'enable_inline_math': False,
    'enable_eval_rst': True,
  }, True)
  app.add_transform(AutoStructify)
