/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.NetworkInfo;
import android.net.Uri;
import android.provider.ContactsContract;
import com.squareup.picasso.Action;
import com.squareup.picasso.AssetBitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.ContactsPhotoBitmapHunter;
import com.squareup.picasso.ContentStreamBitmapHunter;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.FileBitmapHunter;
import com.squareup.picasso.MediaStoreBitmapHunter;
import com.squareup.picasso.NetworkBitmapHunter;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.ResourceBitmapHunter;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Transformation;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

abstract class BitmapHunter
implements Runnable {
    private static final Object DECODE_LOCK = new Object();
    final Picasso picasso;
    final Dispatcher dispatcher;
    final Cache cache;
    final Stats stats;
    final String key;
    final Request data;
    final List<Action> actions;
    final boolean skipMemoryCache;
    Bitmap result;
    Future<?> future;
    Picasso.LoadedFrom loadedFrom;
    Exception exception;
    int exifRotation;

    BitmapHunter(Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        this.picasso = picasso;
        this.dispatcher = dispatcher;
        this.cache = cache;
        this.stats = stats;
        this.key = action.getKey();
        this.data = action.getData();
        this.skipMemoryCache = action.skipCache;
        this.actions = new ArrayList<Action>(4);
        this.attach(action);
    }

    protected void setExifRotation(int exifRotation) {
        this.exifRotation = exifRotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Thread.currentThread().setName("Picasso-" + this.data.getName());
            this.result = this.hunt();
            if (this.result == null) {
                this.dispatcher.dispatchFailed(this);
            } else {
                this.dispatcher.dispatchComplete(this);
            }
        }
        catch (Downloader.ResponseException e) {
            this.exception = e;
            this.dispatcher.dispatchFailed(this);
        }
        catch (IOException e) {
            this.exception = e;
            this.dispatcher.dispatchRetry(this);
        }
        catch (OutOfMemoryError e) {
            StringWriter writer = new StringWriter();
            this.stats.createSnapshot().dump(new PrintWriter(writer));
            this.exception = new RuntimeException(writer.toString(), e);
            this.dispatcher.dispatchFailed(this);
        }
        catch (Exception e) {
            this.exception = e;
            this.dispatcher.dispatchFailed(this);
        }
        finally {
            Thread.currentThread().setName("Picasso-Idle");
        }
    }

    abstract Bitmap decode(Request var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap hunt() throws IOException {
        Bitmap bitmap;
        if (!this.skipMemoryCache && (bitmap = this.cache.get(this.key)) != null) {
            this.stats.dispatchCacheHit();
            this.loadedFrom = Picasso.LoadedFrom.MEMORY;
            return bitmap;
        }
        bitmap = this.decode(this.data);
        if (bitmap != null) {
            this.stats.dispatchBitmapDecoded(bitmap);
            if (this.data.needsTransformation() || this.exifRotation != 0) {
                Object object = DECODE_LOCK;
                synchronized (object) {
                    if (this.data.needsMatrixTransform() || this.exifRotation != 0) {
                        bitmap = BitmapHunter.transformResult(this.data, bitmap, this.exifRotation);
                    }
                    if (this.data.hasCustomTransformations()) {
                        bitmap = BitmapHunter.applyCustomTransformations(this.data.transformations, bitmap);
                    }
                }
                this.stats.dispatchBitmapTransformed(bitmap);
            }
        }
        return bitmap;
    }

    void attach(Action action) {
        this.actions.add(action);
    }

    void detach(Action action) {
        this.actions.remove(action);
    }

    boolean cancel() {
        return this.actions.isEmpty() && this.future != null && this.future.cancel(false);
    }

    boolean isCancelled() {
        return this.future != null && this.future.isCancelled();
    }

    boolean shouldSkipMemoryCache() {
        return this.skipMemoryCache;
    }

    boolean shouldRetry(boolean airplaneMode, NetworkInfo info) {
        return false;
    }

    Bitmap getResult() {
        return this.result;
    }

    String getKey() {
        return this.key;
    }

    Request getData() {
        return this.data;
    }

    List<Action> getActions() {
        return this.actions;
    }

    Exception getException() {
        return this.exception;
    }

    Picasso.LoadedFrom getLoadedFrom() {
        return this.loadedFrom;
    }

    static BitmapHunter forRequest(Context context, Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action, Downloader downloader) {
        if (action.getData().resourceId != 0) {
            return new ResourceBitmapHunter(context, picasso, dispatcher, cache, stats, action);
        }
        Uri uri = action.getData().uri;
        String scheme = uri.getScheme();
        if ("content".equals(scheme)) {
            if (ContactsContract.Contacts.CONTENT_URI.getHost().equals(uri.getHost()) && !uri.getPathSegments().contains("photo")) {
                return new ContactsPhotoBitmapHunter(context, picasso, dispatcher, cache, stats, action);
            }
            if ("media".equals(uri.getAuthority())) {
                return new MediaStoreBitmapHunter(context, picasso, dispatcher, cache, stats, action);
            }
            return new ContentStreamBitmapHunter(context, picasso, dispatcher, cache, stats, action);
        }
        if ("file".equals(scheme)) {
            if (!uri.getPathSegments().isEmpty() && "android_asset".equals(uri.getPathSegments().get(0))) {
                return new AssetBitmapHunter(context, picasso, dispatcher, cache, stats, action);
            }
            return new FileBitmapHunter(context, picasso, dispatcher, cache, stats, action);
        }
        if ("android.resource".equals(scheme)) {
            return new ResourceBitmapHunter(context, picasso, dispatcher, cache, stats, action);
        }
        return new NetworkBitmapHunter(picasso, dispatcher, cache, stats, action, downloader);
    }

    static BitmapFactory.Options createBitmapOptions(Request data) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        if (data.config != null) {
            options.inPreferredConfig = data.config;
        }
        return options;
    }

    static void calculateInSampleSize(int reqWidth, int reqHeight, BitmapFactory.Options options) {
        BitmapHunter.calculateInSampleSize(reqWidth, reqHeight, options.outWidth, options.outHeight, options);
    }

    static void calculateInSampleSize(int reqWidth, int reqHeight, int width, int height, BitmapFactory.Options options) {
        int sampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            sampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        options.inSampleSize = sampleSize;
        options.inJustDecodeBounds = false;
    }

    static Bitmap applyCustomTransformations(List<Transformation> transformations, Bitmap result) {
        int count = transformations.size();
        for (int i = 0; i < count; ++i) {
            final Transformation transformation = transformations.get(i);
            Bitmap newResult = transformation.transform(result);
            if (newResult == null) {
                final StringBuilder builder = new StringBuilder().append("Transformation ").append(transformation.key()).append(" returned null after ").append(i).append(" previous transformation(s).\n\nTransformation list:\n");
                for (Transformation t : transformations) {
                    builder.append(t.key()).append('\n');
                }
                Picasso.HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        throw new NullPointerException(builder.toString());
                    }
                });
                return null;
            }
            if (newResult == result && result.isRecycled()) {
                Picasso.HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        throw new IllegalStateException("Transformation " + transformation.key() + " returned input Bitmap but recycled it.");
                    }
                });
                return null;
            }
            if (newResult != result && !result.isRecycled()) {
                Picasso.HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        throw new IllegalStateException("Transformation " + transformation.key() + " mutated input Bitmap but failed to recycle the original.");
                    }
                });
                return null;
            }
            result = newResult;
        }
        return result;
    }

    static Bitmap transformResult(Request data, Bitmap result, int exifRotation) {
        Bitmap newResult;
        int inWidth = result.getWidth();
        int inHeight = result.getHeight();
        int drawX = 0;
        int drawY = 0;
        int drawWidth = inWidth;
        int drawHeight = inHeight;
        Matrix matrix = new Matrix();
        if (data.needsMatrixTransform()) {
            int targetWidth = data.targetWidth;
            int targetHeight = data.targetHeight;
            float targetRotation = data.rotationDegrees;
            if (targetRotation != 0.0f) {
                if (data.hasRotationPivot) {
                    matrix.setRotate(targetRotation, data.rotationPivotX, data.rotationPivotY);
                } else {
                    matrix.setRotate(targetRotation);
                }
            }
            if (data.centerCrop) {
                float scale;
                float widthRatio = (float)targetWidth / (float)inWidth;
                float heightRatio = (float)targetHeight / (float)inHeight;
                if (widthRatio > heightRatio) {
                    scale = widthRatio;
                    int newSize = (int)Math.ceil((float)inHeight * (heightRatio / widthRatio));
                    drawY = (inHeight - newSize) / 2;
                    drawHeight = newSize;
                } else {
                    scale = heightRatio;
                    int newSize = (int)Math.ceil((float)inWidth * (widthRatio / heightRatio));
                    drawX = (inWidth - newSize) / 2;
                    drawWidth = newSize;
                }
                matrix.preScale(scale, scale);
            } else if (data.centerInside) {
                float widthRatio = (float)targetWidth / (float)inWidth;
                float heightRatio = (float)targetHeight / (float)inHeight;
                float scale = widthRatio < heightRatio ? widthRatio : heightRatio;
                matrix.preScale(scale, scale);
            } else if (targetWidth != 0 && targetHeight != 0 && (targetWidth != inWidth || targetHeight != inHeight)) {
                float sx = (float)targetWidth / (float)inWidth;
                float sy = (float)targetHeight / (float)inHeight;
                matrix.preScale(sx, sy);
            }
        }
        if (exifRotation != 0) {
            matrix.preRotate((float)exifRotation);
        }
        if ((newResult = Bitmap.createBitmap((Bitmap)result, (int)drawX, (int)drawY, (int)drawWidth, (int)drawHeight, (Matrix)matrix, (boolean)true)) != result) {
            result.recycle();
            result = newResult;
        }
        return result;
    }
}

