# Contributing to Pretty Checkbox React

Thanks for your interest in contributing to the project! This project uses
[github issues](https://github.com/atomicpages/pretty-checkbox-react/issues) to
track all reports in a public manner.

The [Open Source Guides](https://opensource.guide/) website has a collection of
resources for individuals, communities, and companies who want to learn how to
run and contribute to an open source project. Contributors and people new to
open source alike will find the following guides especially useful:

- [How to Contribute to Open Source](https://opensource.guide/how-to-contribute/)
- [Building Welcoming Communities](https://opensource.guide/building-community/)

## Get Involved

There are multiple ways to contribute to Pretty Checkbox React, many of which
don't require writing any code! Here are a few ideas:

- Go through the
  [getting started guide](https://pretty-checkbox-react.netlify.app/docs/). Find
  something behaving strangely? Something not working at all? Let us know by
  [opening an issue](https://github.com/atomicpages/pretty-checkbox-react/issues).
- Look through the
  [open issues](https://github.com/atomicpages/pretty-checkbox-react/issues).
  Provide workarounds, ask for clarification, or suggest labels. Help triage
  issues.
- If you find an issue you'd like to fix, open a pull request. Issues tagged as
  [_good first issue_](https://github.com/atomicpages/pretty-checkbox-react/labels/good%20first%20issue)
  are a good place to start

Contributions are most welcome! If you need help planning your contribute let us
know and we'll be happy to help!

### Triaging Issues and Pull Requests

One great way you can contribute to the project without writing any code is to
help triage issues and pull requests as they come in.

- Ask for more information if you believe the issue does not provide all the
  details required to solve it.
- Suggest [labels](https://github.com/atomicpages/pretty-checkbox-react/labels)
  that can help categorize issues.
- Flag issues that are stale or that should be closed.
- Ask for test plans and review code.

## Development Process

Pretty Checkbox React uses github as its source of truth and all changes are
public from the beginning :+1. When a change is made, github actions will lint,
build, and test Pretty Checkbox React code.

### Commit Messages

Commits as of 06/19/2022 use
[conventional commit format](https://www.conventionalcommits.org/en/v1.0.0/) so
please be sure to follow the convention :smile:.

### Branch Organization

Pretty Checkbox React has one main branch: `master`. This is where the code
lives and development takes place. For the most part, `master` will stay in good
shape.
