/*
Tencent is pleased to support the open source community by making PhxQueue available.
Copyright (C) 2017 THL A29 Limited, a Tencent company. All rights reserved.
Licensed under the BSD 3-Clause License (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

<https://opensource.org/licenses/BSD-3-Clause>

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
*/



/* store_server_config.cpp

 Generated by phxrpc_pb2server from store.proto

*/

#include "store_server_config.h"

#include "store.pb.h"


StoreServerConfig::StoreServerConfig() {}

StoreServerConfig::~StoreServerConfig() {}

bool StoreServerConfig::Read(const char *config_file) {
    bool ret = ep_server_config_.Read(config_file);

    if (0 == strlen(ep_server_config_.GetPackageName())) {
        ep_server_config_.SetPackageName("phxqueue_phxrpc.store");
    }

    // read extra
    phxrpc::Config config;
    if (!config.InitConfig(config_file)) {
        return false;
    }
    ret &= config.ReadItem("Store", "Topic", topic_, sizeof(topic_));
    ret &= config.ReadItem("Store", "DataDirPath", data_dir_path_, sizeof(data_dir_path_));
    ret &= config.ReadItem("Store", "PhxQueueGlobalConfigPath",
                           phxqueue_global_config_path_, sizeof(phxqueue_global_config_path_));
    ret &= config.ReadItem("Store", "PaxosPort", &paxos_port_);
    ret &= config.ReadItem("Store", "NPaxosIOThread", &npaxos_iothread_, 3);
    config.ReadItem("Store", "NGroup", &ngroup_, 100);

    return ret;
}

phxrpc::HshaServerConfig &StoreServerConfig::GetHshaServerConfig() {
    return ep_server_config_;
}

const char *StoreServerConfig::GetTopic() const {
    return topic_;
}

const char *StoreServerConfig::GetDataDirPath() const {
    return data_dir_path_;
}

const char *StoreServerConfig::GetPhxQueueGlobalConfigPath() const {
    return phxqueue_global_config_path_;
}

int StoreServerConfig::GetPaxosPort() const {
    return paxos_port_;
}

int StoreServerConfig::GetNPaxosIOThread() const {
    return npaxos_iothread_;
}

int StoreServerConfig::GetNGroup() const {
    return ngroup_;
}

