/*
Tencent is pleased to support the open source community by making PhxQueue available.
Copyright (C) 2017 THL A29 Limited, a Tencent company. All rights reserved.
Licensed under the BSD 3-Clause License (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

<https://opensource.org/licenses/BSD-3-Clause>

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
*/



/* scheduler_server_config.cpp

 Generated by phxrpc_pb2server from scheduler.proto

*/

#include "scheduler.pb.h"
#include "scheduler_server_config.h"


SchedulerServerConfig::SchedulerServerConfig() {}

SchedulerServerConfig::~SchedulerServerConfig() {}

bool SchedulerServerConfig::Read(const char *config_file) {
    bool ret = ep_server_config_.Read(config_file);

    if (0 == strlen(ep_server_config_.GetPackageName())) {
        ep_server_config_.SetPackageName("phxqueue_phxrpc.scheduler");
    }

    // read extra
    phxrpc::Config config;
    if (!config.InitConfig(config_file)) {
        return false;
    }
    ret &= config.ReadItem("Scheduler", "Topic", topic_, sizeof(topic_));
    ret &= config.ReadItem("Scheduler", "PhxQueueGlobalConfigPath",
                           phxqueue_global_config_path_, sizeof(phxqueue_global_config_path_));

    return ret;
}

phxrpc::HshaServerConfig &SchedulerServerConfig::GetHshaServerConfig() {
    return ep_server_config_;
}

const char *SchedulerServerConfig::GetTopic() const {
    return topic_;
}

const char *SchedulerServerConfig::GetPhxQueueGlobalConfigPath() const {
    return phxqueue_global_config_path_;
}

