/*
Tencent is pleased to support the open source community by making PhxQueue available.
Copyright (C) 2017 THL A29 Limited, a Tencent company. All rights reserved.
Licensed under the BSD 3-Clause License (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

<https://opensource.org/licenses/BSD-3-Clause>

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
*/



/* phxrpc_scheduler_dispatcher.h

 Generated by phxrpc_pb2service from scheduler.proto

 Please DO NOT edit unless you know exactly what you are doing.

*/

#include "phxrpc_scheduler_dispatcher.h"

#include <errno.h>

#include "phxrpc/file.h"
#include "phxrpc/http.h"

#include "phxrpc_scheduler_service.h"
#include "scheduler.pb.h"


SchedulerDispatcher::SchedulerDispatcher(SchedulerService &service, phxrpc::DispatcherArgs_t *dispatcher_args)
        : service_(service), dispatcher_args_(dispatcher_args) {}

SchedulerDispatcher::~SchedulerDispatcher() {}

const phxrpc::BaseDispatcher<SchedulerDispatcher>::URIFuncMap &
SchedulerDispatcher::GetURIFuncMap() {
    static phxrpc::BaseDispatcher<SchedulerDispatcher>::URIFuncMap uri_func_map = {
            {"/phxqueue_phxrpc/scheduler/PHXEcho", &SchedulerDispatcher::PHXEcho},
            {"/phxqueue_phxrpc/scheduler/GetAddrScale", &SchedulerDispatcher::GetAddrScale}};
    return uri_func_map;
}

int SchedulerDispatcher::PHXEcho(const phxrpc::BaseRequest &req,
                                 phxrpc::BaseResponse *const resp) {
    dispatcher_args_->server_monitor->SvrCall(-1, "PHXEcho", 1);

    int ret{-1};

    google::protobuf::StringValue req_pb;
    google::protobuf::StringValue resp_pb;

    // unpack request
    {
        ret = req.ToPb(&req_pb);
        if (0 != ret) {
            phxrpc::log(LOG_ERR, "ToPb err %d", ret);

            return -EINVAL;
        }
    }

    // logic process
    {
        if (0 == ret) ret = service_.PHXEcho(req_pb, &resp_pb);
    }

    // pack response
    {
        if (0 != resp->FromPb(resp_pb)) {
            phxrpc::log(LOG_ERR, "FromPb err %d", ret);

            return -ENOMEM;
        }
    }

    phxrpc::log(LOG_DEBUG, "RETN: PHXEcho = %d", ret);

    return ret;
}

int SchedulerDispatcher::GetAddrScale(const phxrpc::BaseRequest &req,
                                      phxrpc::BaseResponse *const resp) {
    dispatcher_args_->server_monitor->SvrCall(1, "GetAddrScale", 1);

    int ret{-1};

    phxqueue::comm::proto::GetAddrScaleRequest req_pb;
    phxqueue::comm::proto::GetAddrScaleResponse resp_pb;

    // unpack request
    {
        ret = req.ToPb(&req_pb);
        if (0 != ret) {
            phxrpc::log(LOG_ERR, "ToPb err %d", ret);

            return -EINVAL;
        }
    }

    // logic process
    {
        if (0 == ret) ret = service_.GetAddrScale(req_pb, &resp_pb);
    }

    // pack response
    {
        if (0 != resp->FromPb(resp_pb)) {
            phxrpc::log(LOG_ERR, "FromPb err %d", ret);

            return -ENOMEM;
        }
    }

    phxrpc::log(LOG_DEBUG, "RETN: GetAddrScale = %d", ret);

    return ret;
}

