/*
Tencent is pleased to support the open source community by making PhxQueue available.
Copyright (C) 2017 THL A29 Limited, a Tencent company. All rights reserved.
Licensed under the BSD 3-Clause License (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

<https://opensource.org/licenses/BSD-3-Clause>

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
*/



/* lock_tool_main.cpp

 Generated by phxrpc_pb2tool from lock.proto

*/

#include <cstdlib>
#include <cstring>
#include <time.h>
#include <unistd.h>

#include "phxrpc/file.h"

#include "lock_client.h"
#include "lock_tool_impl.h"
#include "phxrpc_lock_tool.h"


using namespace phxrpc;


void ShowUsage(const char *program) {
    printf("\nUsage: %s [-c <config>] [-f <func>] [-v]\n", program);

    LockTool::Name2Func_t *name2func{LockTool::GetName2Func()};

    for (int i{0}; ; ++i) {
        LockTool::Name2Func_t *iter = &(name2func[i]);

        if (nullptr == iter->name) break;

        printf("    -f %s %s\n", iter->name, iter->usage);
    }
    printf("\n");
    exit(0);
}

int main(int argc, char *argv[]) {
    const char *func{nullptr};
    const char *config{nullptr};

    for (int i{1}; i < argc - 1; ++i) {
        if (0 == strcmp(argv[i], "-c")) {
            config = argv[++i];
        }
        if (0 == strcmp(argv[i], "-f")) {
            func = argv[++i];
        }
        if (0 == strcmp(argv[i], "-v")) {
            ShowUsage(argv[0]);
        }
    }

    if (nullptr == func) ShowUsage(argv[0]);

    if (nullptr != config) LockClient::Init(config);

    LockTool::Name2Func_t *target{nullptr};

    LockTool::Name2Func_t *name2func{LockTool::GetName2Func()};

    for (int i{0}; i < 100; ++i) {
        LockTool::Name2Func_t *iter = &(name2func[i]);

        if (nullptr == iter->name) break;

        if (0 == strcasecmp(func, iter->name)) {
            target = iter;
            break;
        }
    }

    if (nullptr == target) ShowUsage(argv[0]);

    OptMap opt_map(target->opt_string);

    if (!opt_map.Parse(argc, argv)) ShowUsage(argv[0]);

    LockTool::ToolFunc_t targefunc{target->func};

    LockToolImpl tool;

    if (0 != (tool.*targefunc)(opt_map)) ShowUsage(argv[0]);

    return 0;
}

