/*
Tencent is pleased to support the open source community by making PhxQueue available.
Copyright (C) 2017 THL A29 Limited, a Tencent company. All rights reserved.
Licensed under the BSD 3-Clause License (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

<https://opensource.org/licenses/BSD-3-Clause>

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
*/



/* lock_service_impl.cpp

 Generated by phxrpc_pb2service from lock.proto

*/

#include "lock_service_impl.h"

#include "phxrpc/file.h"

#include "lock_server_config.h"


LockServiceImpl::LockServiceImpl(ServiceArgs_t &app_args) : args_(app_args), lock_(app_args.lock) {}


LockServiceImpl::~LockServiceImpl() {}

int LockServiceImpl::PHXEcho(const google::protobuf::StringValue &req,
                             google::protobuf::StringValue *resp) {
    resp->set_value(req.value());
    return 0;
}

int LockServiceImpl::GetString(const phxqueue::comm::proto::GetStringRequest &req,
                               phxqueue::comm::proto::GetStringResponse *resp) {
    int ret{static_cast<int>(lock_->GetString(req, *resp))};

    if (0 != ret) {
        QLErr("Lock GetString err %d", ret);
    }

    return ret;
}

int LockServiceImpl::SetString(const phxqueue::comm::proto::SetStringRequest &req,
                               phxqueue::comm::proto::SetStringResponse *resp) {
    int ret{static_cast<int>(lock_->SetString(req, *resp))};

    if (0 != ret) {
        QLErr("Lock SetString err %d", ret);
    }

    return ret;
}

int LockServiceImpl::DeleteString(const phxqueue::comm::proto::DeleteStringRequest &req,
                                  phxqueue::comm::proto::DeleteStringResponse *resp) {
    int ret{static_cast<int>(lock_->DeleteString(req, *resp))};

    if (0 != ret) {
        QLErr("Lock DeleteString err %d", ret);
    }

    return ret;
}

int LockServiceImpl::GetLockInfo(const phxqueue::comm::proto::GetLockInfoRequest &req,
                                 phxqueue::comm::proto::GetLockInfoResponse *resp) {
    int ret{static_cast<int>(lock_->GetLockInfo(req, *resp))};

    if (0 != ret) {
        QLErr("Lock GetLockInfo err %d", ret);
    }

    return ret;
}

int LockServiceImpl::AcquireLock(const phxqueue::comm::proto::AcquireLockRequest &req,
                                 phxqueue::comm::proto::AcquireLockResponse *resp) {
    int ret{static_cast<int>(lock_->AcquireLock(req, *resp))};

    if (0 != ret) {
        QLErr("Lock AcquireLock err %d", ret);
    }

    return ret;
}

