# Modeling and Simulation in Python

Order the book from [No Starch Press](https://nostarch.com/modeling-and-simulation-python) or [Amazon](https://amzn.to/3y9UxNb).

[Read the book and run the code](https://allendowney.github.io/ModSimPy/).

*Modeling and Simulation in Python* is an introduction to physical modeling using a computational approach.  It is organized in three parts:

* The first part presents discrete models, including a bikeshare system and world population growth.

* The second part introduces first-order systems, including models of infectious disease, thermal systems, and pharmacokinetics.

* The third part is about second-order systems, including mechanical systems like projectiles, celestial mechanics, and rotating rigid bodies.

Taking a computational approach makes it possible to work with more realistic models than what you typically see in a first-year physics class, with the option to include features like friction and drag.

Python is an ideal programming language for this material.  It is a good first language for people who have not programmed before, and it provides high-level data structures that are well-suited to express solutions to the problems we are interested in.

*Modeling and Simulation in Python* is a Free Book. It is available under the [Creative Commons Attribution-NonCommercial 4.0 Unported License](https://creativecommons.org/licenses/by-nc/4.0/), which means that you are free to copy, distribute, and modify it, as long as you attribute the work and don’t use it for commercial purposes.

This and other Free Books by Allen Downey are available from [Green Tea Press](http://greenteapress.com/wp).

