### Begin Python 🐍 with the TCLab

Welcome to this introductory course on Python! This course is intended to help you start programming in Python from little or no prior experience. There are video tutorials for each exercise if you have questions along the way. One of the unique things about this course is that you work on basic elements to help you with a temperature control project. You will see your Python code have a real effect by adjusting heaters to maintain a target temperature, just like a thermostat in a home or office.

[![Begin Python](https://apmonitor.com/che263/uploads/Begin_Python/BeginPython00.png)](https://www.youtube.com/watch?v=EO_YpBs8cs0 "Begin Python")

One of the best ways to start or review a programming language is to work on a simple project. These exercises are designed to teach basic Python programming skills to help you design a temperature controller. Temperature control is found in many applications such as home or office HVAC, manufacturing processes, transportation, and life sciences. Even our bodies regulate temperature to a specific set point. This project is to regulate the temperature of the TCLab. Each TCLab has thermochromic (changes color with temperature) paint that turns from black to purple when the temperature reaches the target temperature of 37°C (99°F).

**[Final Project](https://github.com/APMonitor/begin_python/blob/master/XX.%20Final%20Project.ipynb) Objective**: Program the TCLab to maintain the temperature at 37°C. Display the heater level with an LED indicator as the program is adjusting the temperature. Create a plot of the temperature and heater values over a 10 minute evaluation period.

To make the problem more concrete, suppose that you are designing a chicken egg incubator. Temperature, humidity, and egg rotation are all important to help the chicks develop. For this exercise, you will only focus on temperature control by adjusting the heater.

**Topics**

There are 12 lessons to help you with the objective of designing the temperature control for the incubator. The first thing that you will need is to [install Anaconda](https://github.com/APMonitor/begin_python/blob/master/00.%20Introduction.ipynb) to open and run the IPython notebook files in Jupyter. Any Python distribution or Integrated Development Environment (IDE) can be used (IDLE (python.org), Spyder, PyCharm, and others) but Jupyter notebook is required to open and run the IPython notebook (`.ipynb`) files. All of the IPython notebook (`.ipynb`) files can be [downloaded at this link](https://github.com/APMonitor/begin_python/archive/master.zip). Don't forget to unzip the folder (extract the archive) and copy it to a convenient location before starting.

1. [Overview](https://github.com/APMonitor/begin_python/blob/master/01.%20Overview.ipynb)
2. [Debugging](https://github.com/APMonitor/begin_python/blob/master/02.%20Debugging.ipynb)
3. [Variables](https://github.com/APMonitor/begin_python/blob/master/03.%20Variables.ipynb)
4. [Printing](https://github.com/APMonitor/begin_python/blob/master/04.%20Printing.ipynb)
5. [Classes and Objects](https://github.com/APMonitor/begin_python/blob/master/05.%20Classes%20and%20Objects.ipynb)
6. [Functions](https://github.com/APMonitor/begin_python/blob/master/06.%20Functions.ipynb)
7. [Loops](https://github.com/APMonitor/begin_python/blob/master/07.%20Loops.ipynb)
8. [Input](https://github.com/APMonitor/begin_python/blob/master/08.%20Input.ipynb)
9. [If Statements](https://github.com/APMonitor/begin_python/blob/master/09.%20If%20Statements.ipynb)
10. [Lists and Tuples](https://github.com/APMonitor/begin_python/blob/master/10.%20Lists%20and%20Tuples.ipynb)
11. [Dictionaries](https://github.com/APMonitor/begin_python/blob/master/11.%20Dictionaries.ipynb)
12. [Plotting](https://github.com/APMonitor/begin_python/blob/master/12.%20Plotting.ipynb)

**Get TCLab**

You will need a [TCLab kit](https://apmonitor.com/heat.htm) to complete the exercises and they are available for [purchase on Amazon](https://www.amazon.com/TCLab-Temperature-Control-Lab/dp/B07GMFWMRY). 

![Temperature Control Lab](https://apmonitor.com/pdc/uploads/Main/tclab_connect.png "TCLab")

**Install Python**

[Download and install Python](https://www.anaconda.com/products/individual) or watch a video on how to install Python.

**[Install Python on Windows](https://youtu.be/_BHsM452vK0)**

   [![Install Python on Windows](https://img.youtube.com/vi/_BHsM452vK0/0.jpg)](https://www.youtube.com/watch?v=_BHsM452vK0 "Install Python on Windows")

**[Install Python on MacOS](https://youtu.be/2VECcPofhP8)**

   [![Install Python on MacOS](https://img.youtube.com/vi/2VECcPofhP8/0.jpg)](https://www.youtube.com/watch?v=2VECcPofhP8 "Install Python on MacOS")

**[Install Python on Linux](https://youtu.be/eUq-6ZuwC_A)**

   [![Install Python on Linux](https://img.youtube.com/vi/eUq-6ZuwC_A/0.jpg)](https://www.youtube.com/watch?v=eUq-6ZuwC_A "Install Python on Linux")

There are additional instructions on how to [install Python and manage modules](https://apmonitor.com/pdc/index.php/Main/InstallPython).

**Support**

We would love to hear any feedback or problems you would like to send us! We are always trying to improve this course and would like to hear about your experience. We can be contacted at _eric@apmonitor.com_ or _john@apmonitor.com_.

**Additional Resources**

- [Temperature Control Lab (TCLab) Kit](https://apmonitor.com/pdc/index.php/Main/ArduinoTemperatureControl)
- [Engineering Programming Course](https://apmonitor.com/pdc) with [Source Code](https://github.com/APMonitor/learn_python)
- [Jupyter as interactive environment for Python, Julia, R](https://jupyter.org/)
