/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.video;

import android.os.Handler;
import android.view.Surface;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.util.Assertions;

public interface VideoRendererEventListener {
    public void onVideoEnabled(DecoderCounters var1);

    public void onVideoDecoderInitialized(String var1, long var2, long var4);

    public void onVideoInputFormatChanged(Format var1);

    public void onDroppedFrames(int var1, long var2);

    public void onVideoSizeChanged(int var1, int var2, int var3, float var4);

    public void onRenderedFirstFrame(Surface var1);

    public void onVideoDisabled(DecoderCounters var1);

    public static final class EventDispatcher {
        private final Handler handler;
        private final VideoRendererEventListener listener;

        public EventDispatcher(Handler handler, VideoRendererEventListener listener) {
            this.handler = listener != null ? Assertions.checkNotNull(handler) : null;
            this.listener = listener;
        }

        public void enabled(final DecoderCounters decoderCounters) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EventDispatcher.this.listener.onVideoEnabled(decoderCounters);
                    }
                });
            }
        }

        public void decoderInitialized(final String decoderName, final long initializedTimestampMs, final long initializationDurationMs) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EventDispatcher.this.listener.onVideoDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs);
                    }
                });
            }
        }

        public void inputFormatChanged(final Format format) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EventDispatcher.this.listener.onVideoInputFormatChanged(format);
                    }
                });
            }
        }

        public void droppedFrames(final int droppedFrameCount, final long elapsedMs) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EventDispatcher.this.listener.onDroppedFrames(droppedFrameCount, elapsedMs);
                    }
                });
            }
        }

        public void videoSizeChanged(final int width, final int height, final int unappliedRotationDegrees, final float pixelWidthHeightRatio) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EventDispatcher.this.listener.onVideoSizeChanged(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
                    }
                });
            }
        }

        public void renderedFirstFrame(final Surface surface) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EventDispatcher.this.listener.onRenderedFirstFrame(surface);
                    }
                });
            }
        }

        public void disabled(final DecoderCounters counters) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        counters.ensureUpdated();
                        EventDispatcher.this.listener.onVideoDisabled(counters);
                    }
                });
            }
        }
    }
}

