/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.view.Choreographer;
import android.view.WindowManager;

@TargetApi(value=16)
public final class VideoFrameReleaseTimeHelper {
    private static final long CHOREOGRAPHER_SAMPLE_DELAY_MILLIS = 500L;
    private static final long MAX_ALLOWED_DRIFT_NS = 20000000L;
    private static final long VSYNC_OFFSET_PERCENTAGE = 80L;
    private static final int MIN_FRAMES_FOR_ADJUSTMENT = 6;
    private final VSyncSampler vsyncSampler;
    private final boolean useDefaultDisplayVsync;
    private final long vsyncDurationNs;
    private final long vsyncOffsetNs;
    private long lastFramePresentationTimeUs;
    private long adjustedLastFrameTimeNs;
    private long pendingAdjustedFrameTimeNs;
    private boolean haveSync;
    private long syncUnadjustedReleaseTimeNs;
    private long syncFramePresentationTimeNs;
    private long frameCount;

    public VideoFrameReleaseTimeHelper() {
        this(-1.0, false);
    }

    public VideoFrameReleaseTimeHelper(Context context) {
        this(VideoFrameReleaseTimeHelper.getDefaultDisplayRefreshRate(context), true);
    }

    private VideoFrameReleaseTimeHelper(double defaultDisplayRefreshRate, boolean useDefaultDisplayVsync) {
        this.useDefaultDisplayVsync = useDefaultDisplayVsync;
        if (useDefaultDisplayVsync) {
            this.vsyncSampler = VSyncSampler.getInstance();
            this.vsyncDurationNs = (long)(1.0E9 / defaultDisplayRefreshRate);
            this.vsyncOffsetNs = this.vsyncDurationNs * 80L / 100L;
        } else {
            this.vsyncSampler = null;
            this.vsyncDurationNs = -1L;
            this.vsyncOffsetNs = -1L;
        }
    }

    public void enable() {
        this.haveSync = false;
        if (this.useDefaultDisplayVsync) {
            this.vsyncSampler.addObserver();
        }
    }

    public void disable() {
        if (this.useDefaultDisplayVsync) {
            this.vsyncSampler.removeObserver();
        }
    }

    public long adjustReleaseTime(long framePresentationTimeUs, long unadjustedReleaseTimeNs) {
        long framePresentationTimeNs;
        long adjustedFrameTimeNs = framePresentationTimeNs = framePresentationTimeUs * 1000L;
        long adjustedReleaseTimeNs = unadjustedReleaseTimeNs;
        if (this.haveSync) {
            if (framePresentationTimeUs != this.lastFramePresentationTimeUs) {
                ++this.frameCount;
                this.adjustedLastFrameTimeNs = this.pendingAdjustedFrameTimeNs;
            }
            if (this.frameCount >= 6L) {
                long averageFrameDurationNs = (framePresentationTimeNs - this.syncFramePresentationTimeNs) / this.frameCount;
                long candidateAdjustedFrameTimeNs = this.adjustedLastFrameTimeNs + averageFrameDurationNs;
                if (this.isDriftTooLarge(candidateAdjustedFrameTimeNs, unadjustedReleaseTimeNs)) {
                    this.haveSync = false;
                } else {
                    adjustedFrameTimeNs = candidateAdjustedFrameTimeNs;
                    adjustedReleaseTimeNs = this.syncUnadjustedReleaseTimeNs + adjustedFrameTimeNs - this.syncFramePresentationTimeNs;
                }
            } else if (this.isDriftTooLarge(framePresentationTimeNs, unadjustedReleaseTimeNs)) {
                this.haveSync = false;
            }
        }
        if (!this.haveSync) {
            this.syncFramePresentationTimeNs = framePresentationTimeNs;
            this.syncUnadjustedReleaseTimeNs = unadjustedReleaseTimeNs;
            this.frameCount = 0L;
            this.haveSync = true;
            this.onSynced();
        }
        this.lastFramePresentationTimeUs = framePresentationTimeUs;
        this.pendingAdjustedFrameTimeNs = adjustedFrameTimeNs;
        if (this.vsyncSampler == null || this.vsyncSampler.sampledVsyncTimeNs == 0L) {
            return adjustedReleaseTimeNs;
        }
        long snappedTimeNs = VideoFrameReleaseTimeHelper.closestVsync(adjustedReleaseTimeNs, this.vsyncSampler.sampledVsyncTimeNs, this.vsyncDurationNs);
        return snappedTimeNs - this.vsyncOffsetNs;
    }

    protected void onSynced() {
    }

    private boolean isDriftTooLarge(long frameTimeNs, long releaseTimeNs) {
        long elapsedReleaseTimeNs = releaseTimeNs - this.syncUnadjustedReleaseTimeNs;
        long elapsedFrameTimeNs = frameTimeNs - this.syncFramePresentationTimeNs;
        return Math.abs(elapsedReleaseTimeNs - elapsedFrameTimeNs) > 20000000L;
    }

    private static long closestVsync(long releaseTime, long sampledVsyncTime, long vsyncDuration) {
        long snappedAfterNs;
        long snappedBeforeNs;
        long vsyncCount = (releaseTime - sampledVsyncTime) / vsyncDuration;
        long snappedTimeNs = sampledVsyncTime + vsyncDuration * vsyncCount;
        if (releaseTime <= snappedTimeNs) {
            snappedBeforeNs = snappedTimeNs - vsyncDuration;
            snappedAfterNs = snappedTimeNs;
        } else {
            snappedBeforeNs = snappedTimeNs;
            snappedAfterNs = snappedTimeNs + vsyncDuration;
        }
        long snappedAfterDiff = snappedAfterNs - releaseTime;
        long snappedBeforeDiff = releaseTime - snappedBeforeNs;
        return snappedAfterDiff < snappedBeforeDiff ? snappedAfterNs : snappedBeforeNs;
    }

    private static float getDefaultDisplayRefreshRate(Context context) {
        WindowManager manager = (WindowManager)context.getSystemService("window");
        return manager.getDefaultDisplay().getRefreshRate();
    }

    private static final class VSyncSampler
    implements Choreographer.FrameCallback,
    Handler.Callback {
        public volatile long sampledVsyncTimeNs;
        private static final int CREATE_CHOREOGRAPHER = 0;
        private static final int MSG_ADD_OBSERVER = 1;
        private static final int MSG_REMOVE_OBSERVER = 2;
        private static final VSyncSampler INSTANCE = new VSyncSampler();
        private final Handler handler;
        private final HandlerThread choreographerOwnerThread = new HandlerThread("ChoreographerOwner:Handler");
        private Choreographer choreographer;
        private int observerCount;

        public static VSyncSampler getInstance() {
            return INSTANCE;
        }

        private VSyncSampler() {
            this.choreographerOwnerThread.start();
            this.handler = new Handler(this.choreographerOwnerThread.getLooper(), (Handler.Callback)this);
            this.handler.sendEmptyMessage(0);
        }

        public void addObserver() {
            this.handler.sendEmptyMessage(1);
        }

        public void removeObserver() {
            this.handler.sendEmptyMessage(2);
        }

        public void doFrame(long vsyncTimeNs) {
            this.sampledVsyncTimeNs = vsyncTimeNs;
            this.choreographer.postFrameCallbackDelayed((Choreographer.FrameCallback)this, 500L);
        }

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    this.createChoreographerInstanceInternal();
                    return true;
                }
                case 1: {
                    this.addObserverInternal();
                    return true;
                }
                case 2: {
                    this.removeObserverInternal();
                    return true;
                }
            }
            return false;
        }

        private void createChoreographerInstanceInternal() {
            this.choreographer = Choreographer.getInstance();
        }

        private void addObserverInternal() {
            ++this.observerCount;
            if (this.observerCount == 1) {
                this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
            }
        }

        private void removeObserverInternal() {
            --this.observerCount;
            if (this.observerCount == 0) {
                this.choreographer.removeFrameCallback((Choreographer.FrameCallback)this);
                this.sampledVsyncTimeNs = 0L;
            }
        }
    }
}

