/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.video;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.SystemClock;
import android.view.Surface;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer2.mediacodec.MediaCodecInfo;
import com.google.android.exoplayer2.mediacodec.MediaCodecRenderer;
import com.google.android.exoplayer2.mediacodec.MediaCodecSelector;
import com.google.android.exoplayer2.mediacodec.MediaCodecUtil;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.TraceUtil;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoFrameReleaseTimeHelper;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class MediaCodecVideoRenderer
extends MediaCodecRenderer {
    private static final String TAG = "MediaCodecVideoRenderer";
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    private final VideoFrameReleaseTimeHelper frameReleaseTimeHelper;
    private final VideoRendererEventListener.EventDispatcher eventDispatcher;
    private final long allowedJoiningTimeMs;
    private final int videoScalingMode;
    private final int maxDroppedFramesToNotify;
    private final boolean deviceNeedsAutoFrcWorkaround;
    private Format[] streamFormats;
    private CodecMaxValues codecMaxValues;
    private Surface surface;
    private boolean renderedFirstFrame;
    private long joiningDeadlineMs;
    private long droppedFrameAccumulationStartTimeMs;
    private int droppedFrames;
    private int consecutiveDroppedFrameCount;
    private int pendingRotationDegrees;
    private float pendingPixelWidthHeightRatio;
    private int currentWidth;
    private int currentHeight;
    private int currentUnappliedRotationDegrees;
    private float currentPixelWidthHeightRatio;
    private int lastReportedWidth;
    private int lastReportedHeight;
    private int lastReportedUnappliedRotationDegrees;
    private float lastReportedPixelWidthHeightRatio;

    public MediaCodecVideoRenderer(Context context, MediaCodecSelector mediaCodecSelector, int videoScalingMode) {
        this(context, mediaCodecSelector, videoScalingMode, 0L);
    }

    public MediaCodecVideoRenderer(Context context, MediaCodecSelector mediaCodecSelector, int videoScalingMode, long allowedJoiningTimeMs) {
        this(context, mediaCodecSelector, videoScalingMode, allowedJoiningTimeMs, null, null, -1);
    }

    public MediaCodecVideoRenderer(Context context, MediaCodecSelector mediaCodecSelector, int videoScalingMode, long allowedJoiningTimeMs, Handler eventHandler, VideoRendererEventListener eventListener, int maxDroppedFrameCountToNotify) {
        this(context, mediaCodecSelector, videoScalingMode, allowedJoiningTimeMs, null, false, eventHandler, eventListener, maxDroppedFrameCountToNotify);
    }

    public MediaCodecVideoRenderer(Context context, MediaCodecSelector mediaCodecSelector, int videoScalingMode, long allowedJoiningTimeMs, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, boolean playClearSamplesWithoutKeys, Handler eventHandler, VideoRendererEventListener eventListener, int maxDroppedFramesToNotify) {
        super(2, mediaCodecSelector, drmSessionManager, playClearSamplesWithoutKeys);
        this.videoScalingMode = videoScalingMode;
        this.allowedJoiningTimeMs = allowedJoiningTimeMs;
        this.maxDroppedFramesToNotify = maxDroppedFramesToNotify;
        this.frameReleaseTimeHelper = new VideoFrameReleaseTimeHelper(context);
        this.eventDispatcher = new VideoRendererEventListener.EventDispatcher(eventHandler, eventListener);
        this.deviceNeedsAutoFrcWorkaround = MediaCodecVideoRenderer.deviceNeedsAutoFrcWorkaround();
        this.joiningDeadlineMs = -9223372036854775807L;
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.lastReportedWidth = -1;
        this.lastReportedHeight = -1;
        this.lastReportedPixelWidthHeightRatio = -1.0f;
    }

    @Override
    protected int supportsFormat(MediaCodecSelector mediaCodecSelector, Format format) throws MediaCodecUtil.DecoderQueryException {
        MediaCodecInfo decoderInfo;
        String mimeType = format.sampleMimeType;
        if (!MimeTypes.isVideo(mimeType)) {
            return 0;
        }
        boolean requiresSecureDecryption = false;
        DrmInitData drmInitData = format.drmInitData;
        if (drmInitData != null) {
            for (int i = 0; i < drmInitData.schemeDataCount; ++i) {
                requiresSecureDecryption |= drmInitData.get((int)i).requiresSecureDecryption;
            }
        }
        if ((decoderInfo = mediaCodecSelector.getDecoderInfo(mimeType, requiresSecureDecryption)) == null) {
            return 1;
        }
        boolean decoderCapable = decoderInfo.isCodecSupported(format.codecs);
        if (decoderCapable && format.width > 0 && format.height > 0) {
            decoderCapable = Util.SDK_INT >= 21 ? (format.frameRate > 0.0f ? decoderInfo.isVideoSizeAndRateSupportedV21(format.width, format.height, format.frameRate) : decoderInfo.isVideoSizeSupportedV21(format.width, format.height)) : format.width * format.height <= MediaCodecUtil.maxH264DecodableFrameSize();
        }
        int adaptiveSupport = decoderInfo.adaptive ? 8 : 4;
        int formatSupport = decoderCapable ? 3 : 2;
        return adaptiveSupport | formatSupport;
    }

    @Override
    protected void onEnabled(boolean joining) throws ExoPlaybackException {
        super.onEnabled(joining);
        this.eventDispatcher.enabled(this.decoderCounters);
        this.frameReleaseTimeHelper.enable();
    }

    @Override
    protected void onStreamChanged(Format[] formats) throws ExoPlaybackException {
        this.streamFormats = formats;
        super.onStreamChanged(formats);
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) throws ExoPlaybackException {
        super.onPositionReset(positionUs, joining);
        this.renderedFirstFrame = false;
        this.consecutiveDroppedFrameCount = 0;
        this.joiningDeadlineMs = joining && this.allowedJoiningTimeMs > 0L ? SystemClock.elapsedRealtime() + this.allowedJoiningTimeMs : -9223372036854775807L;
    }

    @Override
    public boolean isReady() {
        if ((this.renderedFirstFrame || super.shouldInitCodec()) && super.isReady()) {
            this.joiningDeadlineMs = -9223372036854775807L;
            return true;
        }
        if (this.joiningDeadlineMs == -9223372036854775807L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() < this.joiningDeadlineMs) {
            return true;
        }
        this.joiningDeadlineMs = -9223372036854775807L;
        return false;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.droppedFrames = 0;
        this.droppedFrameAccumulationStartTimeMs = SystemClock.elapsedRealtime();
    }

    @Override
    protected void onStopped() {
        this.joiningDeadlineMs = -9223372036854775807L;
        this.maybeNotifyDroppedFrames();
        super.onStopped();
    }

    @Override
    protected void onDisabled() {
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.lastReportedWidth = -1;
        this.lastReportedHeight = -1;
        this.lastReportedPixelWidthHeightRatio = -1.0f;
        this.frameReleaseTimeHelper.disable();
        try {
            super.onDisabled();
        }
        finally {
            this.decoderCounters.ensureUpdated();
            this.eventDispatcher.disabled(this.decoderCounters);
        }
    }

    @Override
    public void handleMessage(int messageType, Object message) throws ExoPlaybackException {
        if (messageType == 1) {
            this.setSurface((Surface)message);
        } else {
            super.handleMessage(messageType, message);
        }
    }

    private void setSurface(Surface surface) throws ExoPlaybackException {
        if (this.surface == surface) {
            return;
        }
        this.renderedFirstFrame = false;
        this.surface = surface;
        int state = this.getState();
        if (state == 1 || state == 2) {
            this.releaseCodec();
            this.maybeInitCodec();
        }
    }

    @Override
    protected boolean shouldInitCodec() {
        return super.shouldInitCodec() && this.surface != null && this.surface.isValid();
    }

    @Override
    protected void configureCodec(MediaCodec codec, Format format, MediaCrypto crypto) {
        this.codecMaxValues = MediaCodecVideoRenderer.getCodecMaxValues(format, this.streamFormats);
        MediaFormat mediaFormat = MediaCodecVideoRenderer.getMediaFormat(format, this.codecMaxValues, this.deviceNeedsAutoFrcWorkaround);
        codec.configure(mediaFormat, this.surface, crypto, 0);
    }

    @Override
    protected void onCodecInitialized(String name, long initializedTimestampMs, long initializationDurationMs) {
        this.eventDispatcher.decoderInitialized(name, initializedTimestampMs, initializationDurationMs);
    }

    @Override
    protected void onInputFormatChanged(Format newFormat) throws ExoPlaybackException {
        super.onInputFormatChanged(newFormat);
        this.eventDispatcher.inputFormatChanged(newFormat);
        this.pendingPixelWidthHeightRatio = MediaCodecVideoRenderer.getPixelWidthHeightRatio(newFormat);
        this.pendingRotationDegrees = MediaCodecVideoRenderer.getRotationDegrees(newFormat);
    }

    @Override
    protected void onOutputFormatChanged(MediaCodec codec, MediaFormat outputFormat) {
        boolean hasCrop = outputFormat.containsKey(KEY_CROP_RIGHT) && outputFormat.containsKey(KEY_CROP_LEFT) && outputFormat.containsKey(KEY_CROP_BOTTOM) && outputFormat.containsKey(KEY_CROP_TOP);
        this.currentWidth = hasCrop ? outputFormat.getInteger(KEY_CROP_RIGHT) - outputFormat.getInteger(KEY_CROP_LEFT) + 1 : outputFormat.getInteger("width");
        this.currentHeight = hasCrop ? outputFormat.getInteger(KEY_CROP_BOTTOM) - outputFormat.getInteger(KEY_CROP_TOP) + 1 : outputFormat.getInteger("height");
        this.currentPixelWidthHeightRatio = this.pendingPixelWidthHeightRatio;
        if (Util.SDK_INT >= 21) {
            if (this.pendingRotationDegrees == 90 || this.pendingRotationDegrees == 270) {
                int rotatedHeight = this.currentWidth;
                this.currentWidth = this.currentHeight;
                this.currentHeight = rotatedHeight;
                this.currentPixelWidthHeightRatio = 1.0f / this.currentPixelWidthHeightRatio;
            }
        } else {
            this.currentUnappliedRotationDegrees = this.pendingRotationDegrees;
        }
        codec.setVideoScalingMode(this.videoScalingMode);
    }

    @Override
    protected boolean canReconfigureCodec(MediaCodec codec, boolean codecIsAdaptive, Format oldFormat, Format newFormat) {
        return MediaCodecVideoRenderer.areAdaptationCompatible(oldFormat, newFormat) && newFormat.width <= this.codecMaxValues.width && newFormat.height <= this.codecMaxValues.height && newFormat.maxInputSize <= this.codecMaxValues.inputSize && (codecIsAdaptive || oldFormat.width == newFormat.width && oldFormat.height == newFormat.height);
    }

    @Override
    protected boolean processOutputBuffer(long positionUs, long elapsedRealtimeUs, MediaCodec codec, ByteBuffer buffer, int bufferIndex, int bufferFlags, long bufferPresentationTimeUs, boolean shouldSkip) {
        if (shouldSkip) {
            this.skipOutputBuffer(codec, bufferIndex);
            return true;
        }
        if (!this.renderedFirstFrame) {
            if (Util.SDK_INT >= 21) {
                this.renderOutputBufferV21(codec, bufferIndex, System.nanoTime());
            } else {
                this.renderOutputBuffer(codec, bufferIndex);
            }
            return true;
        }
        if (this.getState() != 2) {
            return false;
        }
        long elapsedSinceStartOfLoopUs = SystemClock.elapsedRealtime() * 1000L - elapsedRealtimeUs;
        long earlyUs = bufferPresentationTimeUs - positionUs - elapsedSinceStartOfLoopUs;
        long systemTimeNs = System.nanoTime();
        long unadjustedFrameReleaseTimeNs = systemTimeNs + earlyUs * 1000L;
        long adjustedReleaseTimeNs = this.frameReleaseTimeHelper.adjustReleaseTime(bufferPresentationTimeUs, unadjustedFrameReleaseTimeNs);
        earlyUs = (adjustedReleaseTimeNs - systemTimeNs) / 1000L;
        if (earlyUs < -30000L) {
            this.dropOutputBuffer(codec, bufferIndex);
            return true;
        }
        if (Util.SDK_INT >= 21) {
            if (earlyUs < 50000L) {
                this.renderOutputBufferV21(codec, bufferIndex, adjustedReleaseTimeNs);
                return true;
            }
        } else if (earlyUs < 30000L) {
            if (earlyUs > 11000L) {
                try {
                    Thread.sleep((earlyUs - 10000L) / 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.renderOutputBuffer(codec, bufferIndex);
            return true;
        }
        return false;
    }

    private void skipOutputBuffer(MediaCodec codec, int bufferIndex) {
        TraceUtil.beginSection("skipVideoBuffer");
        codec.releaseOutputBuffer(bufferIndex, false);
        TraceUtil.endSection();
        ++this.decoderCounters.skippedOutputBufferCount;
    }

    private void dropOutputBuffer(MediaCodec codec, int bufferIndex) {
        TraceUtil.beginSection("dropVideoBuffer");
        codec.releaseOutputBuffer(bufferIndex, false);
        TraceUtil.endSection();
        ++this.decoderCounters.droppedOutputBufferCount;
        ++this.droppedFrames;
        ++this.consecutiveDroppedFrameCount;
        this.decoderCounters.maxConsecutiveDroppedOutputBufferCount = Math.max(this.consecutiveDroppedFrameCount, this.decoderCounters.maxConsecutiveDroppedOutputBufferCount);
        if (this.droppedFrames == this.maxDroppedFramesToNotify) {
            this.maybeNotifyDroppedFrames();
        }
    }

    private void renderOutputBuffer(MediaCodec codec, int bufferIndex) {
        this.maybeNotifyVideoSizeChanged();
        TraceUtil.beginSection("releaseOutputBuffer");
        codec.releaseOutputBuffer(bufferIndex, true);
        TraceUtil.endSection();
        ++this.decoderCounters.renderedOutputBufferCount;
        this.consecutiveDroppedFrameCount = 0;
        if (!this.renderedFirstFrame) {
            this.renderedFirstFrame = true;
            this.eventDispatcher.renderedFirstFrame(this.surface);
        }
    }

    @TargetApi(value=21)
    private void renderOutputBufferV21(MediaCodec codec, int bufferIndex, long releaseTimeNs) {
        this.maybeNotifyVideoSizeChanged();
        TraceUtil.beginSection("releaseOutputBuffer");
        codec.releaseOutputBuffer(bufferIndex, releaseTimeNs);
        TraceUtil.endSection();
        ++this.decoderCounters.renderedOutputBufferCount;
        this.consecutiveDroppedFrameCount = 0;
        if (!this.renderedFirstFrame) {
            this.renderedFirstFrame = true;
            this.eventDispatcher.renderedFirstFrame(this.surface);
        }
    }

    @SuppressLint(value={"InlinedApi"})
    private static MediaFormat getMediaFormat(Format format, CodecMaxValues codecMaxValues, boolean deviceNeedsAutoFrcWorkaround) {
        MediaFormat frameworkMediaFormat = format.getFrameworkMediaFormatV16();
        frameworkMediaFormat.setInteger("max-width", codecMaxValues.width);
        frameworkMediaFormat.setInteger("max-height", codecMaxValues.height);
        if (codecMaxValues.inputSize != -1) {
            frameworkMediaFormat.setInteger("max-input-size", codecMaxValues.inputSize);
        }
        if (deviceNeedsAutoFrcWorkaround) {
            frameworkMediaFormat.setInteger("auto-frc", 0);
        }
        return frameworkMediaFormat;
    }

    private static CodecMaxValues getCodecMaxValues(Format format, Format[] streamFormats) {
        int maxWidth = format.width;
        int maxHeight = format.height;
        int maxInputSize = MediaCodecVideoRenderer.getMaxInputSize(format);
        for (Format streamFormat : streamFormats) {
            if (!MediaCodecVideoRenderer.areAdaptationCompatible(format, streamFormat)) continue;
            maxWidth = Math.max(maxWidth, streamFormat.width);
            maxHeight = Math.max(maxHeight, streamFormat.height);
            maxInputSize = Math.max(maxInputSize, MediaCodecVideoRenderer.getMaxInputSize(streamFormat));
        }
        return new CodecMaxValues(maxWidth, maxHeight, maxInputSize);
    }

    private static int getMaxInputSize(Format format) {
        int minCompressionRatio;
        int maxPixels;
        if (format.maxInputSize != -1) {
            return format.maxInputSize;
        }
        if (format.width == -1 || format.height == -1) {
            return -1;
        }
        switch (format.sampleMimeType) {
            case "video/3gpp": 
            case "video/mp4v-es": {
                maxPixels = format.width * format.height;
                minCompressionRatio = 2;
                break;
            }
            case "video/avc": {
                if ("BRAVIA 4K 2015".equals(Util.MODEL)) {
                    return -1;
                }
                maxPixels = (format.width + 15) / 16 * ((format.height + 15) / 16) * 16 * 16;
                minCompressionRatio = 2;
                break;
            }
            case "video/x-vnd.on2.vp8": {
                maxPixels = format.width * format.height;
                minCompressionRatio = 2;
                break;
            }
            case "video/hevc": 
            case "video/x-vnd.on2.vp9": {
                maxPixels = format.width * format.height;
                minCompressionRatio = 4;
                break;
            }
            default: {
                return -1;
            }
        }
        return maxPixels * 3 / (2 * minCompressionRatio);
    }

    private void maybeNotifyVideoSizeChanged() {
        if (this.lastReportedWidth != this.currentWidth || this.lastReportedHeight != this.currentHeight || this.lastReportedUnappliedRotationDegrees != this.currentUnappliedRotationDegrees || this.lastReportedPixelWidthHeightRatio != this.currentPixelWidthHeightRatio) {
            this.eventDispatcher.videoSizeChanged(this.currentWidth, this.currentHeight, this.currentUnappliedRotationDegrees, this.currentPixelWidthHeightRatio);
            this.lastReportedWidth = this.currentWidth;
            this.lastReportedHeight = this.currentHeight;
            this.lastReportedUnappliedRotationDegrees = this.currentUnappliedRotationDegrees;
            this.lastReportedPixelWidthHeightRatio = this.currentPixelWidthHeightRatio;
        }
    }

    private void maybeNotifyDroppedFrames() {
        if (this.droppedFrames > 0) {
            long now = SystemClock.elapsedRealtime();
            long elapsedMs = now - this.droppedFrameAccumulationStartTimeMs;
            this.eventDispatcher.droppedFrames(this.droppedFrames, elapsedMs);
            this.droppedFrames = 0;
            this.droppedFrameAccumulationStartTimeMs = now;
        }
    }

    private static boolean deviceNeedsAutoFrcWorkaround() {
        return Util.SDK_INT <= 22 && "foster".equals(Util.DEVICE) && "NVIDIA".equals(Util.MANUFACTURER);
    }

    private static boolean areAdaptationCompatible(Format first, Format second) {
        return first.sampleMimeType.equals(second.sampleMimeType) && MediaCodecVideoRenderer.getRotationDegrees(first) == MediaCodecVideoRenderer.getRotationDegrees(second);
    }

    private static float getPixelWidthHeightRatio(Format format) {
        return format.pixelWidthHeightRatio == -1.0f ? 1.0f : format.pixelWidthHeightRatio;
    }

    private static int getRotationDegrees(Format format) {
        return format.rotationDegrees == -1 ? 0 : format.rotationDegrees;
    }

    private static final class CodecMaxValues {
        public final int width;
        public final int height;
        public final int inputSize;

        public CodecMaxValues(int width, int height, int inputSize) {
            this.width = width;
            this.height = height;
            this.inputSize = inputSize;
        }
    }
}

