/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Assertions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Util {
    public static final int SDK_INT = Build.VERSION.SDK_INT == 23 && Build.VERSION.CODENAME.charAt(0) == 'N' ? 24 : Build.VERSION.SDK_INT;
    public static final String DEVICE = Build.DEVICE;
    public static final String MANUFACTURER = Build.MANUFACTURER;
    public static final String MODEL = Build.MODEL;
    private static final String TAG = "Util";
    private static final Pattern XS_DATE_TIME_PATTERN = Pattern.compile("(\\d\\d\\d\\d)\\-(\\d\\d)\\-(\\d\\d)[Tt](\\d\\d):(\\d\\d):(\\d\\d)(\\.(\\d+))?([Zz]|((\\+|\\-)(\\d\\d):(\\d\\d)))?");
    private static final Pattern XS_DURATION_PATTERN = Pattern.compile("^(-)?P(([0-9]*)Y)?(([0-9]*)M)?(([0-9]*)D)?(T(([0-9]*)H)?(([0-9]*)M)?(([0-9.]*)S)?)?$");
    private static final Pattern ESCAPED_CHARACTER_PATTERN = Pattern.compile("%([A-Fa-f0-9]{2})");
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private static final int[] CRC32_BYTES_MSBF = new int[]{0, 79764919, 159529838, 222504665, 319059676, 398814059, 445009330, 507990021, 638119352, 583659535, 797628118, 726387553, 890018660, 835552979, 1015980042, 944750013, 1276238704, 1221641927, 1167319070, 1095957929, 1595256236, 1540665371, 1452775106, 1381403509, 1780037320, 1859660671, 1671105958, 1733955601, 2031960084, 2111593891, 1889500026, 1952343757, -1742489888, -1662866601, -1851683442, -1788833735, -1960329156, -1880695413, -2103051438, -2040207643, -1104454824, -1159051537, -1213636554, -1284997759, -1389417084, -1444007885, -1532160278, -1603531939, -734892656, -789352409, -575645954, -646886583, -952755380, -1007220997, -827056094, -898286187, -231047128, -151282273, -71779514, -8804623, -515967244, -436212925, -390279782, -327299027, 881225847, 809987520, 1023691545, 969234094, 662832811, 591600412, 771767749, 717299826, 311336399, 374308984, 453813921, 533576470, 25881363, 88864420, 134795389, 214552010, 2023205639, 2086057648, 1897238633, 1976864222, 1804852699, 1867694188, 1645340341, 1724971778, 1587496639, 1516133128, 1461550545, 1406951526, 1302016099, 1230646740, 1142491917, 1087903418, -1398421865, -1469785312, -1524105735, -1578704818, -1079922613, -1151291908, -1239184603, -1293773166, -1968362705, -1905510760, -2094067647, -2014441994, -1716953613, -1654112188, -1876203875, -1796572374, -525066777, -462094256, -382327159, -302564546, -206542021, -143559028, -97365931, -17609246, -960696225, -1031934488, -817968335, -872425850, -709327229, -780559564, -600130067, -654598054, 1762451694, 1842216281, 1619975040, 1682949687, 2047383090, 2127137669, 1938468188, 2001449195, 1325665622, 1271206113, 1183200824, 1111960463, 1543535498, 1489069629, 1434599652, 1363369299, 622672798, 568075817, 748617968, 677256519, 907627842, 853037301, 1067152940, 995781531, 51762726, 131386257, 177728840, 240578815, 269590778, 349224269, 429104020, 491947555, -248556018, -168932423, -122852000, -60002089, -500490030, -420856475, -341238852, -278395381, -685261898, -739858943, -559578920, -630940305, -1004286614, -1058877219, -845023740, -916395085, -1119974018, -1174433591, -1262701040, -1333941337, -1371866206, -1426332139, -1481064244, -1552294533, -1690935098, -1611170447, -1833673816, -1770699233, -2009983462, -1930228819, -2119160460, -2056179517, 1569362073, 1498123566, 1409854455, 1355396672, 1317987909, 1246755826, 1192025387, 1137557660, 2072149281, 2135122070, 1912620623, 1992383480, 1753615357, 1816598090, 1627664531, 1707420964, 295390185, 358241886, 404320391, 483945776, 43990325, 106832002, 186451547, 266083308, 932423249, 861060070, 1041341759, 986742920, 613929101, 542559546, 756411363, 701822548, -978770311, -1050133554, -869589737, -924188512, -693284699, -764654318, -550540341, -605129092, -475935807, -413084042, -366743377, -287118056, -257573603, -194731862, -114850189, -35218492, -1984365303, -1921392450, -2143631769, -2063868976, -1698919467, -1635936670, -1824608069, -1744851700, -1347415887, -1418654458, -1506661409, -1561119128, -1129027987, -1200260134, -1254728445, -1309196108};

    private Util() {
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        return outputStream.toByteArray();
    }

    @TargetApi(value=23)
    public static boolean maybeRequestReadExternalStoragePermission(Activity activity, Uri ... uris) {
        if (SDK_INT < 23) {
            return false;
        }
        for (Uri uri : uris) {
            if (!Util.isLocalFileUri(uri)) continue;
            if (activity.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") == 0) break;
            activity.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 0);
            return true;
        }
        return false;
    }

    public static boolean isLocalFileUri(Uri uri) {
        String scheme = uri.getScheme();
        return TextUtils.isEmpty((CharSequence)scheme) || scheme.equals("file");
    }

    public static boolean areEqual(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static boolean contains(Object[] items, Object item) {
        for (Object arrayItem : items) {
            if (!Util.areEqual(arrayItem, item)) continue;
            return true;
        }
        return false;
    }

    public static ExecutorService newSingleThreadExecutor(final String threadName) {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, threadName);
            }
        });
    }

    public static void closeQuietly(DataSource dataSource) {
        try {
            dataSource.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String normalizeLanguageCode(String language) {
        return language == null ? null : new Locale(language).getLanguage();
    }

    public static byte[] getUtf8Bytes(String value) {
        return value.getBytes(Charset.defaultCharset());
    }

    public static String toLowerInvariant(String text) {
        return text == null ? null : text.toLowerCase(Locale.US);
    }

    public static int ceilDivide(int numerator, int denominator) {
        return (numerator + denominator - 1) / denominator;
    }

    public static long ceilDivide(long numerator, long denominator) {
        return (numerator + denominator - 1L) / denominator;
    }

    public static int constrainValue(int value, int min, int max) {
        return Math.max(min, Math.min(value, max));
    }

    public static int binarySearchFloor(int[] a, int value, boolean inclusive, boolean stayInBounds) {
        int index = Arrays.binarySearch(a, value);
        index = index < 0 ? -(index + 2) : (inclusive ? index : index - 1);
        return stayInBounds ? Math.max(0, index) : index;
    }

    public static int binarySearchFloor(long[] a, long value, boolean inclusive, boolean stayInBounds) {
        int index = Arrays.binarySearch(a, value);
        index = index < 0 ? -(index + 2) : (inclusive ? index : index - 1);
        return stayInBounds ? Math.max(0, index) : index;
    }

    public static int binarySearchCeil(long[] a, long value, boolean inclusive, boolean stayInBounds) {
        int index = Arrays.binarySearch(a, value);
        index = index < 0 ? ~index : (inclusive ? index : index + 1);
        return stayInBounds ? Math.min(a.length - 1, index) : index;
    }

    public static <T> int binarySearchFloor(List<? extends Comparable<? super T>> list, T value, boolean inclusive, boolean stayInBounds) {
        int index = Collections.binarySearch(list, value);
        index = index < 0 ? -(index + 2) : (inclusive ? index : index - 1);
        return stayInBounds ? Math.max(0, index) : index;
    }

    public static <T> int binarySearchCeil(List<? extends Comparable<? super T>> list, T value, boolean inclusive, boolean stayInBounds) {
        int index = Collections.binarySearch(list, value);
        index = index < 0 ? ~index : (inclusive ? index : index + 1);
        return stayInBounds ? Math.min(list.size() - 1, index) : index;
    }

    public static long parseXsDuration(String value) {
        Matcher matcher = XS_DURATION_PATTERN.matcher(value);
        if (matcher.matches()) {
            boolean negated = !TextUtils.isEmpty((CharSequence)matcher.group(1));
            String years = matcher.group(3);
            double durationSeconds = years != null ? Double.parseDouble(years) * 3.1556908E7 : 0.0;
            String months = matcher.group(5);
            durationSeconds += months != null ? Double.parseDouble(months) * 2629739.0 : 0.0;
            String days = matcher.group(7);
            durationSeconds += days != null ? Double.parseDouble(days) * 86400.0 : 0.0;
            String hours = matcher.group(10);
            durationSeconds += hours != null ? Double.parseDouble(hours) * 3600.0 : 0.0;
            String minutes = matcher.group(12);
            durationSeconds += minutes != null ? Double.parseDouble(minutes) * 60.0 : 0.0;
            String seconds = matcher.group(14);
            long durationMillis = (long)((durationSeconds += seconds != null ? Double.parseDouble(seconds) : 0.0) * 1000.0);
            return negated ? -durationMillis : durationMillis;
        }
        return (long)(Double.parseDouble(value) * 3600.0 * 1000.0);
    }

    public static long parseXsDateTime(String value) throws ParseException {
        int timezoneShift;
        Matcher matcher = XS_DATE_TIME_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new ParseException("Invalid date/time format: " + value, 0);
        }
        if (matcher.group(9) == null) {
            timezoneShift = 0;
        } else if (matcher.group(9).equalsIgnoreCase("Z")) {
            timezoneShift = 0;
        } else {
            timezoneShift = Integer.parseInt(matcher.group(12)) * 60 + Integer.parseInt(matcher.group(13));
            if (matcher.group(11).equals("-")) {
                timezoneShift *= -1;
            }
        }
        GregorianCalendar dateTime = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        dateTime.clear();
        dateTime.set(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)));
        if (!TextUtils.isEmpty((CharSequence)matcher.group(8))) {
            BigDecimal bd = new BigDecimal("0." + matcher.group(8));
            dateTime.set(14, bd.movePointRight(3).intValue());
        }
        long time = dateTime.getTimeInMillis();
        if (timezoneShift != 0) {
            time -= (long)(timezoneShift * 60000);
        }
        return time;
    }

    public static long scaleLargeTimestamp(long timestamp, long multiplier, long divisor) {
        if (divisor >= multiplier && divisor % multiplier == 0L) {
            long divisionFactor = divisor / multiplier;
            return timestamp / divisionFactor;
        }
        if (divisor < multiplier && multiplier % divisor == 0L) {
            long multiplicationFactor = multiplier / divisor;
            return timestamp * multiplicationFactor;
        }
        double multiplicationFactor = (double)multiplier / (double)divisor;
        return (long)((double)timestamp * multiplicationFactor);
    }

    public static long[] scaleLargeTimestamps(List<Long> timestamps, long multiplier, long divisor) {
        long[] scaledTimestamps = new long[timestamps.size()];
        if (divisor >= multiplier && divisor % multiplier == 0L) {
            long divisionFactor = divisor / multiplier;
            for (int i = 0; i < scaledTimestamps.length; ++i) {
                scaledTimestamps[i] = timestamps.get(i) / divisionFactor;
            }
        } else if (divisor < multiplier && multiplier % divisor == 0L) {
            long multiplicationFactor = multiplier / divisor;
            for (int i = 0; i < scaledTimestamps.length; ++i) {
                scaledTimestamps[i] = timestamps.get(i) * multiplicationFactor;
            }
        } else {
            double multiplicationFactor = (double)multiplier / (double)divisor;
            for (int i = 0; i < scaledTimestamps.length; ++i) {
                scaledTimestamps[i] = (long)((double)timestamps.get(i).longValue() * multiplicationFactor);
            }
        }
        return scaledTimestamps;
    }

    public static void scaleLargeTimestampsInPlace(long[] timestamps, long multiplier, long divisor) {
        if (divisor >= multiplier && divisor % multiplier == 0L) {
            long divisionFactor = divisor / multiplier;
            int i = 0;
            while (i < timestamps.length) {
                int n = i++;
                timestamps[n] = timestamps[n] / divisionFactor;
            }
        } else if (divisor < multiplier && multiplier % divisor == 0L) {
            long multiplicationFactor = multiplier / divisor;
            int i = 0;
            while (i < timestamps.length) {
                int n = i++;
                timestamps[n] = timestamps[n] * multiplicationFactor;
            }
        } else {
            double multiplicationFactor = (double)multiplier / (double)divisor;
            for (int i = 0; i < timestamps.length; ++i) {
                timestamps[i] = (long)((double)timestamps[i] * multiplicationFactor);
            }
        }
    }

    public static int[] toArray(List<Integer> list) {
        if (list == null) {
            return null;
        }
        int length = list.size();
        int[] intArray = new int[length];
        for (int i = 0; i < length; ++i) {
            intArray[i] = list.get(i);
        }
        return intArray;
    }

    public static DataSpec getRemainderDataSpec(DataSpec dataSpec, int bytesLoaded) {
        if (bytesLoaded == 0) {
            return dataSpec;
        }
        long remainingLength = dataSpec.length == -1L ? -1L : dataSpec.length - (long)bytesLoaded;
        return new DataSpec(dataSpec.uri, dataSpec.position + (long)bytesLoaded, remainingLength, dataSpec.key, dataSpec.flags);
    }

    public static int getIntegerCodeForString(String string2) {
        int length = string2.length();
        Assertions.checkArgument(length <= 4);
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result <<= 8;
            result |= string2.charAt(i);
        }
        return result;
    }

    public static byte[] getBytesFromHexString(String hexString) {
        byte[] data = new byte[hexString.length() / 2];
        for (int i = 0; i < data.length; ++i) {
            int stringOffset = i * 2;
            data[i] = (byte)((Character.digit(hexString.charAt(stringOffset), 16) << 4) + Character.digit(hexString.charAt(stringOffset + 1), 16));
        }
        return data;
    }

    public static String getHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int i = 0;
        for (byte v : bytes) {
            hexChars[i++] = HEX_DIGITS[v >> 4 & 0xF];
            hexChars[i++] = HEX_DIGITS[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String getCommaDelimitedSimpleClassNames(Object[] objects) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            stringBuilder.append(objects[i].getClass().getSimpleName());
            if (i >= objects.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static String getUserAgent(Context context, String applicationName) {
        String versionName;
        try {
            String packageName = context.getPackageName();
            PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 0);
            versionName = info.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            versionName = "?";
        }
        return applicationName + "/" + versionName + " (Linux;Android " + Build.VERSION.RELEASE + ") ExoPlayerLib/" + "2.0.4";
    }

    public static int getPcmEncoding(int bitDepth) {
        switch (bitDepth) {
            case 8: {
                return 3;
            }
            case 16: {
                return 2;
            }
            case 24: {
                return Integer.MIN_VALUE;
            }
            case 32: {
                return 0x40000000;
            }
        }
        return 0;
    }

    public static int inferContentType(String fileName) {
        if (fileName == null) {
            return 3;
        }
        if (fileName.endsWith(".mpd")) {
            return 0;
        }
        if (fileName.endsWith(".ism") || fileName.endsWith(".isml")) {
            return 1;
        }
        if (fileName.endsWith(".m3u8")) {
            return 2;
        }
        return 3;
    }

    public static int getDefaultBufferSize(int trackType) {
        switch (trackType) {
            case 0: {
                return 0x1000000;
            }
            case 1: {
                return 0x360000;
            }
            case 2: {
                return 0xC80000;
            }
            case 3: {
                return 131072;
            }
            case 4: {
                return 131072;
            }
        }
        throw new IllegalStateException();
    }

    public static String escapeFileName(String fileName) {
        int i;
        int length = fileName.length();
        int charactersToEscapeCount = 0;
        for (i = 0; i < length; ++i) {
            if (!Util.shouldEscapeCharacter(fileName.charAt(i))) continue;
            ++charactersToEscapeCount;
        }
        if (charactersToEscapeCount == 0) {
            return fileName;
        }
        i = 0;
        StringBuilder builder = new StringBuilder(length + charactersToEscapeCount * 2);
        while (charactersToEscapeCount > 0) {
            char c;
            if (Util.shouldEscapeCharacter(c = fileName.charAt(i++))) {
                builder.append('%').append(Integer.toHexString(c));
                --charactersToEscapeCount;
                continue;
            }
            builder.append(c);
        }
        if (i < length) {
            builder.append(fileName, i, length);
        }
        return builder.toString();
    }

    private static boolean shouldEscapeCharacter(char c) {
        switch (c) {
            case '\"': 
            case '%': 
            case '*': 
            case '/': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '\\': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    public static String unescapeFileName(String fileName) {
        int length = fileName.length();
        int percentCharacterCount = 0;
        for (int i = 0; i < length; ++i) {
            if (fileName.charAt(i) != '%') continue;
            ++percentCharacterCount;
        }
        if (percentCharacterCount == 0) {
            return fileName;
        }
        int expectedLength = length - percentCharacterCount * 2;
        StringBuilder builder = new StringBuilder(expectedLength);
        Matcher matcher = ESCAPED_CHARACTER_PATTERN.matcher(fileName);
        int endOfLastMatch = 0;
        while (percentCharacterCount > 0 && matcher.find()) {
            char unescapedCharacter = (char)Integer.parseInt(matcher.group(1), 16);
            builder.append(fileName, endOfLastMatch, matcher.start()).append(unescapedCharacter);
            endOfLastMatch = matcher.end();
            --percentCharacterCount;
        }
        if (endOfLastMatch < length) {
            builder.append(fileName, endOfLastMatch, length);
        }
        if (builder.length() != expectedLength) {
            return null;
        }
        return builder.toString();
    }

    public static int crc(byte[] bytes, int start, int end, int initialValue) {
        for (int i = start; i < end; ++i) {
            initialValue = initialValue << 8 ^ CRC32_BYTES_MSBF[(initialValue >>> 24 ^ bytes[i] & 0xFF) & 0xFF];
        }
        return initialValue;
    }

    public static String sha1(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] bytes = input.getBytes("UTF-8");
            digest.update(bytes, 0, bytes.length);
            return Util.getHexString(digest.digest());
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static Point getPhysicalDisplaySize(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        return Util.getPhysicalDisplaySize(context, windowManager.getDefaultDisplay());
    }

    public static Point getPhysicalDisplaySize(Context context, Display display) {
        if (SDK_INT < 25 && display.getDisplayId() == 0) {
            if ("Sony".equals(MANUFACTURER) && MODEL.startsWith("BRAVIA") && context.getPackageManager().hasSystemFeature("com.sony.dtv.hardware.panel.qfhd")) {
                return new Point(3840, 2160);
            }
            if ("NVIDIA".equals(MANUFACTURER) && MODEL.contains("SHIELD")) {
                String sysDisplaySize = null;
                try {
                    Class<?> systemProperties = Class.forName("android.os.SystemProperties");
                    Method getMethod = systemProperties.getMethod("get", String.class);
                    sysDisplaySize = (String)getMethod.invoke(systemProperties, "sys.display-size");
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Failed to read sys.display-size", (Throwable)e);
                }
                if (!TextUtils.isEmpty(sysDisplaySize)) {
                    try {
                        String[] sysDisplaySizeParts = sysDisplaySize.trim().split("x");
                        if (sysDisplaySizeParts.length == 2) {
                            int width = Integer.parseInt(sysDisplaySizeParts[0]);
                            int height = Integer.parseInt(sysDisplaySizeParts[1]);
                            if (width > 0 && height > 0) {
                                return new Point(width, height);
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    Log.e((String)TAG, (String)("Invalid sys.display-size: " + sysDisplaySize));
                }
            }
        }
        Point displaySize = new Point();
        if (SDK_INT >= 23) {
            Util.getDisplaySizeV23(display, displaySize);
        } else if (SDK_INT >= 17) {
            Util.getDisplaySizeV17(display, displaySize);
        } else if (SDK_INT >= 16) {
            Util.getDisplaySizeV16(display, displaySize);
        } else {
            Util.getDisplaySizeV9(display, displaySize);
        }
        return displaySize;
    }

    @TargetApi(value=23)
    private static void getDisplaySizeV23(Display display, Point outSize) {
        Display.Mode mode = display.getMode();
        outSize.x = mode.getPhysicalWidth();
        outSize.y = mode.getPhysicalHeight();
    }

    @TargetApi(value=17)
    private static void getDisplaySizeV17(Display display, Point outSize) {
        display.getRealSize(outSize);
    }

    @TargetApi(value=16)
    private static void getDisplaySizeV16(Display display, Point outSize) {
        display.getSize(outSize);
    }

    private static void getDisplaySizeV9(Display display, Point outSize) {
        outSize.x = display.getWidth();
        outSize.y = display.getHeight();
    }
}

