/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.net.Uri;
import android.text.TextUtils;

public final class UriUtil {
    private static final int INDEX_COUNT = 4;
    private static final int SCHEME_COLON = 0;
    private static final int PATH = 1;
    private static final int QUERY = 2;
    private static final int FRAGMENT = 3;

    private UriUtil() {
    }

    public static Uri resolveToUri(String baseUri, String referenceUri) {
        return Uri.parse((String)UriUtil.resolve(baseUri, referenceUri));
    }

    public static String resolve(String baseUri, String referenceUri) {
        StringBuilder uri = new StringBuilder();
        baseUri = baseUri == null ? "" : baseUri;
        int[] refIndices = UriUtil.getUriIndices(referenceUri = referenceUri == null ? "" : referenceUri);
        if (refIndices[0] != -1) {
            uri.append(referenceUri);
            UriUtil.removeDotSegments(uri, refIndices[1], refIndices[2]);
            return uri.toString();
        }
        int[] baseIndices = UriUtil.getUriIndices(baseUri);
        if (refIndices[3] == 0) {
            return uri.append(baseUri, 0, baseIndices[3]).append(referenceUri).toString();
        }
        if (refIndices[2] == 0) {
            return uri.append(baseUri, 0, baseIndices[2]).append(referenceUri).toString();
        }
        if (refIndices[1] != 0) {
            int baseLimit = baseIndices[0] + 1;
            uri.append(baseUri, 0, baseLimit).append(referenceUri);
            return UriUtil.removeDotSegments(uri, baseLimit + refIndices[1], baseLimit + refIndices[2]);
        }
        if (referenceUri.charAt(refIndices[1]) == '/') {
            uri.append(baseUri, 0, baseIndices[1]).append(referenceUri);
            return UriUtil.removeDotSegments(uri, baseIndices[1], baseIndices[1] + refIndices[2]);
        }
        if (baseIndices[0] + 2 < baseIndices[1] && baseIndices[1] == baseIndices[2]) {
            uri.append(baseUri, 0, baseIndices[1]).append('/').append(referenceUri);
            return UriUtil.removeDotSegments(uri, baseIndices[1], baseIndices[1] + refIndices[2] + 1);
        }
        int lastSlashIndex = baseUri.lastIndexOf(47, baseIndices[2] - 1);
        int baseLimit = lastSlashIndex == -1 ? baseIndices[1] : lastSlashIndex + 1;
        uri.append(baseUri, 0, baseLimit).append(referenceUri);
        return UriUtil.removeDotSegments(uri, baseIndices[1], baseLimit + refIndices[2]);
    }

    private static String removeDotSegments(StringBuilder uri, int offset, int limit) {
        if (offset >= limit) {
            return uri.toString();
        }
        if (uri.charAt(offset) == '/') {
            ++offset;
        }
        int segmentStart = offset;
        int i = offset;
        while (i <= limit) {
            int nextSegmentStart;
            if (i == limit) {
                nextSegmentStart = i;
            } else if (uri.charAt(i) == '/') {
                nextSegmentStart = i + 1;
            } else {
                ++i;
                continue;
            }
            if (i == segmentStart + 1 && uri.charAt(segmentStart) == '.') {
                uri.delete(segmentStart, nextSegmentStart);
                limit -= nextSegmentStart - segmentStart;
                i = segmentStart;
                continue;
            }
            if (i == segmentStart + 2 && uri.charAt(segmentStart) == '.' && uri.charAt(segmentStart + 1) == '.') {
                int prevSegmentStart = uri.lastIndexOf("/", segmentStart - 2) + 1;
                int removeFrom = prevSegmentStart > offset ? prevSegmentStart : offset;
                uri.delete(removeFrom, nextSegmentStart);
                limit -= nextSegmentStart - removeFrom;
                segmentStart = prevSegmentStart;
                i = prevSegmentStart;
                continue;
            }
            segmentStart = ++i;
        }
        return uri.toString();
    }

    private static int[] getUriIndices(String uriString) {
        int pathIndex;
        boolean hasAuthority;
        int schemeIndex;
        int schemeIndexLimit;
        int queryIndex;
        int[] indices = new int[4];
        if (TextUtils.isEmpty((CharSequence)uriString)) {
            indices[0] = -1;
            return indices;
        }
        int length = uriString.length();
        int fragmentIndex = uriString.indexOf(35);
        if (fragmentIndex == -1) {
            fragmentIndex = length;
        }
        if ((queryIndex = uriString.indexOf(63)) == -1 || queryIndex > fragmentIndex) {
            queryIndex = fragmentIndex;
        }
        if ((schemeIndexLimit = uriString.indexOf(47)) == -1 || schemeIndexLimit > queryIndex) {
            schemeIndexLimit = queryIndex;
        }
        if ((schemeIndex = uriString.indexOf(58)) > schemeIndexLimit) {
            schemeIndex = -1;
        }
        boolean bl = hasAuthority = schemeIndex + 2 < queryIndex && uriString.charAt(schemeIndex + 1) == '/' && uriString.charAt(schemeIndex + 2) == '/';
        if (hasAuthority) {
            pathIndex = uriString.indexOf(47, schemeIndex + 3);
            if (pathIndex == -1 || pathIndex > queryIndex) {
                pathIndex = queryIndex;
            }
        } else {
            pathIndex = schemeIndex + 1;
        }
        indices[0] = schemeIndex;
        indices[1] = pathIndex;
        indices[2] = queryIndex;
        indices[3] = fragmentIndex;
        return indices;
    }
}

