/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.os.SystemClock;
import com.google.android.exoplayer2.util.MediaClock;

public final class StandaloneMediaClock
implements MediaClock {
    private boolean started;
    private long positionUs;
    private long deltaUs;

    public void start() {
        if (!this.started) {
            this.started = true;
            this.deltaUs = this.elapsedRealtimeMinus(this.positionUs);
        }
    }

    public void stop() {
        if (this.started) {
            this.positionUs = this.elapsedRealtimeMinus(this.deltaUs);
            this.started = false;
        }
    }

    public void setPositionUs(long timeUs) {
        this.positionUs = timeUs;
        this.deltaUs = this.elapsedRealtimeMinus(timeUs);
    }

    @Override
    public long getPositionUs() {
        return this.started ? this.elapsedRealtimeMinus(this.deltaUs) : this.positionUs;
    }

    private long elapsedRealtimeMinus(long toSubtractUs) {
        return SystemClock.elapsedRealtime() * 1000L - toSubtractUs;
    }
}

