/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import com.google.android.exoplayer2.util.Assertions;

public final class ParsableBitArray {
    public byte[] data;
    private int byteOffset;
    private int bitOffset;
    private int byteLimit;

    public ParsableBitArray() {
    }

    public ParsableBitArray(byte[] data) {
        this(data, data.length);
    }

    public ParsableBitArray(byte[] data, int limit) {
        this.data = data;
        this.byteLimit = limit;
    }

    public void reset(byte[] data) {
        this.reset(data, data.length);
    }

    public void reset(byte[] data, int limit) {
        this.data = data;
        this.byteOffset = 0;
        this.bitOffset = 0;
        this.byteLimit = limit;
    }

    public int bitsLeft() {
        return (this.byteLimit - this.byteOffset) * 8 - this.bitOffset;
    }

    public int getPosition() {
        return this.byteOffset * 8 + this.bitOffset;
    }

    public void setPosition(int position) {
        this.byteOffset = position / 8;
        this.bitOffset = position - this.byteOffset * 8;
        this.assertValidOffset();
    }

    public void skipBits(int n) {
        this.byteOffset += n / 8;
        this.bitOffset += n % 8;
        if (this.bitOffset > 7) {
            ++this.byteOffset;
            this.bitOffset -= 8;
        }
        this.assertValidOffset();
    }

    public boolean readBit() {
        return this.readBits(1) == 1;
    }

    public int readBits(int numBits) {
        if (numBits == 0) {
            return 0;
        }
        int returnValue = 0;
        int wholeBytes = numBits / 8;
        for (int i = 0; i < wholeBytes; ++i) {
            int byteValue = this.bitOffset != 0 ? (this.data[this.byteOffset] & 0xFF) << this.bitOffset | (this.data[this.byteOffset + 1] & 0xFF) >>> 8 - this.bitOffset : this.data[this.byteOffset];
            returnValue |= (byteValue & 0xFF) << (numBits -= 8);
            ++this.byteOffset;
        }
        if (numBits > 0) {
            int nextBit = this.bitOffset + numBits;
            byte writeMask = (byte)(255 >> 8 - numBits);
            if (nextBit > 8) {
                returnValue |= ((this.data[this.byteOffset] & 0xFF) << nextBit - 8 | (this.data[this.byteOffset + 1] & 0xFF) >> 16 - nextBit) & writeMask;
                ++this.byteOffset;
            } else {
                returnValue |= (this.data[this.byteOffset] & 0xFF) >> 8 - nextBit & writeMask;
                if (nextBit == 8) {
                    ++this.byteOffset;
                }
            }
            this.bitOffset = nextBit % 8;
        }
        this.assertValidOffset();
        return returnValue;
    }

    private void assertValidOffset() {
        Assertions.checkState(this.byteOffset >= 0 && this.bitOffset >= 0 && this.bitOffset < 8 && (this.byteOffset < this.byteLimit || this.byteOffset == this.byteLimit && this.bitOffset == 0));
    }
}

