/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.cache;

import android.os.ConditionVariable;
import android.util.Pair;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheEvictor;
import com.google.android.exoplayer2.upstream.cache.CacheSpan;
import com.google.android.exoplayer2.util.Assertions;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class SimpleCache
implements Cache {
    private final File cacheDir;
    private final CacheEvictor evictor;
    private final HashMap<String, CacheSpan> lockedSpans;
    private final HashMap<String, Pair<Long, TreeSet<CacheSpan>>> cachedSpans;
    private final HashMap<String, ArrayList<Cache.Listener>> listeners;
    private long totalSpace = 0L;

    public SimpleCache(File cacheDir, CacheEvictor evictor) {
        this.cacheDir = cacheDir;
        this.evictor = evictor;
        this.lockedSpans = new HashMap();
        this.cachedSpans = new HashMap();
        this.listeners = new HashMap();
        final ConditionVariable conditionVariable = new ConditionVariable();
        new Thread("SimpleCache.initialize()"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SimpleCache simpleCache = SimpleCache.this;
                synchronized (simpleCache) {
                    conditionVariable.open();
                    SimpleCache.this.initialize();
                }
            }
        }.start();
        conditionVariable.block();
    }

    @Override
    public synchronized NavigableSet<CacheSpan> addListener(String key, Cache.Listener listener) {
        ArrayList<Cache.Listener> listenersForKey = this.listeners.get(key);
        if (listenersForKey == null) {
            listenersForKey = new ArrayList();
            this.listeners.put(key, listenersForKey);
        }
        listenersForKey.add(listener);
        return this.getCachedSpans(key);
    }

    @Override
    public synchronized void removeListener(String key, Cache.Listener listener) {
        ArrayList<Cache.Listener> listenersForKey = this.listeners.get(key);
        if (listenersForKey != null) {
            listenersForKey.remove(listener);
            if (listenersForKey.isEmpty()) {
                this.listeners.remove(key);
            }
        }
    }

    @Override
    public synchronized NavigableSet<CacheSpan> getCachedSpans(String key) {
        TreeSet<CacheSpan> spansForKey = this.getSpansForKey(key);
        return spansForKey == null ? null : new TreeSet<CacheSpan>((SortedSet<CacheSpan>)spansForKey);
    }

    @Override
    public synchronized Set<String> getKeys() {
        return new HashSet<String>(this.cachedSpans.keySet());
    }

    @Override
    public synchronized long getCacheSpace() {
        return this.totalSpace;
    }

    @Override
    public synchronized CacheSpan startReadWrite(String key, long position) throws InterruptedException {
        CacheSpan lookupSpan = CacheSpan.createLookup(key, position);
        CacheSpan span;
        while ((span = this.startReadWriteNonBlocking(lookupSpan)) == null) {
            this.wait();
        }
        return span;
    }

    @Override
    public synchronized CacheSpan startReadWriteNonBlocking(String key, long position) {
        return this.startReadWriteNonBlocking(CacheSpan.createLookup(key, position));
    }

    private synchronized CacheSpan startReadWriteNonBlocking(CacheSpan lookupSpan) {
        CacheSpan cacheSpan = this.getSpan(lookupSpan);
        if (cacheSpan.isCached) {
            CacheSpan newCacheSpan = cacheSpan.touch();
            this.replaceSpan(cacheSpan, newCacheSpan);
            this.notifySpanTouched(cacheSpan, newCacheSpan);
            return newCacheSpan;
        }
        if (!this.lockedSpans.containsKey(lookupSpan.key)) {
            this.lockedSpans.put(lookupSpan.key, cacheSpan);
            return cacheSpan;
        }
        return null;
    }

    @Override
    public synchronized File startFile(String key, long position, long maxLength) {
        Assertions.checkState(this.lockedSpans.containsKey(key));
        if (!this.cacheDir.exists()) {
            this.removeStaleSpans();
            this.cacheDir.mkdirs();
        }
        this.evictor.onStartFile(this, key, position, maxLength);
        return CacheSpan.getCacheFileName(this.cacheDir, key, position, System.currentTimeMillis());
    }

    @Override
    public synchronized void commitFile(File file) {
        CacheSpan span = CacheSpan.createCacheEntry(file);
        Assertions.checkState(span != null);
        Assertions.checkState(this.lockedSpans.containsKey(span.key));
        if (!file.exists()) {
            return;
        }
        if (file.length() == 0L) {
            file.delete();
            return;
        }
        Long length = this.getContentLength(span.key);
        if (length != -1L) {
            Assertions.checkState(span.position + span.length <= length);
        }
        this.addSpan(span);
        this.notifyAll();
    }

    @Override
    public synchronized void releaseHoleSpan(CacheSpan holeSpan) {
        Assertions.checkState(holeSpan == this.lockedSpans.remove(holeSpan.key));
        this.notifyAll();
    }

    private CacheSpan getSpan(CacheSpan lookupSpan) {
        String key = lookupSpan.key;
        long offset = lookupSpan.position;
        TreeSet<CacheSpan> entries = this.getSpansForKey(key);
        if (entries == null) {
            return CacheSpan.createOpenHole(key, lookupSpan.position);
        }
        CacheSpan floorSpan = entries.floor(lookupSpan);
        if (floorSpan != null && floorSpan.position <= offset && offset < floorSpan.position + floorSpan.length) {
            if (floorSpan.file.exists()) {
                return floorSpan;
            }
            this.removeStaleSpans();
            return this.getSpan(lookupSpan);
        }
        CacheSpan ceilEntry = entries.ceiling(lookupSpan);
        return ceilEntry == null ? CacheSpan.createOpenHole(key, lookupSpan.position) : CacheSpan.createClosedHole(key, lookupSpan.position, ceilEntry.position - lookupSpan.position);
    }

    private void initialize() {
        File[] files;
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
        }
        if ((files = this.cacheDir.listFiles()) == null) {
            return;
        }
        for (File file : files) {
            if (file.length() == 0L) {
                file.delete();
                continue;
            }
            CacheSpan span = CacheSpan.createCacheEntry(file = CacheSpan.upgradeIfNeeded(file));
            if (span == null) {
                file.delete();
                continue;
            }
            this.addSpan(span);
        }
        this.evictor.onCacheInitialized();
    }

    private void addSpan(CacheSpan span) {
        TreeSet spansForKey;
        Pair<Long, TreeSet<CacheSpan>> entryForKey = this.cachedSpans.get(span.key);
        if (entryForKey == null) {
            spansForKey = new TreeSet();
            this.setKeyValue(span.key, -1L, spansForKey);
        } else {
            spansForKey = (TreeSet)entryForKey.second;
        }
        spansForKey.add(span);
        this.totalSpace += span.length;
        this.notifySpanAdded(span);
    }

    @Override
    public synchronized void removeSpan(CacheSpan span) {
        TreeSet<CacheSpan> spansForKey = this.getSpansForKey(span.key);
        this.totalSpace -= span.length;
        Assertions.checkState(spansForKey.remove(span));
        span.file.delete();
        if (spansForKey.isEmpty()) {
            this.cachedSpans.remove(span.key);
        }
        this.notifySpanRemoved(span);
    }

    private void removeStaleSpans() {
        Iterator<Map.Entry<String, Pair<Long, TreeSet<CacheSpan>>>> iterator = this.cachedSpans.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Pair<Long, TreeSet<CacheSpan>>> next = iterator.next();
            Iterator spanIterator = ((TreeSet)next.getValue().second).iterator();
            boolean isEmpty = true;
            while (spanIterator.hasNext()) {
                CacheSpan span = (CacheSpan)spanIterator.next();
                if (!span.file.exists()) {
                    spanIterator.remove();
                    if (span.isCached) {
                        this.totalSpace -= span.length;
                    }
                    this.notifySpanRemoved(span);
                    continue;
                }
                isEmpty = false;
            }
            if (!isEmpty) continue;
            iterator.remove();
        }
    }

    private void notifySpanRemoved(CacheSpan span) {
        ArrayList<Cache.Listener> keyListeners = this.listeners.get(span.key);
        if (keyListeners != null) {
            for (int i = keyListeners.size() - 1; i >= 0; --i) {
                keyListeners.get(i).onSpanRemoved(this, span);
            }
        }
        this.evictor.onSpanRemoved(this, span);
    }

    private void notifySpanAdded(CacheSpan span) {
        ArrayList<Cache.Listener> keyListeners = this.listeners.get(span.key);
        if (keyListeners != null) {
            for (int i = keyListeners.size() - 1; i >= 0; --i) {
                keyListeners.get(i).onSpanAdded(this, span);
            }
        }
        this.evictor.onSpanAdded(this, span);
    }

    private void notifySpanTouched(CacheSpan oldSpan, CacheSpan newSpan) {
        ArrayList<Cache.Listener> keyListeners = this.listeners.get(oldSpan.key);
        if (keyListeners != null) {
            for (int i = keyListeners.size() - 1; i >= 0; --i) {
                keyListeners.get(i).onSpanTouched(this, oldSpan, newSpan);
            }
        }
        this.evictor.onSpanTouched(this, oldSpan, newSpan);
    }

    @Override
    public synchronized boolean isCached(String key, long position, long length) {
        TreeSet<CacheSpan> entries = this.getSpansForKey(key);
        if (entries == null) {
            return false;
        }
        CacheSpan lookupSpan = CacheSpan.createLookup(key, position);
        CacheSpan floorSpan = entries.floor(lookupSpan);
        if (floorSpan == null || floorSpan.position + floorSpan.length <= position) {
            return false;
        }
        long currentEndPosition = floorSpan.position + floorSpan.length;
        long queryEndPosition = position + length;
        if (currentEndPosition >= queryEndPosition) {
            return true;
        }
        for (CacheSpan next : entries.tailSet(floorSpan, false)) {
            if (next.position > currentEndPosition) {
                return false;
            }
            if ((currentEndPosition = Math.max(currentEndPosition, next.position + next.length)) < queryEndPosition) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean setContentLength(String key, long length) {
        TreeSet<CacheSpan> entries;
        Pair<Long, TreeSet<CacheSpan>> entryForKey = this.cachedSpans.get(key);
        if (entryForKey != null) {
            entries = (TreeSet<CacheSpan>)entryForKey.second;
            if (entries != null && !entries.isEmpty()) {
                CacheSpan last = entries.last();
                long end = last.position + last.length;
                if (end > length) {
                    return false;
                }
            }
        } else {
            entries = new TreeSet<CacheSpan>();
        }
        this.setKeyValue(key, length, entries);
        return true;
    }

    @Override
    public synchronized long getContentLength(String key) {
        Pair<Long, TreeSet<CacheSpan>> entryForKey = this.cachedSpans.get(key);
        return entryForKey == null ? -1L : (Long)entryForKey.first;
    }

    private TreeSet<CacheSpan> getSpansForKey(String key) {
        Pair<Long, TreeSet<CacheSpan>> entryForKey = this.cachedSpans.get(key);
        return entryForKey != null ? (TreeSet)entryForKey.second : null;
    }

    private void setKeyValue(String key, long length, TreeSet<CacheSpan> entries) {
        this.cachedSpans.put(key, (Pair<Long, TreeSet<CacheSpan>>)Pair.create((Object)length, entries));
    }

    private void replaceSpan(CacheSpan oldSpan, CacheSpan newSpan) {
        TreeSet<CacheSpan> spansForKey = this.getSpansForKey(oldSpan.key);
        Assertions.checkState(spansForKey.remove(oldSpan));
        spansForKey.add(newSpan);
    }
}

