/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.cache;

import android.net.Uri;
import android.util.Log;
import com.google.android.exoplayer2.upstream.DataSink;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSourceException;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.FileDataSource;
import com.google.android.exoplayer2.upstream.TeeDataSource;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSink;
import com.google.android.exoplayer2.upstream.cache.CacheSpan;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class CacheDataSource
implements DataSource {
    public static final long DEFAULT_MAX_CACHE_FILE_SIZE = 0x200000L;
    public static final int FLAG_BLOCK_ON_CACHE = 1;
    public static final int FLAG_IGNORE_CACHE_ON_ERROR = 2;
    public static final int FLAG_CACHE_UNBOUNDED_REQUESTS = 4;
    private static final String TAG = "CacheDataSource";
    private final Cache cache;
    private final DataSource cacheReadDataSource;
    private final DataSource cacheWriteDataSource;
    private final DataSource upstreamDataSource;
    private final EventListener eventListener;
    private final boolean blockOnCache;
    private final boolean ignoreCacheOnError;
    private final boolean bypassUnboundedRequests;
    private DataSource currentDataSource;
    private boolean currentRequestUnbounded;
    private Uri uri;
    private int flags;
    private String key;
    private long readPosition;
    private long bytesRemaining;
    private CacheSpan lockedSpan;
    private boolean seenCacheError;
    private boolean currentRequestIgnoresCache;
    private long totalCachedBytesRead;

    public CacheDataSource(Cache cache, DataSource upstream, int flags) {
        this(cache, upstream, flags, 0x200000L);
    }

    public CacheDataSource(Cache cache, DataSource upstream, int flags, long maxCacheFileSize) {
        this(cache, upstream, new FileDataSource(), new CacheDataSink(cache, maxCacheFileSize), flags, null);
    }

    public CacheDataSource(Cache cache, DataSource upstream, DataSource cacheReadDataSource, DataSink cacheWriteDataSink, int flags, EventListener eventListener) {
        this.cache = cache;
        this.cacheReadDataSource = cacheReadDataSource;
        this.blockOnCache = (flags & 1) != 0;
        this.ignoreCacheOnError = (flags & 2) != 0;
        this.bypassUnboundedRequests = (flags & 4) == 0;
        this.upstreamDataSource = upstream;
        this.cacheWriteDataSource = cacheWriteDataSink != null ? new TeeDataSource(upstream, cacheWriteDataSink) : null;
        this.eventListener = eventListener;
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        try {
            this.uri = dataSpec.uri;
            this.flags = dataSpec.flags;
            this.key = dataSpec.key;
            this.readPosition = dataSpec.position;
            boolean bl = this.currentRequestIgnoresCache = this.ignoreCacheOnError && this.seenCacheError || this.bypassUnboundedRequests && dataSpec.length == -1L;
            if (dataSpec.length != -1L || this.currentRequestIgnoresCache) {
                this.bytesRemaining = dataSpec.length;
            } else {
                this.bytesRemaining = this.cache.getContentLength(this.key);
                if (this.bytesRemaining != -1L) {
                    this.bytesRemaining -= dataSpec.position;
                }
            }
            this.openNextSource(true);
            return this.bytesRemaining;
        }
        catch (IOException e) {
            this.handleBeforeThrow(e);
            throw e;
        }
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) throws IOException {
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        try {
            int bytesRead = this.currentDataSource.read(buffer, offset, readLength);
            if (bytesRead >= 0) {
                if (this.currentDataSource == this.cacheReadDataSource) {
                    this.totalCachedBytesRead += (long)bytesRead;
                }
                this.readPosition += (long)bytesRead;
                if (this.bytesRemaining != -1L) {
                    this.bytesRemaining -= (long)bytesRead;
                }
            } else {
                if (this.currentRequestUnbounded) {
                    this.setContentLength(this.readPosition);
                    this.bytesRemaining = 0L;
                }
                this.closeCurrentSource();
                if ((this.bytesRemaining > 0L || this.bytesRemaining == -1L) && this.openNextSource(false)) {
                    return this.read(buffer, offset, readLength);
                }
            }
            return bytesRead;
        }
        catch (IOException e) {
            this.handleBeforeThrow(e);
            throw e;
        }
    }

    @Override
    public Uri getUri() {
        return this.currentDataSource == this.upstreamDataSource ? this.currentDataSource.getUri() : this.uri;
    }

    @Override
    public void close() throws IOException {
        this.uri = null;
        this.notifyBytesRead();
        try {
            this.closeCurrentSource();
        }
        catch (IOException e) {
            this.handleBeforeThrow(e);
            throw e;
        }
    }

    private boolean openNextSource(boolean initial) throws IOException {
        long currentBytesRemaining;
        boolean successful;
        DataSpec dataSpec;
        block20: {
            CacheSpan span;
            if (this.currentRequestIgnoresCache) {
                span = null;
            } else if (this.blockOnCache) {
                try {
                    span = this.cache.startReadWrite(this.key, this.readPosition);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            } else {
                span = this.cache.startReadWriteNonBlocking(this.key, this.readPosition);
            }
            if (span == null) {
                this.currentDataSource = this.upstreamDataSource;
                dataSpec = new DataSpec(this.uri, this.readPosition, this.bytesRemaining, this.key, this.flags);
            } else if (span.isCached) {
                Uri fileUri = Uri.fromFile((File)span.file);
                long filePosition = this.readPosition - span.position;
                long length = span.length - filePosition;
                if (this.bytesRemaining != -1L) {
                    length = Math.min(length, this.bytesRemaining);
                }
                dataSpec = new DataSpec(fileUri, this.readPosition, filePosition, length, this.key, this.flags);
                this.currentDataSource = this.cacheReadDataSource;
            } else {
                long length;
                this.lockedSpan = span;
                if (span.isOpenEnded()) {
                    length = this.bytesRemaining;
                } else {
                    length = span.length;
                    if (this.bytesRemaining != -1L) {
                        length = Math.min(length, this.bytesRemaining);
                    }
                }
                dataSpec = new DataSpec(this.uri, this.readPosition, length, this.key, this.flags);
                this.currentDataSource = this.cacheWriteDataSource != null ? this.cacheWriteDataSource : this.upstreamDataSource;
            }
            this.currentRequestUnbounded = dataSpec.length == -1L;
            successful = false;
            currentBytesRemaining = 0L;
            try {
                currentBytesRemaining = this.currentDataSource.open(dataSpec);
                successful = true;
            }
            catch (IOException e2) {
                Object e2;
                if (!initial && this.currentRequestUnbounded) {
                    for (Throwable cause = e2; cause != null; cause = cause.getCause()) {
                        int reason;
                        if (!(cause instanceof DataSourceException) || (reason = ((DataSourceException)cause).reason) != 0) continue;
                        e2 = null;
                        break;
                    }
                }
                if (e2 == null) break block20;
                throw e2;
            }
        }
        if (this.currentRequestUnbounded && currentBytesRemaining != -1L) {
            this.bytesRemaining = currentBytesRemaining;
            if (this.lockedSpan != null) {
                this.setContentLength(dataSpec.position + this.bytesRemaining);
            }
        }
        return successful;
    }

    private void setContentLength(long length) {
        if (!this.cache.setContentLength(this.key, length)) {
            Log.e((String)TAG, (String)("cache.setContentLength(" + length + ") failed. cache.getContentLength() = " + this.cache.getContentLength(this.key)));
        }
    }

    private void closeCurrentSource() throws IOException {
        if (this.currentDataSource == null) {
            return;
        }
        try {
            this.currentDataSource.close();
            this.currentDataSource = null;
            this.currentRequestUnbounded = false;
        }
        finally {
            if (this.lockedSpan != null) {
                this.cache.releaseHoleSpan(this.lockedSpan);
                this.lockedSpan = null;
            }
        }
    }

    private void handleBeforeThrow(IOException exception) {
        if (this.currentDataSource == this.cacheReadDataSource || exception instanceof CacheDataSink.CacheDataSinkException) {
            this.seenCacheError = true;
        }
    }

    private void notifyBytesRead() {
        if (this.eventListener != null && this.totalCachedBytesRead > 0L) {
            this.eventListener.onCachedBytesRead(this.cache.getCacheSpace(), this.totalCachedBytesRead);
            this.totalCachedBytesRead = 0L;
        }
    }

    public static interface EventListener {
        public void onCachedBytesRead(long var1, long var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

