/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.net.Uri;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.TransferListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

public final class UdpDataSource
implements DataSource {
    public static final int DEFAULT_MAX_PACKET_SIZE = 2000;
    public static final int DEAFULT_SOCKET_TIMEOUT_MILLIS = 8000;
    private final TransferListener<? super UdpDataSource> listener;
    private final int socketTimeoutMillis;
    private final byte[] packetBuffer;
    private final DatagramPacket packet;
    private Uri uri;
    private DatagramSocket socket;
    private MulticastSocket multicastSocket;
    private InetAddress address;
    private InetSocketAddress socketAddress;
    private boolean opened;
    private int packetRemaining;

    public UdpDataSource(TransferListener<? super UdpDataSource> listener) {
        this(listener, 2000);
    }

    public UdpDataSource(TransferListener<? super UdpDataSource> listener, int maxPacketSize) {
        this(listener, maxPacketSize, 8000);
    }

    public UdpDataSource(TransferListener<? super UdpDataSource> listener, int maxPacketSize, int socketTimeoutMillis) {
        this.listener = listener;
        this.socketTimeoutMillis = socketTimeoutMillis;
        this.packetBuffer = new byte[maxPacketSize];
        this.packet = new DatagramPacket(this.packetBuffer, 0, maxPacketSize);
    }

    @Override
    public long open(DataSpec dataSpec) throws UdpDataSourceException {
        this.uri = dataSpec.uri;
        String host = this.uri.getHost();
        int port = this.uri.getPort();
        try {
            this.address = InetAddress.getByName(host);
            this.socketAddress = new InetSocketAddress(this.address, port);
            if (this.address.isMulticastAddress()) {
                this.multicastSocket = new MulticastSocket(this.socketAddress);
                this.multicastSocket.joinGroup(this.address);
                this.socket = this.multicastSocket;
            } else {
                this.socket = new DatagramSocket(this.socketAddress);
            }
        }
        catch (IOException e) {
            throw new UdpDataSourceException(e);
        }
        try {
            this.socket.setSoTimeout(this.socketTimeoutMillis);
        }
        catch (SocketException e) {
            throw new UdpDataSourceException(e);
        }
        this.opened = true;
        if (this.listener != null) {
            this.listener.onTransferStart(this, dataSpec);
        }
        return -1L;
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) throws UdpDataSourceException {
        if (readLength == 0) {
            return 0;
        }
        if (this.packetRemaining == 0) {
            try {
                this.socket.receive(this.packet);
            }
            catch (IOException e) {
                throw new UdpDataSourceException(e);
            }
            this.packetRemaining = this.packet.getLength();
            if (this.listener != null) {
                this.listener.onBytesTransferred(this, this.packetRemaining);
            }
        }
        int packetOffset = this.packet.getLength() - this.packetRemaining;
        int bytesToRead = Math.min(this.packetRemaining, readLength);
        System.arraycopy(this.packetBuffer, packetOffset, buffer, offset, bytesToRead);
        this.packetRemaining -= bytesToRead;
        return bytesToRead;
    }

    @Override
    public Uri getUri() {
        return this.uri;
    }

    @Override
    public void close() {
        this.uri = null;
        if (this.multicastSocket != null) {
            try {
                this.multicastSocket.leaveGroup(this.address);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.multicastSocket = null;
        }
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        this.address = null;
        this.socketAddress = null;
        this.packetRemaining = 0;
        if (this.opened) {
            this.opened = false;
            if (this.listener != null) {
                this.listener.onTransferEnd(this);
            }
        }
    }

    public static final class UdpDataSourceException
    extends IOException {
        public UdpDataSourceException(IOException cause) {
            super(cause);
        }
    }
}

