/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.TransferListener;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class RawResourceDataSource
implements DataSource {
    private static final String RAW_RESOURCE_SCHEME = "rawresource";
    private final Resources resources;
    private final TransferListener<? super RawResourceDataSource> listener;
    private Uri uri;
    private AssetFileDescriptor assetFileDescriptor;
    private InputStream inputStream;
    private long bytesRemaining;
    private boolean opened;

    public static final Uri buildRawResourceUri(int rawResourceId) {
        return Uri.parse((String)("rawresource:///" + rawResourceId));
    }

    public RawResourceDataSource(Context context) {
        this(context, null);
    }

    public RawResourceDataSource(Context context, TransferListener<? super RawResourceDataSource> listener) {
        this.resources = context.getResources();
        this.listener = listener;
    }

    @Override
    public long open(DataSpec dataSpec) throws RawResourceDataSourceException {
        try {
            long assetFileDescriptorLength;
            int resourceId;
            this.uri = dataSpec.uri;
            if (!TextUtils.equals((CharSequence)RAW_RESOURCE_SCHEME, (CharSequence)this.uri.getScheme())) {
                throw new RawResourceDataSourceException("URI must use scheme rawresource");
            }
            try {
                resourceId = Integer.parseInt(this.uri.getLastPathSegment());
            }
            catch (NumberFormatException e) {
                throw new RawResourceDataSourceException("Resource identifier must be an integer.");
            }
            this.assetFileDescriptor = this.resources.openRawResourceFd(resourceId);
            this.inputStream = new FileInputStream(this.assetFileDescriptor.getFileDescriptor());
            this.inputStream.skip(this.assetFileDescriptor.getStartOffset());
            long skipped = this.inputStream.skip(dataSpec.position);
            if (skipped < dataSpec.position) {
                throw new EOFException();
            }
            this.bytesRemaining = dataSpec.length != -1L ? dataSpec.length : ((assetFileDescriptorLength = this.assetFileDescriptor.getLength()) == -1L ? -1L : assetFileDescriptorLength - dataSpec.position);
        }
        catch (IOException e) {
            throw new RawResourceDataSourceException(e);
        }
        this.opened = true;
        if (this.listener != null) {
            this.listener.onTransferStart(this, dataSpec);
        }
        return this.bytesRemaining;
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) throws RawResourceDataSourceException {
        int bytesRead;
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        try {
            int bytesToRead = this.bytesRemaining == -1L ? readLength : (int)Math.min(this.bytesRemaining, (long)readLength);
            bytesRead = this.inputStream.read(buffer, offset, bytesToRead);
        }
        catch (IOException e) {
            throw new RawResourceDataSourceException(e);
        }
        if (bytesRead == -1) {
            if (this.bytesRemaining != -1L) {
                throw new RawResourceDataSourceException(new EOFException());
            }
            return -1;
        }
        if (this.bytesRemaining != -1L) {
            this.bytesRemaining -= (long)bytesRead;
        }
        if (this.listener != null) {
            this.listener.onBytesTransferred(this, bytesRead);
        }
        return bytesRead;
    }

    @Override
    public Uri getUri() {
        return this.uri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws RawResourceDataSourceException {
        this.uri = null;
        try {
            if (this.inputStream == null) return;
            this.inputStream.close();
            return;
        }
        catch (IOException e) {
            throw new RawResourceDataSourceException(e);
        }
        finally {
            this.inputStream = null;
            try {
                if (this.assetFileDescriptor != null) {
                    this.assetFileDescriptor.close();
                }
            }
            catch (IOException e) {
                throw new RawResourceDataSourceException(e);
            }
            finally {
                this.assetFileDescriptor = null;
                if (this.opened) {
                    this.opened = false;
                    if (this.listener != null) {
                        this.listener.onTransferEnd(this);
                    }
                }
            }
        }
    }

    public static class RawResourceDataSourceException
    extends IOException {
        public RawResourceDataSourceException(String message) {
            super(message);
        }

        public RawResourceDataSourceException(IOException e) {
            super(e);
        }
    }
}

