/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.net.Uri;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.PriorityTaskManager;
import java.io.IOException;

public final class PriorityDataSource
implements DataSource {
    private final DataSource upstream;
    private final PriorityTaskManager priorityTaskManager;
    private final int priority;

    public PriorityDataSource(DataSource upstream, PriorityTaskManager priorityTaskManager, int priority) {
        this.upstream = Assertions.checkNotNull(upstream);
        this.priorityTaskManager = Assertions.checkNotNull(priorityTaskManager);
        this.priority = priority;
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        this.priorityTaskManager.proceedOrThrow(this.priority);
        return this.upstream.open(dataSpec);
    }

    @Override
    public int read(byte[] buffer, int offset, int max) throws IOException {
        this.priorityTaskManager.proceedOrThrow(this.priority);
        return this.upstream.read(buffer, offset, max);
    }

    @Override
    public Uri getUri() {
        return this.upstream.getUri();
    }

    @Override
    public void close() throws IOException {
        this.upstream.close();
    }
}

