/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.net.Uri;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSourceInputStream;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.Loader;
import java.io.IOException;
import java.io.InputStream;

public final class ParsingLoadable<T>
implements Loader.Loadable {
    public final DataSpec dataSpec;
    public final int type;
    private final DataSource dataSource;
    private final Parser<T> parser;
    private volatile T result;
    private volatile boolean isCanceled;
    private volatile long bytesLoaded;

    public ParsingLoadable(DataSource dataSource, Uri uri, int type, Parser<T> parser) {
        this.dataSource = dataSource;
        this.dataSpec = new DataSpec(uri, 1);
        this.type = type;
        this.parser = parser;
    }

    public final T getResult() {
        return this.result;
    }

    public long bytesLoaded() {
        return this.bytesLoaded;
    }

    @Override
    public final void cancelLoad() {
        this.isCanceled = true;
    }

    @Override
    public final boolean isLoadCanceled() {
        return this.isCanceled;
    }

    @Override
    public final void load() throws IOException, InterruptedException {
        DataSourceInputStream inputStream = new DataSourceInputStream(this.dataSource, this.dataSpec);
        try {
            inputStream.open();
            this.result = this.parser.parse(this.dataSource.getUri(), inputStream);
        }
        finally {
            inputStream.close();
            this.bytesLoaded = inputStream.bytesRead();
        }
    }

    public static interface Parser<T> {
        public T parse(Uri var1, InputStream var2) throws IOException;
    }
}

