/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.exoplayer2.upstream.LoaderErrorThrower;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.TraceUtil;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.concurrent.ExecutorService;

public final class Loader
implements LoaderErrorThrower {
    public static final int RETRY = 0;
    public static final int RETRY_RESET_ERROR_COUNT = 1;
    public static final int DONT_RETRY = 2;
    public static final int DONT_RETRY_FATAL = 3;
    private static final int MSG_START = 0;
    private static final int MSG_CANCEL = 1;
    private static final int MSG_END_OF_SOURCE = 2;
    private static final int MSG_IO_EXCEPTION = 3;
    private static final int MSG_FATAL_ERROR = 4;
    private final ExecutorService downloadExecutorService;
    private LoadTask<? extends Loadable> currentTask;
    private IOException fatalError;

    public Loader(String threadName) {
        this.downloadExecutorService = Util.newSingleThreadExecutor(threadName);
    }

    public <T extends Loadable> long startLoading(T loadable, Callback<T> callback, int defaultMinRetryCount) {
        Looper looper = Looper.myLooper();
        Assertions.checkState(looper != null);
        long startTimeMs = SystemClock.elapsedRealtime();
        new LoadTask(this, looper, loadable, callback, defaultMinRetryCount, startTimeMs).start(0L);
        return startTimeMs;
    }

    public boolean isLoading() {
        return this.currentTask != null;
    }

    public void cancelLoading() {
        this.currentTask.cancel(false);
    }

    public void release() {
        this.release(null);
    }

    public void release(Runnable postLoadAction) {
        if (this.currentTask != null) {
            this.currentTask.cancel(true);
        }
        if (postLoadAction != null) {
            this.downloadExecutorService.submit(postLoadAction);
        }
        this.downloadExecutorService.shutdown();
    }

    @Override
    public void maybeThrowError() throws IOException {
        this.maybeThrowError(Integer.MIN_VALUE);
    }

    @Override
    public void maybeThrowError(int minRetryCount) throws IOException {
        if (this.fatalError != null) {
            throw this.fatalError;
        }
        if (this.currentTask != null) {
            this.currentTask.maybeThrowError(minRetryCount == Integer.MIN_VALUE ? this.currentTask.defaultMinRetryCount : minRetryCount);
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private final class LoadTask<T extends Loadable>
    extends Handler
    implements Runnable {
        private static final String TAG = "LoadTask";
        private final T loadable;
        private final Callback<T> callback;
        public final int defaultMinRetryCount;
        private final long startTimeMs;
        private IOException currentError;
        private int errorCount;
        private volatile Thread executorThread;
        private volatile boolean released;
        final /* synthetic */ Loader this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public LoadTask(Looper loadable, T callback, Callback<T> defaultMinRetryCount, int startTimeMs, long l2) {
            void looper;
            this.this$0 = (Loader)l;
            super((Looper)looper);
            this.loadable = loadable;
            this.callback = callback;
            this.defaultMinRetryCount = (int)defaultMinRetryCount;
            this.startTimeMs = startTimeMs;
        }

        public void maybeThrowError(int minRetryCount) throws IOException {
            if (this.currentError != null && this.errorCount > minRetryCount) {
                throw this.currentError;
            }
        }

        public void start(long delayMillis) {
            Assertions.checkState(this.this$0.currentTask == null);
            this.this$0.currentTask = this;
            if (delayMillis > 0L) {
                this.sendEmptyMessageDelayed(0, delayMillis);
            } else {
                this.submitToExecutor();
            }
        }

        public void cancel(boolean released) {
            this.released = released;
            this.currentError = null;
            if (this.hasMessages(0)) {
                this.removeMessages(0);
                if (!released) {
                    this.sendEmptyMessage(1);
                }
            } else {
                this.loadable.cancelLoad();
                if (this.executorThread != null) {
                    this.executorThread.interrupt();
                }
            }
            if (released) {
                this.finish();
                long nowMs = SystemClock.elapsedRealtime();
                this.callback.onLoadCanceled(this.loadable, nowMs, nowMs - this.startTimeMs, true);
            }
        }

        @Override
        public void run() {
            try {
                this.executorThread = Thread.currentThread();
                if (!this.loadable.isLoadCanceled()) {
                    TraceUtil.beginSection("load:" + this.loadable.getClass().getSimpleName());
                    try {
                        this.loadable.load();
                    }
                    finally {
                        TraceUtil.endSection();
                    }
                }
                if (!this.released) {
                    this.sendEmptyMessage(2);
                }
            }
            catch (IOException e) {
                if (!this.released) {
                    this.obtainMessage(3, e).sendToTarget();
                }
            }
            catch (InterruptedException e) {
                Assertions.checkState(this.loadable.isLoadCanceled());
                if (!this.released) {
                    this.sendEmptyMessage(2);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Unexpected exception loading stream", (Throwable)e);
                if (!this.released) {
                    this.obtainMessage(3, new UnexpectedLoaderException(e)).sendToTarget();
                }
            }
            catch (Error e) {
                Log.e((String)TAG, (String)"Unexpected error loading stream", (Throwable)e);
                if (!this.released) {
                    this.obtainMessage(4, e).sendToTarget();
                }
                throw e;
            }
        }

        public void handleMessage(Message msg) {
            if (this.released) {
                return;
            }
            if (msg.what == 0) {
                this.submitToExecutor();
                return;
            }
            if (msg.what == 4) {
                throw (Error)msg.obj;
            }
            this.finish();
            long nowMs = SystemClock.elapsedRealtime();
            long durationMs = nowMs - this.startTimeMs;
            if (this.loadable.isLoadCanceled()) {
                this.callback.onLoadCanceled(this.loadable, nowMs, durationMs, false);
                return;
            }
            switch (msg.what) {
                case 1: {
                    this.callback.onLoadCanceled(this.loadable, nowMs, durationMs, false);
                    break;
                }
                case 2: {
                    this.callback.onLoadCompleted(this.loadable, nowMs, durationMs);
                    break;
                }
                case 3: {
                    this.currentError = (IOException)msg.obj;
                    int retryAction = this.callback.onLoadError(this.loadable, nowMs, durationMs, this.currentError);
                    if (retryAction == 3) {
                        this.this$0.fatalError = this.currentError;
                        break;
                    }
                    if (retryAction == 2) break;
                    this.errorCount = retryAction == 1 ? 1 : this.errorCount + 1;
                    this.start(this.getRetryDelayMillis());
                }
            }
        }

        private void submitToExecutor() {
            this.currentError = null;
            this.this$0.downloadExecutorService.submit(this.this$0.currentTask);
        }

        private void finish() {
            this.this$0.currentTask = null;
        }

        private long getRetryDelayMillis() {
            return Math.min((this.errorCount - 1) * 1000, 5000);
        }
    }

    public static interface Callback<T extends Loadable> {
        public void onLoadCompleted(T var1, long var2, long var4);

        public void onLoadCanceled(T var1, long var2, long var4, boolean var6);

        public int onLoadError(T var1, long var2, long var4, IOException var6);
    }

    public static interface Loadable {
        public void cancelLoad();

        public boolean isLoadCanceled();

        public void load() throws IOException, InterruptedException;
    }

    public static final class UnexpectedLoaderException
    extends IOException {
        public UnexpectedLoaderException(Exception cause) {
            super("Unexpected " + cause.getClass().getSimpleName() + ": " + cause.getMessage(), cause);
        }
    }
}

