/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.net.Uri;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.TransferListener;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class FileDataSource
implements DataSource {
    private final TransferListener<? super FileDataSource> listener;
    private RandomAccessFile file;
    private Uri uri;
    private long bytesRemaining;
    private boolean opened;

    public FileDataSource() {
        this(null);
    }

    public FileDataSource(TransferListener<? super FileDataSource> listener) {
        this.listener = listener;
    }

    @Override
    public long open(DataSpec dataSpec) throws FileDataSourceException {
        try {
            this.uri = dataSpec.uri;
            this.file = new RandomAccessFile(dataSpec.uri.getPath(), "r");
            this.file.seek(dataSpec.position);
            long l = this.bytesRemaining = dataSpec.length == -1L ? this.file.length() - dataSpec.position : dataSpec.length;
            if (this.bytesRemaining < 0L) {
                throw new EOFException();
            }
        }
        catch (IOException e) {
            throw new FileDataSourceException(e);
        }
        this.opened = true;
        if (this.listener != null) {
            this.listener.onTransferStart(this, dataSpec);
        }
        return this.bytesRemaining;
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) throws FileDataSourceException {
        int bytesRead;
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        try {
            bytesRead = this.file.read(buffer, offset, (int)Math.min(this.bytesRemaining, (long)readLength));
        }
        catch (IOException e) {
            throw new FileDataSourceException(e);
        }
        if (bytesRead > 0) {
            this.bytesRemaining -= (long)bytesRead;
            if (this.listener != null) {
                this.listener.onBytesTransferred(this, bytesRead);
            }
        }
        return bytesRead;
    }

    @Override
    public Uri getUri() {
        return this.uri;
    }

    @Override
    public void close() throws FileDataSourceException {
        this.uri = null;
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (IOException e) {
            throw new FileDataSourceException(e);
        }
        finally {
            this.file = null;
            if (this.opened) {
                this.opened = false;
                if (this.listener != null) {
                    this.listener.onTransferEnd(this);
                }
            }
        }
    }

    public static class FileDataSourceException
    extends IOException {
        public FileDataSourceException(IOException cause) {
            super(cause);
        }
    }
}

