/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.TransferListener;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ContentDataSource
implements DataSource {
    private final ContentResolver resolver;
    private final TransferListener<? super ContentDataSource> listener;
    private Uri uri;
    private AssetFileDescriptor assetFileDescriptor;
    private InputStream inputStream;
    private long bytesRemaining;
    private boolean opened;

    public ContentDataSource(Context context) {
        this(context, null);
    }

    public ContentDataSource(Context context, TransferListener<? super ContentDataSource> listener) {
        this.resolver = context.getContentResolver();
        this.listener = listener;
    }

    @Override
    public long open(DataSpec dataSpec) throws ContentDataSourceException {
        try {
            this.uri = dataSpec.uri;
            this.assetFileDescriptor = this.resolver.openAssetFileDescriptor(this.uri, "r");
            this.inputStream = new FileInputStream(this.assetFileDescriptor.getFileDescriptor());
            long skipped = this.inputStream.skip(dataSpec.position);
            if (skipped < dataSpec.position) {
                throw new EOFException();
            }
            if (dataSpec.length != -1L) {
                this.bytesRemaining = dataSpec.length;
            } else {
                this.bytesRemaining = this.inputStream.available();
                if (this.bytesRemaining == 0L) {
                    this.bytesRemaining = -1L;
                }
            }
        }
        catch (IOException e) {
            throw new ContentDataSourceException(e);
        }
        this.opened = true;
        if (this.listener != null) {
            this.listener.onTransferStart(this, dataSpec);
        }
        return this.bytesRemaining;
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) throws ContentDataSourceException {
        int bytesRead;
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        try {
            int bytesToRead = this.bytesRemaining == -1L ? readLength : (int)Math.min(this.bytesRemaining, (long)readLength);
            bytesRead = this.inputStream.read(buffer, offset, bytesToRead);
        }
        catch (IOException e) {
            throw new ContentDataSourceException(e);
        }
        if (bytesRead == -1) {
            if (this.bytesRemaining != -1L) {
                throw new ContentDataSourceException(new EOFException());
            }
            return -1;
        }
        if (this.bytesRemaining != -1L) {
            this.bytesRemaining -= (long)bytesRead;
        }
        if (this.listener != null) {
            this.listener.onBytesTransferred(this, bytesRead);
        }
        return bytesRead;
    }

    @Override
    public Uri getUri() {
        return this.uri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws ContentDataSourceException {
        this.uri = null;
        try {
            if (this.inputStream == null) return;
            this.inputStream.close();
            return;
        }
        catch (IOException e) {
            throw new ContentDataSourceException(e);
        }
        finally {
            this.inputStream = null;
            try {
                if (this.assetFileDescriptor != null) {
                    this.assetFileDescriptor.close();
                }
            }
            catch (IOException e) {
                throw new ContentDataSourceException(e);
            }
            finally {
                this.assetFileDescriptor = null;
                if (this.opened) {
                    this.opened = false;
                    if (this.listener != null) {
                        this.listener.onTransferEnd(this);
                    }
                }
            }
        }
    }

    public static class ContentDataSourceException
    extends IOException {
        public ContentDataSourceException(IOException cause) {
            super(cause);
        }
    }
}

