/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.net.Uri;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;

public final class ByteArrayDataSource
implements DataSource {
    private final byte[] data;
    private Uri uri;
    private int readPosition;
    private int bytesRemaining;

    public ByteArrayDataSource(byte[] data) {
        Assertions.checkNotNull(data);
        Assertions.checkArgument(data.length > 0);
        this.data = data;
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        this.uri = dataSpec.uri;
        this.readPosition = (int)dataSpec.position;
        this.bytesRemaining = (int)(dataSpec.length == -1L ? (long)this.data.length - dataSpec.position : dataSpec.length);
        if (this.bytesRemaining <= 0 || this.readPosition + this.bytesRemaining > this.data.length) {
            throw new IOException("Unsatisfiable range: [" + this.readPosition + ", " + dataSpec.length + "], length: " + this.data.length);
        }
        return this.bytesRemaining;
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) throws IOException {
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0) {
            return -1;
        }
        readLength = Math.min(readLength, this.bytesRemaining);
        System.arraycopy(this.data, this.readPosition, buffer, offset, readLength);
        this.readPosition += readLength;
        this.bytesRemaining -= readLength;
        return readLength;
    }

    @Override
    public Uri getUri() {
        return this.uri;
    }

    @Override
    public void close() throws IOException {
        this.uri = null;
    }
}

