/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.R;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextRenderer;
import com.google.android.exoplayer2.ui.AspectRatioFrameLayout;
import com.google.android.exoplayer2.ui.PlaybackControlView;
import com.google.android.exoplayer2.ui.SubtitleView;
import java.util.List;

@TargetApi(value=16)
public final class SimpleExoPlayerView
extends FrameLayout {
    private final View surfaceView;
    private final View shutterView;
    private final SubtitleView subtitleLayout;
    private final AspectRatioFrameLayout layout;
    private final PlaybackControlView controller;
    private final ComponentListener componentListener;
    private SimpleExoPlayer player;
    private boolean useController = true;
    private int controllerShowTimeoutMs;

    public SimpleExoPlayerView(Context context) {
        this(context, null);
    }

    public SimpleExoPlayerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleExoPlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        boolean useTextureView = false;
        int resizeMode = 0;
        int rewindMs = 5000;
        int fastForwardMs = 15000;
        int controllerShowTimeoutMs = 5000;
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SimpleExoPlayerView, 0, 0);
            try {
                this.useController = a.getBoolean(R.styleable.SimpleExoPlayerView_use_controller, this.useController);
                useTextureView = a.getBoolean(R.styleable.SimpleExoPlayerView_use_texture_view, useTextureView);
                resizeMode = a.getInt(R.styleable.SimpleExoPlayerView_resize_mode, 0);
                rewindMs = a.getInt(R.styleable.SimpleExoPlayerView_rewind_increment, rewindMs);
                fastForwardMs = a.getInt(R.styleable.SimpleExoPlayerView_fastforward_increment, fastForwardMs);
                controllerShowTimeoutMs = a.getInt(R.styleable.SimpleExoPlayerView_show_timeout, controllerShowTimeoutMs);
            }
            finally {
                a.recycle();
            }
        }
        LayoutInflater.from((Context)context).inflate(R.layout.exo_simple_player_view, (ViewGroup)this);
        this.componentListener = new ComponentListener();
        this.layout = (AspectRatioFrameLayout)this.findViewById(R.id.video_frame);
        this.layout.setResizeMode(resizeMode);
        this.shutterView = this.findViewById(R.id.shutter);
        this.subtitleLayout = (SubtitleView)this.findViewById(R.id.subtitles);
        this.subtitleLayout.setUserDefaultStyle();
        this.subtitleLayout.setUserDefaultTextSize();
        this.controller = (PlaybackControlView)this.findViewById(R.id.control);
        this.controller.hide();
        this.controller.setRewindIncrementMs(rewindMs);
        this.controller.setFastForwardIncrementMs(fastForwardMs);
        this.controllerShowTimeoutMs = controllerShowTimeoutMs;
        TextureView view = useTextureView ? new TextureView(context) : new SurfaceView(context);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        view.setLayoutParams(params);
        this.surfaceView = view;
        this.layout.addView(this.surfaceView, 0);
    }

    public SimpleExoPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(SimpleExoPlayer player) {
        if (this.player == player) {
            return;
        }
        if (this.player != null) {
            this.player.setTextOutput(null);
            this.player.setVideoListener(null);
            this.player.removeListener(this.componentListener);
            this.player.setVideoSurface(null);
        }
        this.player = player;
        if (this.useController) {
            this.controller.setPlayer(player);
        }
        if (player != null) {
            if (this.surfaceView instanceof TextureView) {
                player.setVideoTextureView((TextureView)this.surfaceView);
            } else if (this.surfaceView instanceof SurfaceView) {
                player.setVideoSurfaceView((SurfaceView)this.surfaceView);
            }
            player.setVideoListener(this.componentListener);
            player.addListener(this.componentListener);
            player.setTextOutput(this.componentListener);
            this.maybeShowController(false);
        } else {
            this.shutterView.setVisibility(0);
            this.controller.hide();
        }
    }

    public void setResizeMode(int resizeMode) {
        this.layout.setResizeMode(resizeMode);
    }

    public boolean getUseController() {
        return this.useController;
    }

    public void setUseController(boolean useController) {
        if (this.useController == useController) {
            return;
        }
        this.useController = useController;
        if (useController) {
            this.controller.setPlayer(this.player);
        } else {
            this.controller.hide();
            this.controller.setPlayer(null);
        }
    }

    public int getControllerShowTimeoutMs() {
        return this.controllerShowTimeoutMs;
    }

    public void setControllerShowTimeoutMs(int controllerShowTimeoutMs) {
        this.controllerShowTimeoutMs = controllerShowTimeoutMs;
    }

    public void setControllerVisibilityListener(PlaybackControlView.VisibilityListener listener) {
        this.controller.setVisibilityListener(listener);
    }

    public void setRewindIncrementMs(int rewindMs) {
        this.controller.setRewindIncrementMs(rewindMs);
    }

    public void setFastForwardIncrementMs(int fastForwardMs) {
        this.controller.setFastForwardIncrementMs(fastForwardMs);
    }

    public View getVideoSurfaceView() {
        return this.surfaceView;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.useController || this.player == null || ev.getActionMasked() != 0) {
            return false;
        }
        if (this.controller.isVisible()) {
            this.controller.hide();
        } else {
            this.maybeShowController(true);
        }
        return true;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        if (!this.useController || this.player == null) {
            return false;
        }
        this.maybeShowController(true);
        return true;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return this.useController ? this.controller.dispatchKeyEvent(event) : super.dispatchKeyEvent(event);
    }

    private void maybeShowController(boolean isForced) {
        if (!this.useController || this.player == null) {
            return;
        }
        int playbackState = this.player.getPlaybackState();
        boolean showIndefinitely = playbackState == 1 || playbackState == 4 || !this.player.getPlayWhenReady();
        boolean wasShowingIndefinitely = this.controller.isVisible() && this.controller.getShowTimeoutMs() <= 0;
        this.controller.setShowTimeoutMs(showIndefinitely ? 0 : this.controllerShowTimeoutMs);
        if (isForced || showIndefinitely || wasShowingIndefinitely) {
            this.controller.show();
        }
    }

    private final class ComponentListener
    implements SimpleExoPlayer.VideoListener,
    TextRenderer.Output,
    ExoPlayer.EventListener {
        private ComponentListener() {
        }

        @Override
        public void onCues(List<Cue> cues) {
            SimpleExoPlayerView.this.subtitleLayout.onCues(cues);
        }

        @Override
        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
            SimpleExoPlayerView.this.layout.setAspectRatio(height == 0 ? 1.0f : (float)width * pixelWidthHeightRatio / (float)height);
        }

        @Override
        public void onRenderedFirstFrame() {
            SimpleExoPlayerView.this.shutterView.setVisibility(8);
        }

        @Override
        public void onVideoTracksDisabled() {
            SimpleExoPlayerView.this.shutterView.setVisibility(0);
        }

        @Override
        public void onLoadingChanged(boolean isLoading) {
        }

        @Override
        public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
            SimpleExoPlayerView.this.maybeShowController(false);
        }

        @Override
        public void onPlayerError(ExoPlaybackException e) {
        }

        @Override
        public void onPositionDiscontinuity() {
        }

        @Override
        public void onTimelineChanged(Timeline timeline, Object manifest) {
        }
    }
}

