/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.R;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.util.Util;
import java.util.Formatter;
import java.util.Locale;

public class PlaybackControlView
extends FrameLayout {
    public static final int DEFAULT_FAST_FORWARD_MS = 15000;
    public static final int DEFAULT_REWIND_MS = 5000;
    public static final int DEFAULT_SHOW_TIMEOUT_MS = 5000;
    private static final int PROGRESS_BAR_MAX = 1000;
    private static final long MAX_POSITION_FOR_SEEK_TO_PREVIOUS = 3000L;
    private final ComponentListener componentListener;
    private final View previousButton;
    private final View nextButton;
    private final ImageButton playButton;
    private final TextView time;
    private final TextView timeCurrent;
    private final SeekBar progressBar;
    private final View fastForwardButton;
    private final View rewindButton;
    private final StringBuilder formatBuilder;
    private final Formatter formatter;
    private final Timeline.Window currentWindow;
    private ExoPlayer player;
    private VisibilityListener visibilityListener;
    private boolean isAttachedToWindow;
    private boolean dragging;
    private int rewindMs = 5000;
    private int fastForwardMs = 15000;
    private int showTimeoutMs = 5000;
    private long hideAtMs;
    private final Runnable updateProgressAction = new Runnable(){

        @Override
        public void run() {
            PlaybackControlView.this.updateProgress();
        }
    };
    private final Runnable hideAction = new Runnable(){

        @Override
        public void run() {
            PlaybackControlView.this.hide();
        }
    };

    public PlaybackControlView(Context context) {
        this(context, null);
    }

    public PlaybackControlView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlaybackControlView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PlaybackControlView, 0, 0);
            try {
                this.rewindMs = a.getInt(R.styleable.PlaybackControlView_rewind_increment, this.rewindMs);
                this.fastForwardMs = a.getInt(R.styleable.PlaybackControlView_fastforward_increment, this.fastForwardMs);
                this.showTimeoutMs = a.getInt(R.styleable.PlaybackControlView_show_timeout, this.showTimeoutMs);
            }
            finally {
                a.recycle();
            }
        }
        this.currentWindow = new Timeline.Window();
        this.formatBuilder = new StringBuilder();
        this.formatter = new Formatter(this.formatBuilder, Locale.getDefault());
        this.componentListener = new ComponentListener();
        LayoutInflater.from((Context)context).inflate(R.layout.exo_playback_control_view, (ViewGroup)this);
        this.time = (TextView)this.findViewById(R.id.time);
        this.timeCurrent = (TextView)this.findViewById(R.id.time_current);
        this.progressBar = (SeekBar)this.findViewById(R.id.mediacontroller_progress);
        this.progressBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this.componentListener);
        this.progressBar.setMax(1000);
        this.playButton = (ImageButton)this.findViewById(R.id.play);
        this.playButton.setOnClickListener((View.OnClickListener)this.componentListener);
        this.previousButton = this.findViewById(R.id.prev);
        this.previousButton.setOnClickListener((View.OnClickListener)this.componentListener);
        this.nextButton = this.findViewById(R.id.next);
        this.nextButton.setOnClickListener((View.OnClickListener)this.componentListener);
        this.rewindButton = this.findViewById(R.id.rew);
        this.rewindButton.setOnClickListener((View.OnClickListener)this.componentListener);
        this.fastForwardButton = this.findViewById(R.id.ffwd);
        this.fastForwardButton.setOnClickListener((View.OnClickListener)this.componentListener);
    }

    public ExoPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(ExoPlayer player) {
        if (this.player == player) {
            return;
        }
        if (this.player != null) {
            this.player.removeListener(this.componentListener);
        }
        this.player = player;
        if (player != null) {
            player.addListener(this.componentListener);
        }
        this.updateAll();
    }

    public void setVisibilityListener(VisibilityListener listener) {
        this.visibilityListener = listener;
    }

    public void setRewindIncrementMs(int rewindMs) {
        this.rewindMs = rewindMs;
        this.updateNavigation();
    }

    public void setFastForwardIncrementMs(int fastForwardMs) {
        this.fastForwardMs = fastForwardMs;
        this.updateNavigation();
    }

    public int getShowTimeoutMs() {
        return this.showTimeoutMs;
    }

    public void setShowTimeoutMs(int showTimeoutMs) {
        this.showTimeoutMs = showTimeoutMs;
    }

    public void show() {
        if (!this.isVisible()) {
            this.setVisibility(0);
            if (this.visibilityListener != null) {
                this.visibilityListener.onVisibilityChange(this.getVisibility());
            }
            this.updateAll();
        }
        this.hideAfterTimeout();
    }

    public void hide() {
        if (this.isVisible()) {
            this.setVisibility(8);
            if (this.visibilityListener != null) {
                this.visibilityListener.onVisibilityChange(this.getVisibility());
            }
            this.removeCallbacks(this.updateProgressAction);
            this.removeCallbacks(this.hideAction);
            this.hideAtMs = -9223372036854775807L;
        }
    }

    public boolean isVisible() {
        return this.getVisibility() == 0;
    }

    private void hideAfterTimeout() {
        this.removeCallbacks(this.hideAction);
        if (this.showTimeoutMs > 0) {
            this.hideAtMs = SystemClock.uptimeMillis() + (long)this.showTimeoutMs;
            if (this.isAttachedToWindow) {
                this.postDelayed(this.hideAction, this.showTimeoutMs);
            }
        } else {
            this.hideAtMs = -9223372036854775807L;
        }
    }

    private void updateAll() {
        this.updatePlayPauseButton();
        this.updateNavigation();
        this.updateProgress();
    }

    private void updatePlayPauseButton() {
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        boolean playing = this.player != null && this.player.getPlayWhenReady();
        String contentDescription = this.getResources().getString(playing ? R.string.exo_controls_pause_description : R.string.exo_controls_play_description);
        this.playButton.setContentDescription((CharSequence)contentDescription);
        this.playButton.setImageResource(playing ? R.drawable.exo_controls_pause : R.drawable.exo_controls_play);
    }

    private void updateNavigation() {
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        Timeline currentTimeline = this.player != null ? this.player.getCurrentTimeline() : null;
        boolean haveTimeline = currentTimeline != null;
        boolean isSeekable = false;
        boolean enablePrevious = false;
        boolean enableNext = false;
        if (haveTimeline) {
            int currentWindowIndex = this.player.getCurrentWindowIndex();
            currentTimeline.getWindow(currentWindowIndex, this.currentWindow);
            isSeekable = this.currentWindow.isSeekable;
            enablePrevious = currentWindowIndex > 0 || isSeekable || !this.currentWindow.isDynamic;
            enableNext = currentWindowIndex < currentTimeline.getWindowCount() - 1 || this.currentWindow.isDynamic;
        }
        this.setButtonEnabled(enablePrevious, this.previousButton);
        this.setButtonEnabled(enableNext, this.nextButton);
        this.setButtonEnabled(this.fastForwardMs > 0 && isSeekable, this.fastForwardButton);
        this.setButtonEnabled(this.rewindMs > 0 && isSeekable, this.rewindButton);
        this.progressBar.setEnabled(isSeekable);
    }

    private void updateProgress() {
        int playbackState;
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        long duration = this.player == null ? 0L : this.player.getDuration();
        long position = this.player == null ? 0L : this.player.getCurrentPosition();
        this.time.setText((CharSequence)this.stringForTime(duration));
        if (!this.dragging) {
            this.timeCurrent.setText((CharSequence)this.stringForTime(position));
        }
        if (!this.dragging) {
            this.progressBar.setProgress(this.progressBarValue(position));
        }
        long bufferedPosition = this.player == null ? 0L : this.player.getBufferedPosition();
        this.progressBar.setSecondaryProgress(this.progressBarValue(bufferedPosition));
        this.removeCallbacks(this.updateProgressAction);
        int n = playbackState = this.player == null ? 1 : this.player.getPlaybackState();
        if (playbackState != 1 && playbackState != 4) {
            long delayMs;
            if (this.player.getPlayWhenReady() && playbackState == 3) {
                delayMs = 1000L - position % 1000L;
                if (delayMs < 200L) {
                    delayMs += 1000L;
                }
            } else {
                delayMs = 1000L;
            }
            this.postDelayed(this.updateProgressAction, delayMs);
        }
    }

    private void setButtonEnabled(boolean enabled, View view) {
        view.setEnabled(enabled);
        if (Util.SDK_INT >= 11) {
            this.setViewAlphaV11(view, enabled ? 1.0f : 0.3f);
            view.setVisibility(0);
        } else {
            view.setVisibility(enabled ? 0 : 4);
        }
    }

    @TargetApi(value=11)
    private void setViewAlphaV11(View view, float alpha) {
        view.setAlpha(alpha);
    }

    private String stringForTime(long timeMs) {
        if (timeMs == -9223372036854775807L) {
            timeMs = 0L;
        }
        long totalSeconds = (timeMs + 500L) / 1000L;
        long seconds = totalSeconds % 60L;
        long minutes = totalSeconds / 60L % 60L;
        long hours = totalSeconds / 3600L;
        this.formatBuilder.setLength(0);
        return hours > 0L ? this.formatter.format("%d:%02d:%02d", hours, minutes, seconds).toString() : this.formatter.format("%02d:%02d", minutes, seconds).toString();
    }

    private int progressBarValue(long position) {
        long duration = this.player == null ? -9223372036854775807L : this.player.getDuration();
        return duration == -9223372036854775807L || duration == 0L ? 0 : (int)(position * 1000L / duration);
    }

    private long positionValue(int progress) {
        long duration = this.player == null ? -9223372036854775807L : this.player.getDuration();
        return duration == -9223372036854775807L ? 0L : duration * (long)progress / 1000L;
    }

    private void previous() {
        Timeline currentTimeline = this.player.getCurrentTimeline();
        if (currentTimeline == null) {
            return;
        }
        int currentWindowIndex = this.player.getCurrentWindowIndex();
        currentTimeline.getWindow(currentWindowIndex, this.currentWindow);
        if (currentWindowIndex > 0 && (this.player.getCurrentPosition() <= 3000L || this.currentWindow.isDynamic && !this.currentWindow.isSeekable)) {
            this.player.seekToDefaultPosition(currentWindowIndex - 1);
        } else {
            this.player.seekTo(0L);
        }
    }

    private void next() {
        Timeline currentTimeline = this.player.getCurrentTimeline();
        if (currentTimeline == null) {
            return;
        }
        int currentWindowIndex = this.player.getCurrentWindowIndex();
        if (currentWindowIndex < currentTimeline.getWindowCount() - 1) {
            this.player.seekToDefaultPosition(currentWindowIndex + 1);
        } else if (currentTimeline.getWindow((int)currentWindowIndex, (Timeline.Window)this.currentWindow, (boolean)false).isDynamic) {
            this.player.seekToDefaultPosition();
        }
    }

    private void rewind() {
        if (this.rewindMs <= 0) {
            return;
        }
        this.player.seekTo(Math.max(this.player.getCurrentPosition() - (long)this.rewindMs, 0L));
    }

    private void fastForward() {
        if (this.fastForwardMs <= 0) {
            return;
        }
        this.player.seekTo(Math.min(this.player.getCurrentPosition() + (long)this.fastForwardMs, this.player.getDuration()));
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.isAttachedToWindow = true;
        if (this.hideAtMs != -9223372036854775807L) {
            long delayMs = this.hideAtMs - SystemClock.uptimeMillis();
            if (delayMs <= 0L) {
                this.hide();
            } else {
                this.postDelayed(this.hideAction, delayMs);
            }
        }
        this.updateAll();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.isAttachedToWindow = false;
        this.removeCallbacks(this.updateProgressAction);
        this.removeCallbacks(this.hideAction);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.player == null || event.getAction() != 0) {
            return super.dispatchKeyEvent(event);
        }
        switch (event.getKeyCode()) {
            case 22: 
            case 90: {
                this.fastForward();
                break;
            }
            case 21: 
            case 89: {
                this.rewind();
                break;
            }
            case 85: {
                this.player.setPlayWhenReady(!this.player.getPlayWhenReady());
                break;
            }
            case 126: {
                this.player.setPlayWhenReady(true);
                break;
            }
            case 127: {
                this.player.setPlayWhenReady(false);
                break;
            }
            case 87: {
                this.next();
                break;
            }
            case 88: {
                this.previous();
                break;
            }
            default: {
                return false;
            }
        }
        this.show();
        return true;
    }

    private final class ComponentListener
    implements ExoPlayer.EventListener,
    SeekBar.OnSeekBarChangeListener,
    View.OnClickListener {
        private ComponentListener() {
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
            PlaybackControlView.this.removeCallbacks(PlaybackControlView.this.hideAction);
            PlaybackControlView.this.dragging = true;
        }

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            if (fromUser) {
                PlaybackControlView.this.timeCurrent.setText((CharSequence)PlaybackControlView.this.stringForTime(PlaybackControlView.this.positionValue(progress)));
            }
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            PlaybackControlView.this.dragging = false;
            PlaybackControlView.this.player.seekTo(PlaybackControlView.this.positionValue(seekBar.getProgress()));
            PlaybackControlView.this.hideAfterTimeout();
        }

        @Override
        public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
            PlaybackControlView.this.updatePlayPauseButton();
            PlaybackControlView.this.updateProgress();
        }

        @Override
        public void onPositionDiscontinuity() {
            PlaybackControlView.this.updateNavigation();
            PlaybackControlView.this.updateProgress();
        }

        @Override
        public void onTimelineChanged(Timeline timeline, Object manifest) {
            PlaybackControlView.this.updateNavigation();
            PlaybackControlView.this.updateProgress();
        }

        @Override
        public void onLoadingChanged(boolean isLoading) {
        }

        @Override
        public void onPlayerError(ExoPlaybackException error) {
        }

        public void onClick(View view) {
            Timeline currentTimeline = PlaybackControlView.this.player.getCurrentTimeline();
            if (PlaybackControlView.this.nextButton == view) {
                PlaybackControlView.this.next();
            } else if (PlaybackControlView.this.previousButton == view) {
                PlaybackControlView.this.previous();
            } else if (PlaybackControlView.this.fastForwardButton == view) {
                PlaybackControlView.this.fastForward();
            } else if (PlaybackControlView.this.rewindButton == view && currentTimeline != null) {
                PlaybackControlView.this.rewind();
            } else if (PlaybackControlView.this.playButton == view) {
                PlaybackControlView.this.player.setPlayWhenReady(!PlaybackControlView.this.player.getPlayWhenReady());
            }
            PlaybackControlView.this.hideAfterTimeout();
        }
    }

    public static interface VisibilityListener {
        public void onVisibilityChange(int var1);
    }
}

