/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.widget.TextView;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.decoder.DecoderCounters;

public final class DebugTextViewHelper
implements Runnable,
ExoPlayer.EventListener {
    private static final int REFRESH_INTERVAL_MS = 1000;
    private final SimpleExoPlayer player;
    private final TextView textView;
    private boolean started;

    public DebugTextViewHelper(SimpleExoPlayer player, TextView textView) {
        this.player = player;
        this.textView = textView;
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.player.addListener(this);
        this.updateAndPost();
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.player.removeListener(this);
        this.textView.removeCallbacks((Runnable)this);
    }

    @Override
    public void onLoadingChanged(boolean isLoading) {
    }

    @Override
    public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        this.updateAndPost();
    }

    @Override
    public void onPositionDiscontinuity() {
        this.updateAndPost();
    }

    @Override
    public void onTimelineChanged(Timeline timeline, Object manifest) {
    }

    @Override
    public void onPlayerError(ExoPlaybackException error) {
    }

    @Override
    public void run() {
        this.updateAndPost();
    }

    private void updateAndPost() {
        this.textView.setText((CharSequence)(this.getPlayerStateString() + this.getPlayerWindowIndexString() + this.getVideoString() + this.getAudioString()));
        this.textView.removeCallbacks((Runnable)this);
        this.textView.postDelayed((Runnable)this, 1000L);
    }

    private String getPlayerStateString() {
        String text = "playWhenReady:" + this.player.getPlayWhenReady() + " playbackState:";
        switch (this.player.getPlaybackState()) {
            case 2: {
                text = text + "buffering";
                break;
            }
            case 4: {
                text = text + "ended";
                break;
            }
            case 1: {
                text = text + "idle";
                break;
            }
            case 3: {
                text = text + "ready";
                break;
            }
            default: {
                text = text + "unknown";
            }
        }
        return text;
    }

    private String getPlayerWindowIndexString() {
        return " window:" + this.player.getCurrentWindowIndex();
    }

    private String getVideoString() {
        Format format = this.player.getVideoFormat();
        if (format == null) {
            return "";
        }
        return "\n" + format.sampleMimeType + "(id:" + format.id + " r:" + format.width + "x" + format.height + DebugTextViewHelper.getDecoderCountersBufferCountString(this.player.getVideoDecoderCounters()) + ")";
    }

    private String getAudioString() {
        Format format = this.player.getAudioFormat();
        if (format == null) {
            return "";
        }
        return "\n" + format.sampleMimeType + "(id:" + format.id + " hz:" + format.sampleRate + " ch:" + format.channelCount + DebugTextViewHelper.getDecoderCountersBufferCountString(this.player.getAudioDecoderCounters()) + ")";
    }

    private static String getDecoderCountersBufferCountString(DecoderCounters counters) {
        if (counters == null) {
            return "";
        }
        counters.ensureUpdated();
        return " rb:" + counters.renderedOutputBufferCount + " sb:" + counters.skippedOutputBufferCount + " db:" + counters.droppedOutputBufferCount + " mcdb:" + counters.maxConsecutiveDroppedOutputBufferCount;
    }
}

