/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.exoplayer2.R;

public final class AspectRatioFrameLayout
extends FrameLayout {
    public static final int RESIZE_MODE_FIT = 0;
    public static final int RESIZE_MODE_FIXED_WIDTH = 1;
    public static final int RESIZE_MODE_FIXED_HEIGHT = 2;
    private static final float MAX_ASPECT_RATIO_DEFORMATION_FRACTION = 0.01f;
    private float videoAspectRatio;
    private int resizeMode = 0;

    public AspectRatioFrameLayout(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AspectRatioFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AspectRatioFrameLayout, 0, 0);
            try {
                this.resizeMode = a.getInt(R.styleable.AspectRatioFrameLayout_resize_mode, 0);
            }
            finally {
                a.recycle();
            }
        }
    }

    public void setAspectRatio(float widthHeightRatio) {
        if (this.videoAspectRatio != widthHeightRatio) {
            this.videoAspectRatio = widthHeightRatio;
            this.requestLayout();
        }
    }

    public void setResizeMode(int resizeMode) {
        if (this.resizeMode != resizeMode) {
            this.resizeMode = resizeMode;
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.videoAspectRatio == 0.0f) {
            return;
        }
        int width = this.getMeasuredWidth();
        float viewAspectRatio = (float)width / (float)(height = this.getMeasuredHeight());
        float aspectDeformation = this.videoAspectRatio / viewAspectRatio - 1.0f;
        if (Math.abs(aspectDeformation) <= 0.01f) {
            return;
        }
        switch (this.resizeMode) {
            case 1: {
                height = (int)((float)width / this.videoAspectRatio);
                break;
            }
            case 2: {
                width = (int)((float)height * this.videoAspectRatio);
                break;
            }
            default: {
                if (aspectDeformation > 0.0f) {
                    height = (int)((float)width / this.videoAspectRatio);
                    break;
                }
                width = (int)((float)height * this.videoAspectRatio);
            }
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }
}

