/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.os.Handler;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelections;
import com.google.android.exoplayer2.util.Assertions;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class TrackSelector<T> {
    private final Handler eventHandler;
    private final CopyOnWriteArraySet<EventListener<? super T>> listeners;
    private InvalidationListener listener;
    private TrackSelections<T> activeSelections;

    public TrackSelector(Handler eventHandler) {
        this.eventHandler = Assertions.checkNotNull(eventHandler);
        this.listeners = new CopyOnWriteArraySet();
    }

    public final void addListener(EventListener<? super T> listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(EventListener<? super T> listener) {
        this.listeners.remove(listener);
    }

    public final TrackSelections<T> getCurrentSelections() {
        return this.activeSelections;
    }

    public final void init(InvalidationListener listener) {
        this.listener = listener;
    }

    public abstract TrackSelections<T> selectTracks(RendererCapabilities[] var1, TrackGroupArray var2) throws ExoPlaybackException;

    public final void onSelectionActivated(TrackSelections<T> activeSelections) {
        this.activeSelections = activeSelections;
        this.notifyTrackSelectionsChanged(activeSelections);
    }

    protected final void invalidate() {
        if (this.listener != null) {
            this.listener.onTrackSelectionsInvalidated();
        }
    }

    private void notifyTrackSelectionsChanged(final TrackSelections<T> activeSelections) {
        if (this.eventHandler != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (EventListener listener : TrackSelector.this.listeners) {
                        listener.onTrackSelectionsChanged(activeSelections);
                    }
                }
            });
        }
    }

    public static interface EventListener<T> {
        public void onTrackSelectionsChanged(TrackSelections<? extends T> var1);
    }

    public static interface InvalidationListener {
        public void onTrackSelectionsInvalidated();
    }
}

