/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.os.Handler;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelections;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class MappingTrackSelector
extends TrackSelector<MappedTrackInfo> {
    private final SparseArray<Map<TrackGroupArray, SelectionOverride>> selectionOverrides = new SparseArray();
    private final SparseBooleanArray rendererDisabledFlags = new SparseBooleanArray();

    public MappingTrackSelector(Handler eventHandler) {
        super(eventHandler);
    }

    public final void setRendererDisabled(int rendererIndex, boolean disabled) {
        if (this.rendererDisabledFlags.get(rendererIndex) == disabled) {
            return;
        }
        this.rendererDisabledFlags.put(rendererIndex, disabled);
        this.invalidate();
    }

    public final boolean getRendererDisabled(int rendererIndex) {
        return this.rendererDisabledFlags.get(rendererIndex);
    }

    public final void setSelectionOverride(int rendererIndex, TrackGroupArray groups, SelectionOverride override) {
        HashMap<TrackGroupArray, SelectionOverride> overrides = (HashMap<TrackGroupArray, SelectionOverride>)this.selectionOverrides.get(rendererIndex);
        if (overrides == null) {
            overrides = new HashMap<TrackGroupArray, SelectionOverride>();
            this.selectionOverrides.put(rendererIndex, overrides);
        }
        if (overrides.containsKey(groups) && Util.areEqual(overrides.get(groups), override)) {
            return;
        }
        overrides.put(groups, override);
        this.invalidate();
    }

    public final boolean hasSelectionOverride(int rendererIndex, TrackGroupArray groups) {
        Map overrides = (Map)this.selectionOverrides.get(rendererIndex);
        return overrides != null && overrides.containsKey(groups);
    }

    public final SelectionOverride getSelectionOverride(int rendererIndex, TrackGroupArray groups) {
        Map overrides = (Map)this.selectionOverrides.get(rendererIndex);
        return overrides != null ? (SelectionOverride)overrides.get(groups) : null;
    }

    public final void clearSelectionOverride(int rendererIndex, TrackGroupArray groups) {
        Map overrides = (Map)this.selectionOverrides.get(rendererIndex);
        if (overrides == null || !overrides.containsKey(groups)) {
            return;
        }
        overrides.remove(groups);
        if (overrides.isEmpty()) {
            this.selectionOverrides.remove(rendererIndex);
        }
        this.invalidate();
    }

    public final void clearSelectionOverrides(int rendererIndex) {
        Map overrides = (Map)this.selectionOverrides.get(rendererIndex);
        if (overrides == null || overrides.isEmpty()) {
            return;
        }
        this.selectionOverrides.remove(rendererIndex);
        this.invalidate();
    }

    public final void clearSelectionOverrides() {
        if (this.selectionOverrides.size() == 0) {
            return;
        }
        this.selectionOverrides.clear();
        this.invalidate();
    }

    @Override
    public final TrackSelections<MappedTrackInfo> selectTracks(RendererCapabilities[] rendererCapabilities, TrackGroupArray trackGroups) throws ExoPlaybackException {
        int[] rendererTrackGroupCounts = new int[rendererCapabilities.length + 1];
        TrackGroup[][] rendererTrackGroups = new TrackGroup[rendererCapabilities.length + 1][];
        int[][][] rendererFormatSupports = new int[rendererCapabilities.length + 1][][];
        for (int i = 0; i < rendererTrackGroups.length; ++i) {
            rendererTrackGroups[i] = new TrackGroup[trackGroups.length];
            rendererFormatSupports[i] = new int[trackGroups.length][];
        }
        int[] mixedMimeTypeAdaptationSupport = MappingTrackSelector.getMixedMimeTypeAdaptationSupport(rendererCapabilities);
        for (int groupIndex = 0; groupIndex < trackGroups.length; ++groupIndex) {
            TrackGroup group = trackGroups.get(groupIndex);
            int rendererIndex = MappingTrackSelector.findRenderer(rendererCapabilities, group);
            int[] rendererFormatSupport = rendererIndex == rendererCapabilities.length ? new int[group.length] : MappingTrackSelector.getFormatSupport(rendererCapabilities[rendererIndex], group);
            int rendererTrackGroupCount = rendererTrackGroupCounts[rendererIndex];
            rendererTrackGroups[rendererIndex][rendererTrackGroupCount] = group;
            rendererFormatSupports[rendererIndex][rendererTrackGroupCount] = rendererFormatSupport;
            int n = rendererIndex;
            rendererTrackGroupCounts[n] = rendererTrackGroupCounts[n] + 1;
        }
        TrackGroupArray[] rendererTrackGroupArrays = new TrackGroupArray[rendererCapabilities.length];
        int[] rendererTrackTypes = new int[rendererCapabilities.length];
        for (int i = 0; i < rendererCapabilities.length; ++i) {
            int rendererTrackGroupCount = rendererTrackGroupCounts[i];
            rendererTrackGroupArrays[i] = new TrackGroupArray(Arrays.copyOf(rendererTrackGroups[i], rendererTrackGroupCount));
            rendererFormatSupports[i] = (int[][])Arrays.copyOf(rendererFormatSupports[i], rendererTrackGroupCount);
            rendererTrackTypes[i] = rendererCapabilities[i].getTrackType();
        }
        int unassociatedTrackGroupCount = rendererTrackGroupCounts[rendererCapabilities.length];
        TrackGroupArray unassociatedTrackGroupArray = new TrackGroupArray(Arrays.copyOf(rendererTrackGroups[rendererCapabilities.length], unassociatedTrackGroupCount));
        TrackSelection[] trackSelections = this.selectTracks(rendererCapabilities, rendererTrackGroupArrays, rendererFormatSupports);
        for (int i = 0; i < rendererCapabilities.length; ++i) {
            SelectionOverride override;
            if (this.rendererDisabledFlags.get(i)) {
                trackSelections[i] = null;
                continue;
            }
            TrackGroupArray rendererTrackGroup = rendererTrackGroupArrays[i];
            Map overrides = (Map)this.selectionOverrides.get(i);
            SelectionOverride selectionOverride = override = overrides == null ? null : (SelectionOverride)overrides.get(rendererTrackGroup);
            if (override == null) continue;
            trackSelections[i] = override.createTrackSelection(rendererTrackGroup);
        }
        MappedTrackInfo mappedTrackInfo = new MappedTrackInfo(rendererTrackTypes, rendererTrackGroupArrays, mixedMimeTypeAdaptationSupport, rendererFormatSupports, unassociatedTrackGroupArray);
        return new TrackSelections<MappedTrackInfo>(mappedTrackInfo, trackSelections);
    }

    protected abstract TrackSelection[] selectTracks(RendererCapabilities[] var1, TrackGroupArray[] var2, int[][][] var3) throws ExoPlaybackException;

    private static int findRenderer(RendererCapabilities[] rendererCapabilities, TrackGroup group) throws ExoPlaybackException {
        int bestRendererIndex = rendererCapabilities.length;
        int bestSupportLevel = 0;
        for (int rendererIndex = 0; rendererIndex < rendererCapabilities.length; ++rendererIndex) {
            RendererCapabilities rendererCapability = rendererCapabilities[rendererIndex];
            for (int trackIndex = 0; trackIndex < group.length; ++trackIndex) {
                int trackSupportLevel = rendererCapability.supportsFormat(group.getFormat(trackIndex));
                if (trackSupportLevel <= bestSupportLevel) continue;
                bestRendererIndex = rendererIndex;
                bestSupportLevel = trackSupportLevel;
                if (bestSupportLevel != 3) continue;
                return bestRendererIndex;
            }
        }
        return bestRendererIndex;
    }

    private static int[] getFormatSupport(RendererCapabilities rendererCapabilities, TrackGroup group) throws ExoPlaybackException {
        int[] formatSupport = new int[group.length];
        for (int i = 0; i < group.length; ++i) {
            formatSupport[i] = rendererCapabilities.supportsFormat(group.getFormat(i));
        }
        return formatSupport;
    }

    private static int[] getMixedMimeTypeAdaptationSupport(RendererCapabilities[] rendererCapabilities) throws ExoPlaybackException {
        int[] mixedMimeTypeAdaptationSupport = new int[rendererCapabilities.length];
        for (int i = 0; i < mixedMimeTypeAdaptationSupport.length; ++i) {
            mixedMimeTypeAdaptationSupport[i] = rendererCapabilities[i].supportsMixedMimeTypeAdaptation();
        }
        return mixedMimeTypeAdaptationSupport;
    }

    public static final class MappedTrackInfo {
        public static final int RENDERER_SUPPORT_NO_TRACKS = 0;
        public static final int RENDERER_SUPPORT_UNPLAYABLE_TRACKS = 1;
        public static final int RENDERER_SUPPORT_PLAYABLE_TRACKS = 2;
        private final int[] rendererTrackTypes;
        private final TrackGroupArray[] trackGroups;
        private final int[] mixedMimeTypeAdaptiveSupport;
        private final int[][][] formatSupport;
        private final TrackGroupArray unassociatedTrackGroups;
        private final int rendererCount;

        MappedTrackInfo(int[] rendererTrackTypes, TrackGroupArray[] trackGroups, int[] mixedMimeTypeAdaptiveSupport, int[][][] formatSupport, TrackGroupArray unassociatedTrackGroups) {
            this.rendererTrackTypes = rendererTrackTypes;
            this.trackGroups = trackGroups;
            this.formatSupport = formatSupport;
            this.mixedMimeTypeAdaptiveSupport = mixedMimeTypeAdaptiveSupport;
            this.unassociatedTrackGroups = unassociatedTrackGroups;
            this.rendererCount = trackGroups.length;
        }

        public TrackGroupArray getTrackGroups(int rendererIndex) {
            return this.trackGroups[rendererIndex];
        }

        public int getRendererSupport(int rendererIndex) {
            boolean hasTracks = false;
            int[][] rendererFormatSupport = this.formatSupport[rendererIndex];
            for (int i = 0; i < rendererFormatSupport.length; ++i) {
                for (int j = 0; j < rendererFormatSupport[i].length; ++j) {
                    hasTracks = true;
                    if ((rendererFormatSupport[i][j] & 3) != 3) continue;
                    return 2;
                }
            }
            return hasTracks ? 1 : 0;
        }

        public int getTrackFormatSupport(int rendererIndex, int groupIndex, int trackIndex) {
            return this.formatSupport[rendererIndex][groupIndex][trackIndex] & 3;
        }

        public int getAdaptiveSupport(int rendererIndex, int groupIndex, boolean includeCapabilitiesExceededTracks) {
            int trackCount = this.trackGroups[rendererIndex].get((int)groupIndex).length;
            int[] trackIndices = new int[trackCount];
            int trackIndexCount = 0;
            for (int i = 0; i < trackCount; ++i) {
                int fixedSupport = this.getTrackFormatSupport(rendererIndex, groupIndex, i);
                if (fixedSupport != 3 && (!includeCapabilitiesExceededTracks || fixedSupport != 2)) continue;
                trackIndices[trackIndexCount++] = i;
            }
            trackIndices = Arrays.copyOf(trackIndices, trackIndexCount);
            return this.getAdaptiveSupport(rendererIndex, groupIndex, trackIndices);
        }

        public int getAdaptiveSupport(int rendererIndex, int groupIndex, int[] trackIndices) {
            int handledTrackCount = 0;
            int adaptiveSupport = 8;
            boolean multipleMimeTypes = false;
            String firstSampleMimeType = null;
            for (int i = 0; i < trackIndices.length; ++i) {
                int trackIndex = trackIndices[i];
                String sampleMimeType = this.trackGroups[rendererIndex].get((int)groupIndex).getFormat((int)trackIndex).sampleMimeType;
                if (handledTrackCount++ == 0) {
                    firstSampleMimeType = sampleMimeType;
                } else {
                    multipleMimeTypes |= !Util.areEqual(firstSampleMimeType, sampleMimeType);
                }
                adaptiveSupport = Math.min(adaptiveSupport, this.formatSupport[rendererIndex][groupIndex][i] & 0xC);
            }
            return multipleMimeTypes ? Math.min(adaptiveSupport, this.mixedMimeTypeAdaptiveSupport[rendererIndex]) : adaptiveSupport;
        }

        public TrackGroupArray getUnassociatedTrackGroups() {
            return this.unassociatedTrackGroups;
        }

        public boolean hasOnlyUnplayableTracks(int trackType) {
            int rendererSupport = 0;
            for (int i = 0; i < this.rendererCount; ++i) {
                if (this.rendererTrackTypes[i] != trackType) continue;
                rendererSupport = Math.max(rendererSupport, this.getRendererSupport(i));
            }
            return rendererSupport == 1;
        }
    }

    public static final class SelectionOverride {
        public final TrackSelection.Factory factory;
        public final int groupIndex;
        public final int[] tracks;
        public final int length;

        public SelectionOverride(TrackSelection.Factory factory, int groupIndex, int ... tracks) {
            this.factory = factory;
            this.groupIndex = groupIndex;
            this.tracks = tracks;
            this.length = tracks.length;
        }

        public TrackSelection createTrackSelection(TrackGroupArray groups) {
            return this.factory.createTrackSelection(groups.get(this.groupIndex), this.tracks);
        }

        public boolean containsTrack(int track) {
            for (int i = 0; i < this.tracks.length; ++i) {
                if (this.tracks[i] != track) continue;
                return true;
            }
            return false;
        }
    }
}

