/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.trackselection.BaseTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.util.Assertions;

public final class FixedTrackSelection
extends BaseTrackSelection {
    private final int reason;
    private final Object data;

    public FixedTrackSelection(TrackGroup group, int track) {
        this(group, track, 0, null);
    }

    public FixedTrackSelection(TrackGroup group, int track, int reason, Object data) {
        super(group, track);
        this.reason = reason;
        this.data = data;
    }

    @Override
    public void updateSelectedTrack(long bufferedDurationUs) {
    }

    @Override
    public int getSelectedIndex() {
        return 0;
    }

    @Override
    public int getSelectionReason() {
        return this.reason;
    }

    @Override
    public Object getSelectionData() {
        return this.data;
    }

    public static final class Factory
    implements TrackSelection.Factory {
        private final int reason;
        private final Object data;

        public Factory() {
            this.reason = 0;
            this.data = null;
        }

        public Factory(int reason, Object data) {
            this.reason = reason;
            this.data = data;
        }

        @Override
        public FixedTrackSelection createTrackSelection(TrackGroup group, int ... tracks) {
            Assertions.checkArgument(tracks.length == 1);
            return new FixedTrackSelection(group, tracks[0], this.reason, this.data);
        }
    }
}

