/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.content.Context;
import android.graphics.Point;
import android.os.Handler;
import android.text.TextUtils;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.FixedTrackSelection;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultTrackSelector
extends MappingTrackSelector {
    private static final float FRACTION_TO_CONSIDER_FULLSCREEN = 0.98f;
    private static final int[] NO_TRACKS = new int[0];
    private final TrackSelection.Factory adaptiveVideoTrackSelectionFactory;
    private final AtomicReference<Parameters> params;

    public DefaultTrackSelector(Handler eventHandler) {
        this(eventHandler, null);
    }

    public DefaultTrackSelector(Handler eventHandler, TrackSelection.Factory adaptiveVideoTrackSelectionFactory) {
        super(eventHandler);
        this.adaptiveVideoTrackSelectionFactory = adaptiveVideoTrackSelectionFactory;
        this.params = new AtomicReference<Parameters>(new Parameters());
    }

    public void setParameters(Parameters params) {
        if (!this.params.get().equals(params)) {
            this.params.set(Assertions.checkNotNull(params));
            this.invalidate();
        }
    }

    public Parameters getParameters() {
        return this.params.get();
    }

    @Override
    protected TrackSelection[] selectTracks(RendererCapabilities[] rendererCapabilities, TrackGroupArray[] rendererTrackGroupArrays, int[][][] rendererFormatSupports) throws ExoPlaybackException {
        TrackSelection[] rendererTrackSelections = new TrackSelection[rendererCapabilities.length];
        Parameters params = this.params.get();
        block5: for (int i = 0; i < rendererCapabilities.length; ++i) {
            switch (rendererCapabilities[i].getTrackType()) {
                case 2: {
                    rendererTrackSelections[i] = this.selectVideoTrack(rendererCapabilities[i], rendererTrackGroupArrays[i], rendererFormatSupports[i], params.maxVideoWidth, params.maxVideoHeight, params.allowNonSeamlessAdaptiveness, params.allowMixedMimeAdaptiveness, params.viewportWidth, params.viewportHeight, params.orientationMayChange, this.adaptiveVideoTrackSelectionFactory, params.exceedVideoConstraintsIfNecessary);
                    continue block5;
                }
                case 1: {
                    rendererTrackSelections[i] = this.selectAudioTrack(rendererTrackGroupArrays[i], rendererFormatSupports[i], params.preferredAudioLanguage);
                    continue block5;
                }
                case 3: {
                    rendererTrackSelections[i] = this.selectTextTrack(rendererTrackGroupArrays[i], rendererFormatSupports[i], params.preferredTextLanguage, params.preferredAudioLanguage);
                    continue block5;
                }
                default: {
                    rendererTrackSelections[i] = this.selectOtherTrack(rendererCapabilities[i].getTrackType(), rendererTrackGroupArrays[i], rendererFormatSupports[i]);
                }
            }
        }
        return rendererTrackSelections;
    }

    protected TrackSelection selectVideoTrack(RendererCapabilities rendererCapabilities, TrackGroupArray groups, int[][] formatSupport, int maxVideoWidth, int maxVideoHeight, boolean allowNonSeamlessAdaptiveness, boolean allowMixedMimeAdaptiveness, int viewportWidth, int viewportHeight, boolean orientationMayChange, TrackSelection.Factory adaptiveVideoTrackSelectionFactory, boolean exceedConstraintsIfNecessary) throws ExoPlaybackException {
        TrackSelection selection = null;
        if (adaptiveVideoTrackSelectionFactory != null) {
            selection = DefaultTrackSelector.selectAdaptiveVideoTrack(rendererCapabilities, groups, formatSupport, maxVideoWidth, maxVideoHeight, allowNonSeamlessAdaptiveness, allowMixedMimeAdaptiveness, viewportWidth, viewportHeight, orientationMayChange, adaptiveVideoTrackSelectionFactory);
        }
        if (selection == null) {
            selection = DefaultTrackSelector.selectFixedVideoTrack(groups, formatSupport, maxVideoWidth, maxVideoHeight, viewportWidth, viewportHeight, orientationMayChange, exceedConstraintsIfNecessary);
        }
        return selection;
    }

    private static TrackSelection selectAdaptiveVideoTrack(RendererCapabilities rendererCapabilities, TrackGroupArray groups, int[][] formatSupport, int maxVideoWidth, int maxVideoHeight, boolean allowNonSeamlessAdaptiveness, boolean allowMixedMimeAdaptiveness, int viewportWidth, int viewportHeight, boolean orientationMayChange, TrackSelection.Factory adaptiveVideoTrackSelectionFactory) throws ExoPlaybackException {
        int requiredAdaptiveSupport = allowNonSeamlessAdaptiveness ? 12 : 8;
        boolean allowMixedMimeTypes = allowMixedMimeAdaptiveness && (rendererCapabilities.supportsMixedMimeTypeAdaptation() & requiredAdaptiveSupport) != 0;
        for (int i = 0; i < groups.length; ++i) {
            TrackGroup group = groups.get(i);
            int[] adaptiveTracks = DefaultTrackSelector.getAdaptiveTracksForGroup(group, formatSupport[i], allowMixedMimeTypes, requiredAdaptiveSupport, maxVideoWidth, maxVideoHeight, viewportWidth, viewportHeight, orientationMayChange);
            if (adaptiveTracks.length <= 0) continue;
            return adaptiveVideoTrackSelectionFactory.createTrackSelection(group, adaptiveTracks);
        }
        return null;
    }

    private static int[] getAdaptiveTracksForGroup(TrackGroup group, int[] formatSupport, boolean allowMixedMimeTypes, int requiredAdaptiveSupport, int maxVideoWidth, int maxVideoHeight, int viewportWidth, int viewportHeight, boolean orientationMayChange) {
        if (group.length < 2) {
            return NO_TRACKS;
        }
        List<Integer> selectedTrackIndices = DefaultTrackSelector.getViewportFilteredTrackIndices(group, viewportWidth, viewportHeight, orientationMayChange);
        if (selectedTrackIndices.size() < 2) {
            return NO_TRACKS;
        }
        String selectedMimeType = null;
        if (!allowMixedMimeTypes) {
            HashSet<String> seenMimeTypes = new HashSet<String>();
            int selectedMimeTypeTrackCount = 0;
            for (int i = 0; i < selectedTrackIndices.size(); ++i) {
                int trackIndex = selectedTrackIndices.get(i);
                String sampleMimeType = group.getFormat((int)trackIndex).sampleMimeType;
                if (seenMimeTypes.contains(sampleMimeType)) continue;
                seenMimeTypes.add(sampleMimeType);
                int countForMimeType = DefaultTrackSelector.getAdaptiveTrackCountForMimeType(group, formatSupport, requiredAdaptiveSupport, sampleMimeType, maxVideoWidth, maxVideoHeight, selectedTrackIndices);
                if (countForMimeType <= selectedMimeTypeTrackCount) continue;
                selectedMimeType = sampleMimeType;
                selectedMimeTypeTrackCount = countForMimeType;
            }
        }
        DefaultTrackSelector.filterAdaptiveTrackCountForMimeType(group, formatSupport, requiredAdaptiveSupport, selectedMimeType, maxVideoWidth, maxVideoHeight, selectedTrackIndices);
        return selectedTrackIndices.size() < 2 ? NO_TRACKS : Util.toArray(selectedTrackIndices);
    }

    private static int getAdaptiveTrackCountForMimeType(TrackGroup group, int[] formatSupport, int requiredAdaptiveSupport, String mimeType, int maxVideoWidth, int maxVideoHeight, List<Integer> selectedTrackIndices) {
        int adaptiveTrackCount = 0;
        for (int i = 0; i < selectedTrackIndices.size(); ++i) {
            int trackIndex = selectedTrackIndices.get(i);
            if (!DefaultTrackSelector.isSupportedAdaptiveVideoTrack(group.getFormat(trackIndex), mimeType, formatSupport[trackIndex], requiredAdaptiveSupport, maxVideoWidth, maxVideoHeight)) continue;
            ++adaptiveTrackCount;
        }
        return adaptiveTrackCount;
    }

    private static void filterAdaptiveTrackCountForMimeType(TrackGroup group, int[] formatSupport, int requiredAdaptiveSupport, String mimeType, int maxVideoWidth, int maxVideoHeight, List<Integer> selectedTrackIndices) {
        for (int i = selectedTrackIndices.size() - 1; i >= 0; --i) {
            int trackIndex = selectedTrackIndices.get(i);
            if (DefaultTrackSelector.isSupportedAdaptiveVideoTrack(group.getFormat(trackIndex), mimeType, formatSupport[trackIndex], requiredAdaptiveSupport, maxVideoWidth, maxVideoHeight)) continue;
            selectedTrackIndices.remove(i);
        }
    }

    private static boolean isSupportedAdaptiveVideoTrack(Format format, String mimeType, int formatSupport, int requiredAdaptiveSupport, int maxVideoWidth, int maxVideoHeight) {
        return !(!DefaultTrackSelector.isSupported(formatSupport) || (formatSupport & requiredAdaptiveSupport) == 0 || mimeType != null && !Util.areEqual(format.sampleMimeType, mimeType) || format.width != -1 && format.width > maxVideoWidth || format.height != -1 && format.height > maxVideoHeight);
    }

    private static TrackSelection selectFixedVideoTrack(TrackGroupArray groups, int[][] formatSupport, int maxVideoWidth, int maxVideoHeight, int viewportWidth, int viewportHeight, boolean orientationMayChange, boolean exceedConstraintsIfNecessary) {
        TrackGroup selectedGroup = null;
        int selectedTrackIndex = 0;
        int selectedPixelCount = -1;
        boolean selectedIsWithinConstraints = false;
        for (int groupIndex = 0; groupIndex < groups.length; ++groupIndex) {
            TrackGroup group = groups.get(groupIndex);
            List<Integer> selectedTrackIndices = DefaultTrackSelector.getViewportFilteredTrackIndices(group, viewportWidth, viewportHeight, orientationMayChange);
            int[] trackFormatSupport = formatSupport[groupIndex];
            for (int trackIndex = 0; trackIndex < group.length; ++trackIndex) {
                boolean selectTrack;
                if (!DefaultTrackSelector.isSupported(trackFormatSupport[trackIndex])) continue;
                Format format = group.getFormat(trackIndex);
                boolean isWithinConstraints = !(!selectedTrackIndices.contains(trackIndex) || format.width != -1 && format.width > maxVideoWidth || format.height != -1 && format.height > maxVideoHeight);
                int pixelCount = format.getPixelCount();
                if (selectedIsWithinConstraints) {
                    selectTrack = isWithinConstraints && DefaultTrackSelector.comparePixelCounts(pixelCount, selectedPixelCount) > 0;
                } else {
                    boolean bl = selectTrack = isWithinConstraints || exceedConstraintsIfNecessary && (selectedGroup == null || DefaultTrackSelector.comparePixelCounts(pixelCount, selectedPixelCount) < 0);
                }
                if (!selectTrack) continue;
                selectedGroup = group;
                selectedTrackIndex = trackIndex;
                selectedPixelCount = pixelCount;
                selectedIsWithinConstraints = isWithinConstraints;
            }
        }
        return selectedGroup == null ? null : new FixedTrackSelection(selectedGroup, selectedTrackIndex);
    }

    private static int comparePixelCounts(int first, int second) {
        return first == -1 ? (second == -1 ? 0 : -1) : (second == -1 ? 1 : first - second);
    }

    protected TrackSelection selectAudioTrack(TrackGroupArray groups, int[][] formatSupport, String preferredAudioLanguage) {
        TrackGroup selectedGroup = null;
        int selectedTrackIndex = 0;
        int selectedTrackScore = 0;
        for (int groupIndex = 0; groupIndex < groups.length; ++groupIndex) {
            TrackGroup trackGroup = groups.get(groupIndex);
            int[] trackFormatSupport = formatSupport[groupIndex];
            for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                boolean isDefault;
                if (!DefaultTrackSelector.isSupported(trackFormatSupport[trackIndex])) continue;
                Format format = trackGroup.getFormat(trackIndex);
                boolean bl = isDefault = (format.selectionFlags & 1) != 0;
                int trackScore = DefaultTrackSelector.formatHasLanguage(format, preferredAudioLanguage) ? (isDefault ? 4 : 3) : (isDefault ? 2 : 1);
                if (trackScore <= selectedTrackScore) continue;
                selectedGroup = trackGroup;
                selectedTrackIndex = trackIndex;
                selectedTrackScore = trackScore;
            }
        }
        return selectedGroup == null ? null : new FixedTrackSelection(selectedGroup, selectedTrackIndex);
    }

    protected TrackSelection selectTextTrack(TrackGroupArray groups, int[][] formatSupport, String preferredTextLanguage, String preferredAudioLanguage) {
        TrackGroup selectedGroup = null;
        int selectedTrackIndex = 0;
        int selectedTrackScore = 0;
        for (int groupIndex = 0; groupIndex < groups.length; ++groupIndex) {
            TrackGroup trackGroup = groups.get(groupIndex);
            int[] trackFormatSupport = formatSupport[groupIndex];
            for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                boolean isForced;
                if (!DefaultTrackSelector.isSupported(trackFormatSupport[trackIndex])) continue;
                Format format = trackGroup.getFormat(trackIndex);
                boolean isDefault = (format.selectionFlags & 1) != 0;
                boolean bl = isForced = (format.selectionFlags & 2) != 0;
                int trackScore = DefaultTrackSelector.formatHasLanguage(format, preferredTextLanguage) ? (isDefault ? 6 : (!isForced ? 5 : 4)) : (isDefault ? 3 : (isForced ? (DefaultTrackSelector.formatHasLanguage(format, preferredAudioLanguage) ? 2 : 1) : 0));
                if (trackScore <= selectedTrackScore) continue;
                selectedGroup = trackGroup;
                selectedTrackIndex = trackIndex;
                selectedTrackScore = trackScore;
            }
        }
        return selectedGroup == null ? null : new FixedTrackSelection(selectedGroup, selectedTrackIndex);
    }

    protected TrackSelection selectOtherTrack(int trackType, TrackGroupArray groups, int[][] formatSupport) {
        TrackGroup selectedGroup = null;
        int selectedTrackIndex = 0;
        int selectedTrackScore = 0;
        for (int groupIndex = 0; groupIndex < groups.length; ++groupIndex) {
            TrackGroup trackGroup = groups.get(groupIndex);
            int[] trackFormatSupport = formatSupport[groupIndex];
            for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                int trackScore;
                if (!DefaultTrackSelector.isSupported(trackFormatSupport[trackIndex])) continue;
                Format format = trackGroup.getFormat(trackIndex);
                boolean isDefault = (format.selectionFlags & 1) != 0;
                int n = trackScore = isDefault ? 2 : 1;
                if (trackScore <= selectedTrackScore) continue;
                selectedGroup = trackGroup;
                selectedTrackIndex = trackIndex;
                selectedTrackScore = trackScore;
            }
        }
        return selectedGroup == null ? null : new FixedTrackSelection(selectedGroup, selectedTrackIndex);
    }

    private static boolean isSupported(int formatSupport) {
        return (formatSupport & 3) == 3;
    }

    private static boolean formatHasLanguage(Format format, String language) {
        return language != null && language.equals(Util.normalizeLanguageCode(format.language));
    }

    private static List<Integer> getViewportFilteredTrackIndices(TrackGroup group, int viewportWidth, int viewportHeight, boolean orientationMayChange) {
        Format format;
        int i;
        ArrayList<Integer> selectedTrackIndices = new ArrayList<Integer>(group.length);
        for (int i2 = 0; i2 < group.length; ++i2) {
            selectedTrackIndices.add(i2);
        }
        if (viewportWidth == Integer.MAX_VALUE || viewportHeight == Integer.MAX_VALUE) {
            return selectedTrackIndices;
        }
        int maxVideoPixelsToRetain = Integer.MAX_VALUE;
        for (i = 0; i < group.length; ++i) {
            format = group.getFormat(i);
            if (format.width <= 0 || format.height <= 0) continue;
            Point maxVideoSizeInViewport = DefaultTrackSelector.getMaxVideoSizeInViewport(orientationMayChange, viewportWidth, viewportHeight, format.width, format.height);
            int videoPixels = format.width * format.height;
            if (format.width < (int)((float)maxVideoSizeInViewport.x * 0.98f) || format.height < (int)((float)maxVideoSizeInViewport.y * 0.98f) || videoPixels >= maxVideoPixelsToRetain) continue;
            maxVideoPixelsToRetain = videoPixels;
        }
        if (maxVideoPixelsToRetain != Integer.MAX_VALUE) {
            for (i = selectedTrackIndices.size() - 1; i >= 0; --i) {
                format = group.getFormat(selectedTrackIndices.get(i));
                int pixelCount = format.getPixelCount();
                if (pixelCount != -1 && pixelCount <= maxVideoPixelsToRetain) continue;
                selectedTrackIndices.remove(i);
            }
        }
        return selectedTrackIndices;
    }

    private static Point getMaxVideoSizeInViewport(boolean orientationMayChange, int viewportWidth, int viewportHeight, int videoWidth, int videoHeight) {
        if (orientationMayChange && videoWidth > videoHeight != viewportWidth > viewportHeight) {
            int tempViewportWidth = viewportWidth;
            viewportWidth = viewportHeight;
            viewportHeight = tempViewportWidth;
        }
        if (videoWidth * viewportHeight >= videoHeight * viewportWidth) {
            return new Point(viewportWidth, Util.ceilDivide(viewportWidth * videoHeight, videoWidth));
        }
        return new Point(Util.ceilDivide(viewportHeight * videoWidth, videoHeight), viewportHeight);
    }

    public static final class Parameters {
        public final String preferredAudioLanguage;
        public final String preferredTextLanguage;
        public final boolean allowMixedMimeAdaptiveness;
        public final boolean allowNonSeamlessAdaptiveness;
        public final int maxVideoWidth;
        public final int maxVideoHeight;
        public final boolean exceedVideoConstraintsIfNecessary;
        public final int viewportWidth;
        public final int viewportHeight;
        public final boolean orientationMayChange;

        public Parameters() {
            this(null, null, false, true, Integer.MAX_VALUE, Integer.MAX_VALUE, true, Integer.MAX_VALUE, Integer.MAX_VALUE, true);
        }

        public Parameters(String preferredAudioLanguage, String preferredTextLanguage, boolean allowMixedMimeAdaptiveness, boolean allowNonSeamlessAdaptiveness, int maxVideoWidth, int maxVideoHeight, boolean exceedVideoConstraintsIfNecessary, int viewportWidth, int viewportHeight, boolean orientationMayChange) {
            this.preferredAudioLanguage = preferredAudioLanguage;
            this.preferredTextLanguage = preferredTextLanguage;
            this.allowMixedMimeAdaptiveness = allowMixedMimeAdaptiveness;
            this.allowNonSeamlessAdaptiveness = allowNonSeamlessAdaptiveness;
            this.maxVideoWidth = maxVideoWidth;
            this.maxVideoHeight = maxVideoHeight;
            this.exceedVideoConstraintsIfNecessary = exceedVideoConstraintsIfNecessary;
            this.viewportWidth = viewportWidth;
            this.viewportHeight = viewportHeight;
            this.orientationMayChange = orientationMayChange;
        }

        public Parameters withPreferredAudioLanguage(String preferredAudioLanguage) {
            if (TextUtils.equals((CharSequence)(preferredAudioLanguage = Util.normalizeLanguageCode(preferredAudioLanguage)), (CharSequence)this.preferredAudioLanguage)) {
                return this;
            }
            return new Parameters(preferredAudioLanguage, this.preferredTextLanguage, this.allowMixedMimeAdaptiveness, this.allowNonSeamlessAdaptiveness, this.maxVideoWidth, this.maxVideoHeight, this.exceedVideoConstraintsIfNecessary, this.viewportWidth, this.viewportHeight, this.orientationMayChange);
        }

        public Parameters withPreferredTextLanguage(String preferredTextLanguage) {
            if (TextUtils.equals((CharSequence)(preferredTextLanguage = Util.normalizeLanguageCode(preferredTextLanguage)), (CharSequence)this.preferredTextLanguage)) {
                return this;
            }
            return new Parameters(this.preferredAudioLanguage, preferredTextLanguage, this.allowMixedMimeAdaptiveness, this.allowNonSeamlessAdaptiveness, this.maxVideoWidth, this.maxVideoHeight, this.exceedVideoConstraintsIfNecessary, this.viewportWidth, this.viewportHeight, this.orientationMayChange);
        }

        public Parameters withAllowMixedMimeAdaptiveness(boolean allowMixedMimeAdaptiveness) {
            if (allowMixedMimeAdaptiveness == this.allowMixedMimeAdaptiveness) {
                return this;
            }
            return new Parameters(this.preferredAudioLanguage, this.preferredTextLanguage, allowMixedMimeAdaptiveness, this.allowNonSeamlessAdaptiveness, this.maxVideoWidth, this.maxVideoHeight, this.exceedVideoConstraintsIfNecessary, this.viewportWidth, this.viewportHeight, this.orientationMayChange);
        }

        public Parameters withAllowNonSeamlessAdaptiveness(boolean allowNonSeamlessAdaptiveness) {
            if (allowNonSeamlessAdaptiveness == this.allowNonSeamlessAdaptiveness) {
                return this;
            }
            return new Parameters(this.preferredAudioLanguage, this.preferredTextLanguage, this.allowMixedMimeAdaptiveness, allowNonSeamlessAdaptiveness, this.maxVideoWidth, this.maxVideoHeight, this.exceedVideoConstraintsIfNecessary, this.viewportWidth, this.viewportHeight, this.orientationMayChange);
        }

        public Parameters withMaxVideoSize(int maxVideoWidth, int maxVideoHeight) {
            if (maxVideoWidth == this.maxVideoWidth && maxVideoHeight == this.maxVideoHeight) {
                return this;
            }
            return new Parameters(this.preferredAudioLanguage, this.preferredTextLanguage, this.allowMixedMimeAdaptiveness, this.allowNonSeamlessAdaptiveness, maxVideoWidth, maxVideoHeight, this.exceedVideoConstraintsIfNecessary, this.viewportWidth, this.viewportHeight, this.orientationMayChange);
        }

        public Parameters withMaxVideoSizeSd() {
            return this.withMaxVideoSize(1279, 719);
        }

        public Parameters withoutVideoSizeConstraints() {
            return this.withMaxVideoSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public Parameters withExceedVideoConstraintsIfNecessary(boolean exceedVideoConstraintsIfNecessary) {
            if (exceedVideoConstraintsIfNecessary == this.exceedVideoConstraintsIfNecessary) {
                return this;
            }
            return new Parameters(this.preferredAudioLanguage, this.preferredTextLanguage, this.allowMixedMimeAdaptiveness, this.allowNonSeamlessAdaptiveness, this.maxVideoWidth, this.maxVideoHeight, exceedVideoConstraintsIfNecessary, this.viewportWidth, this.viewportHeight, this.orientationMayChange);
        }

        public Parameters withViewportSize(int viewportWidth, int viewportHeight, boolean orientationMayChange) {
            if (viewportWidth == this.viewportWidth && viewportHeight == this.viewportHeight && orientationMayChange == this.orientationMayChange) {
                return this;
            }
            return new Parameters(this.preferredAudioLanguage, this.preferredTextLanguage, this.allowMixedMimeAdaptiveness, this.allowNonSeamlessAdaptiveness, this.maxVideoWidth, this.maxVideoHeight, this.exceedVideoConstraintsIfNecessary, viewportWidth, viewportHeight, orientationMayChange);
        }

        public Parameters withViewportSizeFromContext(Context context, boolean orientationMayChange) {
            Point viewportSize = Util.getPhysicalDisplaySize(context);
            return this.withViewportSize(viewportSize.x, viewportSize.y, orientationMayChange);
        }

        public Parameters withoutViewportSizeConstraints() {
            return this.withViewportSize(Integer.MAX_VALUE, Integer.MAX_VALUE, true);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Parameters other = (Parameters)obj;
            return this.allowMixedMimeAdaptiveness == other.allowMixedMimeAdaptiveness && this.allowNonSeamlessAdaptiveness == other.allowNonSeamlessAdaptiveness && this.maxVideoWidth == other.maxVideoWidth && this.maxVideoHeight == other.maxVideoHeight && this.exceedVideoConstraintsIfNecessary == other.exceedVideoConstraintsIfNecessary && this.orientationMayChange == other.orientationMayChange && this.viewportWidth == other.viewportWidth && this.viewportHeight == other.viewportHeight && TextUtils.equals((CharSequence)this.preferredAudioLanguage, (CharSequence)other.preferredAudioLanguage) && TextUtils.equals((CharSequence)this.preferredTextLanguage, (CharSequence)other.preferredTextLanguage);
        }

        public int hashCode() {
            int result = this.preferredAudioLanguage.hashCode();
            result = 31 * result + this.preferredTextLanguage.hashCode();
            result = 31 * result + (this.allowMixedMimeAdaptiveness ? 1 : 0);
            result = 31 * result + (this.allowNonSeamlessAdaptiveness ? 1 : 0);
            result = 31 * result + this.maxVideoWidth;
            result = 31 * result + this.maxVideoHeight;
            result = 31 * result + (this.exceedVideoConstraintsIfNecessary ? 1 : 0);
            result = 31 * result + (this.orientationMayChange ? 1 : 0);
            result = 31 * result + this.viewportWidth;
            result = 31 * result + this.viewportHeight;
            return result;
        }
    }
}

