/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.os.SystemClock;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.util.Assertions;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public abstract class BaseTrackSelection
implements TrackSelection {
    protected final TrackGroup group;
    protected final int length;
    protected final int[] tracks;
    private final Format[] formats;
    private final long[] blacklistUntilTimes;
    private int hashCode;

    public BaseTrackSelection(TrackGroup group, int ... tracks) {
        int i;
        Assertions.checkState(tracks.length > 0);
        this.group = Assertions.checkNotNull(group);
        this.length = tracks.length;
        this.formats = new Format[this.length];
        for (i = 0; i < tracks.length; ++i) {
            this.formats[i] = group.getFormat(tracks[i]);
        }
        Arrays.sort(this.formats, new DecreasingBandwidthComparator());
        this.tracks = new int[this.length];
        for (i = 0; i < this.length; ++i) {
            this.tracks[i] = group.indexOf(this.formats[i]);
        }
        this.blacklistUntilTimes = new long[this.length];
    }

    @Override
    public final TrackGroup getTrackGroup() {
        return this.group;
    }

    @Override
    public final int length() {
        return this.tracks.length;
    }

    @Override
    public final Format getFormat(int index) {
        return this.formats[index];
    }

    @Override
    public final int getIndexInTrackGroup(int index) {
        return this.tracks[index];
    }

    @Override
    public final int indexOf(Format format) {
        for (int i = 0; i < this.length; ++i) {
            if (this.formats[i] != format) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int indexOf(int indexInTrackGroup) {
        for (int i = 0; i < this.length; ++i) {
            if (this.tracks[i] != indexInTrackGroup) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final Format getSelectedFormat() {
        return this.formats[this.getSelectedIndex()];
    }

    @Override
    public final int getSelectedIndexInTrackGroup() {
        return this.tracks[this.getSelectedIndex()];
    }

    @Override
    public int evaluateQueueSize(long playbackPositionUs, List<? extends MediaChunk> queue) {
        return queue.size();
    }

    @Override
    public final boolean blacklist(int index, long blacklistDurationMs) {
        long nowMs = SystemClock.elapsedRealtime();
        boolean canBlacklist = this.isBlacklisted(index, nowMs);
        for (int i = 0; i < this.length && !canBlacklist; ++i) {
            canBlacklist = i != index && !this.isBlacklisted(i, nowMs);
        }
        if (!canBlacklist) {
            return false;
        }
        this.blacklistUntilTimes[index] = Math.max(this.blacklistUntilTimes[index], nowMs + blacklistDurationMs);
        return true;
    }

    protected final boolean isBlacklisted(int index, long nowMs) {
        return this.blacklistUntilTimes[index] > nowMs;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 31 * System.identityHashCode(this.group) + Arrays.hashCode(this.tracks);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BaseTrackSelection other = (BaseTrackSelection)obj;
        return this.group == other.group && Arrays.equals(this.tracks, other.tracks);
    }

    private static final class DecreasingBandwidthComparator
    implements Comparator<Format> {
        private DecreasingBandwidthComparator() {
        }

        @Override
        public int compare(Format a, Format b) {
            return b.bitrate - a.bitrate;
        }
    }
}

