/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.os.SystemClock;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.trackselection.BaseTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import java.util.List;

public class AdaptiveVideoTrackSelection
extends BaseTrackSelection {
    public static final int DEFAULT_MAX_INITIAL_BITRATE = 800000;
    public static final int DEFAULT_MIN_DURATION_FOR_QUALITY_INCREASE_MS = 10000;
    public static final int DEFAULT_MAX_DURATION_FOR_QUALITY_DECREASE_MS = 25000;
    public static final int DEFAULT_MIN_DURATION_TO_RETAIN_AFTER_DISCARD_MS = 25000;
    public static final float DEFAULT_BANDWIDTH_FRACTION = 0.75f;
    private final BandwidthMeter bandwidthMeter;
    private final int maxInitialBitrate;
    private final long minDurationForQualityIncreaseUs;
    private final long maxDurationForQualityDecreaseUs;
    private final long minDurationToRetainAfterDiscardUs;
    private final float bandwidthFraction;
    private int selectedIndex;
    private int reason;

    public AdaptiveVideoTrackSelection(TrackGroup group, int[] tracks, BandwidthMeter bandwidthMeter) {
        this(group, tracks, bandwidthMeter, 800000, 10000L, 25000L, 25000L, 0.75f);
    }

    public AdaptiveVideoTrackSelection(TrackGroup group, int[] tracks, BandwidthMeter bandwidthMeter, int maxInitialBitrate, long minDurationForQualityIncreaseMs, long maxDurationForQualityDecreaseMs, long minDurationToRetainAfterDiscardMs, float bandwidthFraction) {
        super(group, tracks);
        this.bandwidthMeter = bandwidthMeter;
        this.maxInitialBitrate = maxInitialBitrate;
        this.minDurationForQualityIncreaseUs = minDurationForQualityIncreaseMs * 1000L;
        this.maxDurationForQualityDecreaseUs = maxDurationForQualityDecreaseMs * 1000L;
        this.minDurationToRetainAfterDiscardUs = minDurationToRetainAfterDiscardMs * 1000L;
        this.bandwidthFraction = bandwidthFraction;
        this.selectedIndex = this.determineIdealSelectedIndex(Long.MIN_VALUE);
        this.reason = 1;
    }

    @Override
    public void updateSelectedTrack(long bufferedDurationUs) {
        long nowMs = SystemClock.elapsedRealtime();
        int currentSelectedIndex = this.selectedIndex;
        Format currentFormat = this.getSelectedFormat();
        int idealSelectedIndex = this.determineIdealSelectedIndex(nowMs);
        Format idealFormat = this.getFormat(idealSelectedIndex);
        this.selectedIndex = idealSelectedIndex;
        if (currentFormat != null && !this.isBlacklisted(this.selectedIndex, nowMs)) {
            if (idealFormat.bitrate > currentFormat.bitrate && bufferedDurationUs < this.minDurationForQualityIncreaseUs) {
                this.selectedIndex = currentSelectedIndex;
            } else if (idealFormat.bitrate < currentFormat.bitrate && bufferedDurationUs >= this.maxDurationForQualityDecreaseUs) {
                this.selectedIndex = currentSelectedIndex;
            }
        }
        if (this.selectedIndex != currentSelectedIndex) {
            this.reason = 3;
        }
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public int getSelectionReason() {
        return this.reason;
    }

    @Override
    public Object getSelectionData() {
        return null;
    }

    @Override
    public int evaluateQueueSize(long playbackPositionUs, List<? extends MediaChunk> queue) {
        if (queue.isEmpty()) {
            return 0;
        }
        int queueSize = queue.size();
        long bufferedDurationUs = queue.get((int)(queueSize - 1)).endTimeUs - playbackPositionUs;
        if (bufferedDurationUs < this.minDurationToRetainAfterDiscardUs) {
            return queueSize;
        }
        int idealSelectedIndex = this.determineIdealSelectedIndex(SystemClock.elapsedRealtime());
        Format idealFormat = this.getFormat(idealSelectedIndex);
        for (int i = 0; i < queueSize; ++i) {
            MediaChunk chunk = queue.get(i);
            long durationBeforeThisChunkUs = chunk.startTimeUs - playbackPositionUs;
            if (durationBeforeThisChunkUs < this.minDurationToRetainAfterDiscardUs || chunk.trackFormat.bitrate >= idealFormat.bitrate || chunk.trackFormat.height >= idealFormat.height || chunk.trackFormat.height >= 720 || chunk.trackFormat.width >= 1280) continue;
            return i;
        }
        return queueSize;
    }

    private int determineIdealSelectedIndex(long nowMs) {
        long bitrateEstimate = this.bandwidthMeter.getBitrateEstimate();
        long effectiveBitrate = bitrateEstimate == -1L ? (long)this.maxInitialBitrate : (long)((float)bitrateEstimate * this.bandwidthFraction);
        int lowestBitrateNonBlacklistedIndex = 0;
        for (int i = 0; i < this.length; ++i) {
            if (nowMs != Long.MIN_VALUE && this.isBlacklisted(i, nowMs)) continue;
            Format format = this.getFormat(i);
            if ((long)format.bitrate <= effectiveBitrate) {
                return i;
            }
            lowestBitrateNonBlacklistedIndex = i;
        }
        return lowestBitrateNonBlacklistedIndex;
    }

    public static final class Factory
    implements TrackSelection.Factory {
        private final BandwidthMeter bandwidthMeter;
        private final int maxInitialBitrate;
        private final int minDurationForQualityIncreaseMs;
        private final int maxDurationForQualityDecreaseMs;
        private final int minDurationToRetainAfterDiscardMs;
        private final float bandwidthFraction;

        public Factory(BandwidthMeter bandwidthMeter) {
            this(bandwidthMeter, 800000, 10000, 25000, 25000, 0.75f);
        }

        public Factory(BandwidthMeter bandwidthMeter, int maxInitialBitrate, int minDurationForQualityIncreaseMs, int maxDurationForQualityDecreaseMs, int minDurationToRetainAfterDiscardMs, float bandwidthFraction) {
            this.bandwidthMeter = bandwidthMeter;
            this.maxInitialBitrate = maxInitialBitrate;
            this.minDurationForQualityIncreaseMs = minDurationForQualityIncreaseMs;
            this.maxDurationForQualityDecreaseMs = maxDurationForQualityDecreaseMs;
            this.minDurationToRetainAfterDiscardMs = minDurationToRetainAfterDiscardMs;
            this.bandwidthFraction = bandwidthFraction;
        }

        @Override
        public AdaptiveVideoTrackSelection createTrackSelection(TrackGroup group, int ... tracks) {
            return new AdaptiveVideoTrackSelection(group, tracks, this.bandwidthMeter, this.maxInitialBitrate, (long)this.minDurationForQualityIncreaseMs, (long)this.maxDurationForQualityDecreaseMs, (long)this.minDurationToRetainAfterDiscardMs, this.bandwidthFraction);
        }
    }
}

