/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.webvtt;

import android.text.SpannableStringBuilder;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.Subtitle;
import com.google.android.exoplayer2.text.webvtt.WebvttCue;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class WebvttSubtitle
implements Subtitle {
    private final List<WebvttCue> cues;
    private final int numCues;
    private final long[] cueTimesUs;
    private final long[] sortedCueTimesUs;

    public WebvttSubtitle(List<WebvttCue> cues) {
        this.cues = cues;
        this.numCues = cues.size();
        this.cueTimesUs = new long[2 * this.numCues];
        for (int cueIndex = 0; cueIndex < this.numCues; ++cueIndex) {
            WebvttCue cue = cues.get(cueIndex);
            int arrayIndex = cueIndex * 2;
            this.cueTimesUs[arrayIndex] = cue.startTime;
            this.cueTimesUs[arrayIndex + 1] = cue.endTime;
        }
        this.sortedCueTimesUs = Arrays.copyOf(this.cueTimesUs, this.cueTimesUs.length);
        Arrays.sort(this.sortedCueTimesUs);
    }

    @Override
    public int getNextEventTimeIndex(long timeUs) {
        int index = Util.binarySearchCeil(this.sortedCueTimesUs, timeUs, false, false);
        return index < this.sortedCueTimesUs.length ? index : -1;
    }

    @Override
    public int getEventTimeCount() {
        return this.sortedCueTimesUs.length;
    }

    @Override
    public long getEventTime(int index) {
        Assertions.checkArgument(index >= 0);
        Assertions.checkArgument(index < this.sortedCueTimesUs.length);
        return this.sortedCueTimesUs[index];
    }

    @Override
    public List<Cue> getCues(long timeUs) {
        ArrayList<WebvttCue> list = null;
        WebvttCue firstNormalCue = null;
        SpannableStringBuilder normalCueTextBuilder = null;
        for (int i = 0; i < this.numCues; ++i) {
            WebvttCue cue;
            if (this.cueTimesUs[i * 2] > timeUs || timeUs >= this.cueTimesUs[i * 2 + 1]) continue;
            if (list == null) {
                list = new ArrayList<WebvttCue>();
            }
            if ((cue = this.cues.get(i)).isNormalCue()) {
                if (firstNormalCue == null) {
                    firstNormalCue = cue;
                    continue;
                }
                if (normalCueTextBuilder == null) {
                    normalCueTextBuilder = new SpannableStringBuilder();
                    normalCueTextBuilder.append(firstNormalCue.text).append((CharSequence)"\n").append(cue.text);
                    continue;
                }
                normalCueTextBuilder.append((CharSequence)"\n").append(cue.text);
                continue;
            }
            list.add(cue);
        }
        if (normalCueTextBuilder != null) {
            list.add(new WebvttCue((CharSequence)normalCueTextBuilder));
        } else if (firstNormalCue != null) {
            list.add(firstNormalCue);
        }
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }
}

