/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.webvtt;

import com.google.android.exoplayer2.text.SubtitleDecoderException;
import com.google.android.exoplayer2.text.webvtt.WebvttCueParser;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class WebvttParserUtil {
    private static final Pattern COMMENT = Pattern.compile("^NOTE(( |\t).*)?$");
    private static final Pattern HEADER = Pattern.compile("^\ufeff?WEBVTT(( |\t).*)?$");

    private WebvttParserUtil() {
    }

    public static void validateWebvttHeaderLine(ParsableByteArray input) throws SubtitleDecoderException {
        String line = input.readLine();
        if (line == null || !HEADER.matcher(line).matches()) {
            throw new SubtitleDecoderException("Expected WEBVTT. Got " + line);
        }
    }

    public static long parseTimestampUs(String timestamp) throws NumberFormatException {
        String[] subparts;
        long value = 0L;
        String[] parts = timestamp.split("\\.", 2);
        for (String subpart : subparts = parts[0].split(":")) {
            value = value * 60L + Long.parseLong(subpart);
        }
        return (value * 1000L + Long.parseLong(parts[1])) * 1000L;
    }

    public static float parsePercentage(String s) throws NumberFormatException {
        if (!s.endsWith("%")) {
            throw new NumberFormatException("Percentages must end with %");
        }
        return Float.parseFloat(s.substring(0, s.length() - 1)) / 100.0f;
    }

    public static Matcher findNextCueHeader(ParsableByteArray input) {
        String line;
        while ((line = input.readLine()) != null) {
            if (COMMENT.matcher(line).matches()) {
                while ((line = input.readLine()) != null && !line.isEmpty()) {
                }
                continue;
            }
            Matcher cueHeaderMatcher = WebvttCueParser.CUE_HEADER_PATTERN.matcher(line);
            if (!cueHeaderMatcher.matches()) continue;
            return cueHeaderMatcher;
        }
        return null;
    }
}

