/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.cea;

import com.google.android.exoplayer2.text.Subtitle;
import com.google.android.exoplayer2.text.SubtitleDecoder;
import com.google.android.exoplayer2.text.SubtitleDecoderException;
import com.google.android.exoplayer2.text.SubtitleInputBuffer;
import com.google.android.exoplayer2.text.SubtitleOutputBuffer;
import com.google.android.exoplayer2.text.cea.CeaOutputBuffer;
import com.google.android.exoplayer2.util.Assertions;
import java.util.LinkedList;
import java.util.TreeSet;

abstract class CeaDecoder
implements SubtitleDecoder {
    private static final int NUM_INPUT_BUFFERS = 10;
    private static final int NUM_OUTPUT_BUFFERS = 2;
    private final LinkedList<SubtitleInputBuffer> availableInputBuffers = new LinkedList();
    private final LinkedList<SubtitleOutputBuffer> availableOutputBuffers;
    private final TreeSet<SubtitleInputBuffer> queuedInputBuffers;
    private SubtitleInputBuffer dequeuedInputBuffer;
    private long playbackPositionUs;

    public CeaDecoder() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.availableInputBuffers.add(new SubtitleInputBuffer());
        }
        this.availableOutputBuffers = new LinkedList();
        for (i = 0; i < 2; ++i) {
            this.availableOutputBuffers.add(new CeaOutputBuffer(this));
        }
        this.queuedInputBuffers = new TreeSet();
    }

    @Override
    public abstract String getName();

    @Override
    public void setPositionUs(long positionUs) {
        this.playbackPositionUs = positionUs;
    }

    @Override
    public SubtitleInputBuffer dequeueInputBuffer() throws SubtitleDecoderException {
        Assertions.checkState(this.dequeuedInputBuffer == null);
        if (this.availableInputBuffers.isEmpty()) {
            return null;
        }
        this.dequeuedInputBuffer = this.availableInputBuffers.pollFirst();
        return this.dequeuedInputBuffer;
    }

    @Override
    public void queueInputBuffer(SubtitleInputBuffer inputBuffer) throws SubtitleDecoderException {
        Assertions.checkArgument(inputBuffer != null);
        Assertions.checkArgument(inputBuffer == this.dequeuedInputBuffer);
        this.queuedInputBuffers.add(inputBuffer);
        this.dequeuedInputBuffer = null;
    }

    @Override
    public SubtitleOutputBuffer dequeueOutputBuffer() throws SubtitleDecoderException {
        if (this.availableOutputBuffers.isEmpty()) {
            return null;
        }
        while (!this.queuedInputBuffers.isEmpty() && this.queuedInputBuffers.first().timeUs <= this.playbackPositionUs) {
            SubtitleInputBuffer inputBuffer = this.queuedInputBuffers.pollFirst();
            if (inputBuffer.isEndOfStream()) {
                SubtitleOutputBuffer outputBuffer = this.availableOutputBuffers.pollFirst();
                outputBuffer.addFlag(4);
                this.releaseInputBuffer(inputBuffer);
                return outputBuffer;
            }
            this.decode(inputBuffer);
            if (this.isNewSubtitleDataAvailable()) {
                Subtitle subtitle = this.createSubtitle();
                if (!inputBuffer.isDecodeOnly()) {
                    SubtitleOutputBuffer outputBuffer = this.availableOutputBuffers.pollFirst();
                    outputBuffer.setContent(inputBuffer.timeUs, subtitle, 0L);
                    this.releaseInputBuffer(inputBuffer);
                    return outputBuffer;
                }
            }
            this.releaseInputBuffer(inputBuffer);
        }
        return null;
    }

    private void releaseInputBuffer(SubtitleInputBuffer inputBuffer) {
        inputBuffer.clear();
        this.availableInputBuffers.add(inputBuffer);
    }

    protected void releaseOutputBuffer(SubtitleOutputBuffer outputBuffer) {
        outputBuffer.clear();
        this.availableOutputBuffers.add(outputBuffer);
    }

    @Override
    public void flush() {
        this.playbackPositionUs = 0L;
        while (!this.queuedInputBuffers.isEmpty()) {
            this.releaseInputBuffer(this.queuedInputBuffers.pollFirst());
        }
        if (this.dequeuedInputBuffer != null) {
            this.releaseInputBuffer(this.dequeuedInputBuffer);
            this.dequeuedInputBuffer = null;
        }
    }

    @Override
    public void release() {
    }

    protected abstract boolean isNewSubtitleDataAvailable();

    protected abstract Subtitle createSubtitle();

    protected abstract void decode(SubtitleInputBuffer var1);
}

