/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.cea;

import android.text.TextUtils;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.Subtitle;
import com.google.android.exoplayer2.text.SubtitleInputBuffer;
import com.google.android.exoplayer2.text.cea.CeaDecoder;
import com.google.android.exoplayer2.text.cea.CeaSubtitle;
import com.google.android.exoplayer2.util.ParsableByteArray;

public final class Cea608Decoder
extends CeaDecoder {
    private static final int NTSC_CC_FIELD_1 = 0;
    private static final int CC_VALID_FLAG = 4;
    private static final int PAYLOAD_TYPE_CC = 4;
    private static final int COUNTRY_CODE = 181;
    private static final int PROVIDER_CODE = 49;
    private static final int USER_ID = 1195456820;
    private static final int USER_DATA_TYPE_CODE = 3;
    private static final int CC_MODE_UNKNOWN = 0;
    private static final int CC_MODE_ROLL_UP = 1;
    private static final int CC_MODE_POP_ON = 2;
    private static final int CC_MODE_PAINT_ON = 3;
    private static final int DEFAULT_CAPTIONS_ROW_COUNT = 4;
    private static final byte CTRL_RESUME_CAPTION_LOADING = 32;
    private static final byte CTRL_ROLL_UP_CAPTIONS_2_ROWS = 37;
    private static final byte CTRL_ROLL_UP_CAPTIONS_3_ROWS = 38;
    private static final byte CTRL_ROLL_UP_CAPTIONS_4_ROWS = 39;
    private static final byte CTRL_RESUME_DIRECT_CAPTIONING = 41;
    private static final byte CTRL_END_OF_CAPTION = 47;
    private static final byte CTRL_ERASE_DISPLAYED_MEMORY = 44;
    private static final byte CTRL_CARRIAGE_RETURN = 45;
    private static final byte CTRL_ERASE_NON_DISPLAYED_MEMORY = 46;
    private static final byte CTRL_BACKSPACE = 33;
    private static final byte CTRL_MISC_CHAN_1 = 20;
    private static final byte CTRL_MISC_CHAN_2 = 28;
    private static final int[] BASIC_CHARACTER_SET = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 225, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 233, 93, 237, 243, 250, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 231, 247, 209, 241, 9632};
    private static final int[] SPECIAL_CHARACTER_SET = new int[]{174, 176, 189, 191, 8482, 162, 163, 9834, 224, 32, 232, 226, 234, 238, 244, 251};
    private static final int[] SPECIAL_ES_FR_CHARACTER_SET = new int[]{193, 201, 211, 218, 220, 252, 8216, 161, 42, 39, 8212, 169, 8480, 8226, 8220, 8221, 192, 194, 199, 200, 202, 203, 235, 206, 207, 239, 212, 217, 249, 219, 171, 187};
    private static final int[] SPECIAL_PT_DE_CHARACTER_SET = new int[]{195, 227, 205, 204, 236, 210, 242, 213, 245, 123, 125, 92, 94, 95, 124, 126, 196, 228, 214, 246, 223, 165, 164, 9474, 197, 229, 216, 248, 9484, 9488, 9492, 9496};
    private final ParsableByteArray ccData = new ParsableByteArray();
    private final StringBuilder captionStringBuilder = new StringBuilder();
    private int captionMode;
    private int captionRowCount;
    private String captionString;
    private String lastCaptionString;
    private boolean repeatableControlSet;
    private byte repeatableControlCc1;
    private byte repeatableControlCc2;

    public Cea608Decoder() {
        this.setCaptionMode(0);
        this.captionRowCount = 4;
    }

    @Override
    public String getName() {
        return "Cea608Decoder";
    }

    @Override
    public void flush() {
        super.flush();
        this.setCaptionMode(0);
        this.captionRowCount = 4;
        this.captionStringBuilder.setLength(0);
        this.captionString = null;
        this.lastCaptionString = null;
        this.repeatableControlSet = false;
        this.repeatableControlCc1 = 0;
        this.repeatableControlCc2 = 0;
    }

    @Override
    public void release() {
    }

    @Override
    protected boolean isNewSubtitleDataAvailable() {
        return !TextUtils.equals((CharSequence)this.captionString, (CharSequence)this.lastCaptionString);
    }

    @Override
    protected Subtitle createSubtitle() {
        this.lastCaptionString = this.captionString;
        return new CeaSubtitle(new Cue(this.captionString));
    }

    @Override
    protected void decode(SubtitleInputBuffer inputBuffer) {
        this.ccData.reset(inputBuffer.data.array(), inputBuffer.data.limit());
        boolean captionDataProcessed = false;
        boolean isRepeatableControl = false;
        while (this.ccData.bytesLeft() > 0) {
            byte ccTypeAndValid = (byte)(this.ccData.readUnsignedByte() & 7);
            byte ccData1 = (byte)(this.ccData.readUnsignedByte() & 0x7F);
            byte ccData2 = (byte)(this.ccData.readUnsignedByte() & 0x7F);
            if (ccTypeAndValid != 4 || ccData1 == 0 && ccData2 == 0) continue;
            captionDataProcessed = true;
            if ((ccData1 == 17 || ccData1 == 25) && (ccData2 & 0x70) == 48) {
                this.captionStringBuilder.append(Cea608Decoder.getSpecialChar(ccData2));
                continue;
            }
            if ((ccData2 & 0x60) == 32) {
                if (ccData1 == 18 || ccData1 == 26) {
                    this.backspace();
                    this.captionStringBuilder.append(Cea608Decoder.getExtendedEsFrChar(ccData2));
                    continue;
                }
                if (ccData1 == 19 || ccData1 == 27) {
                    this.backspace();
                    this.captionStringBuilder.append(Cea608Decoder.getExtendedPtDeChar(ccData2));
                    continue;
                }
            }
            if (ccData1 < 32) {
                isRepeatableControl = this.handleCtrl(ccData1, ccData2);
                continue;
            }
            this.captionStringBuilder.append(Cea608Decoder.getChar(ccData1));
            if (ccData2 < 32) continue;
            this.captionStringBuilder.append(Cea608Decoder.getChar(ccData2));
        }
        if (captionDataProcessed) {
            if (!isRepeatableControl) {
                this.repeatableControlSet = false;
            }
            if (this.captionMode == 1 || this.captionMode == 3) {
                this.captionString = this.getDisplayCaption();
            }
        }
    }

    private boolean handleCtrl(byte cc1, byte cc2) {
        boolean isRepeatableControl = Cea608Decoder.isRepeatable(cc1);
        if (isRepeatableControl) {
            if (this.repeatableControlSet && this.repeatableControlCc1 == cc1 && this.repeatableControlCc2 == cc2) {
                this.repeatableControlSet = false;
                return true;
            }
            this.repeatableControlSet = true;
            this.repeatableControlCc1 = cc1;
            this.repeatableControlCc2 = cc2;
        }
        if (Cea608Decoder.isMiscCode(cc1, cc2)) {
            this.handleMiscCode(cc2);
        } else if (Cea608Decoder.isPreambleAddressCode(cc1, cc2)) {
            this.maybeAppendNewline();
        }
        return isRepeatableControl;
    }

    private void handleMiscCode(byte cc2) {
        switch (cc2) {
            case 37: {
                this.captionRowCount = 2;
                this.setCaptionMode(1);
                return;
            }
            case 38: {
                this.captionRowCount = 3;
                this.setCaptionMode(1);
                return;
            }
            case 39: {
                this.captionRowCount = 4;
                this.setCaptionMode(1);
                return;
            }
            case 32: {
                this.setCaptionMode(2);
                return;
            }
            case 41: {
                this.setCaptionMode(3);
                return;
            }
        }
        if (this.captionMode == 0) {
            return;
        }
        switch (cc2) {
            case 44: {
                this.captionString = null;
                if (this.captionMode == 1 || this.captionMode == 3) {
                    this.captionStringBuilder.setLength(0);
                }
                return;
            }
            case 46: {
                this.captionStringBuilder.setLength(0);
                return;
            }
            case 47: {
                this.captionString = this.getDisplayCaption();
                this.captionStringBuilder.setLength(0);
                return;
            }
            case 45: {
                this.maybeAppendNewline();
                return;
            }
            case 33: {
                if (this.captionStringBuilder.length() > 0) {
                    this.captionStringBuilder.setLength(this.captionStringBuilder.length() - 1);
                }
                return;
            }
        }
    }

    private void backspace() {
        if (this.captionStringBuilder.length() > 0) {
            this.captionStringBuilder.setLength(this.captionStringBuilder.length() - 1);
        }
    }

    private void maybeAppendNewline() {
        int buildLength = this.captionStringBuilder.length();
        if (buildLength > 0 && this.captionStringBuilder.charAt(buildLength - 1) != '\n') {
            this.captionStringBuilder.append('\n');
        }
    }

    private String getDisplayCaption() {
        int endIndex;
        boolean endsWithNewline;
        int buildLength = this.captionStringBuilder.length();
        if (buildLength == 0) {
            return null;
        }
        boolean bl = endsWithNewline = this.captionStringBuilder.charAt(buildLength - 1) == '\n';
        if (buildLength == 1 && endsWithNewline) {
            return null;
        }
        int n = endIndex = endsWithNewline ? buildLength - 1 : buildLength;
        if (this.captionMode != 1) {
            return this.captionStringBuilder.substring(0, endIndex);
        }
        int startIndex = 0;
        int searchBackwardFromIndex = endIndex;
        for (int i = 0; i < this.captionRowCount && searchBackwardFromIndex != -1; ++i) {
            searchBackwardFromIndex = this.captionStringBuilder.lastIndexOf("\n", searchBackwardFromIndex - 1);
        }
        if (searchBackwardFromIndex != -1) {
            startIndex = searchBackwardFromIndex + 1;
        }
        this.captionStringBuilder.delete(0, startIndex);
        return this.captionStringBuilder.substring(0, endIndex - startIndex);
    }

    private void setCaptionMode(int captionMode) {
        if (this.captionMode == captionMode) {
            return;
        }
        this.captionMode = captionMode;
        this.captionStringBuilder.setLength(0);
        if (captionMode == 1 || captionMode == 0) {
            this.captionString = null;
        }
    }

    private static char getChar(byte ccData) {
        int index = (ccData & 0x7F) - 32;
        return (char)BASIC_CHARACTER_SET[index];
    }

    private static char getSpecialChar(byte ccData) {
        int index = ccData & 0xF;
        return (char)SPECIAL_CHARACTER_SET[index];
    }

    private static char getExtendedEsFrChar(byte ccData) {
        int index = ccData & 0x1F;
        return (char)SPECIAL_ES_FR_CHARACTER_SET[index];
    }

    private static char getExtendedPtDeChar(byte ccData) {
        int index = ccData & 0x1F;
        return (char)SPECIAL_PT_DE_CHARACTER_SET[index];
    }

    private static boolean isMiscCode(byte cc1, byte cc2) {
        return (cc1 == 20 || cc1 == 28) && cc2 >= 32 && cc2 <= 47;
    }

    private static boolean isPreambleAddressCode(byte cc1, byte cc2) {
        return cc1 >= 16 && cc1 <= 31 && cc2 >= 64 && cc2 <= 127;
    }

    private static boolean isRepeatable(byte cc1) {
        return cc1 >= 16 && cc1 <= 31;
    }

    public static boolean isSeiMessageCea608(int payloadType, int payloadLength, ParsableByteArray payload) {
        if (payloadType != 4 || payloadLength < 8) {
            return false;
        }
        int startPosition = payload.getPosition();
        int countryCode = payload.readUnsignedByte();
        int providerCode = payload.readUnsignedShort();
        int userIdentifier = payload.readInt();
        int userDataTypeCode = payload.readUnsignedByte();
        payload.setPosition(startPosition);
        return countryCode == 181 && providerCode == 49 && userIdentifier == 1195456820 && userDataTypeCode == 3;
    }
}

