/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.google.android.exoplayer2.BaseRenderer;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.SubtitleDecoder;
import com.google.android.exoplayer2.text.SubtitleDecoderException;
import com.google.android.exoplayer2.text.SubtitleDecoderFactory;
import com.google.android.exoplayer2.text.SubtitleInputBuffer;
import com.google.android.exoplayer2.text.SubtitleOutputBuffer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import java.util.Collections;
import java.util.List;

public final class TextRenderer
extends BaseRenderer
implements Handler.Callback {
    private static final int MSG_UPDATE_OUTPUT = 0;
    private final Handler outputHandler;
    private final Output output;
    private final SubtitleDecoderFactory decoderFactory;
    private final FormatHolder formatHolder;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;
    private SubtitleDecoder decoder;
    private SubtitleInputBuffer nextInputBuffer;
    private SubtitleOutputBuffer subtitle;
    private SubtitleOutputBuffer nextSubtitle;
    private int nextSubtitleEventIndex;

    public TextRenderer(Output output, Looper outputLooper) {
        this(output, outputLooper, SubtitleDecoderFactory.DEFAULT);
    }

    public TextRenderer(Output output, Looper outputLooper, SubtitleDecoderFactory decoderFactory) {
        super(3);
        this.output = Assertions.checkNotNull(output);
        this.outputHandler = outputLooper == null ? null : new Handler(outputLooper, (Handler.Callback)this);
        this.decoderFactory = decoderFactory;
        this.formatHolder = new FormatHolder();
    }

    @Override
    public int supportsFormat(Format format) {
        return this.decoderFactory.supportsFormat(format) ? 3 : (MimeTypes.isText(format.sampleMimeType) ? 1 : 0);
    }

    @Override
    protected void onStreamChanged(Format[] formats) throws ExoPlaybackException {
        if (this.decoder != null) {
            this.decoder.release();
            this.nextInputBuffer = null;
        }
        this.decoder = this.decoderFactory.createDecoder(formats[0]);
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) {
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        if (this.subtitle != null) {
            this.subtitle.release();
            this.subtitle = null;
        }
        if (this.nextSubtitle != null) {
            this.nextSubtitle.release();
            this.nextSubtitle = null;
        }
        this.nextInputBuffer = null;
        this.clearOutput();
        this.decoder.flush();
    }

    @Override
    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        if (this.outputStreamEnded) {
            return;
        }
        if (this.nextSubtitle == null) {
            this.decoder.setPositionUs(positionUs);
            try {
                this.nextSubtitle = (SubtitleOutputBuffer)this.decoder.dequeueOutputBuffer();
            }
            catch (SubtitleDecoderException e) {
                throw ExoPlaybackException.createForRenderer(e, this.getIndex());
            }
        }
        if (this.getState() != 2) {
            return;
        }
        boolean textRendererNeedsUpdate = false;
        if (this.subtitle != null) {
            long subtitleNextEventTimeUs = this.getNextEventTime();
            while (subtitleNextEventTimeUs <= positionUs) {
                ++this.nextSubtitleEventIndex;
                subtitleNextEventTimeUs = this.getNextEventTime();
                textRendererNeedsUpdate = true;
            }
        }
        if (this.nextSubtitle != null) {
            if (this.nextSubtitle.isEndOfStream()) {
                if (!textRendererNeedsUpdate && this.getNextEventTime() == Long.MAX_VALUE) {
                    if (this.subtitle != null) {
                        this.subtitle.release();
                        this.subtitle = null;
                    }
                    this.nextSubtitle.release();
                    this.nextSubtitle = null;
                    this.outputStreamEnded = true;
                }
            } else if (this.nextSubtitle.timeUs <= positionUs) {
                if (this.subtitle != null) {
                    this.subtitle.release();
                }
                this.subtitle = this.nextSubtitle;
                this.nextSubtitle = null;
                this.nextSubtitleEventIndex = this.subtitle.getNextEventTimeIndex(positionUs);
                textRendererNeedsUpdate = true;
            }
        }
        if (textRendererNeedsUpdate) {
            this.updateOutput(this.subtitle.getCues(positionUs));
        }
        try {
            while (!this.inputStreamEnded) {
                int result;
                if (this.nextInputBuffer == null) {
                    this.nextInputBuffer = (SubtitleInputBuffer)this.decoder.dequeueInputBuffer();
                    if (this.nextInputBuffer == null) {
                        return;
                    }
                }
                if ((result = this.readSource(this.formatHolder, this.nextInputBuffer)) == -4) {
                    this.nextInputBuffer.clearFlag(Integer.MIN_VALUE);
                    if (this.nextInputBuffer.isEndOfStream()) {
                        this.inputStreamEnded = true;
                    } else {
                        this.nextInputBuffer.subsampleOffsetUs = this.formatHolder.format.subsampleOffsetUs;
                        this.nextInputBuffer.flip();
                    }
                    this.decoder.queueInputBuffer(this.nextInputBuffer);
                    this.nextInputBuffer = null;
                    continue;
                }
                if (result != -3) continue;
                break;
            }
        }
        catch (SubtitleDecoderException e) {
            throw ExoPlaybackException.createForRenderer(e, this.getIndex());
        }
    }

    @Override
    protected void onDisabled() {
        if (this.subtitle != null) {
            this.subtitle.release();
            this.subtitle = null;
        }
        if (this.nextSubtitle != null) {
            this.nextSubtitle.release();
            this.nextSubtitle = null;
        }
        this.decoder.release();
        this.decoder = null;
        this.nextInputBuffer = null;
        this.clearOutput();
        super.onDisabled();
    }

    @Override
    public boolean isEnded() {
        return this.outputStreamEnded;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    private long getNextEventTime() {
        return this.nextSubtitleEventIndex == -1 || this.nextSubtitleEventIndex >= this.subtitle.getEventTimeCount() ? Long.MAX_VALUE : this.subtitle.getEventTime(this.nextSubtitleEventIndex);
    }

    private void updateOutput(List<Cue> cues) {
        if (this.outputHandler != null) {
            this.outputHandler.obtainMessage(0, cues).sendToTarget();
        } else {
            this.invokeUpdateOutputInternal(cues);
        }
    }

    private void clearOutput() {
        this.updateOutput(Collections.emptyList());
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.invokeUpdateOutputInternal((List)msg.obj);
                return true;
            }
        }
        return false;
    }

    private void invokeUpdateOutputInternal(List<Cue> cues) {
        this.output.onCues(cues);
    }

    public static interface Output {
        public void onCues(List<Cue> var1);
    }
}

